/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnShort
extends TupleColumn {
    private short[] data;

    TupleColumnShort(String name, Value value, String options) {
        super(name, Short.TYPE, value, options);
    }

    protected void createArray(int size) {
        short[] data = new short[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getShort();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        short[] data = (short[])this.currentArray;
        value.set(data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            short[] data = (short[])this.currentArray;
            data[index % this.arraySize] = value.getShort();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnShort");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getShort());
        }
    }

    protected void currentArrayUpdated() {
        this.data = (short[])this.currentArray;
    }
}

