/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Graphics;

public class Constraint
extends Thing {
    private double left;
    private double right;
    private double top;
    private double bottom;

    public Constraint(SApplet sApplet, SScalable sScalable, double d, double d2, double d3, double d4) {
        super(sScalable, 0.0, 0.0);
        this.applet = sApplet;
        this.left = d;
        this.right = d2;
        this.top = d4;
        this.bottom = d3;
        this.visible = true;
        this.color = Color.black;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.left);
        int n2 = this.canvas.pixFromY(this.top);
        this.w = this.canvas.pixFromX(this.right) - n;
        this.h = this.canvas.pixFromY(this.bottom) - n2;
        graphics.setColor(this.color);
        if (this.w > 0 && this.h > 0) {
            graphics.drawRect(n, n2, this.w, this.h);
        } else if (this.w > 0 && this.h == 0) {
            graphics.drawLine(n, n2, n + this.w, n2);
        } else if (this.w == 0 && this.h > 0) {
            graphics.drawLine(n, n2, n, n2 + this.h);
        }
    }

    public void paintHighlight(Graphics graphics) {
        this.paint(graphics);
    }

    public void enforceConstraint(Thing thing) {
        double d = thing.x;
        double d2 = thing.y;
        if (this.right > this.left) {
            d = Math.max(this.left, d);
            d = Math.min(this.right, d);
            if (this.top == this.bottom) {
                d2 = this.top;
            }
        }
        if (this.top > this.bottom) {
            d2 = Math.max(this.bottom, d2);
            d2 = Math.min(this.top, d2);
            if (this.left == this.right) {
                d = this.left;
            }
        }
        thing.x = d;
        thing.y = d2;
    }

    public final boolean isInsideThing(int n, int n2) {
        return false;
    }
}

