/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.Constraint;
import edu.davidson.display.Format;
import edu.davidson.display.SScalable;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Enumeration;
import java.util.Vector;

public class Thing
implements SDataSource,
SDataListener {
    static Color darkGreen = new Color(0, 128, 0);
    static Color lightGreen = new Color(128, 255, 128);
    protected boolean noDrag = true;
    protected boolean visible = true;
    protected boolean resizable = true;
    protected boolean highlight = false;
    protected int hotSpot = 0;
    protected SApplet applet = null;
    protected int w = 5;
    protected int h = 5;
    protected int s = 5;
    protected Color color = Color.black;
    protected double x;
    protected double y;
    protected SScalable canvas;
    protected Constraint constraint = null;
    protected Font font = new Font("Helvetica", 1, 14);
    protected Format format = new Format("%-+6.3g");
    protected int xDisplayOff = 0;
    protected int yDisplayOff = 0;
    protected String[] varStrings = new String[]{"x", "y"};
    protected double[][] ds = new double[1][2];
    protected String label = null;
    Thing myMaster = null;
    Vector mySlaves = new Vector();
    Color highlightColor = Color.red;
    Polygon trail = new Polygon();
    int trailSize = 0;

    public Thing(SScalable sScalable) {
        this.canvas = sScalable;
        try {
            SApplet.addDataSource(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SApplet.addDataListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Thing(SScalable sScalable, double d, double d2) {
        this(sScalable);
        this.x = d;
        this.y = d2;
    }

    public int getID() {
        return this.hashCode();
    }

    public final boolean isNoDrag() {
        return this.noDrag;
    }

    public final void setNoDrag(boolean bl) {
        this.noDrag = bl;
    }

    public void setOwner(SApplet sApplet) {
        this.applet = sApplet;
    }

    public SApplet getOwner() {
        return this.applet;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public boolean isInsideThing(int n, int n2) {
        return false;
    }

    public final int getSize() {
        return this.s;
    }

    public void setSize(int n) {
        this.s = n;
    }

    public final Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public final void setDragable(boolean bl) {
        this.noDrag = !bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setHighlight(boolean bl) {
        this.highlight = bl;
    }

    public final boolean isHighlight() {
        return this.highlight;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public final boolean isResizable() {
        return this.resizable;
    }

    public final Thing getMaster() {
        return this.myMaster;
    }

    public final Vector getSlaves() {
        return this.mySlaves;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final boolean setFont(Font font) {
        this.font = font;
        if (this.font == null) {
            this.font = new Font("Helvetica", 1, 14);
        }
        return true;
    }

    public void setDisplayOff(int n, int n2) {
        this.xDisplayOff = n;
        this.yDisplayOff = n2;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        if (this.myMaster != null) {
            this.x = this.myMaster.x;
            return;
        }
        this.x = d;
        if (this.constraint != null) {
            this.constraint.enforceConstraint(this);
        }
    }

    public void setXY(double d, double d2) {
        if (this.myMaster != null) {
            this.x = this.myMaster.x;
            this.y = this.myMaster.y;
            return;
        }
        this.x = d;
        this.y = d2;
        if (this.constraint != null) {
            this.constraint.enforceConstraint(this);
        }
        this.updateMySlaves();
    }

    public void dragMe(double d, double d2) {
        this.setXY(d, d2);
    }

    public final int getXPix() {
        return this.canvas.pixFromX(this.x);
    }

    public final double getY() {
        return this.y;
    }

    public void setY(double d) {
        if (this.myMaster != null) {
            this.y = this.myMaster.y;
            return;
        }
        this.y = d;
        if (this.constraint != null) {
            this.constraint.enforceConstraint(this);
        }
    }

    public final int getYPix() {
        return this.canvas.pixFromY(this.y);
    }

    public final int getHeight() {
        return this.h;
    }

    public void setHeight(int n) {
        this.h = n;
    }

    public final int getWidth() {
        return this.w;
    }

    public void setWidth(int n) {
        this.w = n;
    }

    public void setConstraint(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.constraint = constraint;
        this.constraint.enforceConstraint(this);
    }

    public void addSlave(Thing thing) {
        if (this.myMaster == thing) {
            this.myMaster = null;
        }
        this.mySlaves.addElement(thing);
        thing.myMaster = this;
        thing.setVarsFromMaster();
    }

    public void setVarsFromMaster() {
        if (this.myMaster == null) {
            return;
        }
        this.x = this.myMaster.x;
        this.y = this.myMaster.y;
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing == this || thing.myMaster != this) continue;
            thing.setVarsFromMaster();
        }
    }

    public void updateMySlaves() {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
        }
    }

    public void paintMySlaves(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.x;
        this.ds[0][1] = this.y;
        return this.ds;
    }

    public void paint(Graphics graphics) {
    }

    public void paintHighlight(Graphics graphics) {
        this.paint(graphics);
    }

    public void clearSeries(int n) {
    }

    public void deleteSeries(int n) {
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.setXY(d, d2);
        if (this.canvas instanceof Canvas) {
            ((Canvas)((Object)this.canvas)).repaint();
        }
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        int n2 = dArray.length - 1;
        this.setXY(dArray[n2], dArray2[n2]);
    }
}

