/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

class BubblePanel
extends Panel {
    String text;

    public BubblePanel(String string) {
        this.text = string;
        this.setForeground(Color.black);
        this.setBackground(Color.yellow);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawString(this.text, 2, fontMetrics.getAscent() + 2);
    }

    public Dimension getPreferredSize() {
        String string = System.getProperty("java.vendor");
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return new Dimension(10, 10);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.text) + 4;
        int n2 = fontMetrics.getHeight() + 4;
        if (n < 50) {
            n = 50;
        }
        if (!string.startsWith("Microsoft")) {
            n2 += 15;
        }
        return new Dimension(n, n2);
    }

    void setText(String string) {
        this.text = string;
    }
}

