/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.Bubble;
import edu.davidson.graphics.HintThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class HintPanel
extends Panel {
    private Bubble bubble;
    private String bubbleText = null;
    private HintThread thread = null;
    private long bubbleInterval = 200L;
    private boolean isInside = false;

    public HintPanel() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                HintPanel.this.isInside = true;
                if (HintPanel.this.bubbleText != null) {
                    if (HintPanel.this.bubbleInterval == (long)0) {
                        HintPanel.this.showBubbleHelp();
                    } else {
                        HintPanel.this.thread = new HintThread(HintPanel.this);
                        HintPanel.this.thread.start();
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (HintPanel.this.bubble != null && HintPanel.this.bubble.isShowing()) {
                    HintPanel.this.bubble.dispose();
                }
                if (HintPanel.this.thread != null && HintPanel.this.thread.isAlive()) {
                    ((HintPanel)HintPanel.this).thread.interrupted = true;
                    try {
                        HintPanel.this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HintPanel.this.thread = null;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (HintPanel.this.bubbleText != null) {
                    if (HintPanel.this.bubbleInterval == (long)0) {
                        HintPanel.this.showBubbleHelp();
                    } else {
                        HintPanel.this.thread = new HintThread(HintPanel.this);
                        HintPanel.this.thread.start();
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                HintPanel.this.isInside = false;
                if (HintPanel.this.bubble != null && HintPanel.this.bubble.isShowing()) {
                    HintPanel.this.bubble.dispose();
                }
                if (HintPanel.this.thread != null && HintPanel.this.thread.isAlive()) {
                    ((HintPanel)HintPanel.this).thread.interrupted = true;
                    try {
                        HintPanel.this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HintPanel.this.thread = null;
                }
            }
        });
    }

    public synchronized void destroyHint() {
        this.isInside = false;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupted = true;
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        if (this.bubble != null && this.bubble.isShowing()) {
            this.bubble.dispose();
        }
    }

    void showBubbleHelp() {
        if (this.bubbleText != null) {
            Dimension dimension = this.getSize();
            Point point = this.getLocationOnScreen();
            if (this.bubble == null) {
                this.bubble = new Bubble(this, this.bubbleText);
            }
            ((Component)this.bubble).setLocation(point.x, point.y + dimension.height + 2);
            this.bubble.setVisible(true);
        }
    }

    public void setBubbleHelp(String string) {
        this.bubbleText = string;
    }

    public synchronized void forceBubbleHelp(String string) {
        if (this.bubble == null) {
            this.bubbleText = string;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupted = true;
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.thread = null;
            }
            this.showBubbleHelp();
            return;
        }
        if (string == null) {
            this.bubble.dispose();
            this.bubbleText = null;
            return;
        }
        this.bubble.show();
        if (!string.equals(this.bubbleText)) {
            this.bubbleText = string;
            this.bubble.setText(string);
        }
        this.showBubbleHelp();
    }

    public synchronized void updateBubbleHelp(String string) {
        if (this.bubble == null) {
            this.bubbleText = string;
            if (this.isInside) {
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupted = true;
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.thread = null;
                }
                this.showBubbleHelp();
            }
            return;
        }
        if (this.isInside && string == null) {
            this.bubble.dispose();
            this.bubbleText = null;
            return;
        }
        this.bubble.show();
        if (this.isInside && !string.equals(this.bubbleText)) {
            this.bubbleText = string;
            this.bubble.setText(string);
        }
        this.showBubbleHelp();
    }

    public void setBubbleInterval(long l) {
        this.bubbleInterval = l;
    }

    public long getBubbleInterval() {
        return this.bubbleInterval;
    }
}

