/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.tools;

import edu.davidson.display.Format;
import edu.davidson.tools.BusyFlag;
import edu.davidson.tools.SClock;
import edu.davidson.tools.SDataConnection;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SApplet
extends Applet {
    public static Hashtable dataSources = new Hashtable(50);
    public static Hashtable dataListeners = new Hashtable(20);
    static Object runningID = null;
    private SClock localClock;
    public SClock clock;
    public BusyFlag lock;
    public Vector dataConnections;
    protected String oneShotMsg;
    protected boolean autoRefresh;
    public int debugLevel;
    protected String formatString;
    protected Format formatD;
    protected Format formatI;
    public static int staticDebugLevel = 0;

    public SApplet() {
        this.clock = this.localClock = new SClock(this);
        this.lock = new BusyFlag();
        this.dataConnections = new Vector();
        this.oneShotMsg = null;
        this.autoRefresh = true;
        this.debugLevel = 0;
        this.formatString = "%-+6.2g";
        this.formatD = new Format(this.formatString);
        this.formatI = new Format("%-+6d");
    }

    public synchronized void destroy() {
        Object k;
        Hashtable hashtable;
        this.deleteDataConnections();
        this.localClock.panicStopClock();
        SDataSource sDataSource = null;
        SDataListener sDataListener = null;
        Hashtable hashtable2 = dataSources;
        synchronized (hashtable2) {
            hashtable = (Hashtable)dataSources.clone();
        }
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            k = object.nextElement();
            sDataSource = (SDataSource)dataSources.get(k);
            if (sDataSource == null || sDataSource.getOwner() != this) continue;
            dataSources.remove(k);
        }
        object = dataListeners;
        synchronized (object) {
            hashtable = (Hashtable)dataListeners.clone();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            sDataListener = (SDataListener)dataListeners.get(k);
            if (sDataListener == null || sDataListener.getOwner() != this) continue;
            dataListeners.remove(k);
        }
        this.localClock.removeAllClockListeners();
    }

    private SDataConnection getExistingConnection(int n, int n2, int n3) {
        return null;
    }

    public int makeDataConnection(int n, int n2, int n3, String string, String string2) {
        if (string == null) {
            string = "0";
        }
        if (string2 == null) {
            string2 = "0";
        }
        if (this.debugLevel > 7) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("making connection. SourceID=").append(n).append("ListenerID=").append(n2))));
        }
        SDataListener sDataListener = SApplet.getDataListener(n2);
        SDataSource sDataSource = SApplet.getDataSource(n);
        SDataConnection sDataConnection = null;
        if (sDataSource != null && sDataListener != null) {
            sDataConnection = this.getExistingConnection(n, n2, n3);
            if (sDataConnection == null) {
                if (this.debugLevel > 7) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("xStr=").append(string).append(" yStr=").append(string2))));
                }
                sDataConnection = new SDataConnection(sDataSource, sDataListener, n3, string, string2);
                this.dataConnections.addElement(sDataConnection);
            } else {
                System.out.println("Warning: Data connection already exists.");
            }
        } else {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("DataConnection not made.  Listener:").append(sDataListener).append("  Source:").append(sDataSource))));
            return 0;
        }
        return sDataConnection.hashCode();
    }

    public void clearAllData() {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            sDataConnection.clearData();
        }
    }

    public void clearData(int n) {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            if (sDataConnection.getDataSource().hashCode() != n) continue;
            sDataConnection.clearData();
        }
    }

    public void updateDataConnection(int n) {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            if (sDataConnection.getDataSource().hashCode() != n) continue;
            sDataConnection.registerDatum();
        }
    }

    public void updateDataConnections() {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            if (sDataConnection.getDataSource() == this.clock) continue;
            sDataConnection.registerDatum();
        }
    }

    public void deleteDataConnections() {
        this.dataConnections.removeAllElements();
    }

    public void deleteDataConnection(int n) {
        SDataConnection sDataConnection = null;
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            sDataConnection = (SDataConnection)enumeration.nextElement();
            if (n != sDataConnection.hashCode()) continue;
            this.dataConnections.removeElement(sDataConnection);
        }
    }

    private SDataConnection getDataConnection(int n) {
        SDataConnection sDataConnection = null;
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            sDataConnection = (SDataConnection)enumeration.nextElement();
            if (n != sDataConnection.hashCode()) continue;
            return sDataConnection;
        }
        return null;
    }

    public SDataConnection getDataConnectionFromDS(SDataSource sDataSource) {
        SDataConnection sDataConnection = null;
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            sDataConnection = (SDataConnection)enumeration.nextElement();
            if (sDataSource != sDataConnection.getDataSource()) continue;
            return sDataConnection;
        }
        return null;
    }

    public String getDataFromDS(int n) {
        Format format = new Format("%10.5g");
        SDataSource sDataSource = SApplet.getDataSource(n);
        String[] stringArray = sDataSource.getVarStrings();
        double[][] dArray = sDataSource.getVariables();
        if (dArray == null || stringArray == null) {
            return "";
        }
        int n2 = stringArray.length;
        int n3 = dArray.length;
        StringBuffer stringBuffer = new StringBuffer((n2 + 1) * n3 * 10);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]);
            for (int j = 0; j < n3; ++j) {
                stringBuffer.append(",");
                stringBuffer.append(format.form(dArray[j][i]));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public SDataConnection getDataConnectionFromDL(SDataListener sDataListener) {
        SDataConnection sDataConnection = null;
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            sDataConnection = (SDataConnection)enumeration.nextElement();
            if (sDataListener != sDataConnection.getDataListener()) continue;
            return sDataConnection;
        }
        return null;
    }

    public final boolean isValidFunction(String string, String string2) {
        return SUtil.isValidFunction(string, string2);
    }

    public final void cleanupDataConnections() {
        SDataConnection sDataConnection = null;
        SDataSource sDataSource = null;
        SDataListener sDataListener = null;
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            sDataConnection = (SDataConnection)enumeration.nextElement();
            sDataListener = sDataConnection.getDataListener();
            sDataSource = sDataConnection.getDataSource();
            if (dataListeners.contains(sDataListener) && dataSources.contains(sDataSource)) continue;
            this.dataConnections.removeElement(sDataConnection);
        }
    }

    public final Object getRunningID() {
        return runningID;
    }

    public final void setRunningID(Object object) {
        runningID = object;
    }

    public final void setRunningID() {
        runningID = this;
    }

    public final int getDebugLevel() {
        return this.debugLevel;
    }

    public final void setDebugLevel(int n) {
        this.debugLevel = n;
        staticDebugLevel = n;
    }

    public final int getID() {
        return this.hashCode();
    }

    public final boolean setConnectionSmoothing(int n, int n2) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionSmoothing.");
            return false;
        }
        sDataConnection.setSmooth(n2);
        return true;
    }

    public final boolean setConnectionWindowX(int n, double d, double d2) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionWindowX.");
            return false;
        }
        sDataConnection.setWindowX(d, d2);
        return true;
    }

    public final boolean setConnectionWindowY(int n, double d, double d2) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionWindowY.");
            return false;
        }
        sDataConnection.setWindowY(d, d2);
        return true;
    }

    public final boolean setConnectionStride(int n, int n2) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionStride.");
            return false;
        }
        sDataConnection.setStride(n2);
        return true;
    }

    public final boolean setConnectionBlock(int n, boolean bl) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionBlock.");
            return false;
        }
        sDataConnection.block = bl;
        return true;
    }

    public final boolean setConnectionSource(int n) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionSource.");
            return false;
        }
        sDataConnection.ds = SApplet.getDataSource(n);
        return true;
    }

    public final boolean setConnectionListener(int n) {
        SDataConnection sDataConnection = this.getDataConnection(n);
        if (sDataConnection == null) {
            System.out.println("Error: DataConnection not found in setConnectionSource.");
            return false;
        }
        sDataConnection.dl = SApplet.getDataListener(n);
        return true;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
    }

    public String formatValue(double d, double d2, String string) {
        if (!string.equals("") && !this.formatString.equals(string)) {
            this.formatString = string;
            this.formatD = new Format(this.formatString);
        }
        if (Math.abs(d) < d2) {
            return "0";
        }
        if (Math.abs(d - (double)((int)d)) <= d2) {
            return this.formatI.form((int)d);
        }
        return this.formatD.form(d);
    }

    public void forward() {
        this.setRunningID();
        this.clock.dt = Math.abs(this.clock.dt);
        this.clock.startClock();
    }

    public void reverse() {
        this.setRunningID();
        this.clock.dt = -Math.abs(this.clock.dt);
        this.clock.startClock();
    }

    public void pause() {
        this.clock.stopClock();
    }

    public void reset() {
        this.pause();
        this.clock.setTime(0.0);
    }

    public void setDefault() {
        this.pause();
        this.clock.setTime(0.0);
        this.deleteDataConnections();
    }

    public void setDt(double d) {
        this.clock.setDt(d);
    }

    public void setFPS(double d) {
        this.clock.setFPS(d);
    }

    public void setTimeContinuous() {
        this.clock.setContinuous();
    }

    public final int getClockID() {
        return this.clock.hashCode();
    }

    public final boolean setExternalClock(int n) {
        SDataSource sDataSource = SApplet.getDataSource(n);
        if (sDataSource == null) {
            return false;
        }
        SClock sClock = null;
        if (!(sDataSource instanceof SClock)) {
            return false;
        }
        sClock = (SClock)sDataSource;
        this.clock.stopClock();
        sClock.stopClock();
        Enumeration enumeration = this.clock.clockListeners.elements();
        while (enumeration.hasMoreElements()) {
            SStepable sStepable = (SStepable)enumeration.nextElement();
            sClock.addClockListener(sStepable);
        }
        this.removeDataSource(this.clock.getID());
        this.clock = sClock;
        return true;
    }

    public void stepClock() {
        this.clock.doStep();
    }

    public void stepTimeForward() {
        this.clock.setDt(Math.abs(this.clock.getDt()));
        this.clock.doStep();
    }

    public void stepTimeBack() {
        this.clock.setDt(-Math.abs(this.clock.getDt()));
        this.clock.doStep();
    }

    public void stepTime() {
        this.clock.doStep();
    }

    public double getClockTime() {
        return this.clock.getTime();
    }

    public void setClockTime(double d) {
        this.clock.setTime(d);
    }

    public void setTimeOneShot(double d, String string) {
        this.oneShotMsg = string;
        this.clock.setOneShot(0.0, d);
        this.clock.setTime(0.0);
    }

    public void setClockOneShot(double d, double d2) {
        this.clock.setOneShot(d, d2);
        this.clock.setTime(d);
    }

    public void setClockContinous() {
        this.clock.oneShot = false;
        this.clock.cycle = false;
    }

    public void setTimeCycle(double d) {
        this.clearAllData();
        this.clock.setCycle(0.0, d);
        this.clock.setTime(0.0);
    }

    public void setClockCycle(double d, double d2) {
        this.clearAllData();
        this.clock.setCycle(d, d2);
        this.clock.setTime(d);
    }

    public void startClock() {
        this.setRunningID();
        this.clock.startClock();
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public boolean isClockRunning() {
        return this.clock.isRunning();
    }

    protected void stoppingClock() {
    }

    protected void cyclingClock() {
    }

    protected void pausingClock() {
    }

    public void stopClock() {
        this.clock.stopClock();
    }

    public static final void addDataSource(Object object) {
        if (object instanceof SDataSource && !dataSources.contains(object)) {
            dataSources.put(Integer.toString(object.hashCode()), object);
            if (staticDebugLevel > 8) {
                System.out.println("data source added: ".concat(String.valueOf(String.valueOf(object.hashCode()))));
            }
        } else {
            System.out.println("Error: ds is not a DataSource in SApplet.addDataSource:".concat(String.valueOf(String.valueOf(object.hashCode()))));
        }
    }

    public final void removeDataSource(int n) {
        SDataSource sDataSource = SApplet.getDataSource(n);
        SDataConnection sDataConnection = null;
        do {
            if ((sDataConnection = this.getDataConnectionFromDS(sDataSource)) == null) continue;
            this.dataConnections.removeElement(sDataConnection);
        } while (sDataConnection != null);
        dataSources.remove(Integer.toString(n));
    }

    public static final SDataSource getDataSource(String string) {
        return (SDataSource)dataSources.get(string);
    }

    public static final SDataSource getDataSource(int n) {
        return (SDataSource)dataSources.get(Integer.toString(n));
    }

    public String getSourceVariables(int n) {
        String string = "";
        SDataSource sDataSource = (SDataSource)dataSources.get(Integer.toString(n));
        if (sDataSource == null) {
            return "Data source not found.";
        }
        String[] stringArray = sDataSource.getVarStrings();
        if (stringArray == null) {
            return "Variables not found.";
        }
        int n2 = stringArray.length;
        for (int i = 0; i < n2 - 1; ++i) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(stringArray[i]).append(", ")));
        }
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(stringArray[n2 - 1])));
        return string;
    }

    public String getSourceData(int n, String string) {
        int n2 = -1;
        SDataSource sDataSource = (SDataSource)dataSources.get(Integer.toString(n));
        if (sDataSource == null) {
            return "Data source not found.";
        }
        String[] stringArray = sDataSource.getVarStrings();
        if (stringArray == null) {
            return "Variables not found.";
        }
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            return "Data source variable not found.";
        }
        double[][] dArray = sDataSource.getVariables();
        if (dArray == null) {
            return "Values not found.";
        }
        int n4 = dArray.length;
        StringBuffer stringBuffer = new StringBuffer(n4 * 10);
        for (int i = 0; i < n4 - 1; ++i) {
            stringBuffer = stringBuffer.append(dArray[i][n2]);
            stringBuffer.append(", ");
        }
        if (n4 <= 0) {
            return "";
        }
        stringBuffer.append(dArray[n4 - 1][n2]);
        return stringBuffer.toString();
    }

    public final void removeDataListener(int n) {
        SDataListener sDataListener = SApplet.getDataListener(n);
        SDataConnection sDataConnection = null;
        do {
            if ((sDataConnection = this.getDataConnectionFromDL(sDataListener)) == null) continue;
            this.dataConnections.removeElement(sDataConnection);
        } while (sDataConnection != null);
        dataListeners.remove(Integer.toString(n));
    }

    public static final void addDataListener(Object object) {
        if (object instanceof SDataListener) {
            dataListeners.put(Integer.toString(object.hashCode()), object);
            if (staticDebugLevel > 8) {
                System.out.println("data listener added: ".concat(String.valueOf(String.valueOf(object.hashCode()))));
            }
        } else {
            System.out.println("Error: dl is not a DataListener in SApplet.addDataListener:".concat(String.valueOf(String.valueOf(object.hashCode()))));
        }
    }

    public static final SDataListener getDataListener(String string) {
        return (SDataListener)dataListeners.get(string);
    }

    public static final SDataListener getDataListener(int n) {
        return (SDataListener)dataListeners.get(Integer.toString(n));
    }
}

