/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.tools;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.util.Enumeration;
import java.util.Vector;

public final class SClock
implements Runnable,
SDataSource {
    Vector clockListeners = new Vector();
    private String[] varStrings = new String[]{"t"};
    private double[][] ds = new double[1][1];
    private Thread thread = null;
    private Object runLock = new Object();
    private boolean shouldRun = true;
    private boolean running = false;
    private double time = 0.0;
    int delay = 100;
    double maxTime = 100.0;
    double minTime = 0.0;
    double dt = 0.1;
    boolean oneShot = false;
    boolean cycle = false;
    SApplet owner = null;

    public SClock() {
        this.thread = new Thread(this);
        this.thread.start();
        try {
            SApplet.addDataSource(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SClock(SApplet sApplet) {
        this();
        this.owner = sApplet;
    }

    public synchronized void addClockListener(SStepable sStepable) {
        if (this.thread == null) {
            Object object = this.runLock;
            synchronized (object) {
                this.shouldRun = true;
                this.running = false;
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
        if (this.clockListeners.contains(sStepable)) {
            return;
        }
        this.clockListeners.addElement(sStepable);
    }

    public void removeClockListener(SStepable sStepable) {
        Object object = this.runLock;
        synchronized (object) {
            if (!this.clockListeners.contains(sStepable)) {
                return;
            }
            this.clockListeners.removeElement(sStepable);
        }
    }

    public void removeAllClockListeners() {
        Object object = this.runLock;
        synchronized (object) {
            this.clockListeners.removeAllElements();
        }
    }

    public void doStep() {
        if (this.running) {
            this.stopClock();
            return;
        }
        boolean bl = false;
        if (this.isRunning() || this.oneShot && this.dt > 0.0 && this.time + 0.49 * this.dt >= this.maxTime || this.oneShot && this.dt < 0.0 && this.time + 0.49 * this.dt <= this.minTime || this.cycle && this.dt < 0.0 && this.time + this.dt < this.minTime) {
            return;
        }
        if (this.cycle && this.time >= this.maxTime && this.dt > 0.0) {
            this.time = this.minTime;
            bl = true;
        }
        if (this.cycle && this.time < this.minTime && this.dt < 0.0) {
            this.time = this.maxTime;
            bl = true;
        }
        Enumeration enumeration = this.clockListeners.elements();
        while (enumeration.hasMoreElements()) {
            SStepable sStepable = (SStepable)enumeration.nextElement();
            if (!this.shouldRun) continue;
            sStepable.step(this.dt, this.time);
        }
        if (this.owner != null && bl) {
            this.owner.cyclingClock();
        }
        if (this.owner != null && this.shouldRun) {
            this.owner.updateDataConnection(this.hashCode());
        }
        this.time += this.dt;
    }

    private void runningStep() {
        boolean bl = false;
        if (this.cycle && this.time + 0.49 * this.dt >= this.maxTime && this.dt > 0.0) {
            this.time = this.minTime;
            bl = true;
        }
        Enumeration enumeration = this.clockListeners.elements();
        while (enumeration.hasMoreElements()) {
            SStepable sStepable = (SStepable)enumeration.nextElement();
            if (!this.shouldRun) continue;
            sStepable.step(this.dt, this.time);
        }
        if (this.owner != null && this.shouldRun) {
            this.owner.updateDataConnection(this.hashCode());
        }
        this.time += this.dt;
        if (this.owner != null && SApplet.runningID != null && this.owner != SApplet.runningID) {
            this.running = false;
            this.owner.pausingClock();
        }
        if (this.cycle && this.dt < 0.0 && this.time + 0.49 * this.dt < this.minTime || this.oneShot && this.dt < 0.0 && this.time + 0.49 * this.dt <= this.minTime || this.oneShot && this.dt > 0.0 && this.time + 0.49 * this.dt >= this.maxTime) {
            this.running = false;
            this.owner.stoppingClock();
        }
        if (this.owner != null && bl) {
            this.owner.cyclingClock();
        }
    }

    public final double getTime() {
        return this.time;
    }

    public final double getMinTime() {
        return this.minTime;
    }

    public final double getMaxTime() {
        return this.maxTime;
    }

    public void setTime(double d) {
        boolean bl = this.running;
        this.running = false;
        Object object = this.runLock;
        synchronized (object) {
            this.time = d;
        }
        if (bl) {
            this.startClock();
        } else {
            this.owner.updateDataConnection(this.hashCode());
        }
    }

    public final double getDt() {
        return this.dt;
    }

    public void setDt(double d) {
        boolean bl = this.running;
        this.running = false;
        Object object = this.runLock;
        synchronized (object) {
            this.dt = d;
        }
        if (bl) {
            this.startClock();
        }
    }

    public final double getTimeStep() {
        return this.getDt();
    }

    public void setTimeStep(double d) {
        this.setDt(d);
    }

    public void setContinuous() {
        this.cycle = false;
        this.oneShot = false;
    }

    public void setCycle(double d, double d2) {
        boolean bl = this.running;
        double d3 = this.time;
        this.running = false;
        Object object = this.runLock;
        synchronized (object) {
            this.minTime = Math.min(d, d2);
            this.maxTime = Math.max(d, d2);
            this.time = Math.max(this.time, this.minTime);
            this.time = Math.min(this.time, this.maxTime);
            this.oneShot = false;
            this.cycle = true;
        }
        if (bl) {
            this.startClock();
        } else if (d3 != this.time) {
            this.owner.updateDataConnection(this.hashCode());
        }
    }

    public void setOneShot(double d, double d2) {
        boolean bl = this.running;
        double d3 = this.time;
        this.running = false;
        Object object = this.runLock;
        synchronized (object) {
            this.minTime = Math.min(d, d2);
            this.maxTime = Math.max(d, d2);
            this.time = Math.max(this.time, this.minTime);
            this.time = Math.min(this.time, this.maxTime);
            this.oneShot = true;
            this.cycle = false;
        }
        if (bl) {
            this.startClock();
        } else if (d3 != this.time) {
            this.owner.updateDataConnection(this.hashCode());
        }
    }

    public synchronized void startClock() {
        if (this.owner != null) {
            SApplet.runningID = this.owner;
        }
        if (this.running && this.thread != null) {
            return;
        }
        if (this.oneShot && this.dt > 0.0 && this.time + 0.49 * this.dt >= this.maxTime) {
            this.running = false;
            this.owner.stoppingClock();
            return;
        }
        if ((this.oneShot || this.cycle) && this.dt < 0.0 && this.time + 0.49 * this.dt <= this.minTime) {
            this.running = false;
            this.owner.stoppingClock();
            return;
        }
        if (this.thread == null) {
            this.shouldRun = true;
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            Object object = this.runLock;
            synchronized (object) {
                this.running = true;
                this.runLock.notifyAll();
            }
        }
    }

    public synchronized void panicStopClock() {
        this.shouldRun = false;
        if (this.thread == null) {
            return;
        }
        this.startClock();
        try {
            this.thread.join(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stopClock() {
        if (!this.running) {
            return;
        }
        this.running = false;
        Object object = this.runLock;
        // MONITORENTER : object
        // MONITOREXIT : object
    }

    public double getFPS() {
        return 1000.0 / (double)this.delay;
    }

    public void setFPS(double d) {
        this.delay = Math.max(0, (int)((double)1000 / d));
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public boolean isContinous() {
        return !this.oneShot && !this.cycle;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        while (this.shouldRun) {
            Object object = this.runLock;
            synchronized (object) {
                while (!this.running) {
                    try {
                        this.runLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.shouldRun) {
                    this.runningStep();
                }
            }
            if (!this.shouldRun) continue;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.time;
        return this.ds;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
        this.owner = sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }
}

