/*
 * Decompiled with CFR 0.152.
 */
package doppler;

import doppler.DopplerCanvas;
import doppler.DopplerFrame;
import doppler.SizedButton;
import doppler.VarScrollBar;
import edu.davidson.graphics.EtchedBorder;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;
import java.net.URL;

public class Doppler
extends Applet
implements Runnable {
    private Thread m_Doppler = null;
    private VarScrollBar speedBar;
    private DopplerCanvas dc;
    private int sleepTime = 50;
    private Checkbox cCheck;
    private Checkbox rCheck;
    private SizedButton runBtn;
    private boolean runOnStart = false;
    private boolean m_fStandAlone = false;
    private double m_speed = 0.5;
    private int m_fps = 20;
    private boolean m_relativistic = false;
    private String m_helpFile = null;
    private boolean m_showControls = true;
    private boolean m_showButtons = true;
    private final String PARAM_speed = "speed";
    private final String PARAM_fps = "fps";
    private final String PARAM_relativistic = "relativistic";
    private final String PARAM_helpFile = "helpFile";
    private final String PARAM_showControls = "showControls";
    private final String PARAM_showButtons = "showButtons";

    String GetParameter(String string, String[] stringArray) {
        if (stringArray == null) {
            return this.getParameter(string);
        }
        String string2 = String.valueOf(string).concat(String.valueOf("="));
        String string3 = null;
        int n = string2.length();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].substring(0, n);
                if (!string2.equalsIgnoreCase(string4)) continue;
                string3 = stringArray[i].substring(n);
                if (string3.startsWith("\"") && (string3 = string3.substring(1)).endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    void GetParameters(String[] stringArray) {
        String string = this.GetParameter("speed", stringArray);
        if (string != null) {
            this.m_speed = Double.valueOf(string);
        }
        if ((string = this.GetParameter("fps", stringArray)) != null) {
            this.m_fps = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("relativistic", stringArray)) != null) {
            this.m_relativistic = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("showControls", stringArray)) != null) {
            this.m_showControls = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("showButtons", stringArray)) != null) {
            this.m_showButtons = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("helpFile", stringArray)) != null) {
            this.m_helpFile = string;
        }
    }

    public static void main(String[] stringArray) {
        DopplerFrame dopplerFrame = new DopplerFrame("Doppler");
        dopplerFrame.show();
        ((Component)dopplerFrame).hide();
        dopplerFrame.resize(dopplerFrame.insets().left + dopplerFrame.insets().right + 320, dopplerFrame.insets().top + dopplerFrame.insets().bottom + 340);
        Doppler doppler = new Doppler();
        dopplerFrame.add("Center", doppler);
        doppler.m_fStandAlone = true;
        doppler.GetParameters(stringArray);
        doppler.init();
        doppler.start();
        dopplerFrame.show();
    }

    public String getAppletInfo() {
        return "Name: Doppler ver 1.2\r\nAuthor: Wolfgang Christian\r\nemail: wochristian@davidson.edu\r\n";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"speed", "double", "Source speed"}, {"fps", "int", "Frames per second"}, {"relativistic", "boolean", "Relativistic effects."}, {"showControls", "boolean", "Show controls and buttons."}, {"showButtons", "boolean", "Show classical/relativistic options."}, {"helpFile", "String", "Applet help file URL."}};
        return stringArray;
    }

    public void init() {
        this.runOnStart = false;
        if (!this.m_fStandAlone) {
            this.GetParameters(null);
        }
        this.resize(320, 340);
        this.sleepTime = 1000 / this.m_fps;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new BorderLayout());
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Panel panel2 = new Panel();
        panel2.setBackground(Color.lightGray);
        panel2.setLayout(new GridLayout(1, 2, 4, 4));
        this.cCheck = new Checkbox("Classical", checkboxGroup, true);
        panel2.add(this.cCheck);
        this.rCheck = new Checkbox("Relativistic", checkboxGroup, false);
        panel2.add(this.rCheck);
        if (this.m_showButtons) {
            panel.add("North", panel2);
        }
        if (this.m_relativistic) {
            if (this.m_speed > 0.99) {
                this.m_speed = 0.99;
            }
            this.speedBar = new VarScrollBar("speed= ", this.m_speed, 0.0, 0.99);
        } else {
            if (this.m_speed > 2.0) {
                this.m_speed = 2.0;
            }
            this.speedBar = new VarScrollBar("speed", this.m_speed, 0.0, 2.0);
        }
        panel.add("Center", new EtchedBorder(this.speedBar));
        this.runBtn = new SizedButton("Run ");
        panel.add("West", this.runBtn);
        if (this.m_showControls) {
            this.add("South", panel);
        }
        this.dc = new DopplerCanvas(this);
        this.dc.setBackground(Color.white);
        this.add("Center", this.dc);
        this.dc.setSpeed(this.m_speed, 0.0);
        this.dc.setRelativistic(this.m_relativistic);
    }

    public void destroy() {
        if (this.m_Doppler != null) {
            this.m_Doppler.stop();
            this.m_Doppler = null;
        }
    }

    public void reset() {
        this.dc.reset();
        this.dc.repaint();
    }

    public void start() {
        if (this.m_Doppler == null) {
            this.m_Doppler = new Thread(this);
            this.m_Doppler.start();
        }
    }

    public void stop() {
        if (this.m_Doppler != null) {
            this.m_Doppler.stop();
            this.m_Doppler = null;
        }
    }

    public void forward() {
        this.runOnStart = true;
        this.start();
    }

    public void pause() {
        this.runOnStart = false;
        this.stop();
    }

    public void step() {
        if (this.m_Doppler == null) {
            this.dc.incTime(this.m_speed);
        }
    }

    public void run() {
        boolean bl = true;
        while (this.runOnStart && bl) {
            try {
                this.dc.incTime(this.m_speed);
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.stop();
            }
        }
        this.m_Doppler = null;
    }

    public boolean handleEvent(Event event) {
        if (event.target.equals(this.speedBar)) {
            this.m_speed = this.speedBar.getValue();
            this.dc.setSpeed(this.m_speed, 0.0);
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            String string = this.m_helpFile;
            if (string != null) {
                try {
                    URL uRL = new URL(this.getDocumentBase(), string);
                    this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    System.out.println("Failed to load help file!");
                }
            }
            return true;
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.runBtn)) {
            if (this.runOnStart) {
                this.runOnStart = false;
                this.runBtn.setLabel("Stop");
                this.pause();
            } else {
                this.runOnStart = false;
                this.runBtn.setLabel("Run ");
                this.forward();
            }
            return true;
        }
        if (event.target.equals(this.rCheck)) {
            this.m_relativistic = true;
            if (this.m_speed > 1.0) {
                this.m_speed = 0.99;
            }
            this.speedBar.setMinMax(0.0, 0.99);
            this.speedBar.setValue(this.m_speed);
            this.dc.setSpeed(this.m_speed, 0.0);
            this.dc.setRelativistic(this.m_relativistic);
            return true;
        }
        if (event.target.equals(this.cCheck)) {
            this.m_relativistic = false;
            this.speedBar.setMinMax(0.0, 2.0);
            this.speedBar.setValue(this.m_speed);
            this.dc.setRelativistic(this.m_relativistic);
            return true;
        }
        return false;
    }

    public void setSpeed(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.m_speed = this.m_relativistic ? (d > 0.99 ? 0.99 : d) : (d > 2.0 ? 2.0 : d);
        this.speedBar.setValue(this.m_speed);
        this.dc.setSpeed(this.m_speed, 0.0);
    }

    public void setSourceX(double d) {
        this.dc.setX((int)d);
    }

    public void setClassical() {
        if (!this.m_relativistic) {
            return;
        }
        this.m_relativistic = false;
        this.speedBar.setMinMax(0.0, 2.0);
        this.speedBar.setValue(this.m_speed);
        this.dc.setRelativistic(this.m_relativistic);
        this.cCheck.setState(true);
    }

    public void setRelativistic() {
        if (this.m_relativistic) {
            return;
        }
        this.m_relativistic = true;
        if (this.m_speed > 1.0) {
            this.m_speed = 0.99;
        }
        this.speedBar.setMinMax(0.0, 0.99);
        this.speedBar.setValue(this.m_speed);
        this.dc.setSpeed(this.m_speed, 0.0);
        this.dc.setRelativistic(this.m_relativistic);
        this.rCheck.setState(true);
    }

    public void setCaption(String string) {
        this.dc.setCaption(string);
    }
}

