/*
 * Decompiled with CFR 0.152.
 */
package doppler;

import doppler.ChangeValueEvent;
import edu.davidson.display.Format;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;

public final class VarScrollBar
extends Panel {
    String caption;
    Scrollbar scrollBar;
    double value;
    double min;
    double max;
    TextField valFld;
    boolean hasChanged = false;
    Label captionLbl;

    public VarScrollBar(String string, double d, double d2, double d3) {
        this.caption = string;
        this.setLayout(new BorderLayout());
        this.value = d;
        this.min = d2;
        this.max = d3;
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.scrollBar = new Scrollbar(0, (int)((double)100 * (this.value - this.min) / (this.max - this.min)), 4, 0, 100);
        this.captionLbl = new Label(string, 0);
        this.add("West", this.captionLbl);
        this.add("Center", this.scrollBar);
        this.valFld = new TextField(String.valueOf("").concat(String.valueOf(d)));
        this.add("East", this.valFld);
    }

    public Insets insets() {
        int n = (this.size().height - 30) / 2;
        if (n < 0) {
            n = 0;
        }
        return new Insets(n, 2, n, 2);
    }

    public Dimension preferredSize() {
        return new Dimension(100, 20);
    }

    public Dimension minimumSize() {
        return new Dimension(40, 15);
    }

    public boolean keyUp(Event event, int n) {
        if (!event.target.equals(this.valFld)) {
            return false;
        }
        ((Component)this.valFld).setBackground(Color.yellow);
        return true;
    }

    public void setCaption(String string) {
        this.caption = string;
        this.captionLbl.setText(this.caption);
    }

    public double getValue() {
        this.hasChanged = false;
        ((Component)this.valFld).setBackground(Color.white);
        this.valFld.setText(String.valueOf("").concat(String.valueOf(this.value)));
        this.scrollBar.setValue((int)((double)100 * (this.value - this.min) / (this.max - this.min)));
        return this.value;
    }

    public void setValue(double d) {
        this.hasChanged = false;
        ((Component)this.valFld).setBackground(Color.white);
        this.value = d;
        this.valFld.setText(String.valueOf("").concat(String.valueOf(this.value)));
        this.scrollBar.setValue((int)((double)100 * (this.value - this.min) / (this.max - this.min)));
    }

    public void setMinMax(double d, double d2) {
        this.hasChanged = false;
        ((Component)this.valFld).setBackground(Color.white);
        this.min = d;
        this.max = d2;
        this.valFld.setText(String.valueOf("").concat(String.valueOf(this.value)));
        this.scrollBar.setValue((int)((double)100 * (this.value - this.min) / (this.max - this.min)));
    }

    public boolean action(Event event, Object object) {
        if (!event.target.equals(this.valFld)) {
            return false;
        }
        this.value = Format.atof((String)object);
        this.scrollBar.setValue((int)((double)100 * (this.value - this.min) / (this.max - this.min)));
        ((Component)this.valFld).setBackground(Color.white);
        String string = this.valFld.getText();
        this.valFld.setText(string);
        ChangeValueEvent changeValueEvent = new ChangeValueEvent((Object)this, event, 1);
        this.deliverEvent(changeValueEvent);
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 605 || event.id == 602 || event.id == 601 || event.id == 604 || event.id == 603) {
            this.value = this.min + (this.max - this.min) * (double)this.scrollBar.getValue() / 100.0;
            ((Component)this.valFld).setBackground(Color.white);
            this.valFld.setText(String.valueOf("").concat(String.valueOf(this.value)));
            ChangeValueEvent changeValueEvent = new ChangeValueEvent((Object)this, event, 1);
            this.deliverEvent(changeValueEvent);
            return true;
        }
        return super.handleEvent(event);
    }
}

