/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.DrawnRectangle;
import edu.davidson.graphics.HintPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;

public class Border
extends Panel {
    protected int thickness;
    protected int gap;
    protected DrawnRectangle border;
    protected Component borderMe;
    protected static int _defaultThickness = 2;
    protected static int _defaultGap = 0;

    public Border() {
        this(new HintPanel(), _defaultThickness, _defaultGap);
    }

    public Border(Component component) {
        this(component, _defaultThickness, _defaultGap);
    }

    public Border(Component component, int n) {
        this(component, n, _defaultGap);
    }

    public Border(Component component, int n, int n2) {
        this.borderMe = component;
        this.thickness = n;
        this.gap = n2;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
    }

    public Component getComponent() {
        return this.borderMe;
    }

    public Rectangle getInnerBounds() {
        return this.border().getInnerBounds();
    }

    public void setLineColor(Color color) {
        this.border().setLineColor(color);
        this.repaint();
    }

    public Color getLineColor() {
        return this.border().getLineColor();
    }

    public void paint(Graphics graphics) {
        this.border().paint();
        super.paint(graphics);
    }

    public Insets getInsets() {
        return new Insets(this.thickness + this.gap, this.thickness + this.gap, this.thickness + this.gap, this.thickness + this.gap);
    }

    public void setSize(int n, int n2) {
        Point point = this.getLocation();
        this.setBounds(point.x, point.y, n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.border().setSize(n3, n4);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",border="))).concat(String.valueOf(this.border().toString()))).concat(String.valueOf(",thickness="))).concat(String.valueOf(this.thickness))).concat(String.valueOf(",gap="))).concat(String.valueOf(this.gap));
    }

    protected DrawnRectangle border() {
        if (this.border == null) {
            this.border = new DrawnRectangle(this, this.thickness);
        }
        return this.border;
    }

    public void setHint(String string) {
        if (this.borderMe instanceof HintPanel) {
            ((HintPanel)this.borderMe).setBubbleHelp(string);
        }
    }

    public void setThickness(int n) {
        this.thickness = n;
        this.border().setThickness(n);
        this.repaint();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setGap(int n) {
        this.gap = n;
        this.repaint();
    }

    public int getGap() {
        return this.gap;
    }

    public void setFillColor(Color color) {
        this.border().setFillColor(color);
        this.repaint();
    }

    public Color getFillColor() {
        return this.border().getFillColor();
    }
}

