/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.Animator;
import animator4.Animator_mouseAdapter;
import animator4.Animator_mouseMotionAdapter;
import animator4.Arrow;
import animator4.ArrowStatic;
import animator4.Box;
import animator4.CaptionThing;
import animator4.Charge;
import animator4.Circle;
import animator4.Connector;
import animator4.CursorThing;
import animator4.Doppler;
import animator4.DrawnRectangle;
import animator4.ExShell;
import animator4.FunctionThing;
import animator4.ImageThing;
import animator4.Interaction;
import animator4.Piston;
import animator4.ShapeThing;
import animator4.Shell;
import animator4.Spring;
import animator4.TextThing;
import animator4.Thing;
import animator4.TrailThing;
import edu.davidson.display.Format;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public class AnimatorCanvas
extends Canvas
implements SStepable,
SDataSource {
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private boolean enableMouse = false;
    private int boxWidth = 0;
    private Format mouseFormat = new Format("%-+6.3g");
    private String collisionMessage = "Collision";
    private Image sketchImage = null;
    private boolean sketchMode = false;
    private TrailThing trailThing = null;
    private Cursor sketchCursor = null;
    Thing dragThing = null;
    Color defaultColor = null;
    Vector things = new Vector();
    Font boldFont = new Font("Helvetica", 1, 14);
    Animator owner = null;
    int pixPerUnit = 10;
    Image backgroundImage = null;
    Image osi;
    int iwidth = 0;
    int iheight = 0;
    int xOffset = 0;
    int yOffset = 0;
    double gridUnit = 1.0;
    double time = 0.0;
    boolean timeDisplay = true;
    boolean coordDisplay = true;
    boolean autoRefresh = true;
    String message = null;
    boolean mouseDrag = false;
    int mouseX = 0;
    int mouseY = 0;
    String[] varStrings = new String[]{"t", "xcm", "ycm", "px", "py", "m", "ke"};
    double[][] ds = new double[1][7];
    DynamicsSolver dynamics = new DynamicsSolver();
    int stickyCount = 0;
    boolean dampOnMousePressed = true;

    public AnimatorCanvas(Animator animator) {
        this();
        this.owner = animator;
    }

    public AnimatorCanvas() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setEnableMouse(true);
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public double[][] getVariables() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            d5 += thing.mass;
            d += thing.mass * thing.vars[1];
            d2 += thing.mass * thing.vars[2];
            d3 += thing.mass * thing.vars[3];
            d4 += thing.mass * thing.vars[4];
            d6 += thing.mass * (thing.vars[3] * thing.vars[3] + thing.vars[4] * thing.vars[4]);
        }
        this.ds[0][0] = this.time;
        this.ds[0][1] = d5 > 0.0 ? d / d5 : 0.0;
        this.ds[0][2] = d5 > 0.0 ? d2 / d5 : 0.0;
        this.ds[0][3] = d3;
        this.ds[0][4] = d4;
        this.ds[0][5] = d5;
        this.ds[0][6] = d6 / (double)2;
        return this.ds;
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    void clearTrails() {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.clearTrail();
        }
    }

    public int addParametricCurve(int n, double d, double d2, String string, String string2) {
        FunctionThing functionThing = new FunctionThing(this, n, d, d2, string, string2);
        if (this.defaultColor != null) {
            functionThing.color = this.defaultColor;
        }
        this.things.addElement(functionThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return functionThing.hashCode();
    }

    public int addPolyShape(int n, int[] nArray, int[] nArray2, String string, String string2) {
        ShapeThing shapeThing = new ShapeThing(this, n, nArray, nArray2, string, string2);
        if (this.defaultColor != null) {
            shapeThing.color = this.defaultColor;
        }
        this.things.addElement(shapeThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return shapeThing.hashCode();
    }

    public boolean addInteraction(int n, int n2, String string, String string2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        string2 = string2.trim();
        int n3 = (string2 = string2.toLowerCase()).equals("x") ? Interaction.XMODE : (string2.equals("y") ? Interaction.YMODE : Interaction.RMODE);
        if (thing != null && thing.dynamic) {
            thing.addInteraction(thing2, string, n3);
        }
        if (thing2 != null && thing2.dynamic) {
            thing2.addInteraction(thing, string, n3);
        }
        return true;
    }

    public int addArrow(int n, String string, String string2, String string3, String string4) {
        Arrow arrow = new Arrow(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            arrow.color = this.defaultColor;
        }
        this.things.addElement(arrow);
        if (this.autoRefresh) {
            this.repaint();
        }
        return arrow.hashCode();
    }

    public int addArrowStatic(int n, double d, double d2, String string, String string2) {
        ArrowStatic arrowStatic = new ArrowStatic(this, n, d, d2, string, string2);
        if (this.defaultColor != null) {
            arrowStatic.color = this.defaultColor;
        }
        this.things.addElement(arrowStatic);
        if (this.autoRefresh) {
            this.repaint();
        }
        return arrowStatic.hashCode();
    }

    public int addPiston(int n, String string, String string2, String string3, String string4) {
        Piston piston = new Piston(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            piston.color = this.defaultColor;
        }
        this.things.addElement(piston);
        if (this.autoRefresh) {
            this.repaint();
        }
        return piston.hashCode();
    }

    public int addSpring(int n, String string, String string2, String string3, String string4) {
        Spring spring = new Spring(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            spring.color = this.defaultColor;
        }
        this.things.addElement(spring);
        if (this.autoRefresh) {
            this.repaint();
        }
        return spring.hashCode();
    }

    public int addCircle(int n, String string, String string2) {
        Circle circle = new Circle(this, n, string, string2);
        if (this.defaultColor != null) {
            circle.color = this.defaultColor;
        }
        this.things.addElement(circle);
        if (this.autoRefresh) {
            this.repaint();
        }
        return circle.hashCode();
    }

    public int addDoppler(int n, String string, String string2, int n2, double d, double d2) {
        Doppler doppler = new Doppler(this, n, string, string2, n2, d, d2);
        if (this.defaultColor != null) {
            doppler.color = this.defaultColor;
        }
        this.things.addElement(doppler);
        if (this.autoRefresh) {
            this.repaint();
        }
        return doppler.hashCode();
    }

    public int addCharge(int n, String string, String string2, double d) {
        Charge charge = new Charge(this, n, string, string2, d);
        if (this.defaultColor != null) {
            charge.color = this.defaultColor;
        }
        this.things.addElement(charge);
        if (this.autoRefresh) {
            this.repaint();
        }
        return charge.hashCode();
    }

    public int addShell(int n, String string, String string2) {
        Shell shell = new Shell(this, n, string, string2);
        if (this.defaultColor != null) {
            shell.color = this.defaultColor;
        }
        this.things.addElement(shell);
        if (this.autoRefresh) {
            this.repaint();
        }
        return shell.hashCode();
    }

    public int addExShell(int n, String string, String string2, String string3) {
        ExShell exShell = new ExShell(this, n, string, string2, string3);
        if (this.defaultColor != null) {
            exShell.color = this.defaultColor;
        }
        this.things.addElement(exShell);
        if (this.autoRefresh) {
            this.repaint();
        }
        return exShell.hashCode();
    }

    public int addBox(int n, int n2, String string, String string2) {
        Box box = new Box(this, n, n2, string, string2);
        if (this.defaultColor != null) {
            box.color = this.defaultColor;
        }
        this.things.addElement(box);
        if (this.autoRefresh) {
            this.repaint();
        }
        return box.hashCode();
    }

    public int addRectangle(int n, int n2, String string, String string2) {
        DrawnRectangle drawnRectangle = new DrawnRectangle(this, n, n2, string, string2);
        if (this.defaultColor != null) {
            drawnRectangle.color = this.defaultColor;
        }
        this.things.addElement(drawnRectangle);
        if (this.autoRefresh) {
            this.repaint();
        }
        return drawnRectangle.hashCode();
    }

    public int addText(String string, String string2, String string3, String string4) {
        TextThing textThing = new TextThing(this, string, string2, string3, string4);
        if (this.defaultColor != null) {
            textThing.color = this.defaultColor;
        }
        this.things.addElement(textThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return textThing.hashCode();
    }

    public int addCaption(String string, String string2, String string3, String string4) {
        CaptionThing captionThing = new CaptionThing(this, string, string2, string3, string4);
        this.things.addElement(captionThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return captionThing.hashCode();
    }

    public int addCursor(int n, String string, String string2) {
        CursorThing cursorThing = new CursorThing(this, n, string, string2);
        this.things.addElement(cursorThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return cursorThing.hashCode();
    }

    public int addImage(Image image, String string, String string2) {
        if (image == null) {
            return 0;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            mediaTracker.addImage(image, 1);
            mediaTracker.waitForID(1, 4000L);
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
        if (mediaTracker.isErrorAny()) {
            return 0;
        }
        if (image.getHeight(this) < 1) {
            return 0;
        }
        ImageThing imageThing = new ImageThing(this, image, string, string2);
        this.things.addElement(imageThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return imageThing.hashCode();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            this.paintOSI();
            graphics.drawImage(this.osi, 0, 0, this);
            if (this.mouseDrag && this.sketchMode && this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, this.mouseX, this.mouseY - this.sketchImage.getHeight(this), this);
            }
            graphics.dispose();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.sync();
        }
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        if (this.owner.isClockRunning()) {
            return;
        }
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            this.paintOSI();
            graphics.drawImage(this.osi, 0, 0, this);
        }
    }

    public void paintOSI() {
        int n = this.iwidth / 2 - this.xOffset;
        int n2 = this.iheight / 2 + this.yOffset;
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.iwidth, this.iheight);
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, 0, 0, this);
        }
        graphics.clipRect(0, 0, this.iwidth, this.iheight);
        this.paintThingsBeforeGrid(graphics);
        this.paintGrid(graphics, n, n2);
        this.paintThingsAfterGrid(graphics);
        this.paintTime(graphics);
        this.paintMessage(graphics);
        if (this.mouseDrag) {
            this.paintCoords(graphics, this.mouseX, this.mouseY);
        }
        graphics.dispose();
    }

    void setTime() {
        Thing thing;
        this.time = this.owner.clock.getTime();
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setTime(this.time, this.owner.dt / 10000.0);
        }
        enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
        }
        this.dynamics.resetDynamicsVariables();
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
        if (this.autoRefresh) {
            this.paint();
        }
    }

    public void step(double d, double d2) {
        Thing thing;
        if (this.testForCollision()) {
            if (this.collisionMessage != null && !this.collisionMessage.equals("")) {
                this.setMessage(this.collisionMessage);
            }
            this.owner.stopClock();
            return;
        }
        this.dynamics.step(d, d2);
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (!thing.dynamic && thing.noDrag && thing.myMaster == null) {
                thing.setVars(this.time + d, d);
            }
            if (!thing.dynamic) {
                thing.vars[0] = this.time + d;
            }
            if (thing.myMaster != null || thing instanceof TrailThing) continue;
            thing.incTrail();
        }
        if (this.dragThing != null) {
            this.dragThing.vars[0] = this.time + d;
            this.dragThing.vars[3] = 0.0;
            this.dragThing.vars[4] = 0.0;
        }
        enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.myMaster == null) continue;
            thing.setVarsFromMaster();
            thing.incTrail();
        }
        this.time = d2 + d;
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
        this.paint();
    }

    public void setMessage(String string) {
        if (this.message == null && string == null || this.message != null && this.message.equals(string)) {
            return;
        }
        this.message = string;
        this.paintMessage();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setCollisionMessage(String string) {
        this.collisionMessage = string;
    }

    public int setCaption(String string) {
        int n = this.addCaption(string, null, "0", "0");
        if (this.autoRefresh) {
            this.repaint();
        }
        return n;
    }

    public void paintThingsBeforeGrid(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!thing.paintBeforeGrid) continue;
            thing.paint(graphics);
        }
    }

    public void paintThingsAfterGrid(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (thing.paintBeforeGrid) continue;
            thing.paint(graphics);
        }
    }

    void paintTime(Graphics graphics) {
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.boldFont);
        String string = new Format("%7.4g").form(SUtil.chop((double)this.time, (double)1.0E-12));
        if (this.timeDisplay) {
            if (this.iwidth > 150) {
                graphics.drawString("Time: ".concat(String.valueOf(string)), 10, 15);
            } else {
                graphics.drawString("Time: ".concat(String.valueOf(string)), 10, this.iheight - 40);
            }
        }
        graphics.setFont(font);
    }

    void paintGrid(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(Color.lightGray);
        int n4 = (int)Math.round((double)this.pixPerUnit * this.gridUnit);
        if (n4 > 0) {
            for (n3 = n % n4; n3 < this.iwidth; n3 += n4) {
                graphics.drawLine(n3, 0, n3, this.iheight);
            }
        }
        if (n4 > 0) {
            for (n3 = n2 % n4; n3 < this.iheight; n3 += n4) {
                graphics.drawLine(0, n3, this.iwidth, n3);
            }
        }
    }

    void paintMessage() {
        Graphics graphics = this.getGraphics();
        this.paintMessage(graphics);
        graphics.dispose();
    }

    void paintMessage(Graphics graphics) {
        if (this.message == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(this.message);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.message, this.iwidth - n + 2, this.iheight - 3);
        graphics.drawRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
    }

    void paintCoords(int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        if (!this.coordDisplay) {
            return;
        }
        String string = String.valueOf(new StringBuffer("").append(this.mouseFormat.form(this.xFromPix(n))).append(" , ").append(this.mouseFormat.form(this.yFromPix(n2))));
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(0, rectangle.height - 20, this.boxWidth - 1, 20);
    }

    double xFromPix(int n) {
        int n2 = this.iwidth / 2 - this.xOffset;
        return (double)(n - n2) / (1.0 * (double)this.pixPerUnit);
    }

    double yFromPix(int n) {
        int n2 = this.iheight / 2 + this.yOffset;
        return (double)(-(n - n2)) / (1.0 * (double)this.pixPerUnit);
    }

    int pixFromX(double d) {
        int n = (int)((double)(this.iwidth / 2) + d * (double)this.pixPerUnit - (double)this.xOffset);
        return n;
    }

    int pixFromY(double d) {
        int n = (int)((double)(this.iheight / 2) - d * (double)this.pixPerUnit + (double)this.yOffset);
        return n;
    }

    void setDefault() {
        this.defaultColor = null;
        this.setBackground(Color.white);
        this.xOffset = 0;
        this.yOffset = 0;
        this.dynamics = new DynamicsSolver();
        this.things.removeAllElements();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public final boolean setFormat(String string) {
        try {
            this.mouseFormat = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public int setSketchMode(boolean bl) {
        this.sketchImage = Util.getImage((String)"pencil.gif", (Applet)((Object)this.owner));
        boolean bl2 = false;
        int n = 29;
        this.sketchMode = bl;
        if (!bl) {
            this.trailThing = null;
            return 0;
        }
        this.sketchCursor = null;
        return 0;
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        int n3 = this.things.indexOf(thing);
        int n4 = this.things.indexOf(thing2);
        this.things.removeElementAt(n3);
        this.things.insertElementAt(thing2, n3);
        this.things.removeElementAt(n4);
        this.things.insertElementAt(thing, n4);
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    void highlightMySlaves(Thing thing, Graphics graphics) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2.myMaster != thing) continue;
            thing2.paintHighlight(graphics);
        }
    }

    void paintMyConnectors(Thing thing, Graphics graphics) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (!(thing2 instanceof Connector) || thing != ((Connector)thing2).thing1 && thing != ((Connector)thing2).thing2) continue;
            thing2.paint(graphics);
        }
    }

    public boolean isEnableMouse() {
        return this.enableMouse;
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.noDrag && !thing.resizable || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean isInsideStickyThing(int n, int n2, Thing thing) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2 == thing || !thing2.sticky || !thing2.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean testForCollision() {
        if (this.stickyCount == 0) {
            return false;
        }
        int n = this.things.size();
        this.stickyCount = 0;
        for (int i = 0; i < n; ++i) {
            Thing thing = (Thing)this.things.elementAt(i);
            if (!thing.sticky || !thing.dynamic) continue;
            ++this.stickyCount;
            if (!this.isInsideStickyThing(this.pixFromX(thing.vars[1]), this.pixFromY(thing.vars[2]), thing)) continue;
            return true;
        }
        return false;
    }

    public void setEnableMouse(boolean bl) {
        if (this.enableMouse == bl) {
            return;
        }
        this.enableMouse = bl;
        if (this.enableMouse) {
            this.mouseMotionAdapter = new Animator_mouseMotionAdapter(this);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.mouseAdapter = new Animator_mouseAdapter(this);
            this.addMouseListener(this.mouseAdapter);
        } else {
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeMouseListener(this.mouseAdapter);
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        double d;
        int n;
        if ((mouseEvent.getModifiers() & 4) == 0) {
            this.mouseDrag = true;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            Graphics graphics = this.getGraphics();
            n = this.things.size();
            for (int i = 0; i < n; ++i) {
                Thing thing = (Thing)this.things.elementAt(i);
                if (thing.noDrag && !thing.resizable || !thing.isInsideThing(this.mouseX, this.mouseY)) continue;
                this.dragThing = thing;
            }
            if (this.dragThing != null) {
                this.mouseX = this.pixFromX(this.dragThing.getX());
                this.mouseY = this.pixFromY(this.dragThing.getY());
                double d2 = this.xFromPix(this.mouseX);
                d = this.yFromPix(this.mouseY);
                if (this.dragThing.dynamic) {
                    this.dynamics.resetDynamicsDragThingVariables(d2, d);
                } else {
                    this.dragThing.setXY(d2, d);
                    if (this.dampOnMousePressed) {
                        this.dragThing.setVX(0.0);
                        this.dragThing.setVY(0.0);
                    }
                }
                this.dragThing.updateMySlaves();
                this.owner.updateDataConnection(this.dragThing.hashCode());
                graphics.setXORMode(this.getBackground());
                this.dragThing.paintHighlight(graphics);
                this.highlightMySlaves(this.dragThing, graphics);
                graphics.setPaintMode();
            }
            graphics.dispose();
            this.paintCoords(this.mouseX, this.mouseY);
        }
        if (this.sketchMode) {
            if (this.trailThing == null) {
                this.trailThing = new TrailThing(this, 1);
                this.trailThing.trailSize = 2000;
                this.things.addElement(this.trailThing);
            }
            int n2 = this.iwidth;
            n = 0;
            if (this.mouseX < n) {
                this.mouseX = n;
            } else if (this.mouseX > n2 - 2) {
                this.mouseX = n2 - 2;
            }
            double d3 = this.xFromPix(this.mouseX);
            n = 0;
            n2 = this.iheight;
            if (this.mouseY < n) {
                this.mouseY = n;
            } else if (this.mouseY > n2 - 2) {
                this.mouseY = n2 - 2;
            }
            d = this.yFromPix(this.mouseY);
            this.trailThing.incTrail(d3, d);
            this.owner.clearData(this.trailThing.hashCode());
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.this_mouseDragged(mouseEvent);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.iwidth;
        int n2 = 0;
        if (this.mouseX < n2) {
            this.mouseX = n2;
        } else if (this.mouseX > n - 2) {
            this.mouseX = n - 2;
        }
        double d = this.xFromPix(this.mouseX);
        n2 = 0;
        n = this.iheight;
        if (this.mouseY < n2) {
            this.mouseY = n2;
        } else if (this.mouseY > n - 2) {
            this.mouseY = n - 2;
        }
        double d2 = this.yFromPix(this.mouseY);
        if (this.dragThing != null) {
            if (this.dragThing.dynamic) {
                this.dynamics.resetDynamicsDragThingVariables(d, d2);
            } else {
                this.dragThing.setXY(d, d2);
                if (this.dampOnMousePressed) {
                    this.dragThing.setVX(0.0);
                    this.dragThing.setVY(0.0);
                }
            }
            this.dragThing.updateMySlaves();
            if (!this.owner.isClockRunning()) {
                this.owner.updateDataConnection(this.dragThing.hashCode());
                this.paint();
            }
        } else if (this.sketchMode && this.trailThing != null) {
            this.trailThing.incTrail(d, d2);
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            if (this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, this.mouseX, this.mouseY - this.sketchImage.getHeight(this), this);
            }
            this.trailThing.paint(graphics);
            graphics.dispose();
            this.owner.updateDataConnection(this.trailThing.hashCode());
        }
        this.paintCoords(this.mouseX, this.mouseY);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDrag = false;
        Rectangle rectangle = this.getBounds();
        if (this.sketchMode && this.trailThing != null) {
            this.owner.updateDataConnection(this.trailThing.hashCode());
            this.trailThing = null;
        }
        if (this.dragThing == null && !this.sketchMode) {
            this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        } else {
            this.paint();
        }
        this.dragThing = null;
        this.boxWidth = 0;
    }

    public void this_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void this_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void this_mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.isInsideDragableThing(n2, n = mouseEvent.getY())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    final class DynamicsSolver
    implements SDifferentiable {
        int n = 1;
        private SRK45 odeSolver = new SRK45();
        private double[] dxdt = new double[1];
        private double[] vars = new double[1];
        private Vector dThings = new Vector();

        public DynamicsSolver() {
            this.odeSolver.setDifferentials((SDifferentiable)this);
        }

        public final double[] rate(double[] dArray) {
            if (4 * this.dThings.size() != this.n - 1) {
                return new double[this.n];
            }
            this.updateThings();
            this.dxdt[0] = 1.0;
            for (int i = 1; i < this.n; i += 4) {
                Thing thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                this.dxdt[i] = thing.constrainX ? 0.0 : dArray[i + 2];
                this.dxdt[i + 1] = thing.constrainY ? 0.0 : dArray[i + 3];
                if (thing.constrainR) {
                    thing.constrainedRForce(i, this.dxdt);
                    continue;
                }
                this.dxdt[i + 2] = thing.getFx() / thing.mass;
                this.dxdt[i + 3] = thing.getFy() / thing.mass;
            }
            return this.dxdt;
        }

        public final int getNumEqu() {
            return this.n;
        }

        synchronized void addRateEquation(Thing thing) {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.dThings.addElement(thing);
            this.dxdt = new double[this.n + 4];
            this.vars = new double[this.n + 4];
            this.vars[0] = AnimatorCanvas.this.time;
            this.n += 4;
            for (int i = 1; i < this.n; i += 4) {
                thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                this.vars[i] = thing.vars[1];
                this.vars[i + 1] = thing.vars[2];
                this.vars[i + 2] = thing.vars[3];
                this.vars[i + 3] = thing.vars[4];
            }
            thing.vars[5] = thing.getTotalFx() / thing.mass;
            thing.vars[6] = thing.getTotalFy() / thing.mass;
            this.odeSolver.setDifferentials((SDifferentiable)this);
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        synchronized void resetDynamicsDragThingVariables(double d, double d2) {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.vars[0] = AnimatorCanvas.this.time;
            for (int i = 1; i < this.n; i += 4) {
                Thing thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                if (thing != AnimatorCanvas.this.dragThing) continue;
                thing.vars[1] = d;
                thing.vars[2] = d2;
                if (AnimatorCanvas.this.dampOnMousePressed) {
                    thing.vars[3] = 0.0;
                    thing.vars[4] = 0.0;
                }
                thing.enforceConstraintOnXY();
                this.vars[i] = thing.vars[1];
                this.vars[i + 1] = thing.vars[2];
                this.vars[i + 2] = thing.vars[3];
                this.vars[i + 3] = thing.vars[4];
                thing.vars[5] = 0.0;
                thing.vars[6] = 0.0;
            }
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        synchronized void resetDynamicsVariables() {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.vars[0] = AnimatorCanvas.this.time;
            for (int i = 1; i < this.n; i += 4) {
                Thing thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                this.vars[i] = thing.vars[1];
                this.vars[i + 1] = thing.vars[2];
                this.vars[i + 2] = thing.vars[3];
                this.vars[i + 3] = thing.vars[4];
                thing.vars[5] = thing.getTotalFx() / thing.mass;
                thing.vars[6] = thing.getTotalFy() / thing.mass;
            }
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        void updateThings() {
            for (int i = 1; i < this.n; i += 4) {
                Thing thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                thing.vars[0] = this.vars[0];
                thing.vars[1] = this.vars[i];
                thing.vars[2] = this.vars[i + 1];
                thing.vars[3] = this.vars[i + 2];
                thing.vars[4] = this.vars[i + 3];
            }
        }

        void setTolerance(double d) {
            this.odeSolver.setTol(d);
        }

        void step(double d, double d2) {
            if (d == 0.0) {
                return;
            }
            if (this.n < 2) {
                return;
            }
            this.vars[0] = d2;
            this.odeSolver.step(d, this.vars);
            for (int i = 1; i < this.n; i += 4) {
                Thing thing = (Thing)this.dThings.elementAt((i - 1) / 4);
                thing.vars[0] = d2 + d;
                thing.vars[1] = this.vars[i];
                thing.vars[2] = this.vars[i + 1];
                thing.vars[3] = this.vars[i + 2];
                thing.vars[4] = this.vars[i + 3];
                if (thing.enforceConstraintOnXY()) {
                    this.vars[i + 2] = thing.vars[3];
                    this.vars[i + 3] = thing.vars[4];
                }
                thing.vars[5] = thing.getTotalFx() / thing.mass;
                thing.vars[6] = thing.getTotalFy() / thing.mass;
                if (thing != AnimatorCanvas.this.dragThing) continue;
                this.vars[i] = AnimatorCanvas.this.xFromPix(AnimatorCanvas.this.mouseX);
                this.vars[i + 1] = AnimatorCanvas.this.yFromPix(AnimatorCanvas.this.mouseY);
                this.vars[i + 2] = 0.0;
                this.vars[i + 3] = 0.0;
            }
            if (AnimatorCanvas.this.dragThing != null) {
                AnimatorCanvas.this.dragThing.vars[1] = AnimatorCanvas.this.xFromPix(AnimatorCanvas.this.mouseX);
                AnimatorCanvas.this.dragThing.vars[2] = AnimatorCanvas.this.yFromPix(AnimatorCanvas.this.mouseY);
                if (AnimatorCanvas.this.dampOnMousePressed) {
                    AnimatorCanvas.this.dragThing.vars[3] = 0.0;
                    AnimatorCanvas.this.dragThing.vars[4] = 0.0;
                }
                AnimatorCanvas.this.dragThing.enforceConstraintOnXY();
                AnimatorCanvas.this.dragThing.vars[5] = AnimatorCanvas.this.dragThing.getTotalFx() / AnimatorCanvas.this.dragThing.mass;
                AnimatorCanvas.this.dragThing.vars[6] = AnimatorCanvas.this.dragThing.getTotalFy() / AnimatorCanvas.this.dragThing.mass;
            }
        }
    }
}

