/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Thing;
import edu.davidson.tools.SUtil;
import java.awt.Graphics;

public class ArrowStatic
extends Thing {
    private double[] arrowVars = new double[10];
    private boolean insideTip = false;
    private boolean fixedlength = false;
    private double length = 0.0;
    private boolean filled = false;
    double horz = 0.0;
    double vert = 0.0;

    public ArrowStatic(AnimatorCanvas animatorCanvas, int n, double d, double d2, String string, String string2) {
        super(animatorCanvas, string, string2);
        this.varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay", "m", "horz", "vert"};
        this.ds = new double[1][10];
        this.s = n;
        this.horz = d;
        this.vert = d2;
        this.length = Math.sqrt(d * d + d2 * d2);
    }

    double getHorz() {
        return this.horz;
    }

    double getVert() {
        return this.vert;
    }

    public final boolean isInsideThing(int n, int n2) {
        this.insideTip = false;
        int n3 = this.canvas.pixFromX(this.vars[1]) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.vars[2]) - this.yDisplayOff;
        if (!this.noDrag && Math.abs(n - n3) < this.s + 1 && Math.abs(n2 - n4) < this.s + 1) {
            return true;
        }
        n3 = (int)((double)n3 + (double)this.canvas.pixPerUnit * this.horz);
        n4 = (int)((double)n4 - (double)this.canvas.pixPerUnit * this.vert);
        if (this.resizable && Math.abs(n - n3) < this.s + 5 && Math.abs(n2 - n4) < this.s + 5) {
            this.insideTip = true;
            return true;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = (double)this.canvas.pixPerUnit * this.horz;
        double d2 = (double)this.canvas.pixPerUnit * this.vert;
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d);
        int n4 = (int)((double)n2 - d2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d3 > (double)(3 * this.s) ? (double)this.s : d3 / (double)3;
        d4 = Math.max(d4, 5.0);
        if (this.filled) {
            SUtil.drawSolidArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4, (int)((int)d4));
            return;
        }
        graphics.drawLine(n, n2, n3, n4);
        if (d3 > 1.0) {
            double d5 = d4 * d / d3;
            double d6 = -(d4 * d2 / d3);
            double d7 = (double)n3 - (double)3 * d5;
            double d8 = (double)n4 - (double)3 * d6;
            graphics.drawLine((int)(d7 - d6), (int)(d8 + d5), n3, n4);
            graphics.drawLine((int)(d7 + d6), (int)(d8 - d5), n3, n4);
        }
    }

    public void paintHighlight(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = (double)this.canvas.pixPerUnit * this.horz;
        double d2 = (double)this.canvas.pixPerUnit * this.vert;
        graphics.setColor(this.highlightColor);
        int n3 = (int)((double)n + d);
        int n4 = (int)((double)n2 - d2);
        graphics.drawLine(n, n2, n3, n4);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d3 > (double)(3 * this.s) ? (double)this.s : d3 / (double)3;
        d4 = Math.max(d4, 5.0);
        if (d3 > 1.0) {
            double d5 = d4 * d / d3;
            double d6 = -(d4 * d2 / d3);
            double d7 = (double)n3 - (double)3 * d5;
            double d8 = (double)n4 - (double)3 * d6;
            graphics.drawLine((int)(d7 - d6), (int)(d8 + d5), n3, n4);
            graphics.drawLine((int)(d7 + d6), (int)(d8 - d5), n3, n4);
        }
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        this.ds[0][5] = this.vars[5];
        this.ds[0][6] = this.vars[6];
        this.ds[0][7] = this.mass;
        this.ds[0][8] = this.horz;
        this.ds[0][9] = this.vert;
        return this.ds;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public void setFixedLength(boolean bl) {
        this.fixedlength = bl;
    }

    public double getH() {
        return this.vert;
    }

    public void setH(double d) {
        this.vert = d;
    }

    public double getW() {
        return this.horz;
    }

    public void setW(double d) {
        this.horz = d;
    }

    public void setXY(double d, double d2) {
        if (this.insideTip) {
            this.horz = d - this.vars[1];
            this.vert = d2 - this.vars[2];
            if (this.fixedlength) {
                double d3 = Math.sqrt(this.horz * this.horz + this.vert * this.vert);
                if (d3 == 0.0) {
                    return;
                }
                this.horz = this.length * this.horz / d3;
                this.vert = this.length * this.vert / d3;
            }
            return;
        }
        super.setXY(d, d2);
    }
}

