/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Thing;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Box
extends Thing {
    public Box(AnimatorCanvas animatorCanvas, int n, int n2, String string, String string2) {
        super(animatorCanvas, string, string2);
        this.s = 1;
        this.w = n;
        this.h = n2;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.vars[1]) - this.w / 2 + this.xDisplayOff;
        int n2 = this.canvas.pixFromY(this.vars[2]) - this.h / 2 - this.yDisplayOff;
        this.paintGhosts(graphics);
        graphics.setColor(this.color);
        for (int i = 0; i <= this.s; ++i) {
            graphics.drawRect(n + i, n2 + i, this.w - 2 * i, this.h - 2 * i);
        }
        this.paintTrail(graphics);
        if (this.showCoordinates) {
            this.paintCoordinates(graphics, n + this.w / 2, n2 + this.h / 2);
        }
        super.paint(graphics);
    }

    public void paintHighlight(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.vars[1]) - this.w / 2 + this.xDisplayOff;
        int n2 = this.canvas.pixFromY(this.vars[2]) - this.h / 2 - this.yDisplayOff;
        this.paintGhosts(graphics);
        if (this.color == this.highlightColor) {
            graphics.setColor(Thing.lightBlue);
        } else {
            graphics.setColor(this.highlightColor);
        }
        graphics.drawRect(n, n2, this.w, this.h);
        graphics.drawRect(n - 1, n2 - 1, this.w + 2, this.h + 2);
        super.paintHighlight(graphics);
    }

    public final boolean isInsideThing(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.vars[1]) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.vars[2]) - this.yDisplayOff;
        return Math.abs(n - n3) < this.w / 2 + 1 && Math.abs(n2 - n4) < this.h / 2 + 1;
    }

    public final void paintGhosts(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.ghost && this.footPrints > 0 && this.trailSize > 1 && this.trail.npoints > 1) {
            graphics.setColor(SUtil.veryPaleColor((Color)this.color));
            for (int i = 0; i < this.trail.npoints; i += this.footPrints) {
                for (int j = 0; j <= this.s; ++j) {
                    graphics.drawRect(this.trail.xpoints[i] - this.w / 2 + j + this.xDisplayOff, this.trail.ypoints[i] - this.h / 2 + j - this.yDisplayOff, this.w - 2 * j, this.h - 2 * j);
                }
            }
        }
    }
}

