/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Circle;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class Doppler
extends Circle {
    double lastCrest = 0.0;
    double c = 1.0;
    double period = 1.0;
    int numCrests = 10;
    Vector waves = null;

    public Doppler(AnimatorCanvas animatorCanvas, int n, String string, String string2, int n2, double d, double d2) {
        super(animatorCanvas, n, string, string2);
        this.numCrests = n2;
        this.period = d;
        this.c = d2;
        this.waves = new Vector(n2);
        this.lastCrest = this.vars[0];
    }

    void addCrest(double d) {
        if (d < this.lastCrest + this.period) {
            return;
        }
        while (d >= this.lastCrest + this.period) {
            this.lastCrest += this.period;
            if (this.waves.size() > this.numCrests) {
                this.waves.removeElementAt(0);
            }
            this.waves.addElement(new Wave(this.lastCrest, this.vars[1], this.vars[2]));
        }
    }

    public void clearTrail() {
        super.clearTrail();
        this.lastCrest = this.vars[0];
        if (this.waves == null) {
            return;
        }
        this.waves.removeAllElements();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.waves == null) {
            return;
        }
        this.addCrest(this.vars[0]);
        int n = this.waves.size();
        int n2 = 255 - this.color.getRed();
        int n3 = 255 - this.color.getGreen();
        int n4 = 255 - this.color.getBlue();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                graphics.setColor(new Color(255 - n2 * i / (n + 1), 255 - n3 * i / (n + 1), 255 - n4 * i / (n + 1)));
                Wave wave = (Wave)this.waves.elementAt(i);
                wave.draw(this.vars[0], graphics);
            }
        }
    }

    final class Wave {
        private double x0;
        private double y0;
        private double t0;

        Wave(double d, double d2, double d3) {
            this.x0 = d2;
            this.y0 = d3;
            this.t0 = d;
        }

        void draw(double d, Graphics graphics) {
            if (!Doppler.this.visible) {
                return;
            }
            double d2 = (d - this.t0) * Doppler.this.c;
            int n = Doppler.this.w / 2 + (int)(d2 * (double)Doppler.this.canvas.pixPerUnit) + 1;
            int n2 = Doppler.this.canvas.pixFromX(this.x0) - n + Doppler.this.xDisplayOff;
            int n3 = Doppler.this.canvas.pixFromY(this.y0) - n - Doppler.this.yDisplayOff;
            graphics.drawOval(n2, n3, n * 2, n * 2);
        }
    }
}

