/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Thing;
import edu.davidson.numerics.Parser;
import java.awt.Graphics;

public class Piston
extends Thing {
    private String hStr;
    private String vStr;
    Parser hFunc;
    Parser vFunc;

    public Piston(AnimatorCanvas animatorCanvas, int n, String string, String string2, String string3, String string4) {
        super(animatorCanvas, string3, string4);
        this.s = n;
        this.hStr = string;
        this.vStr = string2;
        this.hFunc = new Parser(1);
        this.hFunc.defineVariable(1, "t");
        this.hFunc.define(this.hStr);
        this.hFunc.parse();
        if (this.hFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse horzizontal component of vector: ".concat(String.valueOf(this.hStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.hFunc.getErrorString()).append(" at function 1, position ").append(this.hFunc.getErrorPosition())));
            return;
        }
        this.vFunc = new Parser(1);
        this.vFunc.defineVariable(1, "t");
        this.vFunc.define(this.vStr);
        this.vFunc.parse();
        if (this.vFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse vertical component of vector: ".concat(String.valueOf(this.vStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.vFunc.getErrorString()).append(" at function 1, position ").append(this.vFunc.getErrorPosition())));
            return;
        }
    }

    double getHorz(double d) {
        double d2 = 0.0;
        try {
            d2 = this.hFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    double getVert(double d) {
        double d2 = 0.0;
        try {
            d2 = this.vFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = (double)this.canvas.pixPerUnit * this.getHorz(this.vars[0]);
        double d2 = (double)this.canvas.pixPerUnit * this.getVert(this.vars[0]);
        graphics.setColor(this.color);
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d);
        int n4 = (int)((double)n2 - d2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = this.s / 2;
        double d5 = d4 * d / d3;
        double d6 = -(d4 * d2 / d3);
        graphics.fillPolygon(new int[]{(int)((double)n - d6), (int)((double)n3 - d6), (int)((double)n3 + d6), (int)((double)n + d6), (int)((double)n3 + d6)}, new int[]{(int)((double)n2 + d5), (int)((double)n4 + d5), (int)((double)n4 - d5), (int)((double)n2 - d5)}, 4);
        super.paint(graphics);
    }
}

