/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.OdePanel;
import eField4.Thing;
import edu.davidson.numerics.Parser;
import java.awt.Graphics;

public class Arrow
extends Thing {
    private String hStr;
    private String vStr;
    private double[] tempVars = new double[8];
    Parser hFunc;
    Parser vFunc;

    public Arrow(OdePanel odePanel, int n, String string, String string2, double d, double d2) {
        super(odePanel, d, d2, 0.0, 0.0);
        this.varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay", "m", "horz", "vert"};
        this.ds = new double[1][10];
        this.s = n;
        this.hStr = string;
        this.vStr = string2;
        this.hFunc = new Parser(8);
        this.hFunc.defineVariable(1, "t");
        this.hFunc.defineVariable(2, "x");
        this.hFunc.defineVariable(3, "y");
        this.hFunc.defineVariable(4, "vx");
        this.hFunc.defineVariable(5, "vy");
        this.hFunc.defineVariable(6, "ax");
        this.hFunc.defineVariable(7, "ay");
        this.hFunc.defineVariable(8, "m");
        this.hFunc.define(this.hStr);
        this.hFunc.parse();
        if (this.hFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse horzizontal component of vector: ".concat(String.valueOf(this.hStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.hFunc.getErrorString()).append(" at position ").append(this.hFunc.getErrorPosition())));
            return;
        }
        this.vFunc = new Parser(8);
        this.vFunc.defineVariable(1, "t");
        this.vFunc.defineVariable(2, "x");
        this.vFunc.defineVariable(3, "y");
        this.vFunc.defineVariable(4, "vx");
        this.vFunc.defineVariable(5, "vy");
        this.vFunc.defineVariable(6, "ax");
        this.vFunc.defineVariable(7, "ay");
        this.vFunc.defineVariable(8, "m");
        this.vFunc.define(this.vStr);
        this.vFunc.parse();
        if (this.vFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse vertical component of vector: ".concat(String.valueOf(this.vStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.vFunc.getErrorString()).append(" at position ").append(this.vFunc.getErrorPosition())));
            return;
        }
    }

    double getHorz(double[] dArray) {
        double d = 0.0;
        this.tempVars[0] = dArray[0];
        this.tempVars[1] = dArray[1];
        this.tempVars[2] = dArray[2];
        this.tempVars[3] = dArray[3];
        this.tempVars[4] = dArray[4];
        this.tempVars[5] = dArray[5];
        this.tempVars[6] = dArray[6];
        this.tempVars[7] = this.mass;
        try {
            d = this.hFunc.evaluate(this.tempVars);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    double getVert(double[] dArray) {
        double d = 0.0;
        this.tempVars[0] = dArray[0];
        this.tempVars[1] = dArray[1];
        this.tempVars[2] = dArray[2];
        this.tempVars[3] = dArray[3];
        this.tempVars[4] = dArray[4];
        this.tempVars[5] = dArray[5];
        this.tempVars[6] = dArray[6];
        this.tempVars[7] = this.mass;
        try {
            d = this.vFunc.evaluate(this.tempVars);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void paint(Graphics graphics) {
        if (this.hideThing) {
            return;
        }
        int n = Math.round(this.p.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.p.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = this.p.pixFromX(1.0) - this.p.pixFromX(0.0);
        double d2 = d * this.getHorz(this.vars);
        double d3 = d * this.getVert(this.vars);
        if (this.showVVector) {
            d2 = d * this.vars[3];
            d3 = d * this.vars[4];
        }
        if (this.showAVector) {
            d2 = d * this.vars[5];
            d3 = d * this.vars[6];
        }
        if (this.dynamic && this.showFVector) {
            d2 = d * this.vars[5] * this.mass;
            d3 = d * this.vars[6] * this.mass;
        }
        if (!this.dynamic && this.showFVector) {
            d2 = d * this.vars[5] * this.mass;
            d3 = d * this.vars[6] * this.mass;
        }
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d2);
        int n4 = (int)((double)n2 - d3);
        graphics.drawLine(n, n2, n3, n4);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d4 > (double)(3 * this.s) ? (double)this.s : d4 / (double)3;
        if (d4 > 1.0) {
            double d6 = d5 * d2 / d4;
            double d7 = -(d5 * d3 / d4);
            double d8 = (double)n3 - (double)3 * d6;
            double d9 = (double)n4 - (double)3 * d7;
            graphics.drawLine((int)(d8 - d7), (int)(d9 + d6), n3, n4);
            graphics.drawLine((int)(d8 + d7), (int)(d9 - d6), n3, n4);
        }
    }

    public void paintHighlight(Graphics graphics) {
        if (this.hideThing) {
            return;
        }
        int n = Math.round(this.p.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.p.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = this.p.pixFromX(1.0) - this.p.pixFromX(0.0);
        double d2 = d * this.getHorz(this.vars);
        double d3 = d * this.getVert(this.vars);
        if (this.showVVector) {
            d2 = d * this.vars[3];
            d3 = d * this.vars[4];
        }
        if (this.dynamic && this.showFVector) {
            d2 = d * this.vars[5];
            d3 = d * this.vars[6];
        }
        if (!this.dynamic && this.showFVector) {
            d2 = d * this.vars[5];
            d3 = d * this.vars[6];
        }
        graphics.setColor(this.highlightColor);
        int n3 = (int)((double)n + d2);
        int n4 = (int)((double)n2 - d3);
        graphics.drawLine(n, n2, n3, n4);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d4 > (double)(3 * this.s) ? (double)this.s : d4 / (double)3;
        if (d4 > 1.0) {
            double d6 = d5 * d2 / d4;
            double d7 = -(d5 * d3 / d4);
            double d8 = (double)n3 - (double)3 * d6;
            double d9 = (double)n4 - (double)3 * d7;
            graphics.drawLine((int)(d8 - d7), (int)(d9 + d6), n3, n4);
            graphics.drawLine((int)(d8 + d7), (int)(d9 - d6), n3, n4);
        }
    }

    public double[][] getVariables() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.showVVector) {
            d = this.vars[3];
            d2 = this.vars[4];
        } else if (this.dynamic && this.showFVector) {
            d = this.vars[5];
            d2 = this.vars[6];
        } else if (!this.dynamic && this.showFVector) {
            d = this.vars[5];
            d2 = this.vars[6];
        } else {
            d = this.getHorz(this.vars);
            d2 = this.getVert(this.vars);
        }
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        this.ds[0][5] = this.vars[5];
        this.ds[0][6] = this.vars[6];
        this.ds[0][7] = this.mass;
        this.ds[0][8] = d;
        this.ds[0][9] = d2;
        return this.ds;
    }
}

