/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.OdePanel;
import eField4.Pole;
import eField4.Thing;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class Charge
extends Thing
implements Cloneable {
    public Charge(OdePanel odePanel, double d, double d2, double d3, double d4) {
        this(odePanel, d, d2, d3, d4, 1.0);
    }

    public Charge(OdePanel odePanel, double d, double d2, double d3, double d4, double d5) {
        super(odePanel, d, d2, d3, d4, d5);
        this.sticky = true;
        this.noDrag = false;
        this.p = odePanel;
        this.vars[0] = 0.0;
        this.vars[1] = d;
        this.vars[2] = d2;
        this.vars[3] = d3;
        this.vars[4] = d4;
        this.initVars[0] = 0.0;
        this.initVars[1] = d;
        this.initVars[2] = d2;
        this.initVars[3] = d3;
        this.initVars[4] = d4;
        this.mag = d5;
        this.showFVector = true;
        this.ds = new double[1][12];
        this.varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay", "fx", "fy", "p", "m", "q"};
    }

    public void setAcceleration() {
        this.vars[5] = this.mag * (-this.p.dudx(this.vars[1], this.vars[2]) + this.p.getPoleFx(this.vars[1], this.vars[2], this) + this.p.bz * this.vars[4]);
        this.vars[6] = this.mag * (-this.p.dudy(this.vars[1], this.vars[2]) + this.p.getPoleFy(this.vars[1], this.vars[2], this) - this.p.bz * this.vars[3]);
    }

    public final double[][] getVariables() {
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        this.ds[0][7] = this.mag * (-this.p.dudx(this.vars[1], this.vars[2]) + this.p.getPoleFx(this.vars[1], this.vars[2], this) + this.p.bz * this.vars[4]);
        this.ds[0][8] = this.mag * (-this.p.dudy(this.vars[1], this.vars[2]) + this.p.getPoleFy(this.vars[1], this.vars[2], this) - this.p.bz * this.vars[3]);
        if (this.hasTrajectory()) {
            this.ds[0][5] = this.vars[5];
            this.ds[0][6] = this.vars[6];
        } else {
            this.ds[0][5] = this.ds[0][7] / this.mass;
            this.ds[0][6] = this.ds[0][8] / this.mass;
        }
        this.ds[0][9] = this.p.parser != null ? this.p.parser.evaluate(this.vars[1], this.vars[2]) + this.p.getPoleU(this.vars[1], this.vars[2]) : this.p.getPoleU(this.vars[1], this.vars[2]);
        this.ds[0][10] = this.mag;
        this.ds[0][11] = this.mass;
        return this.ds;
    }

    double calcPE() {
        this.pe = this.p.getPE(this);
        return this.pe;
    }

    void calculateState() {
        this.calcPE();
    }

    public final Object clone() {
        Charge charge = null;
        try {
            charge = (Charge)super.clone();
            charge.trail = new Polygon();
            charge.font = new Font("Monospaced", 0, 14);
            charge.vars = (double[])this.vars.clone();
            charge.initVars = (double[])this.initVars.clone();
            charge.color = Color.black;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Object var3_3 = null;
            return var3_3;
        }
        return charge;
    }

    public final void incTrail() {
        if (this.trail == null || this.trailSize < 1) {
            return;
        }
        int n = this.p.pixFromX(this.vars[1]);
        int n2 = this.p.pixFromY(this.vars[2]);
        if (this.trail.npoints < this.trailSize) {
            this.trail.addPoint(n, n2);
        } else {
            System.arraycopy(this.trail.xpoints, 1, this.trail.xpoints, 0, this.trailSize - 1);
            System.arraycopy(this.trail.ypoints, 1, this.trail.ypoints, 0, this.trailSize - 1);
            this.trail.xpoints[this.trailSize - 1] = n;
            this.trail.ypoints[this.trailSize - 1] = n2;
        }
    }

    public final Polygon getTrail() {
        return this.trail;
    }

    public final void resetTime() {
        this.vars[0] = this.initVars[0];
        this.vars[1] = this.initVars[1];
        this.vars[2] = this.initVars[2];
        this.vars[3] = this.initVars[3];
        this.vars[4] = this.initVars[4];
        this.vars[5] = this.initVars[5];
        this.vars[6] = this.initVars[6];
        this.clearTrail();
    }

    public final double getMaxU() {
        double d;
        double d2 = this.p.xFromPix(0);
        double d3 = (d2 - (d = this.p.xFromPix(this.s))) * (d2 - d);
        if (d3 != 0.0) {
            return this.mag / Math.sqrt(d3);
        }
        return 0.0;
    }

    public final void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.hideThing) {
            return;
        }
        if (!this.p.showPoles && this instanceof Pole) {
            return;
        }
        int n3 = this.p.pixFromX(this.vars[1]);
        int n4 = this.p.pixFromY(this.vars[2]);
        if (this.ghost && this.footPrints > 0 && this.trailSize > 1 && this.trail.npoints > 1) {
            graphics.setColor(SUtil.veryPaleColor((Color)this.color));
            for (n2 = 0; n2 < this.trail.npoints; n2 += this.footPrints) {
                graphics.fillOval(this.trail.xpoints[n2] - this.s, this.trail.ypoints[n2] - this.s, 2 * this.s, 2 * this.s);
            }
        }
        graphics.setColor(this.color);
        if (this.p.pointChargeMode) {
            graphics.fillOval(n3 - this.s, n4 - this.s, 2 * this.s, 2 * this.s);
        } else {
            graphics.setColor(SUtil.paleColor((Color)this.color));
            graphics.fillOval(n3 - this.s, n4 - this.s, 2 * this.s, 2 * this.s);
            graphics.setColor(this.color);
            graphics.drawLine(n3, n4 - this.s, n3, n4 + this.s);
            graphics.drawLine(n3 - this.s, n4, n3 + this.s, n4);
            graphics.drawOval(n3 - this.s, n4 - this.s, 2 * this.s, 2 * this.s);
        }
        graphics.setColor(this.lightGreen);
        if (this.showVComponents) {
            n2 = this.p.pixFromX(this.vars[1] + this.vars[3]);
            n = this.p.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        graphics.setColor(this.darkGreen);
        if (this.showVVector) {
            n2 = this.p.pixFromX(this.vars[1] + this.vars[3]);
            n = this.p.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        graphics.setColor(this.color);
        this.paintTrail(graphics);
        this.paintConstraint(graphics);
        if (this.label != null) {
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            graphics.setColor(Color.white);
            graphics.drawString(this.label, n3 - 4, n4 + 5);
            graphics.setFont(font);
            graphics.setColor(this.color);
        }
    }

    public final double getMag() {
        return this.mag;
    }

    public final void setMag(double d) {
        this.mag = d;
    }

    private final boolean isInsidePole(int n, int n2, OdePanel odePanel) {
        int n3 = odePanel.pixFromX(this.vars[1]);
        int n4 = odePanel.pixFromY(this.vars[2]);
        return Math.abs(n - n3) < this.s + 1 && Math.abs(n2 - n4) < this.s + 1;
    }

    public final boolean isInsideThing(int n, int n2) {
        int n3 = this.p.pixFromX(this.vars[1]);
        int n4 = this.p.pixFromY(this.vars[2]);
        return Math.abs(n - n3) < this.s + 1 && Math.abs(n2 - n4) < this.s + 1;
    }

    public final boolean isInsidePole(double d, double d2, OdePanel odePanel) {
        return this.isInsidePole(odePanel.pixFromX(d), odePanel.pixFromY(d2), odePanel);
    }

    public final boolean doesOverlap(Charge charge) {
        double d = charge.getMag() < 0.0 && this.mag < 0.0 || charge.getMag() > 0.0 && this.mag > 0.0 ? (this.p.xFromPix(0) - this.p.xFromPix(this.s * 2 + 3)) * (this.p.xFromPix(0) - this.p.xFromPix(this.s * 2 + 3)) : (this.p.xFromPix(0) - this.p.xFromPix(this.s + 2)) * (this.p.xFromPix(0) - this.p.xFromPix(this.s + 2));
        double d2 = (this.getX() - charge.getX()) * (this.getX() - charge.getX()) + (this.getY() - charge.getY()) * (this.getY() - charge.getY());
        return !(d2 > d);
    }

    public final double getRadius() {
        double d = (this.p.xFromPix(0) - this.p.xFromPix(this.s + 1)) * (this.p.xFromPix(0) - this.p.xFromPix(this.s + 1));
        d = Math.sqrt(d);
        return d;
    }
}

