/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.Charge;
import eField4.OdePanel;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;

public class TestCharge
extends Charge
implements SDifferentiable {
    SRK45 odeSolver = new SRK45();
    private double[] dydx = new double[5];

    public TestCharge(OdePanel odePanel, double d, double d2, double d3, double d4) {
        super(odePanel, d, d2, d3, d4, 1.0);
        this.odeSolver.setDifferentials((SDifferentiable)this);
        this.sticky = false;
        this.dynamic = true;
        this.noDrag = false;
    }

    public TestCharge(OdePanel odePanel, double d, double d2, double d3, double d4, double d5) {
        super(odePanel, d, d2, d3, d4, d5);
        this.odeSolver.setDifferentials((SDifferentiable)this);
        this.sticky = false;
        this.dynamic = true;
        this.noDrag = false;
    }

    public int getNumEqu() {
        return 5;
    }

    public final double[] constrainedRate(double[] dArray) {
        this.dydx[0] = 1.0;
        if (this.constraintMin < this.constraintMax) {
            if (dArray[1] < this.constraintMin) {
                dArray[1] = this.constraintMin;
                if (dArray[3] < 0.0) {
                    dArray[3] = -dArray[3];
                    dArray[4] = -dArray[4];
                }
            } else if (dArray[1] > this.constraintMax) {
                dArray[1] = this.constraintMax;
                if (dArray[3] > 0.0) {
                    dArray[3] = -dArray[3];
                    dArray[4] = -dArray[4];
                }
            }
        }
        dArray[2] = this.constraint.evaluate(dArray[1]);
        double d = this.getConstraintSlope(dArray[1], 1.0E-9);
        double d2 = Math.sqrt(dArray[3] * dArray[3] + dArray[4] * dArray[4]);
        double d3 = 1.0 / Math.sqrt(1.0 + d * d);
        if (dArray[3] > 0.0) {
            dArray[3] = d2 * d3;
            dArray[4] = d2 * d * d3;
        } else {
            dArray[3] = -d2 * d3;
            dArray[4] = -d2 * d * d3;
        }
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        double d4 = 1.0E-7;
        double d5 = this.p.parser != null ? this.p.parser.evaluate(dArray[1], dArray[2]) + this.p.getPoleU(dArray[1], dArray[2]) : this.p.getPoleU(dArray[1], dArray[2]);
        double d6 = dArray[1] + d4;
        double d7 = this.constraint.evaluate(dArray[1] + d4);
        double d8 = this.p.parser != null ? this.p.parser.evaluate(d6, d7) + this.p.getPoleU(d6, d7) : this.p.getPoleU(d6, d7);
        double d9 = (d5 - d8) / Math.sqrt((dArray[1] - d6) * (dArray[1] - d6) + (dArray[2] - d7) * (dArray[2] - d7));
        this.dydx[3] = (this.mag * d9 * d3 - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (this.mag * d9 * d * d3 - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        return this.dydx;
    }

    public final double[] constrainedRRate(double[] dArray) {
        this.dydx[0] = 1.0;
        this.enforceConstraintOnR();
        double d = Math.sqrt((this.vars[1] - this.constantRx) * (this.vars[1] - this.constantRx) + (this.vars[2] - this.constantRy) * (this.vars[2] - this.constantRy));
        double d2 = (this.vars[1] - this.constantRx) / d;
        double d3 = (this.vars[2] - this.constantRy) / d;
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        double d4 = this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]);
        double d5 = this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]);
        double d6 = -d4 * d3 + d5 * d2;
        this.dydx[3] = (-d6 * d3 - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (d6 * d2 - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        if (this.p.dragShape == this) {
            this.dydx[3] = 0.0;
            this.dydx[4] = 0.0;
        }
        return this.dydx;
    }

    public final double[] constrainedXRate(double[] dArray) {
        dArray[1] = this.constantX;
        this.dydx[0] = 1.0;
        this.dydx[1] = 0.0;
        this.dydx[2] = dArray[4];
        this.dydx[3] = 0.0;
        this.dydx[4] = (this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]) - this.damping * dArray[4]) / this.mass;
        this.vars[5] = 0.0;
        this.vars[6] = this.dydx[4];
        return this.dydx;
    }

    public final double[] constrainedYRate(double[] dArray) {
        dArray[2] = this.constantY;
        this.dydx[0] = 1.0;
        this.dydx[1] = dArray[3];
        this.dydx[2] = 0.0;
        this.dydx[3] = (this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]) - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = 0.0;
        this.vars[5] = this.dydx[3];
        this.vars[6] = 0.0;
        return this.dydx;
    }

    public final double[] rate(double[] dArray) {
        if (this.p.dragShape == this) {
            dArray[3] = 0.0;
            dArray[4] = 0.0;
        }
        if (this.constraint != null) {
            return this.constrainedRate(dArray);
        }
        if (this.constrainX) {
            return this.constrainedXRate(dArray);
        }
        if (this.constrainY) {
            return this.constrainedYRate(dArray);
        }
        if (this.constrainR) {
            return this.constrainedRRate(dArray);
        }
        this.dydx[0] = 1.0;
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        this.dydx[3] = (this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]) - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]) - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        if (this.p.dragShape == this) {
            this.dydx[3] = 0.0;
            this.dydx[4] = 0.0;
        }
        return this.dydx;
    }
}

