/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.OdePanel;
import eField4.Pole;
import eField4.TextThing;
import edu.davidson.display.Format;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class Thing
implements SDataSource {
    Format format = new Format("%-+6.3g");
    Color darkGreen = new Color(0, 128, 0);
    Color lightGreen = new Color(128, 255, 128);
    OdePanel p;
    int s = 5;
    int w = 5;
    int h = 5;
    Color color = Color.black;
    Color highlightColor = Color.gray;
    double[] vars = new double[7];
    double[] initVars = new double[7];
    String[] varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay"};
    double[][] ds = new double[1][7];
    double mag = 1.0;
    double pe = 0.0;
    double flux = 0.0;
    boolean sticky = false;
    boolean ghost = false;
    boolean showFOnDrag = false;
    boolean showVVector = false;
    boolean showAVector = false;
    boolean showFVector = false;
    boolean showFComponents = false;
    boolean showVComponents = false;
    Polygon trail = new Polygon();
    int trailSize = 0;
    double damping = 0.0;
    String label = null;
    boolean noDrag = true;
    boolean hideThing = false;
    boolean disabled = false;
    int footPrints = 0;
    double mass = 1.0;
    boolean dynamic = false;
    Font font = new Font("Monospaced", 0, 14);
    String xStr;
    String yStr;
    Parser xFunc = null;
    Parser yFunc = null;
    Parser constraint = null;
    String constraintStr = null;
    double constraintMin = 0.0;
    double constraintMax = 0.0;
    boolean showConstraintPath = true;
    boolean constrainX = false;
    boolean constrainY = false;
    boolean constrainR = false;
    double constantX = 0.0;
    double constantY = 0.0;
    double constantRx = 0.0;
    double constantRy = 0.0;
    double constantR = 0.0;
    int xDisplayOff = 0;
    int yDisplayOff = 0;
    Thing myMaster = null;
    Vector mySlaves = new Vector();

    public Thing(OdePanel odePanel, double d, double d2, double d3, double d4) {
        this(odePanel, d, d2, d3, d4, 1.0);
    }

    public Thing(OdePanel odePanel, double d, double d2, double d3, double d4, double d5) {
        this.p = odePanel;
        this.vars[0] = 0.0;
        this.vars[1] = d;
        this.vars[2] = d2;
        this.vars[3] = d3;
        this.vars[4] = d4;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        this.initVars[0] = 0.0;
        this.initVars[1] = d;
        this.initVars[2] = d2;
        this.initVars[3] = d3;
        this.initVars[4] = d4;
        this.initVars[5] = 0.0;
        this.initVars[6] = 0.0;
        this.mag = d5;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getID() {
        return this.hashCode();
    }

    public final boolean isNoDrag() {
        return this.noDrag;
    }

    public final void setNoDrag(boolean bl) {
        this.noDrag = bl;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.p.getOwner();
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public boolean isInsideThing(int n, int n2) {
        return false;
    }

    public final boolean isShowFVector() {
        return this.showFVector;
    }

    public final void setShowFVector(boolean bl) {
        this.showFVector = bl;
    }

    public final int getSize() {
        return this.s;
    }

    public final void setSize(int n) {
        this.s = n;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final boolean isHideThing() {
        return this.hideThing;
    }

    public final void setHideThing(boolean bl) {
        this.hideThing = bl;
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String string) {
        this.label = string == null || string.trim().equals("") ? null : new String(new char[]{string.charAt(0)});
    }

    public final boolean isShowV() {
        return this.showVVector;
    }

    public final void setShowV(boolean bl) {
        this.showVVector = bl;
    }

    final double enclosedCharge() {
        double d = 0.0;
        int n = this.p.poles.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Pole pole = (Pole)this.p.poles.elementAt(i);
            int n3 = this.p.pixFromX(pole.vars[1]);
            if (!this.isInsideThing(n3, n2 = this.p.pixFromY(pole.vars[2]))) continue;
            d += pole.mag;
        }
        return d;
    }

    void calculateState() {
    }

    private final void enforceConstraintOnX() {
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        this.vars[4] = this.vars[4] == 0.0 ? d : d * this.vars[4] / Math.abs(this.vars[4]);
        this.vars[3] = 0.0;
        if (this.constraintMin < this.constraintMax) {
            if (this.vars[2] < this.constraintMin) {
                this.vars[2] = this.constraintMin;
                if (this.vars[4] < 0.0) {
                    this.vars[4] = -this.vars[4];
                }
            } else if (this.vars[2] > this.constraintMax) {
                this.vars[2] = this.constraintMax;
                if (this.vars[4] > 0.0) {
                    this.vars[4] = -this.vars[4];
                }
            }
        }
        this.vars[1] = this.constantX;
    }

    private final void enforceConstraintOnY() {
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        this.vars[3] = this.vars[3] == 0.0 ? d : d * this.vars[3] / Math.abs(this.vars[3]);
        this.vars[4] = 0.0;
        if (this.constraintMin < this.constraintMax) {
            if (this.vars[1] < this.constraintMin) {
                this.vars[1] = this.constraintMin;
                if (this.vars[3] < 0.0) {
                    this.vars[3] = -this.vars[3];
                }
            } else if (this.vars[1] > this.constraintMax) {
                this.vars[1] = this.constraintMax;
                if (this.vars[3] > 0.0) {
                    this.vars[3] = -this.vars[3];
                }
            }
        }
        this.vars[2] = this.constantY;
    }

    final void enforceConstraintOnR() {
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d2 = Math.sqrt((this.vars[1] - this.constantRx) * (this.vars[1] - this.constantRx) + (this.vars[2] - this.constantRy) * (this.vars[2] - this.constantRy));
        if (d2 == 0.0) {
            this.vars[1] = this.constantRx + this.constantR;
            this.vars[2] = this.constantRy;
            this.vars[3] = 0.0;
            this.vars[4] = d;
            return;
        }
        double d3 = (this.vars[1] - this.constantRx) / d2;
        double d4 = (this.vars[2] - this.constantRy) / d2;
        this.vars[1] = this.constantR * d3;
        this.vars[2] = this.constantR * d4;
        if (-this.vars[3] * d4 + this.vars[4] * d3 > 0.0) {
            this.vars[3] = -d * d4;
            this.vars[4] = d * d3;
        } else {
            this.vars[3] = d * d4;
            this.vars[4] = -d * d3;
        }
    }

    private final void enforceConstraintOnXY() {
        if (this.xFunc != null || this.yFunc != null) {
            return;
        }
        if (this.constrainX) {
            this.enforceConstraintOnX();
            return;
        }
        if (this.constrainY) {
            this.enforceConstraintOnY();
            return;
        }
        if (this.constrainR) {
            this.enforceConstraintOnR();
            return;
        }
        if (this.constraintMin < this.constraintMax) {
            if (this.vars[1] < this.constraintMin) {
                this.vars[1] = this.constraintMin;
                if (this.vars[3] < 0.0) {
                    this.vars[3] = -this.vars[3];
                    this.vars[4] = -this.vars[4];
                }
            } else if (this.vars[1] > this.constraintMax) {
                this.vars[1] = this.constraintMax;
                if (this.vars[3] > 0.0) {
                    this.vars[3] = -this.vars[3];
                    this.vars[4] = -this.vars[4];
                }
            }
        }
        this.vars[2] = this.constraint.evaluate(this.vars[1]);
    }

    public final void setXY(double d, double d2) {
        if (this.myMaster != null) {
            this.vars[1] = this.myMaster.vars[1];
            this.vars[2] = this.myMaster.vars[2];
            return;
        }
        if (!this.constrainX) {
            this.vars[1] = d;
        } else {
            this.vars[2] = d2;
        }
        if (!(this.constraint != null || this.constrainX || this.constrainY || this.constrainR)) {
            this.vars[2] = d2;
            return;
        }
        if (this.constrainR) {
            this.vars[2] = d2;
            this.enforceConstraintOnR();
        } else {
            this.enforceConstraintOnXY();
        }
    }

    public final double getX() {
        return this.vars[1];
    }

    public final void setX(double d) {
        if (this.myMaster != null) {
            this.vars[1] = this.myMaster.vars[1];
            return;
        }
        this.vars[1] = d;
        if (!(this.constraint != null || this.constrainX || this.constrainY || this.constrainR)) {
            return;
        }
        this.enforceConstraintOnXY();
    }

    public final double getY() {
        return this.vars[2];
    }

    public final void setY(double d) {
        if (this.myMaster != null) {
            this.vars[2] = this.myMaster.vars[2];
            return;
        }
        if (this.constraint != null || this.constrainY || this.constrainR) {
            return;
        }
        this.vars[2] = d;
    }

    public void setAcceleration() {
    }

    public final double getVX() {
        return this.vars[3];
    }

    public final void setVX(double d) {
        if (this.constrainX) {
            return;
        }
        this.vars[3] = d;
    }

    public final double getVY() {
        return this.vars[4];
    }

    public final void setVY(double d) {
        if (this.constrainY) {
            return;
        }
        this.vars[4] = d;
    }

    public final double[] getVars() {
        return this.vars;
    }

    public final void setSpeed(double d) {
        d = Math.abs(d);
        if (this.constraint != null || this.constrainX || this.constrainY) {
            this.setConstrainedSpeed(d);
            return;
        }
        double d2 = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        if (d2 == 0.0) {
            this.vars[3] = d;
            this.vars[4] = 0.0;
            return;
        }
        this.vars[3] = d * this.vars[3] / d2;
        this.vars[4] = d * this.vars[4] / d2;
    }

    double getConstraintSlope(double d, double d2) {
        double d3 = this.constraint.evaluate(d + (double)2 * d2);
        double d4 = this.constraint.evaluate(d + d2);
        double d5 = this.constraint.evaluate(d - d2);
        double d6 = this.constraint.evaluate(d - (double)2 * d2);
        return (-d3 + (double)8 * d4 - (double)8 * d5 + d6) / (double)12 / d2;
    }

    private final void setConstrainedSpeed(double d) {
        if (this.constrainX) {
            this.vars[3] = 0.0;
            this.vars[4] = d;
            return;
        }
        if (this.constrainY) {
            this.vars[3] = d;
            this.vars[4] = 0.0;
            return;
        }
        double d2 = this.getConstraintSlope(this.vars[1], 1.0E-9);
        double d3 = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d4 = 1.0 / Math.sqrt(1.0 + d2 * d2);
        if (this.vars[3] > 0.0) {
            this.vars[3] = d * d4;
            this.vars[4] = d * d2 * d4;
        } else {
            this.vars[3] = -d * d4;
            this.vars[4] = -d * d2 * d4;
        }
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        return this.ds;
    }

    public void paint(Graphics graphics) {
    }

    public void paintHighlight(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintTrail(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.trailSize > 1 && this.trail.npoints > 1) {
            if (this.footPrints == 0) {
                graphics.drawPolyline(this.trail.xpoints, this.trail.ypoints, this.trail.npoints);
            } else {
                for (int i = 0; i < this.trail.npoints; i += this.footPrints) {
                    graphics.drawLine(this.trail.xpoints[i] - 2, this.trail.ypoints[i], this.trail.xpoints[i] + 2, this.trail.ypoints[i]);
                    graphics.drawLine(this.trail.xpoints[i], this.trail.ypoints[i] - 2, this.trail.xpoints[i], this.trail.ypoints[i] + 2);
                }
            }
        }
    }

    public final double getTime() {
        return this.vars[0];
    }

    public final void setTrailSize(int n) {
        this.trailSize = n;
        this.clearTrail();
    }

    public void clearTrail() {
        if (this.trail == null || this.trail.npoints != 0) {
            this.trail = new Polygon();
        }
        this.incTrail();
    }

    public void incTrail() {
    }

    public void setTime(double d, double d2) {
        if (this.myMaster != null || this.dynamic) {
            return;
        }
        this.vars[0] = d;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        if (this.xFunc == null || this.yFunc == null) {
            return;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        try {
            d3 = this.xFunc.evaluate(d - (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d8 = this.yFunc.evaluate(d - (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d4 = this.xFunc.evaluate(d - d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d9 = this.yFunc.evaluate(d - d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d5 = this.xFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d10 = this.yFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d6 = this.xFunc.evaluate(d + d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d11 = this.yFunc.evaluate(d + d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d7 = this.xFunc.evaluate(d + (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d12 = this.yFunc.evaluate(d + (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vars[1] = d5;
        this.vars[2] = d10;
        this.vars[3] = (d6 - d4) / d2 / (double)2;
        this.vars[4] = (d11 - d9) / d2 / (double)2;
        this.vars[5] = (-d7 + (double)16 * d6 - (double)30 * d5 + (double)16 * d4 - d3) / d2 / d2 / (double)12;
        this.vars[6] = (-d12 + (double)16 * d11 - (double)30 * d10 + (double)16 * d9 - d8) / d2 / d2 / (double)12;
    }

    public boolean hasTrajectory() {
        return this.xFunc != null && this.yFunc != null;
    }

    public boolean setTrajectory(String string, String string2) {
        this.vars[0] = this.p.time;
        this.vars[1] = 0.0;
        this.vars[2] = 0.0;
        this.vars[3] = 0.0;
        this.vars[4] = 0.0;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        if (string == null || string2 == null) {
            this.xStr = string;
            this.yStr = string2;
            this.xFunc = null;
            this.yFunc = null;
            return true;
        }
        this.xStr = string;
        this.yStr = string2;
        this.xFunc = new Parser(1);
        this.xFunc.defineVariable(1, "t");
        this.xFunc.define(string);
        this.xFunc.parse();
        if (this.xFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse trajectory x(t): ".concat(String.valueOf(string)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.xFunc.getErrorString()).append(" at function 1, position ").append(this.xFunc.getErrorPosition())));
            return false;
        }
        this.yFunc = new Parser(1);
        this.yFunc.defineVariable(1, "t");
        this.yFunc.define(string2);
        this.yFunc.parse();
        if (this.yFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse trajectory y(t): ".concat(String.valueOf(string2)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.yFunc.getErrorString()).append(" at function 1, position ").append(this.yFunc.getErrorPosition())));
            return false;
        }
        this.setTime(this.p.time, 0.001);
        this.clearTrail();
        this.dynamic = false;
        if (this.p.autoRefresh) {
            this.p.repaint();
        }
        return true;
    }

    public boolean setConstraintStr(String string, double d, double d2) {
        this.constrainX = false;
        this.constrainY = false;
        this.constrainR = false;
        if (string == null || string.equals("")) {
            this.constraintMin = 0.0;
            this.constraintMax = 0.0;
            this.constraintStr = null;
            this.constraint = null;
            return true;
        }
        this.constraintMin = d;
        this.constraintMax = d2;
        this.constraintStr = string.trim();
        this.constraint = new Parser(1);
        this.constraint.defineVariable(1, "x");
        this.constraint.define(this.constraintStr);
        this.constraint.parse();
        if (this.constraint.getErrorCode() != 0) {
            System.out.println("Failed to parse constraint: ".concat(String.valueOf(this.constraint.getFunctionString())));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.constraint.getErrorString()).append(" at position ").append(this.constraint.getErrorPosition())));
            return false;
        }
        this.enforceConstraintOnXY();
        if (this.p.autoRefresh) {
            this.p.repaint();
        }
        return true;
    }

    public boolean setConstrainR(double d, double d2, double d3) {
        this.constraint = null;
        this.constrainX = false;
        this.constrainY = false;
        this.constrainR = true;
        this.constantRx = d2;
        this.constantRy = d2;
        this.constantR = d;
        this.enforceConstraintOnXY();
        if (this.p.autoRefresh) {
            this.p.repaint();
        }
        return true;
    }

    public boolean setConstrainX(double d, double d2, double d3) {
        this.constraint = null;
        this.constrainX = true;
        this.constrainY = false;
        this.constrainR = false;
        this.constraintMin = d2;
        this.constraintMax = d3;
        this.constantX = d;
        this.enforceConstraintOnXY();
        if (this.p.autoRefresh) {
            this.p.repaint();
        }
        return true;
    }

    public boolean setConstrainY(double d, double d2, double d3) {
        this.constraint = null;
        this.constrainX = false;
        this.constrainY = true;
        this.constrainR = false;
        this.constraintMin = d2;
        this.constraintMax = d3;
        this.constantY = d;
        this.enforceConstraintOnXY();
        if (this.p.autoRefresh) {
            this.p.repaint();
        }
        return true;
    }

    void paintConstraintR(Graphics graphics, Rectangle rectangle) {
        int n = this.p.pixFromX(this.constantRx);
        int n2 = this.p.pixFromY(this.constantRy);
        int n3 = this.p.pixFromX(this.constantRx + this.constantR) - n;
        n = n - n3 + this.xDisplayOff;
        n2 = n2 - n3 - this.yDisplayOff;
        graphics.drawOval(n, n2, 2 * n3 + 1, 2 * n3 + 1);
    }

    void paintConstraintX(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3 = this.p.pixFromX(this.constantX);
        if (this.constraintMin < this.constraintMax) {
            n2 = this.p.pixFromY(this.constraintMin);
            n = this.p.pixFromY(this.constraintMax);
        } else {
            n = rectangle.y;
            n2 = rectangle.y + rectangle.height - 1;
        }
        graphics.drawLine(n3, n, n3, n2);
    }

    void paintConstraintY(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3 = this.p.pixFromY(this.constantY);
        if (this.constraintMin < this.constraintMax) {
            n2 = this.p.pixFromX(this.constraintMin);
            n = this.p.pixFromX(this.constraintMax);
        } else {
            n2 = rectangle.x;
            n = rectangle.x + rectangle.width - 1;
        }
        graphics.drawLine(n2, n3, n, n3);
    }

    public void paintConstraint(Graphics graphics) {
        if (!this.showConstraintPath) {
            return;
        }
        if (!(this.constraint != null || this.constrainX || this.constrainY || this.constrainR)) {
            return;
        }
        Rectangle rectangle = this.p.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        graphics.setColor(Color.black);
        if (this.constrainX) {
            this.paintConstraintX(graphics, rectangle);
            return;
        }
        if (this.constrainY) {
            this.paintConstraintY(graphics, rectangle);
            return;
        }
        if (this.constrainR) {
            this.paintConstraintR(graphics, rectangle);
            return;
        }
        if (this.constraint == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.constraintMin < this.constraintMax) {
            n = this.p.pixFromX(this.constraintMin);
            n = Math.max(n, rectangle.x);
            n2 = this.p.pixFromX(this.constraintMax);
            n2 = Math.min(n2, rectangle.x + rectangle.width - 1);
            d = this.constraintMin;
            d2 = this.constraintMax;
        } else {
            n = rectangle.x;
            n2 = rectangle.x + rectangle.width - 1;
            d = this.p.xFromPix(n);
            d2 = this.p.xFromPix(n2);
        }
        n3 = n2 - n;
        double d5 = (d2 - d) / (double)(n3 - 1);
        d3 = d;
        d4 = this.constraint.evaluate(d3);
        n4 = this.p.pixFromY(d4);
        for (int i = 0; i < n3 - 1; ++i) {
            d4 = this.constraint.evaluate(d3 += d5);
            n5 = this.p.pixFromY(d4);
            graphics.drawLine(n + i, n4, n + i + 1, n5);
            n4 = n5;
        }
    }

    public void setVarsFromMaster() {
        if (this.myMaster == null) {
            return;
        }
        if (this instanceof TextThing) {
            this.myMaster.calculateState();
        }
        this.vars[0] = this.myMaster.vars[0];
        this.vars[1] = this.myMaster.vars[1];
        this.vars[2] = this.myMaster.vars[2];
        this.vars[3] = this.myMaster.vars[3];
        this.vars[4] = this.myMaster.vars[4];
        this.vars[5] = this.myMaster.vars[5];
        this.vars[6] = this.myMaster.vars[6];
        this.mass = this.myMaster.mass;
        this.flux = this.myMaster.flux;
        this.pe = this.myMaster.pe;
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing == this || thing.myMaster != this) continue;
            thing.setVarsFromMaster();
        }
    }

    void updateMySlaves() {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
        }
    }

    void paintMySlaves(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }
}

