/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public final class VectorField {
    static int halfWidth = 175;
    static int[] saturation = new int[halfWidth * 2];
    double[][][] field;
    int row = 0;
    int col = 0;
    double scale = 1.0;

    public VectorField(int n, int n2) {
        this.field = new double[n][n2][3];
        VectorField.calSaturation();
        this.row = n;
        this.col = n2;
    }

    private static void calSaturation() {
        int n = halfWidth * 2;
        for (int i = 0; i < n; ++i) {
            double d = 1.4 * (double)(i - halfWidth) / (double)halfWidth;
            VectorField.saturation[i] = (int)((double)255 * Math.exp(-d * d));
        }
    }

    public double[][][] resize(int n, int n2) {
        if (n == this.row && n2 == this.col) {
            return this.field;
        }
        this.field = new double[n][n2][3];
        this.row = n;
        this.col = n2;
        return this.field;
    }

    public void setGridValue(int n, int n2, double d, double d2, double d3) {
        this.field[n][n2][0] = d;
        this.field[n][n2][1] = d2;
        this.field[n][n2][2] = d3;
    }

    private final Color getColor(double d) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)((double)100 * d);
        if (n4 > 100 - halfWidth && n4 < 100 + halfWidth) {
            n3 = saturation[n4 - 100 + halfWidth];
        }
        if (n4 > 275 - halfWidth && n4 < 275 + halfWidth) {
            n2 = saturation[n4 - 275 + halfWidth];
        }
        if (n4 > 450 - halfWidth && n4 < 450 + halfWidth) {
            n = saturation[n4 - 450 + halfWidth];
        }
        return new Color(n, n2, n3);
    }

    private final Color colorFromMag(double d) {
        if ((d *= this.scale) > 1.0) {
            return this.getColor(d);
        }
        int n = (int)((double)255 * (1.0 - d));
        int n2 = (int)((double)255 * (1.0 - d));
        int n3 = 255;
        return new Color(n, n2, n3);
    }

    public void paint(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = rectangle.width / (this.col - 1);
        int n3 = rectangle.height / (this.row - 1);
        int n4 = (int)((double)(Math.min(n2, n3) * n) * 0.6);
        double d = 2.0;
        double d2 = 15.0;
        for (int i = 0; i < this.row; ++i) {
            int n5 = rectangle.height - (int)((double)rectangle.height * (double)i / (double)(this.row - 1)) + rectangle.y;
            for (int j = 0; j < this.col; ++j) {
                int n6 = (int)((double)rectangle.width * (double)j / (double)(this.col - 1)) + rectangle.x;
                double d3 = this.field[i][j][0];
                double d4 = this.field[i][j][1];
                double d5 = this.field[i][j][2];
                graphics.setColor(this.colorFromMag(d5));
                int n7 = (int)((double)n4 * d3);
                int n8 = -((int)((double)n4 * d4));
                int n9 = n7 + n6;
                int n10 = n8 + n5;
                graphics.drawLine(n6, n5, n9, n10);
                double d6 = d * (double)n7 / d2;
                double d7 = d * (double)n8 / d2;
                double d8 = (double)n9 - (double)3 * d6;
                double d9 = (double)n10 - (double)3 * d7;
                graphics.drawLine((int)(d8 - d7), (int)(d9 + d6), n9, n10);
                graphics.drawLine((int)(d8 + d7), (int)(d9 - d6), n9, n10);
            }
        }
    }
}

