/*
 * Decompiled with CFR 0.152.
 */
package dataTable;

import dataTable.SGrid;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;

public class DataTable
extends SApplet {
    boolean isStandalone = false;
    boolean firstTime = true;
    String dataFile = "";
    int numRows;
    int numCols;
    int cellWidth;
    boolean showControls;
    boolean showRowHeader;
    boolean showColHeader;
    boolean showScrollBars = true;
    boolean lastOnTop;
    boolean sizeToFit;
    SGrid grid;
    BorderLayout borderLayout1 = new BorderLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.numRows = Integer.parseInt(this.getParameter("NumRows", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.cellWidth = Integer.parseInt(this.getParameter("CellWidth", "40"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.numCols = Integer.parseInt(this.getParameter("NumCols", "2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showRowHeader = Boolean.valueOf(this.getParameter("ShowRowHeader", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showColHeader = Boolean.valueOf(this.getParameter("ShowColHeader", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.lastOnTop = Boolean.valueOf(this.getParameter("LastOnTop", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showScrollBars = Boolean.valueOf(this.getParameter("ShowScrollBars", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sizeToFit = Boolean.valueOf(this.getParameter("SizeToFit", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dataFile = this.getParameter("DataFile", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.grid = new SGrid(this, this.showScrollBars);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.grid.setDefaultCellWidth(this.cellWidth);
        this.grid.setLastOnTop(this.lastOnTop);
        this.grid.setShowRowHeader(this.showRowHeader);
        this.grid.setShowColHeader(this.showColHeader);
        this.grid.initCells(this.numRows, this.numCols);
        this.grid.setShowControls(this.showControls);
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Container)((Object)this)).add((Component)((Object)this.grid), "Center");
    }

    public void start() {
        super.start();
        ((Container)((Object)this)).validate();
        if (this.sizeToFit) {
            this.sizeToFit(true);
        }
        if (this.firstTime) {
            if (this.dataFile != null && !this.dataFile.equals("")) {
                this.grid.loadFile(1, this.dataFile);
            }
            this.firstTime = false;
        }
    }

    public final String getAppletInfo() {
        return "Data Table Applet by W. Christian";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"NumRows", "int", "Number of rows"}, {"NumCols", "int", "Number of cols."}, {"ShowControls", "boolean", "Show controls at start up."}, {"ShowRowHeader", "boolean", "Show the fixed row header"}, {"ShowColHeader", "boolean", "Show the fixed col header"}, {"SizeToFit", "boolean", "Fit the table to size of the panel."}};
        return stringArray;
    }

    public void loadDataFile(int n, String string) {
        this.grid.loadFile(n, string);
    }

    public void clearSeries(int n) {
        this.grid.clearSeries(n);
    }

    public void clearAllSeries() {
        this.grid.clearAllSeries();
    }

    public void addDatum(int n, double d) {
        this.grid.addDatum(n, d, 0.0);
    }

    public int getTableID() {
        return ((Object)((Object)this.grid)).hashCode();
    }

    public void setAutoRefresh(boolean bl) {
        this.grid.setAutoRefresh(bl);
    }

    public void sizeToFit(boolean bl) {
        this.grid.sizeToFit(bl);
    }

    public void setDefault() {
        this.grid.setDefault();
    }

    public void setDataStride(int n, int n2) {
        this.grid.setDataStride(n, n2);
    }

    public int getSeriesID(int n) {
        return this.grid.getSeriesID(n);
    }

    public int getSeriesWidth(int n) {
        return this.grid.getSeriesWidth(n);
    }

    public void setSeriesWidth(int n, int n2) {
        this.grid.setSeriesWidth(n, n2);
    }

    public boolean setSeriesLabel(int n, String string) {
        return this.grid.setSeriesLabel(n, string);
    }

    public void setNumericFormat(int n, String string) {
        this.grid.gridPanel.setNumericFormat(n, string);
    }

    public boolean setFormat(int n, String string) {
        SDataSource sDataSource = SApplet.getDataSource((int)n);
        if (sDataSource == null && n == 0) {
            return this.grid.setFormat(string);
        }
        return this.grid.setFormat(sDataSource, string);
    }

    public void setShowActiveCell(boolean bl) {
        this.grid.gridPanel.setShowActiveCell(bl);
    }

    public double getActiveCellValue() {
        return this.grid.gridPanel.getActiveCellValue();
    }

    public int getActiveCellRow() {
        return this.grid.gridPanel.getActiveCellRow();
    }

    public int getActiveCellCol() {
        return this.grid.gridPanel.getActiveCellCol();
    }

    public boolean setActiveCellValue(double d) {
        return this.grid.gridPanel.setActiveCellValue(d);
    }

    public boolean setActiveCell(int n, int n2) {
        return this.grid.gridPanel.setActiveCell(n, n2);
    }
}

