/*
 * Decompiled with CFR 0.152.
 */
package dataTable;

import dataTable.GridPanel;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SPanel;
import edu.davidson.graphics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;

public class SGrid
extends EtchedBorder
implements SDataListener {
    boolean showScrollBars = true;
    SApplet owner = null;
    Container scrollPane;
    EtchedBorder controlPanel = new EtchedBorder();
    Panel panel2 = new Panel();
    Label label1 = new Label();
    Panel panel3 = new Panel();
    TextField colField = new TextField();
    Label label2 = new Label();
    BorderLayout borderLayout2 = new BorderLayout();
    Panel panel4 = new Panel();
    Button enterBtn = new Button();
    TextField rowField = new TextField();
    Label label3 = new Label();
    BorderLayout borderLayout1 = new BorderLayout();
    SPanel panel1 = new SPanel();
    TextField cellField = new TextField();
    BorderLayout borderLayout3 = new BorderLayout();
    boolean autosizeGrid = false;
    GridPanel gridPanel = new GridPanel(this);
    BorderLayout borderLayout4 = new BorderLayout();

    public SGrid(SApplet sApplet, boolean bl) {
        this.showScrollBars = bl;
        this.scrollPane = this.showScrollBars ? new ScrollPane(0) : new Panel();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.owner = sApplet;
        try {
            SApplet.addDataListener((Object)((Object)this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (!this.showScrollBars) {
            this.scrollPane.setLayout(this.borderLayout4);
        }
        this.panel2.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        this.label1.setAlignment(2);
        this.label1.setText("Cell:");
        this.colField.setText("A");
        this.label2.setAlignment(2);
        this.label2.setText("C:");
        this.enterBtn.setLabel("Enter");
        this.enterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGrid.this.enterBtn_actionPerformed(actionEvent);
            }
        });
        this.rowField.setText("1");
        this.label3.setAlignment(2);
        this.label3.setText("R:");
        this.panel1.setVinsets(5);
        this.panel1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).add(this.scrollPane, "Center");
        if (this.showScrollBars) {
            this.scrollPane.add((Component)this.gridPanel, null);
        } else {
            this.scrollPane.add((Component)this.gridPanel, "Center");
        }
        ((Container)((Object)this)).add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.panel3, "West");
        this.panel3.add((Component)this.label3, null);
        this.panel3.add((Component)this.rowField, null);
        this.panel3.add((Component)this.label2, null);
        this.panel3.add((Component)this.colField, null);
        this.controlPanel.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, "West");
        this.panel2.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.cellField, "Center");
        this.controlPanel.add((Component)this.panel4, "East");
        this.panel4.add((Component)this.enterBtn, null);
    }

    void initCells(int n, int n2) {
        this.gridPanel.initCells(n + 1, n2 + 1);
    }

    void setAutoRefresh(boolean bl) {
        this.gridPanel.setAutoRefresh(bl);
    }

    void setShowRowHeader(boolean bl) {
        this.gridPanel.setShowRowHeader(bl);
    }

    void setShowColHeader(boolean bl) {
        this.gridPanel.setShowColHeader(bl);
    }

    void setLastOnTop(boolean bl) {
        this.gridPanel.setLastOnTop(bl);
    }

    void setShowControls(boolean bl) {
        this.controlPanel.setVisible(bl);
        if (this.owner != null) {
            this.owner.invalidate();
        }
    }

    public void loadFile(int n, String string) {
        Object object = this.owner;
        if (object == null) {
            object = Util.getApplet((Component)((Object)this));
        }
        if (object == null) {
            System.out.println("File load failed. Aplet not found.");
            return;
        }
        boolean bl = this.gridPanel.autoRefresh;
        this.gridPanel.autoRefresh = false;
        this.clearSeries(n);
        try {
            InputStream inputStream = new URL(((Applet)object).getDocumentBase(), string).openStream();
            this.readFile(n, inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf("file load failed: ").concat(String.valueOf(exception.getMessage())));
        }
        this.gridPanel.autoRefresh = bl;
        if (this.gridPanel.autoRefresh) {
            this.gridPanel.paintOsi();
        }
    }

    void readFile(int n, InputStream inputStream) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        block5: while (streamTokenizer.ttype != -1) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break block5;
                }
                case 10: {
                    break;
                }
                case -3: {
                    if ("series".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        n = (int)streamTokenizer.nval;
                        this.clearSeries(n);
                        break;
                    }
                }
                case -2: {
                    double d = streamTokenizer.nval;
                    this.addDatum(n, d, 0.0);
                }
            }
            while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                streamTokenizer.nextToken();
            }
        }
    }

    public void setDataStride(int n, int n2) {
        this.gridPanel.setDataStride(n, n2);
    }

    public boolean setSeriesLabel(int n, String string) {
        return this.gridPanel.setColLabel(n, string);
    }

    public int getID() {
        return ((Object)((Object)this)).hashCode();
    }

    public void addDatum(int n, double d, double d2) {
        this.gridPanel.addDatum(n, d, d2);
        this.owner.updateDataConnections();
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.gridPanel.addDatum(n, d, d2);
        if (sDataSource.getOwner() != this.owner) {
            this.owner.updateDataConnections();
        }
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        this.gridPanel.addData(n, dArray, dArray2);
        this.owner.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        this.gridPanel.addData(n, dArray, dArray2);
        if (sDataSource.getOwner() != this.owner) {
            this.owner.updateDataConnections();
        }
    }

    public void setDefault() {
        this.owner.deleteDataConnections();
        this.gridPanel.setDefault();
        if (this.autosizeGrid) {
            this.gridPanel.sizeToFit();
        } else {
            this.gridPanel.setGridSize();
        }
    }

    void setDefaultCellWidth(int n) {
        this.gridPanel.setDefaultCellWidth(n);
    }

    public void deleteSeries(int n) {
        this.gridPanel.clearSeries(n);
    }

    public void clearSeries(int n) {
        this.gridPanel.clearSeries(n);
    }

    public void clearAllSeries() {
        this.gridPanel.clearAllSeries();
    }

    public void setOwner(SApplet sApplet) {
        this.owner = sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public boolean setFormat(SDataSource sDataSource, String string) {
        if (sDataSource instanceof SeriesDataSource) {
            int n = ((SeriesDataSource)sDataSource).sid;
            return this.gridPanel.setNumericFormat(n, string);
        }
        return false;
    }

    public boolean setFormat(String string) {
        return this.gridPanel.setFormat(string);
    }

    public int getSeriesWidth(int n) {
        return this.gridPanel.getSeriesWidth(n);
    }

    public void setSeriesWidth(int n, int n2) {
        this.gridPanel.setSeriesWidth(n, n2);
    }

    public void sizeToFit(boolean bl) {
        this.autosizeGrid = bl;
        if (bl) {
            this.gridPanel.sizeToFit();
        } else {
            this.gridPanel.setGridSize();
        }
    }

    void enterBtn_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        try {
            n = new Integer(this.rowField.getText());
            ((Component)this.rowField).setBackground(Color.white);
        }
        catch (NumberFormatException numberFormatException) {
            ((Component)this.rowField).setBackground(Color.red);
            return;
        }
        int n2 = this.gridPanel.getCol(this.colField.getText());
        if (n2 < 0) {
            ((Component)this.colField).setBackground(Color.red);
            return;
        }
        ((Component)this.colField).setBackground(Color.white);
        this.gridPanel.setHighlight(n, n2);
        this.gridPanel.setCell(n, n2, this.cellField.getText());
    }

    public int getSeriesID(int n) {
        SeriesDataSource seriesDataSource = new SeriesDataSource(n);
        return seriesDataSource.hashCode();
    }

    public class SeriesDataSource
    implements SDataSource {
        String[] varStrings = new String[]{"x", "dx"};
        double[][] ds = new double[1][2];
        int sid = 0;

        SeriesDataSource(int n) {
            this.sid = n;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n2 = SGrid.this.gridPanel.getNextRow(this.sid) - 1;
            if (n2 > 0) {
                this.ds = new double[n2][2];
            }
        }

        public double[][] getVariables() {
            int n;
            int n2 = SGrid.this.gridPanel.getNextRow(this.sid) - 1;
            if (this.ds == null || this.ds.length != n2) {
                this.ds = new double[n2][2];
            }
            for (n = 0; n < this.ds.length; ++n) {
                this.ds[n][0] = SGrid.this.gridPanel.getCellValue(n + 1, this.sid);
            }
            for (n = 0; n < this.ds.length - 1; ++n) {
                this.ds[n][1] = this.ds[n + 1][0] - this.ds[n][0];
            }
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return SGrid.this.owner;
        }
    }
}

