/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import java.io.PrintStream;

public class Format {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String s) {
        boolean state = false;
        int length = s.length();
        int parse_state = 0;
        int i = 0;
        while (parse_state == 0) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = String.valueOf(this.pre).concat(String.valueOf('%'));
                    ++i;
                } else {
                    parse_state = 1;
                }
            } else {
                this.pre = String.valueOf(this.pre).concat(String.valueOf(s.charAt(i)));
            }
            ++i;
        }
        while (parse_state == 1) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == ' ') {
                this.show_space = true;
            } else if (s.charAt(i) == '-') {
                this.left_align = true;
            } else if (s.charAt(i) == '+') {
                this.show_plus = true;
            } else if (s.charAt(i) == '0') {
                this.leading_zeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else {
                parse_state = 2;
                --i;
            }
            ++i;
        }
        while (parse_state == 2) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parse_state = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        while (parse_state == 3) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        if (parse_state == 4) {
            if (i >= length) {
                parse_state = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    public static void print(PrintStream s, String fmt, double x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, long x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, char x) {
        s.print(new Format(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, String x) {
        s.print(new Format(fmt).form(x));
    }

    public static int atoi(String s) {
        return (int)Format.atol(s);
    }

    public static long atol(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '0') {
            if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                return Format.parseLong(s.substring(i + 2), 16);
            }
            return Format.parseLong(s, 8);
        }
        return Format.parseLong(s, 10);
    }

    private static long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - (long)48;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - (long)65 + (long)10;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - (long)97 + (long)10;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double f = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * (double)10 + (double)ch - (double)48;
                } else if (state) {
                    r += (p /= (double)10) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)Format.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    public String form(double x) {
        String r;
        if (this.fmt == 'i' || this.fmt == 'd') {
            return this.form((int)x);
        }
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return "NaN";
        }
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixed_format(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.exp_format(x);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(long x) {
        String r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (x < (long)0) {
                r = "".concat(String.valueOf(x)).substring(1);
                s = -1;
            } else {
                r = "".concat(String.valueOf(x));
                s = 1;
            }
        } else if (this.fmt == 'o') {
            r = Format.convert(x, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            r = Format.convert(x, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = Format.convert(x, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "".concat(String.valueOf(c));
        return this.pad(r);
    }

    public String form(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    public static void main(String[] a) {
        double x = 1.23456789012;
        double y = 123.0;
        double z = 1.2345E30;
        double w = 1.02;
        double u = 1.234E-5;
        int d = 51966;
        Format.print(System.out, "x = |%f|\n", x);
        Format.print(System.out, "u = |%20f|\n", u);
        Format.print(System.out, "x = |% .5f|\n", x);
        Format.print(System.out, "w = |%20.5f|\n", w);
        Format.print(System.out, "x = |%020.5f|\n", x);
        Format.print(System.out, "x = |%+20.5f|\n", x);
        Format.print(System.out, "x = |%+020.5f|\n", x);
        Format.print(System.out, "x = |% 020.5f|\n", x);
        Format.print(System.out, "y = |%#+20.5f|\n", y);
        Format.print(System.out, "y = |%-+20.5f|\n", y);
        Format.print(System.out, "z = |%20.5f|\n", z);
        Format.print(System.out, "x = |%e|\n", x);
        Format.print(System.out, "u = |%20e|\n", u);
        Format.print(System.out, "x = |% .5e|\n", x);
        Format.print(System.out, "w = |%20.5e|\n", w);
        Format.print(System.out, "x = |%020.5e|\n", x);
        Format.print(System.out, "x = |%+20.5e|\n", x);
        Format.print(System.out, "x = |%+020.5e|\n", x);
        Format.print(System.out, "x = |% 020.5e|\n", x);
        Format.print(System.out, "y = |%#+20.5e|\n", y);
        Format.print(System.out, "y = |%-+20.5e|\n", y);
        Format.print(System.out, "x = |%g|\n", x);
        Format.print(System.out, "z = |%g|\n", z);
        Format.print(System.out, "w = |%g|\n", w);
        Format.print(System.out, "u = |%g|\n", u);
        Format.print(System.out, "y = |%.2g|\n", y);
        Format.print(System.out, "y = |%#.2g|\n", y);
        Format.print(System.out, "d = |%d|\n", d);
        Format.print(System.out, "d = |%20d|\n", d);
        Format.print(System.out, "d = |%020d|\n", d);
        Format.print(System.out, "d = |%+20d|\n", d);
        Format.print(System.out, "d = |% 020d|\n", d);
        Format.print(System.out, "d = |%-20d|\n", d);
        Format.print(System.out, "d = |%20.8d|\n", d);
        Format.print(System.out, "d = |%x|\n", d);
        Format.print(System.out, "d = |%20X|\n", d);
        Format.print(System.out, "d = |%#20x|\n", d);
        Format.print(System.out, "d = |%020X|\n", d);
        Format.print(System.out, "d = |%20.8x|\n", d);
        Format.print(System.out, "d = |%o|\n", d);
        Format.print(System.out, "d = |%020o|\n", d);
        Format.print(System.out, "d = |%#20o|\n", d);
        Format.print(System.out, "d = |%#020o|\n", d);
        Format.print(System.out, "d = |%20.12o|\n", d);
        Format.print(System.out, "s = |%-20s|\n", "Hello");
        Format.print(System.out, "s = |%-20c|\n", '!');
        Format.print(System.out, "|%i|\n", Long.MIN_VALUE);
        Format.print(System.out, "|%6.2e|\n", 0.0);
        Format.print(System.out, "|%6.2g|\n", 0.0);
        Format.print(System.out, "|%6.2f|\n", 9.99);
        Format.print(System.out, "|%6.2f|\n", 9.999);
        Format.print(System.out, "|%6.0f|\n", 9.999);
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            s.append(c);
        }
        return s.toString();
    }

    private static String convert(long x, int n, int m, String d) {
        if (x == (long)0) {
            return "0";
        }
        String r = "";
        while (x != (long)0) {
            r = String.valueOf(d.charAt((int)(x & (long)m))).concat(String.valueOf(r));
            x >>>= n;
        }
        return r;
    }

    private String pad(String r) {
        String p = Format.repeat(' ', this.width - r.length());
        if (this.left_align) {
            return String.valueOf(new StringBuffer(String.valueOf(this.pre)).append(r).append(p).append(this.post));
        }
        return String.valueOf(new StringBuffer(String.valueOf(this.pre)).append(p).append(r).append(this.post));
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.show_plus) {
                p = "+";
            } else if (this.show_space) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leading_zeroes) {
            w = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        return String.valueOf(new StringBuffer(String.valueOf(p)).append(Format.repeat('0', w - p.length() - r.length())).append(r));
    }

    private String fixed_format(double d) {
        boolean removeTrailing;
        boolean bl = removeTrailing = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > (double)Long.MAX_VALUE) {
            return this.exp_format(d);
        }
        if (this.precision == 0) {
            return String.valueOf((long)(d + 0.5)).concat(String.valueOf(removeTrailing ? "" : "."));
        }
        long whole = (long)d;
        double fr = d - (double)whole;
        if (fr >= 1.0 || fr < 0.0) {
            return this.exp_format(d);
        }
        double factor = 1.0;
        String leading_zeroes = "";
        for (int i = 1; i <= this.precision && factor <= (double)Long.MAX_VALUE; factor *= (double)10, ++i) {
            leading_zeroes = String.valueOf(leading_zeroes).concat("0");
        }
        long l = (long)(factor * fr + 0.5);
        if ((double)l >= factor) {
            l = 0L;
            ++whole;
        }
        String z = String.valueOf(leading_zeroes).concat(String.valueOf(l));
        z = ".".concat(String.valueOf(z.substring(z.length() - this.precision, z.length())));
        if (removeTrailing) {
            int t;
            for (t = z.length() - 1; t >= 0 && z.charAt(t) == '0'; --t) {
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return String.valueOf(whole).concat(String.valueOf(z));
    }

    private String exp_format(double d) {
        String f = "";
        int e = 0;
        double factor = 1.0;
        if (d != 0.0) {
            double dd;
            for (dd = d; dd > (double)10; dd /= (double)10) {
                ++e;
                factor /= (double)10;
            }
            while (dd < 1.0) {
                --e;
                factor *= (double)10;
                dd *= (double)10;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixed_format(d);
        }
        f = String.valueOf(f).concat(String.valueOf(this.fixed_format(d *= factor)));
        f = this.fmt == 'e' || this.fmt == 'g' ? String.valueOf(f).concat("e") : String.valueOf(f).concat("E");
        String p = "000";
        if (e >= 0) {
            f = String.valueOf(f).concat("+");
            p = String.valueOf(p).concat(String.valueOf(e));
        } else {
            f = String.valueOf(f).concat("-");
            p = String.valueOf(p).concat(String.valueOf(-e));
        }
        return String.valueOf(f).concat(String.valueOf(p.substring(p.length() - 3, p.length())));
    }
}

