/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.numerics;

import edu.davidson.numerics.ParserException;
import java.util.Hashtable;
import java.util.Vector;

public final class Parser {
    private int var_count;
    private String[] var_name;
    private double[] var_value;
    private double[] number;
    private String function = "";
    private String postfix_code = "";
    private boolean valid = false;
    private int error;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private boolean radian;
    private int numberindex;
    private double[] refvalue = null;
    private static final int MAX_NUM = 100;
    private static final int NO_FUNCS = 26;
    private static final int NO_EXT_FUNCS = 4;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private static final double DEGTORAD = Math.PI / 180;
    private static final double LOG10 = Math.log(10.0);
    private Hashtable references = null;
    private Vector refnames = null;
    public static final int NO_ERROR = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int FUNC_OFFSET = 1000;
    private static final int EXT_FUNC_OFFSET = 1026;
    private static final int VAR_OFFSET = 2000;
    private static final int REF_OFFSET = 3000;
    private static final char PI_CODE = '\u00fd';
    private static final char E_CODE = '\u00fe';
    private static final char NUMERIC = '\u00ff';
    private static final char JUMP_CODE = '\u0001';
    private static final char LESS_THAN = '\u0002';
    private static final char GREATER_THAN = '\u0003';
    private static final char LESS_EQUAL = '\u0004';
    private static final char GREATER_EQUAL = '\u0005';
    private static final char NOT_EQUAL = '\u0006';
    private static final char EQUAL = '\u0007';
    private static final char IF_CODE = '\b';
    private static final char ENDIF = '\t';
    private static final char AND_CODE = '\n';
    private static final char OR_CODE = '\u000b';
    private static final char NOT_CODE = '\f';
    private String[] funcname = new String[]{"sin", "cos", "tan", "ln", "log", "abs", "int", "frac", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ceil", "floor", "round", "exp", "sqr", "sqrt", "sign", "step", "random"};
    private String[] extfunc = new String[]{"min", "max", "mod", "atan2"};

    public Parser(int variablecount) {
        this.var_count = variablecount;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.radian = true;
        this.var_name = new String[variablecount];
        this.var_value = new double[variablecount];
        this.number = new double[100];
    }

    public Parser() {
        int variablecount;
        this.var_count = variablecount = 1;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.radian = true;
        this.var_name = new String[variablecount];
        this.var_value = new double[variablecount];
        this.number = new double[100];
    }

    private void adjustVarCount(int variablecount) {
        this.var_count = variablecount;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.var_name = new String[variablecount];
        this.var_value = new double[variablecount];
        this.number = new double[100];
    }

    public void useRadian() {
        this.radian = true;
    }

    public void useDegree() {
        this.radian = false;
    }

    public void defineVariable(int index, String name) {
        if (index > this.var_count) {
            return;
        }
        this.var_name[index - 1] = name;
    }

    public void defineVariables(String[] newVars) {
        if (newVars.length != this.var_count) {
            this.adjustVarCount(newVars.length);
        }
        for (int i = 0; i < newVars.length; ++i) {
            this.defineVariable(i + 1, newVars[i]);
        }
    }

    public void setVariable(int index, double value) {
        if (index > this.var_count) {
            return;
        }
        this.var_value[index - 1] = value;
    }

    public void setVariable(String name, double value) {
        for (int i = 0; i < this.var_count; ++i) {
            if (!this.var_name[i].equals(name)) continue;
            this.var_value[i] = value;
            break;
        }
    }

    private String removeEscapeCharacter(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    private String fixUnaryMinus(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        if (str.charAt(0) == '-') {
            sb.append('0');
        }
        for (int i = 0; i < str.length(); ++i) {
            if (i > 0 && str.charAt(i) == '-' && str.charAt(i - 1) == '(') {
                sb.append('0');
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public void define(String definition) {
        this.function = definition;
        this.function.toLowerCase();
        this.function = this.removeEscapeCharacter(this.function);
        this.function = this.fixUnaryMinus(this.function);
        this.valid = false;
    }

    public void parse() {
        int index;
        String allFunction = new String(this.function);
        String orgFunction = new String(this.function);
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.references.clear();
        this.refnames.removeAllElements();
        while ((index = allFunction.lastIndexOf(";")) != -1) {
            this.function = String.valueOf(allFunction.substring(index + 1)).concat(String.valueOf(')'));
            allFunction = allFunction.substring(0, index++);
            String refname = null;
            int separator = this.function.indexOf(":");
            if (separator == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length() && this.function.charAt(this.position) == ' ') {
                    ++this.position;
                }
                ++this.position;
            } else {
                refname = this.function.substring(0, separator);
                this.function = this.function.substring(separator + 1);
                if ((refname = refname.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    index += ++separator;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += index;
                break;
            }
            this.references.put(refname, this.postfix_code);
            this.refnames.addElement(refname);
        }
        if (this.error == 0) {
            this.function = String.valueOf(allFunction).concat(String.valueOf(')'));
            this.parseSubFunction();
        }
        this.function = orgFunction;
        this.valid = this.error == 0;
    }

    public double evaluate(double x, double y) {
        if (this.var_count != 2) {
            return 0.0;
        }
        this.var_value[0] = x;
        this.var_value[1] = y;
        return this.evaluate();
    }

    public double evaluate(double x) {
        if (this.var_count != 1) {
            return 0.0;
        }
        this.var_value[0] = x;
        return this.evaluate();
    }

    public double evaluate(double[] v) {
        if (this.var_value.length != v.length) {
            return 0.0;
        }
        System.arraycopy(v, 0, this.var_value, 0, v.length);
        return this.evaluate();
    }

    public double evaluate() {
        double result;
        int size = this.refnames.size();
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        this.numberindex = 0;
        if (size != 0) {
            String orgPFC = this.postfix_code;
            this.refvalue = new double[size];
            for (int i = 0; i < this.refnames.size(); ++i) {
                String name = (String)this.refnames.elementAt(i);
                this.postfix_code = (String)this.references.get(name);
                result = this.evaluateSubFunction();
                if (this.error != 0) {
                    this.postfix_code = orgPFC;
                    this.refvalue = null;
                    return result;
                }
                this.refvalue[i] = result;
            }
            this.postfix_code = orgPFC;
        }
        result = this.evaluateSubFunction();
        this.refvalue = null;
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return Parser.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int errorcode) {
        String s = "";
        switch (errorcode) {
            case 0: {
                s = "no error";
                break;
            }
            case 1: {
                s = "syntax error";
                break;
            }
            case 2: {
                s = "parenthesis expected";
                break;
            }
            case 3: {
                s = "uncompiled function";
                break;
            }
            case 4: {
                s = "expression expected";
                break;
            }
            case 5: {
                s = "unknown identifier";
                break;
            }
            case 6: {
                s = "operator expected";
                break;
            }
            case 7: {
                s = "parentheses not match";
                break;
            }
            case 8: {
                s = "internal code damaged";
                break;
            }
            case 9: {
                s = "execution stack overflow";
                break;
            }
            case 10: {
                s = "too many constants";
                break;
            }
            case 11: {
                s = "comma expected";
                break;
            }
            case 12: {
                s = "invalid operand type";
                break;
            }
            case 13: {
                s = "invalid operator";
                break;
            }
            case 14: {
                s = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                s = "reference name expected";
            }
        }
        return s;
    }

    public String getFunctionString() {
        return this.function;
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void getNextCharacter() throws ParserException {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParserException(7);
        }
    }

    private void addCode(char code) {
        this.postfix_code = String.valueOf(this.postfix_code).concat(String.valueOf(code));
    }

    private void scanNumber() throws ParserException {
        double value;
        String numstr = "";
        if (this.num == 100) {
            throw new ParserException(10);
        }
        if (this.character != '.') {
            do {
                numstr = String.valueOf(numstr).concat(String.valueOf(this.character));
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        } else {
            numstr = String.valueOf(numstr).concat(String.valueOf('0'));
        }
        if (this.character == '.') {
            do {
                numstr = String.valueOf(numstr).concat(String.valueOf(this.character));
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e') {
            numstr = String.valueOf(numstr).concat(String.valueOf(this.character));
            this.getNextCharacter();
            if (this.character == '+' || this.character == '-') {
                numstr = String.valueOf(numstr).concat(String.valueOf(this.character));
                this.getNextCharacter();
            }
            while (this.character >= '0' && this.character <= '9') {
                numstr = String.valueOf(numstr).concat(String.valueOf(this.character));
                this.getNextCharacter();
            }
        }
        try {
            value = Double.valueOf(numstr);
        }
        catch (NumberFormatException e) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.number[this.num++] = value;
        this.addCode('\u00ff');
    }

    private void scanNonNumeric() throws ParserException {
        int i;
        String stream = "";
        if (this.character == '*' || this.character == '/' || this.character == '^' || this.character == ')' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            throw new ParserException(1);
        }
        do {
            stream = String.valueOf(stream).concat(String.valueOf(this.character));
            this.getNextCharacter();
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '^' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        if (stream.equals("pi")) {
            this.addCode('\u00fd');
            return;
        }
        if (stream.equals("e")) {
            this.addCode('\u00fe');
            return;
        }
        if (stream.equals("if")) {
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            this.addCode('\b');
            String savecode = new String(this.postfix_code);
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            this.addCode('\u0001');
            savecode = String.valueOf(savecode).concat(String.valueOf((char)(this.postfix_code.length() + 2)));
            savecode = String.valueOf(savecode).concat(String.valueOf(this.postfix_code));
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            savecode = String.valueOf(savecode).concat(String.valueOf((char)(this.postfix_code.length() + 1)));
            savecode = String.valueOf(savecode).concat(String.valueOf(this.postfix_code));
            this.postfix_code = new String(savecode);
            this.getNextCharacter();
            return;
        }
        for (i = 0; i < 26; ++i) {
            if (!stream.equals(this.funcname[i])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            this.addCode((char)(i + 1000));
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (!stream.equals(this.extfunc[i])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            String savecode = new String(this.postfix_code);
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            savecode = String.valueOf(savecode).concat(String.valueOf(this.postfix_code));
            this.postfix_code = new String(savecode);
            this.addCode((char)(i + 1026));
            return;
        }
        for (i = 0; i < this.var_count; ++i) {
            if (!stream.equals(this.var_name[i])) continue;
            this.addCode((char)(i + 2000));
            return;
        }
        int index = this.refnames.indexOf(stream);
        if (index != -1) {
            this.addCode((char)(index + 3000));
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private void getIdentifier() throws ParserException {
        boolean negate = false;
        this.getNextCharacter();
        this.skipSpaces();
        if (this.character == '!') {
            this.getNextCharacter();
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            if (!this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            this.addCode('\f');
            this.getNextCharacter();
            return;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                negate = !negate;
            }
            this.getNextCharacter();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9' || this.character == '.') {
            this.scanNumber();
        } else if (this.character == '(') {
            this.scanAndParse();
            this.getNextCharacter();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        if (negate) {
            this.addCode('_');
        }
    }

    private void arithmeticLevel3() throws ParserException {
        int repcount = 0;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            repcount = (byte)(repcount + 1);
        } while (this.character == '^');
        for (int i = 1; i <= repcount; ++i) {
            this.addCode('^');
        }
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char operator = this.character;
            this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '^') {
                this.arithmeticLevel3();
            }
            this.addCode(operator);
        } while (this.character == '*' || this.character == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char operator = this.character;
            this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '^') {
                this.arithmeticLevel3();
            } else if (this.character == '*' || this.character == '/') {
                this.arithmeticLevel2();
            }
            this.addCode(operator);
        } while (this.character == '+' || this.character == '-');
    }

    private void relationLevel() throws ParserException {
        int code = 0;
        if (this.INRELATION) {
            throw new ParserException(13);
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (this.character) {
            case '=': {
                code = 7;
                break;
            }
            case '<': {
                code = 2;
                this.getNextCharacter();
                if (this.character == '>') {
                    code = 6;
                    break;
                }
                if (this.character == '=') {
                    code = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                code = 3;
                this.getNextCharacter();
                if (this.character == '=') {
                    code = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.INRELATION = false;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        this.addCode((char)code);
        this.ISBOOLEAN = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        char operator = this.character;
        this.scanAndParse();
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (operator) {
            case '&': {
                this.addCode('\n');
                break;
            }
            case '|': {
                this.addCode('\u000b');
            }
        }
    }

    private void scanAndParse() throws ParserException {
        this.getIdentifier();
        block8: while (true) {
            switch (this.character) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block8;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block8;
                }
                case '^': {
                    this.arithmeticLevel3();
                    continue block8;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block8;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block8;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.postfix_code = "";
            this.INRELATION = false;
            this.ISBOOLEAN = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException e) {
                this.error = e.getErrorCode();
                if (this.error != 1 || this.postfix_code != "") break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    private double builtInFunction(int function, double parameter) {
        switch (function) {
            case 0: {
                if (this.radian) {
                    return Math.sin(parameter);
                }
                return Math.sin(parameter * (Math.PI / 180));
            }
            case 1: {
                if (this.radian) {
                    return Math.cos(parameter);
                }
                return Math.cos(parameter * (Math.PI / 180));
            }
            case 2: {
                if (this.radian) {
                    return Math.tan(parameter);
                }
                return Math.tan(parameter * (Math.PI / 180));
            }
            case 3: {
                return Math.log(parameter);
            }
            case 4: {
                return Math.log(parameter) / LOG10;
            }
            case 5: {
                return Math.abs(parameter);
            }
            case 6: {
                return Math.rint(parameter);
            }
            case 7: {
                return parameter - Math.rint(parameter);
            }
            case 8: {
                if (this.radian) {
                    return Math.asin(parameter);
                }
                return Math.asin(parameter) / (Math.PI / 180);
            }
            case 9: {
                if (this.radian) {
                    return Math.acos(parameter);
                }
                return Math.acos(parameter) / (Math.PI / 180);
            }
            case 10: {
                if (this.radian) {
                    return Math.atan(parameter);
                }
                return Math.atan(parameter) / (Math.PI / 180);
            }
            case 11: {
                return (Math.exp(parameter) - Math.exp(-parameter)) / (double)2;
            }
            case 12: {
                return (Math.exp(parameter) + Math.exp(-parameter)) / (double)2;
            }
            case 13: {
                double a = Math.exp(parameter);
                double b = Math.exp(-parameter);
                return (a - b) / (a + b);
            }
            case 14: {
                return Math.log(parameter + Math.sqrt(parameter * parameter + 1.0));
            }
            case 15: {
                return Math.log(parameter + Math.sqrt(parameter * parameter - 1.0));
            }
            case 16: {
                return Math.log((1.0 + parameter) / (1.0 - parameter)) / (double)2;
            }
            case 17: {
                return Math.ceil(parameter);
            }
            case 18: {
                return Math.floor(parameter);
            }
            case 19: {
                return Math.round(parameter);
            }
            case 20: {
                return Math.exp(parameter);
            }
            case 21: {
                return parameter * parameter;
            }
            case 22: {
                return Math.sqrt(parameter);
            }
            case 23: {
                if (parameter == 0.0) {
                    return 0.0;
                }
                if (parameter > 0.0) {
                    return 1.0;
                }
                return -1.0;
            }
            case 24: {
                if (parameter < 0.0) {
                    return 0.0;
                }
                return 1.0;
            }
            case 25: {
                return parameter * Math.random();
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInExtFunction(int function, double param1, double param2) {
        switch (function) {
            case 0: {
                return Math.min(param1, param2);
            }
            case 1: {
                return Math.max(param1, param2);
            }
            case 2: {
                return Math.IEEEremainder(param1, param2);
            }
            case 3: {
                return Math.atan2(param1, param2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double evaluateSubFunction() {
        int stack_pointer = -1;
        int code_pointer = 0;
        int codeLength = this.postfix_code.length();
        block28: while (true) {
            char code;
            try {
                if (code_pointer == codeLength) {
                    return this.stack[0];
                }
                code = this.postfix_code.charAt(code_pointer++);
            }
            catch (StringIndexOutOfBoundsException e) {
                return this.stack[0];
            }
            try {
                switch (code) {
                    case '+': {
                        int n = stack_pointer - 1;
                        this.stack[n] = this.stack[n] + this.stack[stack_pointer];
                        --stack_pointer;
                        continue block28;
                    }
                    case '-': {
                        int n = stack_pointer - 1;
                        this.stack[n] = this.stack[n] - this.stack[stack_pointer];
                        --stack_pointer;
                        continue block28;
                    }
                    case '*': {
                        int n = stack_pointer - 1;
                        this.stack[n] = this.stack[n] * this.stack[stack_pointer];
                        --stack_pointer;
                        continue block28;
                    }
                    case '/': {
                        if (this.stack[stack_pointer] != 0.0) {
                            int n = stack_pointer - 1;
                            this.stack[n] = this.stack[n] / this.stack[stack_pointer];
                        } else {
                            int n = stack_pointer - 1;
                            this.stack[n] = this.stack[n] / 1.0E-128;
                        }
                        --stack_pointer;
                        continue block28;
                    }
                    case '^': {
                        this.stack[stack_pointer - 1] = Math.pow(this.stack[stack_pointer - 1], this.stack[stack_pointer]);
                        --stack_pointer;
                        continue block28;
                    }
                    case '_': {
                        this.stack[stack_pointer] = -this.stack[stack_pointer];
                        continue block28;
                    }
                    case '\u0001': {
                        int destination = code_pointer + this.postfix_code.charAt(code_pointer++);
                        while (true) {
                            if (code_pointer >= destination) continue block28;
                            if (this.postfix_code.charAt(code_pointer++) != '\u00ff') continue;
                            ++this.numberindex;
                        }
                    }
                    case '\u0002': {
                        double d = this.stack[--stack_pointer] < this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\u0003': {
                        double d = this.stack[--stack_pointer] > this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\u0004': {
                        double d = this.stack[--stack_pointer] <= this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\u0005': {
                        double d = this.stack[--stack_pointer] >= this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\u0007': {
                        double d = this.stack[--stack_pointer] == this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\u0006': {
                        double d = this.stack[--stack_pointer] != this.stack[stack_pointer + 1] ? 1.0 : 0.0;
                        this.stack[stack_pointer] = d;
                        continue block28;
                    }
                    case '\b': {
                        int destination;
                        if (this.stack[stack_pointer--] == 0.0) {
                            destination = code_pointer + this.postfix_code.charAt(code_pointer++);
                            while (true) {
                                if (code_pointer >= destination) continue block28;
                                if (this.postfix_code.charAt(code_pointer++) != '\u00ff') continue;
                                ++this.numberindex;
                            }
                        }
                        ++code_pointer;
                        continue block28;
                    }
                    case '\t': {
                        continue block28;
                    }
                    case '\n': {
                        if (this.stack[--stack_pointer] != 0.0 && this.stack[stack_pointer + 1] != 0.0) {
                            this.stack[stack_pointer] = 1.0;
                            continue block28;
                        }
                        this.stack[stack_pointer] = 0.0;
                        continue block28;
                    }
                    case '\u000b': {
                        if (this.stack[--stack_pointer] != 0.0 || this.stack[stack_pointer + 1] != 0.0) {
                            this.stack[stack_pointer] = 1.0;
                            continue block28;
                        }
                        this.stack[stack_pointer] = 0.0;
                        continue block28;
                    }
                    case '\f': {
                        this.stack[stack_pointer] = this.stack[stack_pointer] == 0.0 ? 1.0 : 0.0;
                        continue block28;
                    }
                    case '\u00ff': {
                        this.stack[++stack_pointer] = this.number[this.numberindex++];
                        continue block28;
                    }
                    case '\u00fd': {
                        this.stack[++stack_pointer] = Math.PI;
                        continue block28;
                    }
                    case '\u00fe': {
                        this.stack[++stack_pointer] = Math.E;
                        continue block28;
                    }
                }
                if (code >= '\u0bb8') {
                    this.stack[++stack_pointer] = this.refvalue[code - 3000];
                    continue;
                }
                if (code >= '\u07d0') {
                    this.stack[++stack_pointer] = this.var_value[code - 2000];
                    continue;
                }
                if (code >= '\u0402') {
                    this.stack[stack_pointer - 1] = this.builtInExtFunction(code - 1026, this.stack[stack_pointer - 1], this.stack[stack_pointer]);
                    --stack_pointer;
                    continue;
                }
                if (code < '\u03e8') {
                    this.error = 8;
                    return Double.NaN;
                }
                this.stack[stack_pointer] = this.builtInFunction(code - 1000, this.stack[stack_pointer]);
            }
            catch (ArrayIndexOutOfBoundsException oe) {
                this.error = 9;
                return Double.NaN;
            }
            catch (NullPointerException ne) {
                this.error = 8;
                return Double.NaN;
            }
        }
    }
}

