/*
 * Decompiled with CFR 0.152.
 */
package superposition;

import edu.davidson.graphics.EtchedBorder;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;
import superposition.SuperpositionCanvas;

public class Superposition
extends Applet
implements Runnable {
    Thread m_Superposition = null;
    boolean m_fStandAlone = false;
    private boolean runOnStart = false;
    private int m_numPoints = 100;
    private double m_pixPerX = 10.0;
    private double m_pixPerY = 10.0;
    private double m_gridX = 1.0;
    private double m_gridY = 1.0;
    private String m_func1 = "sin(x-t)";
    private String m_func2 = "sin(x+t)";
    private int m_FPS = 10;
    private boolean m_showControls = true;
    private double m_dt = 0.1;
    private int m_numGraphs = 3;
    private final String PARAM_numPoints = "numPoints";
    private final String PARAM_numGraphs = "numGraphs";
    private final String PARAM_dt = "dt";
    private final String PARAM_pixPerX = "pixPerX";
    private final String PARAM_pixPerY = "pixPerY";
    private final String PARAM_gridX = "gridX";
    private final String PARAM_gridY = "gridY";
    private final String PARAM_func1 = "func1";
    private final String PARAM_func2 = "func2";
    private final String PARAM_showControls = "showControls";
    private final String PARAM_FPS = "FPS";
    private final String PARAM_helpFile = "helpFile";
    private SuperpositionCanvas sc1;
    private SuperpositionCanvas sc2;
    private SuperpositionCanvas sc3;
    private boolean noRun = false;
    private int sleepTime = 100;
    private boolean interval = false;
    private double startTime = -1.0;
    private double endTime = 1.0;
    private double t = 0.0;
    Button forwardBtn;
    Button stopBtn;
    Button reverseBtn;
    Button stepFBtn;
    Button stepBBtn;
    Button resetBtn;

    String GetParameter(String string, String[] stringArray) {
        if (stringArray == null) {
            return this.getParameter(string);
        }
        String string2 = String.valueOf(string).concat("=");
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i].substring(0, string2.length())) || !(string3 = stringArray[i].substring(string2.length())).startsWith("\"") || !(string3 = string3.substring(1)).endsWith("\"")) continue;
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    void GetParameters(String[] stringArray) {
        String string = this.GetParameter("numPoints", stringArray);
        if (string != null) {
            this.m_numPoints = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("numGraphs", stringArray)) != null) {
            this.m_numGraphs = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("dt", stringArray)) != null) {
            this.m_dt = Double.valueOf(string);
        }
        if ((string = this.GetParameter("pixPerX", stringArray)) != null) {
            this.m_pixPerX = Double.valueOf(string);
        }
        if ((string = this.GetParameter("pixPerY", stringArray)) != null) {
            this.m_pixPerY = Double.valueOf(string);
        }
        if ((string = this.GetParameter("gridX", stringArray)) != null) {
            this.m_gridX = Double.valueOf(string);
        }
        if ((string = this.GetParameter("gridY", stringArray)) != null) {
            this.m_gridY = Double.valueOf(string);
        }
        if ((string = this.GetParameter("func1", stringArray)) != null) {
            this.m_func1 = string;
        }
        if ((string = this.GetParameter("func2", stringArray)) != null) {
            this.m_func2 = string;
        }
        if ((string = this.GetParameter("FPS", stringArray)) != null) {
            this.m_FPS = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("showControls", stringArray)) != null) {
            this.m_showControls = Boolean.valueOf(string);
        }
    }

    public String getAppletInfo() {
        return "Name: Superposition Ver 1.3a\r\nAuthor: Wolfgang Christian\r\nEmail: wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"numPoints", "int", "Number of points to use for plot."}, {"numGraphs", "int", "Number of graphs to display (1, 2, or 3)."}, {"dt", "double", "Time step"}, {"pixPerX", "double", "X scale"}, {"pixPerY", "double", "Y Scale"}, {"gridX", "double", "X grid marks"}, {"gridY", "double", "Y grid marks"}, {"func1", "String", "Function of x and t"}, {"func2", "String", "Function of x and t."}, {"showControls", "boolean", "Show control buttons."}, {"FPS", "int", "Frames per second."}, {"helpFile", "String", "Applet help file URL"}};
        return stringArray;
    }

    public void init() {
        this.runOnStart = false;
        if (!this.m_fStandAlone) {
            this.GetParameters(null);
        }
        if (this.m_numGraphs < 1) {
            this.m_numGraphs = 1;
        }
        if (this.m_numGraphs > 3) {
            this.m_numGraphs = 3;
        }
        this.resize(400, 400);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 6));
        this.forwardBtn = new Button("Forward");
        panel2.add(this.forwardBtn);
        this.stopBtn = new Button("Stop");
        panel2.add(this.stopBtn);
        this.reverseBtn = new Button("Reverse");
        panel2.add(this.reverseBtn);
        this.stepBBtn = new Button("<<Step");
        panel2.add(this.stepBBtn);
        this.stepFBtn = new Button("Step>>");
        panel2.add(this.stepFBtn);
        this.resetBtn = new Button("Reset");
        panel2.add(this.resetBtn);
        if (this.m_showControls) {
            panel.add("South", panel2);
            this.add("Center", panel);
        } else {
            this.add("Center", panel);
        }
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(this.m_numGraphs, 1));
        panel.add("Center", panel3);
        this.sc1 = new SuperpositionCanvas();
        panel3.add(new EtchedBorder(this.sc1));
        if (this.m_numGraphs > 1) {
            this.sc2 = new SuperpositionCanvas();
            panel3.add(new EtchedBorder(this.sc2));
        }
        if (this.m_numGraphs > 2) {
            this.sc3 = new SuperpositionCanvas();
            panel3.add(new EtchedBorder(this.sc3));
        }
        this.sc1.setPixPerX(this.m_pixPerX);
        this.sc1.setPixPerY(this.m_pixPerY);
        this.sc1.setGridX(this.m_gridX);
        this.sc1.setGridY(this.m_gridY);
        this.sc1.setShowTime(true);
        this.sc1.setFuncStr(this.m_func1);
        this.sc1.setCaption("f(x,t)");
        if (this.m_numGraphs > 1) {
            this.sc2.setPixPerX(this.m_pixPerX);
            this.sc2.setPixPerY(this.m_pixPerY);
            this.sc2.setGridX(this.m_gridX);
            this.sc2.setGridY(this.m_gridY);
            this.sc2.setFuncStr(this.m_func2);
            this.sc2.setCaption("g(x,t)");
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setPixPerX(this.m_pixPerX);
            this.sc3.setPixPerY(this.m_pixPerY);
            this.sc3.setGridX(this.m_gridX);
            this.sc3.setGridY(this.m_gridY);
            if (this.m_func2.length() > 0) {
                if (this.m_func2.charAt(0) == '+' || this.m_func2.charAt(0) == '-') {
                    this.sc3.setFuncStr(String.valueOf(this.m_func1).concat(String.valueOf(this.m_func2)));
                } else {
                    this.sc3.setFuncStr(String.valueOf(new StringBuffer(String.valueOf(this.m_func1)).append('+').append(this.m_func2)));
                }
            }
            this.sc3.setCaption("f(x,t)+g(x,t)");
        }
        this.sleepTime = Math.round(1000 / this.m_FPS);
    }

    public void destroy() {
        this.m_Superposition = null;
        super.destroy();
    }

    public void start() {
        if (this.m_Superposition == null) {
            this.m_Superposition = new Thread(this);
            this.m_Superposition.start();
        }
    }

    public void stop() {
        this.m_Superposition = null;
    }

    public void run() {
        while (this.runOnStart && this.m_Superposition != null) {
            try {
                this.t += this.m_dt;
                if (this.interval && this.t > this.endTime) {
                    this.t = this.startTime;
                }
                this.sc1.setTime(this.t);
                if (this.m_numGraphs > 1) {
                    this.sc2.setTime(this.t);
                }
                if (this.m_numGraphs > 2) {
                    this.sc3.setTime(this.t);
                }
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.stop();
            }
        }
        this.m_Superposition = null;
    }

    public void setCaption(String string) {
        this.sc1.setCaption(string);
    }

    public void setCaption(int n, String string) {
        if (n == 1) {
            this.sc1.setCaption(string);
        } else if (n == 2 && this.m_numGraphs > 1) {
            this.sc2.setCaption(string);
        } else if (n == 3 && this.m_numGraphs > 2) {
            this.sc3.setCaption(string);
        }
    }

    public void setRGB(int n, int n2, int n3) {
        this.sc1.setRGB(n, n2, n3);
        if (this.m_numGraphs > 1) {
            this.sc2.setRGB(n, n2, n3);
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setRGB(n, n2, n3);
        }
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        if (n == 1) {
            this.sc1.setRGB(n2, n3, n4);
        } else if (n == 2 && this.m_numGraphs > 1) {
            this.sc2.setRGB(n2, n3, n4);
        } else if (n == 3 && this.m_numGraphs > 2) {
            this.sc3.setRGB(n2, n3, n4);
        }
    }

    public void setShowTime(int n) {
        if (n == 0) {
            this.sc1.setShowTime(false);
        } else {
            this.sc1.setShowTime(true);
        }
    }

    public void reset(double d) {
        this.t = d;
        this.m_dt = Math.abs(this.m_dt);
        this.sc1.setTime(this.t);
        if (this.m_numGraphs > 1) {
            this.sc2.setTime(this.t);
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setTime(this.t);
        }
    }

    public void reset() {
        this.t = 0.0;
        this.m_dt = Math.abs(this.m_dt);
        this.sc1.setTime(this.t);
        if (this.m_numGraphs > 1) {
            this.sc2.setTime(this.t);
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setTime(this.t);
        }
    }

    public void pause() {
        this.runOnStart = false;
        this.stop();
    }

    public void forward() {
        this.runOnStart = true;
        this.m_dt = Math.abs(this.m_dt);
        this.start();
    }

    public void reverse() {
        this.runOnStart = true;
        this.m_dt = -Math.abs(this.m_dt);
        this.start();
    }

    public void stepForward() {
        this.stop();
        this.t += Math.abs(this.m_dt);
        this.sc1.setTime(this.t);
        if (this.m_numGraphs > 1) {
            this.sc2.setTime(this.t);
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setTime(this.t);
        }
    }

    public void stepBack() {
        this.stop();
        this.t -= Math.abs(this.m_dt);
        this.sc1.setTime(this.t);
        if (this.m_numGraphs > 1) {
            this.sc2.setTime(this.t);
        }
        if (this.m_numGraphs > 2) {
            this.sc3.setTime(this.t);
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.stopBtn)) {
            this.pause();
            return true;
        }
        if (event.target.equals(this.forwardBtn)) {
            this.forward();
            return true;
        }
        if (event.target.equals(this.reverseBtn)) {
            this.reverse();
            return true;
        }
        if (event.target.equals(this.resetBtn)) {
            this.reset();
            return true;
        }
        if (event.target.equals(this.stepFBtn)) {
            this.stepForward();
            return true;
        }
        if (event.target.equals(this.stepBBtn)) {
            this.stepBack();
            return true;
        }
        return false;
    }

    public void setFunc1(String string) {
        this.m_func1 = string;
        this.sc1.setFuncStr(string);
        if (this.m_numGraphs > 2 && this.m_func2.length() > 0) {
            if (this.m_func2.charAt(0) == '+' || this.m_func2.charAt(0) == '-') {
                this.sc3.setFuncStr(String.valueOf(this.m_func1).concat(String.valueOf(this.m_func2)));
            } else {
                this.sc3.setFuncStr(String.valueOf(new StringBuffer(String.valueOf(this.m_func1)).append('+').append(this.m_func2)));
            }
        }
        this.reset();
    }

    public void setFunc2(String string) {
        this.m_func2 = string;
        if (this.m_numGraphs > 1) {
            this.sc2.setFuncStr(string);
        }
        if (this.m_numGraphs > 2 && this.m_func2.length() > 0) {
            if (this.m_func2.charAt(0) == '+' || this.m_func2.charAt(0) == '-') {
                this.sc3.setFuncStr(String.valueOf(this.m_func1).concat(String.valueOf(this.m_func2)));
            } else {
                this.sc3.setFuncStr(String.valueOf(new StringBuffer(String.valueOf(this.m_func1)).append('+').append(this.m_func2)));
            }
        }
        this.reset();
    }
}

