/*
 * Decompiled with CFR 0.152.
 */
package superposition;

import edu.davidson.display.Format;
import edu.davidson.numerics.Parser;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public final class SuperpositionCanvas
extends Canvas {
    private Image osiGrid = null;
    private Image osi = null;
    private int iwidth = 0;
    private int iheight = 0;
    private boolean showCoord = false;
    private int xCoord;
    private int yCoord;
    private boolean running = false;
    boolean invalidGrid = true;
    String caption = "";
    double time = 0.0;
    double pixPerX = 10.0;
    double pixPerY = 10.0;
    double gridX = 1.0;
    double gridY = 1.0;
    int[] xpix = null;
    int[] ypix = null;
    Color lineColor = new Color(0, 0, 0);
    Parser parser;
    String funcStr = "5*exp(-(x-2*t-5)*(x-2*t-5))";
    boolean showTime = false;
    Font f = new Font("Helvetica", 1, 14);

    public void setRGB(int n, int n2, int n3) {
        this.lineColor = new Color(n, n2, n3);
    }

    public SuperpositionCanvas() {
        this.parser = new Parser(2);
        this.parser.defineVariable(1, "x");
        this.parser.defineVariable(2, "t");
        this.parser.define(this.funcStr);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function 1, position ").append(this.parser.getErrorPosition())));
            System.out.println("Function: ".concat(String.valueOf(this.funcStr)));
        }
        this.setBackground(Color.white);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setTime(double d) {
        this.time = d;
        this.repaint();
    }

    public void setFuncStr(String string) {
        this.funcStr = string;
        this.parser.define(this.funcStr);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function 1, position ").append(this.parser.getErrorPosition())));
            return;
        }
        this.repaint();
    }

    public void setRunning(boolean bl) {
        this.running = bl;
        if (!bl) {
            this.repaint();
        }
    }

    public void setShowTime(boolean bl) {
        this.showTime = bl;
        this.repaint();
    }

    public void setPixPerX(double d) {
        if (this.pixPerX != d) {
            this.pixPerX = d;
            this.invalidGrid = true;
            this.repaint();
        }
    }

    public void setPixPerY(double d) {
        if (this.pixPerY != d) {
            this.pixPerY = d;
            this.invalidGrid = true;
            this.repaint();
        }
    }

    public void setCaption(String string) {
        if (!this.caption.equals(string)) {
            this.caption = string;
            this.invalidGrid = true;
            this.repaint();
        }
    }

    public void setGridX(double d) {
        if (this.gridX != d) {
            this.gridX = d;
            this.invalidGrid = true;
            this.repaint();
        }
    }

    public void setGridY(double d) {
        if (this.gridY != d) {
            this.gridY = d;
            this.invalidGrid = true;
            this.repaint();
        }
    }

    void drawGrid(Graphics graphics) {
        int n;
        this.invalidGrid = false;
        if (this.osiGrid == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osiGrid = this.createImage(this.iwidth, this.iheight);
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        int n2 = this.iwidth / 2;
        int n3 = this.iheight / 2;
        Graphics graphics2 = this.osiGrid.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        graphics2.setColor(graphics.getColor());
        graphics2.clipRect(0, 0, this.iwidth, this.iheight);
        graphics2.setColor(Color.lightGray);
        int n4 = (int)(this.pixPerX * this.gridX);
        if ((double)n4 > 0.5) {
            for (n = n2 % n4; n < this.iwidth; n += n4) {
                graphics2.drawLine(n, 0, n, this.iheight);
            }
        }
        if ((double)(n4 = (int)(this.pixPerY * this.gridY)) > 0.5) {
            for (n = n3 % n4; n < this.iheight; n += n4) {
                graphics2.drawLine(0, n, this.iwidth, n);
            }
        }
        graphics2.setFont(this.f);
        graphics2.setColor(Color.black);
        FontMetrics fontMetrics = graphics2.getFontMetrics(this.f);
        graphics2.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 15);
        graphics2.dispose();
    }

    void drawOSI() {
        Object object;
        if (this.xpix == null || this.ypix == null || this.getBounds().width != this.iwidth) {
            this.iwidth = this.getBounds().width;
            this.xpix = new int[this.iwidth];
            this.ypix = new int[this.iwidth];
        }
        int n = this.iwidth / 2;
        int n2 = this.iheight / 2;
        int n3 = 0;
        try {
            for (n3 = 0; n3 < this.iwidth; ++n3) {
                double d = (double)(n3 - n) / this.pixPerX;
                this.xpix[n3] = n3;
                this.ypix[n3] = (int)Math.round((double)n2 - this.parser.evaluate(d, this.time) * this.pixPerY);
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to draw function.");
        }
        Graphics graphics = this.osi.getGraphics();
        graphics.drawImage(this.osiGrid, 0, 0, this);
        graphics.setColor(this.lineColor);
        graphics.drawPolyline(this.xpix, this.ypix, this.iwidth);
        graphics.setColor(Color.black);
        if (this.showTime) {
            object = new Format("%7.4g").form(this.time);
            graphics.drawString("Time: ".concat(String.valueOf(object)), 15, 15);
        }
        if (this.showCoord) {
            object = new Format("%-+6.3g");
            String string = ((Format)object).form(this.pixToX(this.xCoord));
            String string2 = ((Format)object).form(this.pixToY(this.yCoord));
            graphics.drawString(String.valueOf(new StringBuffer("X: ").append(string).append("  F: ").append(string2)), 10, this.iheight - 15);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
        }
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.invalidGrid || this.osiGrid == null || this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.drawGrid(graphics);
        }
        this.drawOSI();
        graphics.drawImage(this.osi, 0, 0, this);
    }

    private double pixToX(int n) {
        int n2 = this.iwidth / 2;
        return (double)(n - n2) / (1.0 * this.pixPerX);
    }

    private double pixToY(int n) {
        int n2 = this.iheight / 2;
        return (double)(-(n - n2)) / (1.0 * this.pixPerY);
    }

    public void startDrawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (!this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            Format format = new Format("%-+6.3g");
            String string = format.form(this.pixToX(this.xCoord));
            String string2 = format.form(this.pixToY(this.yCoord));
            graphics.drawString(String.valueOf(new StringBuffer("X: ").append(string).append("  F: ").append(string2)), 10, this.iheight - 15);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            graphics.dispose();
        }
        this.showCoord = true;
    }

    public void endDrawCoord(int n, int n2) {
        this.showCoord = false;
        if (!this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public void drawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (!this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            Format format = new Format("%-+6.3g");
            String string = format.form(this.pixToX(this.xCoord));
            String string2 = format.form(this.pixToY(this.yCoord));
            graphics.drawString(String.valueOf(new StringBuffer("X: ").append(string).append("  F: ").append(string2)), 10, this.iheight - 15);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            graphics.dispose();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.startDrawCoord(n, n2);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.endDrawCoord(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.drawCoord(n, n2);
        return true;
    }
}

