/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class Kepler2
extends Applet
implements Runnable {
    int width;
    int height;
    final int xM = 220;
    final int yM = 170;
    Graphics g1;
    Graphics g2;
    Image offscreen;
    final Color bgColor = Color.yellow;
    final Color pColor = Color.green;
    final Color COL1 = Color.green;
    final Color COL2 = Color.magenta;
    Font fontH;
    Font fontC;
    FontMetrics fmH;
    FontMetrics fmC;
    Panel pan;
    Choice chPl;
    TextField tfA;
    TextField tfEps;
    Button bPause;
    Checkbox cbSlow;
    Checkbox cbS;
    Checkbox cbV;
    Scrollbar scrS;
    Label lR;
    Label lV;
    Label lMin;
    Label lMax;
    final double PI = Math.PI;
    final double PI2 = Math.PI * 2;
    final int aPix = 120;
    int bPix;
    int ePix;
    double a;
    double b;
    double a2;
    double b2;
    double eps;
    double vMin;
    double vMax;
    double eTotal;
    final double AE = 1.4959787E11;
    final double GAMMA = 6.672E-11;
    final double MS = 1.993E30;
    final double c0 = 8.888693401851243E8;
    Thread thr;
    double t;
    boolean on;
    boolean slow;
    final double u = 10.0;
    double c1;
    double c2;
    Polygon s1;
    Polygon s2;
    int nr;
    final int nSector = 60;
    double yps1;
    double yps2;
    double part;
    double t0S1;
    double t0S2;
    double tS1;
    double tS2;
    final double[] aPl = new double[]{0.387, 0.723, 1.0, 1.52, 5.2, 9.55, 19.2, 30.1, 39.7, 17.9, 1.0};
    final double[] epsPl;
    String lang;
    String[] text;
    String[] planet;
    String[] german;
    String[] plGerman;
    String[] english;
    String[] plEnglish;
    String[] french;
    String[] plFrench;

    public void init() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.fontH = new Font("Helvetica", 1, 12);
        this.fontC = new Font("Courier", 1, 16);
        this.fmH = this.getFontMetrics(this.fontH);
        this.fmC = this.getFontMetrics(this.fontC);
        this.g1 = this.getGraphics();
        this.offscreen = this.createImage(this.width, this.height);
        this.g2 = this.offscreen.getGraphics();
        this.setLayout(new BorderLayout());
    }

    void addComponent(Component component, Color color, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(n4, n5, n6, n7);
        ((GridBagLayout)this.pan.getLayout()).setConstraints(component, gridBagConstraints);
        component.setFont(this.fontH);
        component.setBackground(color);
        this.pan.add(component);
    }

    void calculation() {
        this.b = Math.sqrt(1.0 - this.eps * this.eps);
        this.bPix = (int)(120.0 * this.b + 0.5);
        this.b *= this.a;
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.c1 = Math.sqrt((1.0 + this.eps) / (1.0 - this.eps));
        this.c2 = this.eps * 120.0;
        this.ePix = (int)(this.c2 + 0.5);
        double d = Math.PI * 2 * this.a * 1.4959787E11 * Math.sqrt(this.a / 8.888693401851243E8);
        double d2 = Math.PI * 2 * this.a * this.b * 1.4959787E11 / (d * this.a);
        this.vMin = d2 / (1.0 + this.eps);
        this.vMax = d2 / (1.0 - this.eps);
        this.eTotal = this.vMin * this.vMin / 2.0 - 8.888693401851243E8 / (this.a * (1.0 + this.eps));
    }

    public void start() {
        this.text = this.german;
        this.planet = this.plGerman;
        this.lang = this.getParameter("language");
        if (this.lang == null) {
            this.lang = "German";
        }
        if (this.lang.equals("English")) {
            this.text = this.english;
            this.planet = this.plEnglish;
        } else if (this.lang.equals("French")) {
            this.text = this.french;
            this.planet = this.plFrench;
        }
        this.a = this.aPl[0];
        this.eps = this.epsPl[0];
        this.calculation();
        this.s1 = new Polygon();
        this.s2 = new Polygon();
        int n = 0;
        while (n <= 61) {
            this.s1.addPoint(0, 0);
            this.s2.addPoint(0, 0);
            ++n;
        }
        this.yps1 = 0.0;
        this.yps2 = Math.PI;
        this.part = 0.1;
        this.setSector(this.s1, this.yps1);
        this.setSector(this.s2, this.yps2);
        this.nr = 0;
        this.pan = new Panel();
        this.pan.setBackground(this.pColor);
        this.pan.setLayout(new GridBagLayout());
        this.chPl = new Choice();
        int n2 = 0;
        while (n2 < this.planet.length) {
            this.chPl.addItem(this.planet[n2]);
            ++n2;
        }
        this.addComponent(this.chPl, Color.white, 0, 0, 3, 15, 10, 0, 10);
        this.addComponent(new Label(this.text[2]), this.pColor, 0, 1, 1, 10, 10, 0, 5);
        this.tfA = new TextField(5);
        ((TextComponent)this.tfA).setText(this.doubleToString2(this.a, 3));
        this.addComponent(this.tfA, Color.white, 1, 1, 1, 10, 0, 0, 0);
        this.addComponent(new Label(this.text[1]), this.pColor, 2, 1, 1, 10, 5, 0, 10);
        this.addComponent(new Label(this.text[3]), this.pColor, 0, 2, 1, 10, 10, 0, 5);
        this.tfEps = new TextField(5);
        ((TextComponent)this.tfEps).setText(this.doubleToString2(this.eps, 3));
        this.addComponent(this.tfEps, Color.white, 1, 2, 1, 10, 0, 0, 0);
        this.bPause = new Button(this.text[4]);
        this.addComponent(this.bPause, Color.magenta, 0, 3, 3, 10, 10, 0, 10);
        this.cbSlow = new Checkbox(this.text[5]);
        this.addComponent(this.cbSlow, this.pColor, 0, 4, 3, 10, 10, 0, 10);
        this.cbS = new Checkbox(this.text[6]);
        this.cbS.setState(true);
        this.addComponent(this.cbS, this.pColor, 0, 5, 1, 10, 10, 0, 5);
        this.scrS = new Scrollbar(0, 4, 4, 0, 24);
        this.addComponent(this.scrS, Color.gray, 1, 5, 2, 10, 0, 0, 10);
        this.cbV = new Checkbox(this.text[7]);
        this.addComponent(this.cbV, this.pColor, 0, 6, 3, 0, 10, 0, 10);
        this.addComponent(new Label(this.text[8]), this.pColor, 0, 7, 1, 10, 10, 0, 0);
        this.addComponent(new Label(this.text[9]), this.pColor, 0, 8, 1, 0, 10, 0, 0);
        this.lR = new Label();
        this.addComponent(this.lR, this.pColor, 1, 8, 1, 0, 0, 0, 0);
        this.addComponent(new Label(this.text[1]), this.pColor, 2, 8, 1, 0, 0, 0, 10);
        this.addComponent(new Label(this.text[10]), this.pColor, 0, 9, 3, 10, 10, 0, 10);
        this.addComponent(new Label(this.text[11]), this.pColor, 0, 10, 1, 0, 10, 0, 0);
        this.lV = new Label();
        this.addComponent(this.lV, this.pColor, 1, 10, 1, 0, 0, 0, 0);
        this.addComponent(new Label("km/s"), this.pColor, 2, 10, 1, 0, 0, 0, 10);
        this.addComponent(new Label(this.text[12]), this.pColor, 0, 11, 1, 0, 10, 0, 0);
        this.lMin = new Label();
        this.lMin.setText(this.doubleToString2(this.vMin / 1000.0, 3));
        this.addComponent(this.lMin, this.pColor, 1, 11, 1, 0, 0, 0, 0);
        this.addComponent(new Label("km/s"), this.pColor, 2, 11, 1, 0, 0, 0, 10);
        this.addComponent(new Label(this.text[13]), this.pColor, 0, 12, 1, 0, 10, 0, 0);
        this.lMax = new Label();
        this.lMax.setText(this.doubleToString2(this.vMax / 1000.0, 3));
        this.addComponent(this.lMax, this.pColor, 1, 12, 1, 0, 0, 0, 0);
        this.addComponent(new Label("km/s"), this.pColor, 2, 12, 1, 0, 0, 0, 10);
        this.addComponent(new Label(this.text[14]), this.pColor, 0, 13, 3, 10, 10, 10, 10);
        this.add("East", this.pan);
        this.chPl.addItemListener(new ChPlListener());
        TFListener tFListener = new TFListener();
        this.tfA.addActionListener(tFListener);
        this.tfEps.addActionListener(tFListener);
        this.bPause.addActionListener(new BPauseListener());
        this.cbSlow.addItemListener(new CBSlowListener());
        this.scrS.addAdjustmentListener(new ScrSListener());
        this.addMouseListener(new MHandler());
        this.addMouseMotionListener(new MMHandler());
        this.thr = new Thread(this);
        this.thr.start();
        this.on = true;
        this.slow = false;
        this.t = 0.0;
    }

    public void stop() {
        this.thr.stop();
        this.thr = null;
        this.removeAll();
    }

    public void run() {
        long l = System.currentTimeMillis();
        while (true) {
            this.paint(this.g2);
            this.g1.drawImage(this.offscreen, 0, 0, this);
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - l) / 1000.0;
            if (this.slow) {
                d /= 10.0;
            }
            if (this.on) {
                this.t += d;
            }
            l = l2;
        }
    }

    double excAnomaly(double d) {
        double d2 = 0.0;
        double d3 = Math.PI * 2;
        double d4 = Math.PI;
        while (d3 - d2 > 1.0E-5) {
            d4 = (d2 + d3) / 2.0;
            if (d4 - this.eps * Math.sin(d4) < d) {
                d2 = d4;
                continue;
            }
            d3 = d4;
        }
        return d4;
    }

    void thickLine(int n, int n2, int n3, int n4) {
        this.g2.drawLine(n, n2, n3, n4);
        if (Math.abs(n3 - n) > Math.abs(n4 - n2)) {
            this.g2.drawLine(n, n2 - 1, n3, n4 - 1);
            this.g2.drawLine(n, n2 + 1, n3, n4 + 1);
            return;
        }
        this.g2.drawLine(n - 1, n2, n3 - 1, n4);
        this.g2.drawLine(n + 1, n2, n3 + 1, n4);
    }

    void thickArrow(int n, int n2, int n3, int n4) {
        double d = 0.2;
        double d2 = 10.0;
        double d3 = n3 - n;
        double d4 = n2 - n4;
        this.thickLine(n, n2, n3, n4);
        double d5 = Math.atan2(d4, d3);
        n = (int)((double)n3 - d2 * Math.cos(d5 + d) + 0.5);
        n2 = (int)((double)n4 + d2 * Math.sin(d5 + d) + 0.5);
        this.thickLine(n, n2, n3, n4);
        n = (int)((double)n3 - d2 * Math.cos(d5 - d) + 0.5);
        n2 = (int)((double)n4 + d2 * Math.sin(d5 - d) + 0.5);
        this.thickLine(n, n2, n3, n4);
    }

    void planet() {
        int n = (int)(this.t / 10.0);
        if (n > 0) {
            this.t -= (double)n * 10.0;
        }
        double d = this.excAnomaly(Math.PI * 2 * this.t / 10.0);
        double d2 = 2.0 * Math.atan(this.c1 * Math.tan(d / 2.0));
        double d3 = 1.0 - this.eps * Math.cos(d);
        double d4 = 120.0 * d3;
        this.lR.setText(this.doubleToString2(d3 *= this.a, 3));
        int n2 = (int)(220.0 + this.c2 + d4 * Math.cos(d2) + 0.5);
        int n3 = (int)(170.0 - d4 * Math.sin(d2) + 0.5);
        this.g2.setColor(Color.blue);
        this.g2.fillOval(n2 - 2, n3 - 2, 5, 5);
        double d5 = this.eTotal + 8.888693401851243E8 / d3;
        double d6 = Math.sqrt(2.0 * d5);
        this.lV.setText(this.doubleToString2(d6 / 1000.0, 3));
        if (this.inside(this.s1, n2, n3)) {
            this.tS1 = this.t - this.t0S1;
            if (this.tS1 < 0.0) {
                this.tS1 += 10.0;
            }
            if (this.tS1 > this.part * 10.0) {
                this.tS1 = this.part * 10.0;
            }
        } else {
            this.tS1 = this.part * 10.0;
        }
        if (this.inside(this.s2, n2, n3)) {
            this.tS2 = this.t - this.t0S2;
            if (this.tS2 < 0.0) {
                this.tS2 += 10.0;
            }
            if (this.tS2 > this.part * 10.0) {
                this.tS2 = this.part * 10.0;
            }
        } else {
            this.tS2 = this.part * 10.0;
        }
        if (this.cbV.getState()) {
            this.g2.setColor(Color.black);
            this.g2.drawLine(220 + this.ePix, 170, n2, n3);
            double d7 = -this.a2 * d3 * Math.sin(d2);
            double d8 = this.b2 * (this.a * this.eps + d3 * Math.cos(d2));
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            double d10 = 100.0 * d6 / (d9 * this.vMax);
            this.thickArrow(n2, n3, n2 + (int)(d7 *= d10), n3 - (int)(d8 *= d10));
        }
    }

    void sun() {
        this.g2.setColor(Color.red);
        this.g2.fillOval(220 + this.ePix - 4, 166, 9, 9);
    }

    void setSector(Polygon polygon, double d) {
        double d2;
        double d3;
        double d4;
        double d5 = 2.0 * Math.atan(Math.tan(d / 2.0) / this.c1);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        if ((d4 = (d3 = d5 - this.eps * Math.sin(d5)) - this.part * Math.PI) < 0.0) {
            d4 += Math.PI * 2;
        }
        if ((d2 = d3 + this.part * Math.PI) > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        double d6 = this.excAnomaly(d4);
        double d7 = this.excAnomaly(d2);
        if (d7 < d6) {
            d7 += Math.PI * 2;
        }
        double d8 = (d7 - d6) / 60.0;
        int n = 0;
        while (n <= 60) {
            d5 = d6 + (double)n * d8;
            double d9 = 120.0 * (1.0 - this.eps * Math.cos(d5));
            double d10 = 2.0 * Math.atan(this.c1 * Math.tan(d5 / 2.0));
            polygon.xpoints[n] = (int)(220.0 + this.c2 + d9 * Math.cos(d10) + 0.5);
            polygon.ypoints[n] = (int)(170.0 - d9 * Math.sin(d10) + 0.5);
            ++n;
        }
        polygon.xpoints[61] = 220 + this.ePix;
        polygon.ypoints[61] = 170;
        if (polygon == this.s1) {
            this.t0S1 = 10.0 * d4 / (Math.PI * 2);
            return;
        }
        if (polygon == this.s2) {
            this.t0S2 = 10.0 * d4 / (Math.PI * 2);
        }
    }

    String doubleToString(double d, int n) {
        String string;
        if (Math.abs(d) < 1.0E-6) {
            String string2 = "0" + this.text[0];
            int n2 = 0;
            while (n2 < n) {
                string2 = String.valueOf(string2) + "0";
                ++n2;
            }
            return string2;
        }
        String string3 = string = d >= 0.0 ? "" : "-";
        if (d < 0.0) {
            d = -d;
        }
        int n3 = 0;
        int n4 = 1;
        while (n3 < n) {
            n4 *= 10;
            ++n3;
        }
        int n5 = (int)(d * (double)n4 + 0.5);
        string = String.valueOf(string) + n5 / n4;
        if (n > 0) {
            string = String.valueOf(string) + this.text[0];
        }
        n5 %= n4;
        n3 = 0;
        while (n3 < n) {
            string = String.valueOf(string) + n5 / (n4 /= 10);
            n5 %= n4;
            ++n3;
        }
        return string;
    }

    String doubleToString2(double d, int n) {
        double d2 = Math.abs(d);
        int n2 = (int)Math.floor(Math.log(d2) / Math.log(10.0));
        String string = d >= 0.0 ? "" : "-";
        return String.valueOf(string) + this.doubleToString(d2, n - 1 - n2);
    }

    double stringToDouble(String string) {
        double d;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == ',') {
                stringBuffer.setCharAt(n, '.');
            }
            ++n;
        }
        try {
            d = Double.valueOf(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    double inputTF(TextField textField, double d, double d2, int n, int n2) {
        double d3 = this.stringToDouble(textField.getText());
        if (d3 < d) {
            d3 = d;
        }
        if (d3 > d2) {
            d3 = d2;
        }
        if (n2 == 1) {
            ((TextComponent)textField).setText(this.doubleToString(d3, n));
        } else {
            ((TextComponent)textField).setText(this.doubleToString2(d3, n));
        }
        return d3;
    }

    double diff(double d, int n, int n2) {
        double d2 = Math.atan2(170 - n2, (double)(n - 220) - this.c2) - d;
        while (d2 < -Math.PI) {
            d2 += Math.PI * 2;
        }
        while (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        return d2;
    }

    boolean inside(Polygon polygon, int n, int n2) {
        double d;
        double d2 = polygon == this.s1 ? this.yps1 : this.yps2;
        double d3 = this.diff(d2, polygon.xpoints[0], polygon.ypoints[0]);
        double d4 = this.diff(d2, polygon.xpoints[60], polygon.ypoints[60]);
        if (d3 > 0.0) {
            d3 -= Math.PI * 2;
        }
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        if ((d = this.diff(d2, n, n2)) >= d3 && d <= d4) {
            return true;
        }
        if ((d += Math.PI * 2) >= d3 && d <= d4) {
            return true;
        }
        return (d -= Math.PI * 4) >= d3 && d <= d4;
    }

    void moveS1() {
        double d;
        double d2;
        int n = 0;
        if (this.inside(this.s2, this.s1.xpoints[0], this.s1.ypoints[0])) {
            n = 1;
        }
        if (this.inside(this.s2, this.s1.xpoints[60], this.s1.ypoints[60])) {
            n = -1;
        }
        if (n == 0) {
            return;
        }
        double d3 = 2.0 * Math.atan(Math.tan(this.yps2 / 2.0) / this.c1);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = (d = d3 - this.eps * Math.sin(d3)) + (double)n * this.part * (Math.PI * 2)) < 0.0) {
            d2 += Math.PI * 2;
        }
        if (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        double d4 = this.excAnomaly(d2);
        this.yps1 = 2.0 * Math.atan(this.c1 * Math.tan(d4 / 2.0));
        if (this.yps1 < 0.0) {
            this.yps1 += Math.PI * 2;
        }
        this.setSector(this.s1, this.yps1);
    }

    void moveS2() {
        double d;
        double d2;
        int n = 0;
        if (this.inside(this.s1, this.s2.xpoints[0], this.s2.ypoints[0])) {
            n = 1;
        }
        if (this.inside(this.s1, this.s2.xpoints[60], this.s2.ypoints[60])) {
            n = -1;
        }
        if (n == 0) {
            return;
        }
        double d3 = 2.0 * Math.atan(Math.tan(this.yps1 / 2.0) / this.c1);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = (d = d3 - this.eps * Math.sin(d3)) + (double)n * this.part * (Math.PI * 2)) < 0.0) {
            d2 += Math.PI * 2;
        }
        if (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        double d4 = this.excAnomaly(d2);
        this.yps2 = 2.0 * Math.atan(this.c1 * Math.tan(d4 / 2.0));
        if (this.yps2 < 0.0) {
            this.yps2 += Math.PI * 2;
        }
        this.setSector(this.s2, this.yps2);
    }

    void sectors() {
        int n = 220 + this.ePix;
        this.g2.setColor(this.COL1);
        this.g2.fillPolygon(this.s1);
        this.g2.setColor(this.COL2);
        this.g2.fillPolygon(this.s2);
        this.g2.setColor(Color.black);
        this.g2.drawLine(n, 170, this.s1.xpoints[0], this.s1.ypoints[0]);
        this.g2.drawLine(n, 170, this.s1.xpoints[60], this.s1.ypoints[60]);
        this.g2.drawLine(n, 170, this.s2.xpoints[0], this.s2.ypoints[0]);
        this.g2.drawLine(n, 170, this.s2.xpoints[60], this.s2.ypoints[60]);
    }

    void clock(Color color, int n, int n2, double d) {
        this.g2.setColor(color);
        this.g2.fillRect(n - 60, n2 - 15, 120, 30);
        this.g2.setColor(Color.black);
        this.g2.drawRect(n - 60, n2 - 15, 120, 30);
        this.g2.setColor(Color.black);
        this.g2.fillRect(n - 50, n2 - 10, 100, 20);
        this.g2.setColor(Color.red);
        this.g2.setFont(this.fontC);
        String string = String.valueOf(this.doubleToString(d, 3)) + " T";
        int n3 = this.fmC.stringWidth(string);
        this.g2.drawString(string, n - n3 / 2, n2 + 5);
        this.g2.setFont(this.fontH);
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.fontH);
        graphics.setColor(this.bgColor);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.cbS.getState()) {
            this.sectors();
            this.clock(this.COL1, 340, 320, this.tS1 / 10.0);
            this.clock(this.COL2, 100, 320, this.tS2 / 10.0);
        }
        graphics.setColor(Color.black);
        graphics.drawOval(100, 170 - this.bPix, 240, 2 * this.bPix);
        this.sun();
        this.planet();
    }

    void actionEnd() {
        this.yps1 = 0.0;
        this.yps2 = Math.PI;
        this.calculation();
        this.lMin.setText(this.doubleToString2(this.vMin / 1000.0, 3));
        this.lMax.setText(this.doubleToString2(this.vMax / 1000.0, 3));
        this.setSector(this.s1, this.yps1);
        this.setSector(this.s2, this.yps2);
    }

    public Kepler2() {
        double[] dArray = new double[11];
        dArray[0] = 0.206;
        dArray[1] = 0.007;
        dArray[2] = 0.017;
        dArray[3] = 0.093;
        dArray[4] = 0.048;
        dArray[5] = 0.056;
        dArray[6] = 0.046;
        dArray[7] = 0.009;
        dArray[8] = 0.252;
        dArray[9] = 0.967;
        this.epsPl = dArray;
        this.german = new String[]{",", "AE", "Gro\u00dfe Halbachse:", "Num. Exzentrit\u00e4t:", "Pause / Weiter", "Zeitlupe", "Sektoren", "Geschwindigkeitsvektor", "Entfernung", "von der Sonne:", "Geschwindigkeit:", "Aktueller Wert:", "Minimum:", "Maximum:", "\u00a9  W. Fendt 2000"};
        this.plGerman = new String[]{"Merkur", "Venus", "Erde", "Mars", "Jupiter", "Saturn", "Uranus", "Neptun", "Pluto", "Halleyscher Komet", ""};
        this.english = new String[]{".", "AU", "Semimajor axis:", "Num. eccentrity:", "Pause / Resume", "Slow motion", "Sectors", "Vector of velocity", "Distance", "from the Sun:", "Velocity:", "Currently:", "Minimum:", "Maximum:", "\u00a9  W. Fendt 2000"};
        this.plEnglish = new String[]{"Mercury", "Venus", "Earth", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune", "Pluto", "Halley's Comet", ""};
        this.french = new String[]{",", "AU", "Demi grand axe:", "Num. excentricit\u00e9:", "Pause / Recommence", "Ralenti", "Secteurs", "Vecteur vitesse", "Distance", "au Soleil:", "Vitesse:", "Actuellement:", "Minimum:", "Maximum:", "\u00a9  W. Fendt, Y. Weiss 2000"};
        this.plFrench = new String[]{"Mercure", "Venus", "Terre", "Mars", "Jupiter", "Saturne", "Uranus", "Neptune", "Pluton", "Com\u00e8te de Halley", ""};
    }

    class ChPlListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = Kepler2.this.chPl.getSelectedIndex();
            if (n == Kepler2.this.planet.length - 1) {
                Kepler2.this.chPl.select(--n);
            }
            Kepler2.this.a = Kepler2.this.aPl[n];
            Kepler2.this.eps = Kepler2.this.epsPl[n];
            ((TextComponent)Kepler2.this.tfA).setText(Kepler2.this.doubleToString2(Kepler2.this.a, 3));
            ((TextComponent)Kepler2.this.tfEps).setText(Kepler2.this.doubleToString(Kepler2.this.eps, 3));
            Kepler2.this.actionEnd();
        }

        ChPlListener() {
            Kepler2.this = Kepler2.this;
        }
    }

    class TFListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Kepler2.this.a = Kepler2.this.inputTF(Kepler2.this.tfA, 0.1, 100.0, 3, 2);
            Kepler2.this.eps = Kepler2.this.inputTF(Kepler2.this.tfEps, 0.0, 0.999, 3, 1);
            Kepler2.this.chPl.select(Kepler2.this.planet.length - 1);
            Kepler2.this.actionEnd();
        }

        TFListener() {
            Kepler2.this = Kepler2.this;
        }
    }

    class BPauseListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Kepler2.this.on = !Kepler2.this.on;
        }

        BPauseListener() {
            Kepler2.this = Kepler2.this;
        }
    }

    class CBSlowListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Kepler2.this.slow = Kepler2.this.cbSlow.getState();
        }

        CBSlowListener() {
            Kepler2.this = Kepler2.this;
        }
    }

    class ScrSListener
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = Kepler2.this.scrS.getValue();
            if (n > 20) {
                n = 20;
                Kepler2.this.scrS.setValue(n);
            }
            Kepler2.this.part = (double)n * 0.025;
            Kepler2.this.actionEnd();
        }

        ScrSListener() {
            Kepler2.this = Kepler2.this;
        }
    }

    class MHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            double d = Math.atan2(170 - n2, (double)(n - 220) - Kepler2.this.c2);
            if (d < 0.0) {
                d += Math.PI * 2;
            }
            if (Kepler2.this.inside(Kepler2.this.s1, n, n2)) {
                Kepler2.this.nr = 1;
                Kepler2.this.yps1 = d;
                Kepler2.this.setSector(Kepler2.this.s1, Kepler2.this.yps1);
                return;
            }
            if (Kepler2.this.inside(Kepler2.this.s2, n, n2)) {
                Kepler2.this.nr = 2;
                Kepler2.this.yps2 = d;
                Kepler2.this.setSector(Kepler2.this.s2, Kepler2.this.yps2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Kepler2.this.nr = 0;
        }

        MHandler() {
            Kepler2.this = Kepler2.this;
        }
    }

    class MMHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (Kepler2.this.nr == 0) {
                return;
            }
            double d = Math.atan2(170 - mouseEvent.getY(), (double)(mouseEvent.getX() - 220) - Kepler2.this.c2);
            if (d < 0.0) {
                d += Math.PI * 2;
            }
            if (Kepler2.this.nr == 1) {
                Kepler2.this.yps1 = d;
                Kepler2.this.setSector(Kepler2.this.s1, Kepler2.this.yps1);
                Kepler2.this.moveS2();
                return;
            }
            Kepler2.this.yps2 = d;
            Kepler2.this.setSector(Kepler2.this.s2, Kepler2.this.yps2);
            Kepler2.this.moveS1();
        }

        MMHandler() {
            Kepler2.this = Kepler2.this;
        }
    }
}

