/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import faraday.Faraday_forwardBtn_actionAdapter;
import faraday.Faraday_resetBtn_actionAdapter;
import faraday.Faraday_runBtn_actionAdapter;
import faraday.Schematic;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import sGraphics.EtchedBorder;
import sTools.SApplet;
import sTools.SGraph;

public class Faraday
extends SApplet
implements Runnable {
    boolean isStandalone = false;
    int pixPerUnit;
    int fps;
    boolean showControls;
    String fieldStr;
    String posStr;
    boolean showGraph;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button runBtn = new Button();
    Button resetBtn = new Button();
    EtchedBorder etchedBorder4 = new EtchedBorder();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    Label label1 = new Label();
    Label label2 = new Label();
    TextField posField = new TextField();
    TextField fieldField = new TextField();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    EtchedBorder etchedBorder7 = new EtchedBorder();
    SGraph graph = new SGraph();
    Schematic schematic = new Schematic(this);
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    private boolean dragMode = true;
    private boolean cycle = true;
    private boolean keepRunning = true;
    private Thread runThread = null;
    private long time = 0L;
    private int sleepTime = 100;
    private double mTime = 10.0;
    private long maxTime = 10000L;
    private int schematicWidth = 200;
    private boolean showSchematic = true;
    private boolean showGrid = true;
    private boolean showColor = true;
    private boolean showCurrentArrow = true;
    Button forwardBtn = new Button();
    Checkbox dragBox = new Checkbox();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public void init() {
        try {
            this.mTime = (double)1000 * Double.valueOf(this.getParameter("MaxTime", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.maxTime = (int)this.mTime;
        try {
            this.pixPerUnit = Integer.parseInt(this.getParameter("PixPerUnit", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.schematicWidth = Integer.parseInt(this.getParameter("SchematicWidth", "200"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fieldStr = this.getParameter("FieldFunction", "10*sin(pi*x/5)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.posStr = this.getParameter("PositionFunction", "1.0+3.0*t");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showSchematic = Boolean.valueOf(this.getParameter("ShowSchematic", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGrid = Boolean.valueOf(this.getParameter("ShowGrid", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showColor = Boolean.valueOf(this.getParameter("ShowColor", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showCurrentArrow = Boolean.valueOf(this.getParameter("ShowCurrentArrow", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dragMode = Boolean.valueOf(this.getParameter("DragMode", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sleepTime = (int)(1000.0 / (double)this.fps);
        if (!this.showControls) {
            this.etchedBorder1.setVisible(false);
        }
        this.schematic.showSchematic = this.showSchematic;
        ((TextComponent)this.posField).setText(this.posStr);
        this.posField.setEnabled(!this.dragMode);
        this.dragBox.setState(this.dragMode);
        ((TextComponent)this.fieldField).setText(this.fieldStr);
        this.graph.setEnableMouse(true);
        this.setBackground(Color.lightGray);
        this.graph.setBackground(Color.white);
        this.graph.setVisible(this.showGraph);
        this.setRunningID(this);
        this.graph.deleteAllSeries();
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setBorders("0,10,10,5");
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.graph.setMinMaxX(0.0, (double)this.maxTime / 1000.0);
        this.graph.setMinMaxY(-250.0, 250.0);
        this.schematic.parsePosFunction(this.posStr);
        this.schematic.parseFieldFunction(this.fieldStr);
        this.schematic.pixPerUnit = this.pixPerUnit;
        this.schematic.setDragMode(this.dragMode);
        this.schematic.fillApplet = !this.showGraph;
        this.schematic.setPreferredWidth(this.schematicWidth);
        this.schematic.showGrid = this.showGrid;
        this.schematic.showColor = this.showColor;
        this.schematic.showCurrentArrow = this.showCurrentArrow;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(669, 401));
        this.runBtn.setLabel(" Run ");
        this.runBtn.addActionListener(new Faraday_runBtn_actionAdapter(this));
        this.resetBtn.setLabel("Reset");
        this.resetBtn.addActionListener(new Faraday_resetBtn_actionAdapter(this));
        this.label1.setAlignment(2);
        this.label1.setText("B(x,t)=");
        this.label2.setAlignment(2);
        this.label2.setText("    x(t)=");
        this.graph.setSampleData(false);
        this.graph.setLabelY("Voltage (mV)");
        this.forwardBtn.setLabel(">>");
        this.dragBox.setLabel("U Drag");
        this.dragBox.addItemListener(new 1());
        this.fieldField.addActionListener(new 2());
        this.posField.addActionListener(new 3());
        this.forwardBtn.addActionListener(new Faraday_forwardBtn_actionAdapter(this));
        this.graph.setLabelX("Time (s)");
        this.etchedBorder4.setLayout(this.borderLayout4);
        this.panel2.setLayout(this.borderLayout1);
        this.panel1.setLayout(this.borderLayout2);
        this.etchedBorder3.setLayout(this.borderLayout6);
        this.etchedBorder1.setLayout(this.borderLayout3);
        this.etchedBorder2.setLayout(this.flowLayout1);
        this.etchedBorder7.setLayout(this.borderLayout7);
        this.setLayout(this.borderLayout5);
        this.add((Component)this.etchedBorder4, "Center");
        this.etchedBorder4.add((Component)this.graph, "Center");
        this.etchedBorder7.add((Component)this.schematic, "Center");
        this.etchedBorder4.add((Component)this.etchedBorder7, "West");
        this.add((Component)this.etchedBorder1, "South");
        this.etchedBorder1.add((Component)this.etchedBorder2, "West");
        this.etchedBorder2.add((Component)this.dragBox, null);
        this.etchedBorder2.add((Component)this.runBtn, null);
        this.etchedBorder2.add((Component)this.resetBtn, null);
        this.etchedBorder2.add((Component)this.forwardBtn, null);
        this.etchedBorder1.add((Component)this.etchedBorder3, "Center");
        this.etchedBorder3.add((Component)this.panel1, "North");
        this.panel1.add((Component)this.label2, "West");
        this.panel1.add((Component)this.posField, "Center");
        this.etchedBorder3.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label1, "West");
        this.panel2.add((Component)this.fieldField, "Center");
    }

    public void forward() {
        this.start();
    }

    public void start() {
        this.setRunningID(this);
        if (!this.showSchematic) {
            return;
        }
        if (this.runThread == null) {
            this.runThread = new Thread(this);
            this.runThread.start();
        }
    }

    void step() {
        try {
            Thread.sleep(this.sleepTime);
            if (this.schematic.osi != null) {
                if (this.time == (long)0) {
                    this.schematic.reset();
                }
                this.time += (long)this.sleepTime;
                double d = this.schematic.setTime(this.time);
                if (this.time > (long)0) {
                    this.graph.addDatum(1, (double)this.time / 1000.0, d);
                }
                if (this.cycle && this.time >= this.maxTime) {
                    this.time = 0L;
                    this.schematic.reset();
                    this.graph.clearSeriesData(1);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        this.runBtn.setLabel("Pause");
        this.keepRunning = true;
        while (this.keepRunning && this.time < this.maxTime && this.getRunningID() == this) {
            this.step();
        }
        this.keepRunning = false;
        this.runBtn.setLabel(" Run ");
        this.runThread = null;
    }

    public void stop() {
        this.keepRunning = false;
        this.runBtn.setLabel(" Run ");
        if (this.runThread != null) {
            try {
                this.runThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public int getGraphID() {
        return this.graph.getID();
    }

    public int getSchematicID() {
        return this.schematic.getID();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MaxTime", "double", "Length of time the animation should run in seconds."}, {"PixPerUnit", "int", "Pixesl per unit"}, {"FPS", "int", "Frames per second in anmination"}, {"ShowControls", "boolean", "Show controls"}, {"FieldFunction", "String", "Magnetic Field: B(x,t)"}, {"PositionFunction", "String", "The postion of the wire: x(t)"}, {"ShowSchematic", "boolean", "Show the schematic at start up."}, {"ShowGraph", "boolean", "Show the voltage graph: V(t)."}, {"DragMode", "boolean", "Let the user drag the wire."}};
        return stringArray;
    }

    void runBtn_actionPerformed(ActionEvent actionEvent) {
        this.fieldField_actionPerformed(actionEvent);
        this.posField_actionPerformed(actionEvent);
        if (this.runThread == null) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void setDefault() {
        this.showSchematic = true;
        this.schematic.showSchematic = true;
        this.stop();
        this.schematic.reset();
        this.step();
        this.schematic.reset();
        this.time = 0L;
        this.graph.clearSeriesData(1);
        if (this.runThread == null) {
            this.schematic.repaint();
        }
    }

    void resetBtn_actionPerformed(ActionEvent actionEvent) {
        this.setDefault();
    }

    public void setShowColor(boolean bl) {
        this.schematic.showColor = this.showColor = bl;
        this.schematic.repaint();
    }

    public void setShowGrid(boolean bl) {
        this.schematic.showGrid = this.showGrid = bl;
        this.schematic.repaint();
    }

    public void setShowBOnDrag(boolean bl) {
        this.schematic.showBOnDrag = bl;
    }

    public void setShowCurrentArrow(boolean bl) {
        this.schematic.showCurrentArrow = this.showCurrentArrow = bl;
        this.schematic.repaint();
    }

    public void setDragMode(boolean bl) {
        this.dragMode = bl;
        this.dragBox.setState(this.dragMode);
        this.posField.setEnabled(!bl);
        this.schematic.setDragMode(bl);
    }

    public void setMeterMinMax(double d, double d2) {
        this.schematic.setMeterMinMax(d, d2);
        this.graph.setMinMaxY(d, d2);
        this.graph.repaint();
        this.schematic.repaint();
    }

    public void setPixPerUnit(int n) {
        this.schematic.pixPerUnit = this.pixPerUnit = n;
    }

    public void setShowGraph(boolean bl) {
        if (this.graph.isVisible() == bl) {
            return;
        }
        this.showGraph = bl;
        this.schematic.fillApplet = !this.showGraph;
        this.graph.setVisible(bl);
        this.invalidate();
        this.validate();
    }

    public void setPosFunction(String string) {
        this.posStr = string;
        ((TextComponent)this.posField).setText(this.posStr);
        this.schematic.parsePosFunction(this.posStr);
    }

    public void setFieldFunction(String string) {
        this.fieldStr = string;
        ((TextComponent)this.fieldField).setText(this.fieldStr);
        this.schematic.parseFieldFunction(this.fieldStr);
    }

    public void setMaxTime(double d) {
        this.maxTime = (long)((double)1000 * d);
        this.graph.setMinMaxX(0.0, (double)this.maxTime / 1000.0);
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    void forwardBtn_actionPerformed(ActionEvent actionEvent) {
        this.step();
    }

    void posField_actionPerformed(ActionEvent actionEvent) {
        if (this.schematic.parsePosFunction(this.posField.getText())) {
            ((Component)this.posField).setBackground(Color.white);
        } else {
            ((Component)this.posField).setBackground(Color.red);
        }
    }

    void fieldField_actionPerformed(ActionEvent actionEvent) {
        if (this.schematic.parseFieldFunction(this.fieldField.getText())) {
            ((Component)this.fieldField).setBackground(Color.white);
            this.schematic.repaint();
        } else {
            ((Component)this.fieldField).setBackground(Color.red);
        }
    }

    void dragBox_itemStateChanged(ItemEvent itemEvent) {
        this.schematic.setDragMode(this.dragBox.getState());
        this.setDefault();
        this.fieldField_actionPerformed(new ActionEvent(this, 0, null));
        this.posField_actionPerformed(new ActionEvent(this, 0, null));
        this.posField.setEnabled(!this.dragBox.getState());
        if (this.dragBox.getState() && this.graph.isVisible()) {
            this.time = 0L;
            this.start();
        }
    }

    class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Faraday.this.posField_actionPerformed(actionEvent);
        }

        3() {
        }
    }

    class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Faraday.this.fieldField_actionPerformed(actionEvent);
        }

        2() {
        }
    }

    class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Faraday.this.dragBox_itemStateChanged(itemEvent);
        }

        1() {
        }
    }
}

