/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import faraday.Part;
import faraday.Schematic;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sTools.Format;

public class Meter
extends Part {
    Format format = new Format("%-+6.2f");
    boolean horz = true;
    int h = 40;
    double min = -200.0;
    double max = 200.0;
    double value = 1.0;
    int xo = 0;
    int yo = 0;
    int textOffset = -25;

    public Meter(Schematic schematic, int n, int n2, int n3, int n4) {
        super(schematic, n, n2, n3, n4);
        this.horz = n2 == n4;
        this.xo = (n + n3) / 2;
        this.yo = (n2 + n4) / 2 + (int)(0.8 * (double)this.h);
    }

    void paint(Graphics graphics) {
        boolean bl = false;
        graphics.setColor(new Color(192, 255, 255));
        graphics.fillOval((this.x1 + this.x2) / 2 - this.h, (this.y1 + this.y2) / 2 - this.h, 2 * this.h, 2 * this.h);
        graphics.setColor(Color.black);
        graphics.drawOval((this.x1 + this.x2) / 2 - this.h, (this.y1 + this.y2) / 2 - this.h, 2 * this.h, 2 * this.h);
        int n = this.h - 4;
        graphics.drawLine(this.xo, this.yo, this.xo - n, this.yo - n);
        graphics.drawLine(this.xo, this.yo, this.xo + n, this.yo - n);
        n = (int)((double)n * Part.sqrt2 - (double)4);
        graphics.setColor(Color.red);
        double d = this.value < this.min ? -Part.pi / (double)4 : (this.value > this.max ? Part.pi / (double)4 : -Part.pi / (double)4 + Part.pi / 2.0 * (this.value - this.min) / (this.max - this.min));
        graphics.drawLine(this.xo, this.yo, this.xo + (int)((double)n * Math.sin(d)), this.yo - (int)((double)n * Math.cos(d)));
        graphics.drawLine(this.xo - 1, this.yo, this.xo + (int)((double)n * Math.sin(d)) - 1, this.yo - (int)((double)n * Math.cos(d)));
        String string = String.valueOf("").concat(String.valueOf(this.format.form(this.value)));
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n2 = fontMetrics.stringWidth(string) / 2 + 5;
        graphics.setColor(Color.yellow);
        graphics.fillRect(this.xo - n2 + this.textOffset, this.yo + 12, 2 * n2, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.xo - (n2 -= 5) + this.textOffset, this.yo + 25);
        Font font = graphics.getFont();
        graphics.setFont(this.bigFont);
        graphics.drawString("+", (this.x1 + this.x2) / 2 - 15, (this.y1 + this.y2) / 2 - this.h);
        graphics.setFont(font);
    }

    void setValue(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.value = 0.0;
            return;
        }
        Graphics graphics = this.schematic.getGraphics();
        if (graphics == null) {
            return;
        }
        this.setValue(graphics, d);
        graphics.dispose();
    }

    void setValue(Graphics graphics, double d) {
        this.value = d;
        this.paint(graphics);
    }

    double getValue() {
        return this.value;
    }
}

