/*
 * Decompiled with CFR 0.152.
 */
package faraday;

import faraday.Meter;
import faraday.Part;
import faraday.Schematic_mouseAdapter;
import faraday.Schematic_mouseMotionAdapter;
import faraday.Slider;
import faraday.Wire;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import sGraphics.Util;
import sTools.Format;
import sTools.Parser;
import sTools.SApplet;
import sTools.SDataSource;

public class Schematic
extends Panel
implements SDataSource {
    private String[] varStrings = new String[]{"t", "x", "v", "f"};
    private double[][] variables = new double[1][4];
    private Parser posFunc = new Parser(1);
    private Parser fieldFunc = new Parser(2);
    boolean drag = false;
    int iwidth = 0;
    int iheight = 0;
    Format format = new Format("%-+6.2f");
    Image osi = null;
    boolean fillApplet = false;
    int pixPerUnit = 10;
    boolean showSchematic = true;
    boolean showGrid = true;
    boolean showColor = true;
    boolean showCurrentArrow = true;
    boolean showBOnDrag = false;
    private boolean osiInvalid = true;
    private int xOffset = 0;
    private int yOffset = 0;
    private Vector parts = new Vector();
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private int boxWidth = 0;
    private Slider slider = null;
    private Meter meter = null;
    private int xOld = 100;
    private int xinset = 0;
    private int yinset = 0;
    private double flux = 0.0;
    private long tOld = 0L;
    private long time = 0L;
    private int np = 4;
    private int next = 0;
    private double[] readings = new double[this.np];
    private boolean firstDatum = true;
    private double sliderX = 0.0;
    private boolean dragMode = true;
    private int preferredWidth = 200;
    private int mouseX = 0;
    private int mouseY = 0;
    private boolean mouseDown = false;
    private SApplet owner = null;

    public Schematic(SApplet sApplet) {
        this.owner = sApplet;
        this.mouseMotionAdapter = new Schematic_mouseMotionAdapter(this);
        this.addMouseMotionListener(this.mouseMotionAdapter);
        this.mouseAdapter = new Schematic_mouseAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.setBackground(new Color(224, 224, 224));
        try {
            SApplet.addDataSource(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public int getID() {
        return this.hashCode();
    }

    public double[][] getVariables() {
        this.variables[0][0] = (double)this.time / 1000.0;
        this.variables[0][1] = this.sliderX;
        this.variables[0][2] = this.meter.getValue();
        this.variables[0][3] = this.flux;
        return this.variables;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
        this.owner = sApplet;
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getPreferredSize() {
        Applet applet = Util.getApplet(this);
        if (this.fillApplet && applet != null) {
            return new Dimension(applet.getBounds().width - 6, applet.getBounds().height);
        }
        return new Dimension(this.preferredWidth, this.preferredWidth);
    }

    public void paint(Graphics graphics) {
        this.osiInvalid = true;
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.osiInvalid || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.paintOSI();
        }
        if (this.showSchematic) {
            graphics.drawImage(this.osi, 0, 0, this);
            if (this.slider != null) {
                this.slider.paint(graphics);
            }
            this.paintTime(graphics);
            if (this.mouseDown) {
                this.paintCoords(this.mouseX, this.mouseY);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
        }
    }

    public void paintTime() {
        Graphics graphics = this.getGraphics();
        this.paintTime(graphics);
        graphics.dispose();
    }

    public void paintTime(Graphics graphics) {
        String string = String.valueOf("Time:").concat(String.valueOf(this.format.form((double)this.time / 1000.0)));
        graphics.drawImage(this.osi, 10, 5, 75, 25, 10, 5, 75, 25, this);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, 15);
    }

    public void paintGrid(Graphics graphics) {
        if (!this.showGrid) {
            return;
        }
        graphics.setColor(Color.gray);
        for (int i = 0; i < 1 + this.iheight / this.pixPerUnit; ++i) {
            for (int j = 0; j < 1 + this.iwidth / this.pixPerUnit; ++j) {
                double d = this.xFromPix(this.pixPerUnit * j);
                double d2 = this.fieldFunc.evaluate(d, (double)this.time / 1000.0);
                if (d2 >= 0.0) {
                    graphics.drawLine(this.pixPerUnit * j, this.pixPerUnit * i, this.pixPerUnit * j, this.pixPerUnit * i);
                    continue;
                }
                graphics.drawLine(this.pixPerUnit * j - 2, this.pixPerUnit * i, this.pixPerUnit * j + 2, this.pixPerUnit * i);
                graphics.drawLine(this.pixPerUnit * j, this.pixPerUnit * i - 2, this.pixPerUnit * j, this.pixPerUnit * i + 2);
            }
        }
        graphics.setColor(Color.black);
    }

    public void paintCurrentArrow(Graphics graphics) {
        if (!this.showCurrentArrow) {
            return;
        }
        double d = this.meter.getValue();
        if (d == 0.0) {
            return;
        }
        int n = this.yinset + 10;
        int n2 = this.iwidth / 2 - 20;
        int n3 = this.iwidth / 2 + 20;
        graphics.drawLine(n2, n, n3, n);
        graphics.drawLine(n2, n + 1, n3, n + 1);
        if (d < 0.0) {
            graphics.drawLine(n3, n, n3 - 5, n - 5);
            graphics.drawLine(n3, n, n3 - 5, n + 5);
            graphics.drawLine(n3, n + 1, n3 - 5, n - 4);
            graphics.drawLine(n3, n + 1, n3 - 5, n + 6);
        } else {
            graphics.drawLine(n2, n, n2 + 5, n - 5);
            graphics.drawLine(n2, n, n2 + 5, n + 5);
            graphics.drawLine(n2, n + 1, n2 + 5, n - 4);
            graphics.drawLine(n2, n + 1, n2 + 5, n + 6);
        }
        graphics.drawString("Current", this.iwidth / 2 - 10, n + 15);
    }

    public void paintBackground(Graphics graphics) {
        double d;
        double d2;
        if (!this.showColor) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            return;
        }
        double d3 = this.xFromPix(0);
        double d4 = d2 = this.fieldFunc.evaluate(d3, (double)this.time / 1000.0);
        double d5 = d2;
        for (int i = 1; i < this.iwidth; ++i) {
            d3 = this.xFromPix(i);
            d2 = this.fieldFunc.evaluate(d3, (double)this.time / 1000.0);
            if (d2 > d4) {
                d4 = d2;
            }
            if (!(d2 < d5)) continue;
            d5 = d2;
        }
        if (d4 == d5) {
            d4 = Math.max(2.0, d4);
            d5 = Math.min(-2.0, d5);
        }
        if ((d = (d4 = Math.max(0.0, d4)) - (d5 = Math.min(0.0, d5))) == 0.0) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            return;
        }
        for (int i = 0; i < this.iwidth; ++i) {
            d3 = this.xFromPix(i);
            d2 = this.fieldFunc.evaluate(d3, (double)this.time / 1000.0);
            if (d2 > 0.0) {
                d2 = d4 > -d5 ? (double)255 * d2 / d4 : (double)-255 * d2 / d5;
                graphics.setColor(new Color(255, 255 - (int)d2, 255 - (int)d2));
                graphics.drawLine(i, 0, i, this.iheight);
                continue;
            }
            if (d2 < 0.0) {
                d2 = d4 > -d5 ? (double)-255 * d2 / d4 : (double)255 * d2 / d5;
                graphics.setColor(new Color(255 - (int)d2, 255 - (int)d2, 255));
                graphics.drawLine(i, 0, i, this.iheight);
                continue;
            }
            graphics.setColor(Color.white);
            graphics.drawLine(i, 0, i, this.iheight);
        }
        graphics.setColor(Color.black);
    }

    public void paintParts(Graphics graphics) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = (Part)this.parts.elementAt(i);
            part.paint(graphics);
        }
    }

    public void paintOSI() {
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.buildSchematic();
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        Graphics graphics = this.osi.getGraphics();
        this.paintBackground(graphics);
        this.paintGrid(graphics);
        this.paintParts(graphics);
        this.paintCurrentArrow(graphics);
        graphics.dispose();
        this.osiInvalid = false;
    }

    public void buildSchematic() {
        this.parts.removeAllElements();
        if (this.iwidth == 0 || this.iheight == 0) {
            return;
        }
        this.xinset = (int)((double)this.iwidth * 0.2);
        this.yinset = (int)((double)this.iheight * 0.1);
        this.xOffset = this.xinset;
        this.yOffset = this.iheight / 2;
        Wire wire = new Wire(this, this.xinset, this.yinset, this.iwidth - 10, this.yinset);
        this.parts.addElement(wire);
        wire = new Wire(this, this.xinset, this.iheight - this.yinset, this.iwidth - 10, this.iheight - this.yinset);
        this.parts.addElement(wire);
        wire = new Wire(this, this.xinset, this.yinset - 1, this.xinset, this.iheight - this.yinset + 1);
        this.parts.addElement(wire);
        this.meter = new Meter(this, this.xinset, this.yinset, this.xinset, this.iheight - this.yinset);
        this.parts.addElement(this.meter);
        if (this.xOld > this.iwidth - 10) {
            this.xOld = this.iwidth - 10;
        }
        if (this.xOld < 10) {
            this.xOld = 10;
        }
        this.slider = new Slider(this, this.xOld, this.yinset - 10, this.xOld, this.iheight - this.yinset + 10);
    }

    void setDragMode(boolean bl) {
        this.dragMode = bl;
    }

    void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    void setMeterMinMax(double d, double d2) {
        this.meter.min = d;
        this.meter.max = d2;
    }

    void setSlider(double d) {
        this.sliderX = d;
        Graphics graphics = this.getGraphics();
        int n = this.xOffset + (int)(d * (double)this.pixPerUnit);
        if (this.osi == null || this.slider == null) {
            return;
        }
        graphics.drawImage(this.osi, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this);
        if (n < this.xinset + 5) {
            n = this.xinset + 5;
        }
        if (n > this.iwidth - 10) {
            n = this.iwidth - 10;
        }
        this.slider.setX(n);
        this.slider.paint(graphics);
        graphics.dispose();
        this.xOld = n;
        Rectangle rectangle = this.getBounds();
        this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
    }

    void reset() {
        double d = this.posFunc.evaluate(0.0);
        if (!this.dragMode) {
            this.setSlider(d);
        }
        this.flux = this.calcFlux();
        this.time = 0L;
        this.next = 0;
        this.tOld = 0L;
        this.firstDatum = true;
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
    }

    double setTime(long l) {
        int n;
        double d;
        if (this.meter == null) {
            return 0.0;
        }
        this.time = l;
        if (!this.dragMode) {
            this.setSlider(this.posFunc.evaluate((double)this.time / 1000.0));
        }
        if (this.firstDatum) {
            d = this.calcVolt();
            for (n = 0; n < this.np; ++n) {
                this.readings[n] = d;
            }
            this.firstDatum = false;
        } else {
            this.readings[this.next] = this.calcVolt();
        }
        ++this.next;
        if (this.next == this.np) {
            this.next = 0;
        }
        d = 0.0;
        for (n = 0; n < this.np; ++n) {
            d += this.readings[n];
        }
        this.meter.setValue(d / (double)this.np);
        this.paintTime();
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
        if (this.showColor || this.showGrid || this.showCurrentArrow) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.dispose();
        }
        return d / (double)this.np;
    }

    double calcFlux() {
        int n = 200;
        double d = 0.8 * (double)this.iheight / (double)this.pixPerUnit;
        if (this.slider == null) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.sliderX / (double)(n - 1);
        double d5 = (double)this.time / 1000.0;
        for (int i = 0; i < n; ++i) {
            d2 += this.fieldFunc.evaluate(d3, d5);
            d3 += d4;
        }
        return d2 * d4 * d;
    }

    double calcVolt() {
        if (this.time == this.tOld) {
            return 0.0;
        }
        double d = this.flux;
        this.flux = this.calcFlux();
        double d2 = -1000.0 * (this.flux - d) / (double)(this.time - this.tOld);
        this.tOld = this.time;
        return d2;
    }

    boolean parseFieldFunction(String string) {
        this.fieldFunc.defineVariable(1, "x");
        this.fieldFunc.defineVariable(2, "t");
        this.fieldFunc.define(string.toLowerCase());
        this.fieldFunc.parse();
        if (this.fieldFunc.getErrorCode() != 0) {
            System.out.println(String.valueOf("Failed to parse B(xmt): ").concat(String.valueOf(string)));
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error: ").concat(String.valueOf(this.fieldFunc.getErrorString()))).concat(String.valueOf(" at B(x,t) function, position "))).concat(String.valueOf(this.fieldFunc.getErrorPosition())));
            return false;
        }
        return true;
    }

    boolean parsePosFunction(String string) {
        this.posFunc.defineVariable(1, "t");
        this.posFunc.define(string.toLowerCase());
        this.posFunc.parse();
        if (this.posFunc.getErrorCode() != 0) {
            System.out.println(String.valueOf("Failed to parse x(t): ").concat(String.valueOf(string)));
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error: ").concat(String.valueOf(this.posFunc.getErrorString()))).concat(String.valueOf(" at phase function, position "))).concat(String.valueOf(this.posFunc.getErrorPosition())));
            return false;
        }
        return true;
    }

    void paintCoords(int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.paintCoords(graphics, n, n2);
        graphics.dispose();
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        double d = (double)(n - this.xOffset) / (double)this.pixPerUnit;
        double d2 = (double)(-(n2 - this.yOffset)) / (double)this.pixPerUnit;
        if (this.drag && this.slider != null) {
            graphics.drawImage(this.osi, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this);
            if (n < this.xinset + 5) {
                n = this.xinset + 5;
            }
            if (n > this.iwidth - 10) {
                n = this.iwidth - 10;
            }
            this.slider.setX(n);
            this.slider.paint(graphics);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)(this.slider.getLeft() - this.xOffset) / (double)this.pixPerUnit) {
                d = (double)(this.slider.getLeft() - this.xOffset) / (double)this.pixPerUnit;
            }
        }
        String string = this.mouseDown && this.drag ? String.valueOf("Wire Postion=").concat(String.valueOf(this.format.form(d))) : String.valueOf(String.valueOf(String.valueOf("x=").concat(String.valueOf(this.format.form(d)))).concat(String.valueOf("  y="))).concat(String.valueOf(this.format.form(d2)));
        if (this.showBOnDrag) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf("  B=").concat(String.valueOf(this.format.form(this.fieldFunc.evaluate(d, this.time / (long)1000))))));
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
    }

    double xFromPix(int n) {
        return (double)(n - this.xOffset) / (double)this.pixPerUnit;
    }

    double yFromPix(int n) {
        return (double)(-(n - this.yOffset)) / (double)this.pixPerUnit;
    }

    void schematic_mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.slider != null && this.slider.isInside(this.mouseX, this.mouseY) && this.dragMode) {
            this.drag = true;
            this.xOld = this.slider.getX();
        }
        this.paintCoords(this.mouseX, this.mouseY);
    }

    void schematic_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.dragMode && this.drag) {
            this.setSlider((double)(this.mouseX - this.xOffset) / (double)this.pixPerUnit);
        }
        this.paintCoords(this.mouseX, this.mouseY);
        this.xOld = this.mouseY;
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
    }

    void schematic_mouseReleased(MouseEvent mouseEvent) {
        Object object;
        this.mouseDown = false;
        if (this.drag) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.drag = false;
            object = this.getGraphics();
            ((Graphics)object).drawImage(this.osi, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this.slider.getLeft(), 0, this.slider.getRight(), this.iheight, this);
            if (this.mouseX < this.xinset + 5) {
                this.mouseX = this.xinset + 5;
            }
            if (this.mouseX > this.iwidth - 10) {
                this.mouseX = this.iwidth - 10;
            }
            this.slider.setX(this.mouseX);
            this.slider.paint((Graphics)object);
            ((Graphics)object).dispose();
            this.xOld = this.mouseX;
        }
        object = this.getBounds();
        this.repaint(0, ((Rectangle)object).height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
    }

    public void schematic_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void schematic_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void schematic_mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.slider != null && this.slider.isInside(n, n2)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }
}

