/*
 * Decompiled with CFR 0.152.
 */
package sTools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import sTools.Format;
import sTools.Parser;
import sTools.SApplet;
import sTools.SDataListener;
import sTools.SDataSource;
import sTools.SGraphFrame;
import sTools.SGraph_mouseAdapter;
import sTools.SGraph_mouseMotionAdapter;
import sTools.graph.Axis;
import sTools.graph.DataSet;
import sTools.graph.Graph2D;
import sTools.graph.Markers;
import sTools.graph.TextLine;

public class SGraph
extends Graph2D
implements Cloneable,
SDataListener {
    Axis xaxis;
    Axis yaxis;
    int[] borders = new int[]{0, 10, 10, 0};
    Format format = new Format("%-+6.2g");
    private boolean autoRefresh = true;
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private int boxWidth = 0;
    private boolean sampleData = true;
    private Vector dataSetSeries = new Vector();
    private Vector functions = new Vector();
    private double[] dPoint = new double[2];
    private DataSet defaultData = null;
    private String labelX = "X Axis";
    private String labelY = "Y Axis";
    private double defaultMarkerScale = 1.0;
    private boolean enableMouse = false;
    private SApplet parentSApplet;
    private String titleStr = null;
    private TextLine title = new TextLine();

    public SGraph() {
        this.title.setFontStyle(1);
        this.title.setFontSize(16);
        this.setDataBackground(Color.white);
        this.setGraphBackground(Color.white);
        this.buildMarkers(4);
        this.drawzero = false;
        this.drawgrid = false;
        this.borderLeft = this.borders[0];
        this.borderTop = this.borders[1];
        this.borderRight = this.borders[2];
        this.borderBottom = this.borders[3];
        this.xaxis = this.createAxis(5);
        this.xaxis.setTitleColor(Color.black);
        this.xaxis.setLabelColor(Color.black);
        this.xaxis.setTitleText(this.labelX);
        this.xaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.xaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.yaxis = this.createAxis(2);
        this.yaxis.setTitleColor(Color.black);
        this.yaxis.setLabelColor(Color.black);
        this.yaxis.setTitleText(this.labelY);
        this.yaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.yaxis.setLabelFont(new Font("Helvetica", 0, 10));
        if (this.sampleData) {
            this.makeSampleData(100);
        }
        try {
            SApplet.addDataListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SGraph(SApplet sApplet) {
        this();
        this.parentSApplet = sApplet;
    }

    public void setSampleData(boolean bl) {
        if (bl == this.sampleData) {
            return;
        }
        this.sampleData = bl;
        if (bl) {
            this.makeSampleData(100);
        } else {
            this.deleteAllSeries();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isSampleData() {
        return this.sampleData;
    }

    public void setDrawGrid(boolean bl) {
        if (bl == this.drawgrid) {
            return;
        }
        this.drawgrid = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isDrawGrid() {
        return this.drawgrid;
    }

    public void setAutoRefresh(boolean bl) {
        if (bl == this.autoRefresh) {
            return;
        }
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setAutoscaleX(boolean bl) {
        if (!bl == this.xaxis.isManualRange()) {
            return;
        }
        this.xaxis.setManualRange(!bl);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isAutoscaleX() {
        return !this.xaxis.isManualRange();
    }

    public void setAutoscaleY(boolean bl) {
        if (!bl == this.yaxis.isManualRange()) {
            return;
        }
        this.yaxis.setManualRange(!bl);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isAutoscaleY() {
        return !this.yaxis.isManualRange();
    }

    public void setDrawZero(boolean bl) {
        if (bl == this.drawzero) {
            return;
        }
        this.drawzero = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isDrawZero() {
        return this.drawzero;
    }

    public synchronized void setSeriesLegend(int n, Color color, int n2, int n3, String string) {
        DataSet dataSet;
        Series series = null;
        boolean bl = false;
        int n4 = this.dataSetSeries.size();
        for (int i = 0; i < n4; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.dPoint[0] = 0.0;
            this.dPoint[1] = 0.0;
            dataSet = this.attachArray(n, this.dPoint).getDataSet();
            dataSet.deleteData();
        } else {
            dataSet = series.data;
        }
        dataSet.legend(n2, n3, string);
        if (color != null) {
            dataSet.legendColor(color);
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setSeriesLegend(int n, int n2, int n3, String string) {
        Color color = Color.black;
        Series series = this.createSeries(n);
        color = ((Series)series).data.markercolor;
        this.setSeriesLegend(n, color, n2, n3, string);
    }

    public synchronized void setSeriesLegendColor(int n, Color color) {
        Series series = this.createSeries(n);
        series.data.legendColor(color);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setSeriesStyle(int n, Color color, boolean bl, int n2) {
        DataSet dataSet;
        Series series = null;
        boolean bl2 = false;
        int n3 = this.dataSetSeries.size();
        for (int i = 0; i < n3; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.dPoint[0] = 0.0;
            this.dPoint[1] = 0.0;
            dataSet = this.attachArray(n, this.dPoint).getDataSet();
            dataSet.deleteData();
        } else {
            dataSet = series.data;
        }
        dataSet.linestyle = bl ? 1 : 0;
        dataSet.marker = n2;
        dataSet.markercolor = color;
        dataSet.linecolor = color;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setSeriesStyle(int n, boolean bl, int n2) {
        Color color = Color.black;
        Series series = this.createSeries(n);
        color = ((Series)series).data.markercolor;
        this.setSeriesStyle(n, color, bl, n2);
    }

    public synchronized void setSeriesColor(int n, Color color) {
        Series series = this.createSeries(n);
        ((Series)series).data.markercolor = color;
        ((Series)series).data.linecolor = color;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public String getBorders() {
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.borders[0]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[1]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[2]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[3]));
        return string;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setBorders(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    this.borders[i] = Integer.parseInt(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.borderLeft = this.borders[0];
            this.borderTop = this.borders[1];
            this.borderRight = this.borders[2];
            this.borderBottom = this.borders[3];
            if (this.autoRefresh) {
                this.repaint();
            }
        } else {
            this.borders[0] = this.borderLeft;
            this.borders[1] = this.borderTop;
            this.borders[2] = this.borderRight;
            this.borders[3] = this.borderBottom;
        }
    }

    public void setLabelX(String string) {
        this.xaxis.setTitleColor(Color.black);
        this.xaxis.setTitleText(string);
        this.labelX = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelX(String string, Color color) {
        this.xaxis.setTitleColor(color);
        this.xaxis.setTitleText(string);
        this.labelX = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public String getLabelX() {
        return this.labelX;
    }

    public void setLabelY(String string) {
        this.yaxis.setTitleColor(Color.black);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setLastPointMarker(int n, boolean bl) {
        Series series = this.createSeries(n);
        series.enableLPCursor = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelY(String string, Color color) {
        this.yaxis.setTitleColor(color);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public String getLabelY() {
        return this.labelY;
    }

    public void setMarkerSize(double d) {
        this.defaultMarkerScale = d;
    }

    public void setMarkerSize(int n, double d) {
        Series series = this.createSeries(n);
        ((Series)series).data.markerscale = d;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinMaxX(double d, double d2) {
        if (this.xaxis.isManualRange()) {
            this.xaxis.setManualRange(true, d, d2);
        } else {
            this.xaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMinX() {
        return this.xaxis.minimum;
    }

    public double getMaxX() {
        return this.xaxis.maximum;
    }

    public void setMinMaxY(double d, double d2) {
        if (this.yaxis.isManualRange()) {
            this.yaxis.setManualRange(true, d, d2);
        } else {
            this.yaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMinY() {
        return this.yaxis.minimum;
    }

    public double getMaxY() {
        return this.yaxis.maximum;
    }

    private DataSet getDataSetFromSID(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            return series.data;
        }
        return null;
    }

    private Series getSeriesFromSID(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            return series;
        }
        return null;
    }

    public String getTitle() {
        return this.titleStr;
    }

    public void setTitle(String string) {
        this.titleStr = string;
        this.title.setText(string);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public int getIDFromSID(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            return series.hashCode();
        }
        return 0;
    }

    public void setOwner(SApplet sApplet) {
        this.parentSApplet = sApplet;
    }

    public SApplet getOwner() {
        return this.parentSApplet;
    }

    public void deleteAllFunctions() {
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            SApplet.dataSources.remove(Integer.toString(mathFunction.hashCode()));
        }
        this.functions.removeAllElements();
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void deleteFunction(int n) {
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            if (mathFunction.hashCode() != n) continue;
            SApplet.dataSources.remove(Integer.toString(mathFunction.hashCode()));
            this.functions.removeElement(mathFunction);
            break;
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void deleteAllSeries() {
        Enumeration enumeration = this.dataSetSeries.elements();
        while (enumeration.hasMoreElements()) {
            Series series = (Series)enumeration.nextElement();
            SApplet.dataSources.remove(Integer.toString(series.hashCode()));
        }
        this.dataSetSeries.removeAllElements();
        this.detachDataSets();
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        this.defaultData = null;
        this.makeDefaultData();
        if (!this.xaxis.isManualRange()) {
            this.setMinMaxX(0.0, 1.0);
        }
        if (!this.yaxis.isManualRange()) {
            this.setMinMaxY(0.0, 1.0);
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void deleteSeries(int n) {
        this.deleteSeries(n, true);
    }

    public void deleteSeries(int n, boolean bl) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            SApplet.dataSources.remove(Integer.toString(series.hashCode()));
            this.dataSetSeries.removeElement(series);
            this.detachDataSet(series.data);
            break;
        }
        if (this.dataSetSeries.size() == 0) {
            this.detachDataSets();
            this.defaultData = null;
            this.makeDefaultData();
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        if (bl && this.autoRefresh) {
            this.repaint();
        }
    }

    public void setFunctionRange(int n, double d, double d2, int n2) {
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            if (mathFunction.hashCode() != n) continue;
            mathFunction.setFunctionRange(d, d2, n2);
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public Object clone() {
        int n;
        SGraph sGraph = new SGraph(this.parentSApplet);
        sGraph.autoRefresh = this.autoRefresh;
        sGraph.setSampleData(false);
        sGraph.setAutoscaleX(this.isAutoscaleX());
        sGraph.setAutoscaleY(this.isAutoscaleY());
        sGraph.setLabelX(this.labelX);
        sGraph.setLabelY(this.labelY);
        sGraph.setMinMaxX(this.getMinX(), this.getMaxX());
        sGraph.setMinMaxY(this.getMinY(), this.getMaxY());
        sGraph.defaultMarkerScale = this.defaultMarkerScale;
        sGraph.drawgrid = this.isDrawGrid();
        sGraph.drawzero = this.isDrawZero();
        sGraph.enableMouse = this.enableMouse;
        sGraph.deleteAllSeries();
        for (int i = 0; i < this.dataSetSeries.size(); ++i) {
            sGraph.addDataSeries((Series)this.dataSetSeries.elementAt(i));
        }
        sGraph.deleteAllFunctions();
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            n = sGraph.addFunction(mathFunction.getFunctionStr());
            sGraph.setFunctionRange(n, mathFunction.xmin, mathFunction.xmax, mathFunction.numPts);
        }
        n = sGraph.xaxis.manualRange;
        sGraph.xaxis.manualRange = true;
        boolean bl = sGraph.yaxis.manualRange;
        sGraph.yaxis.manualRange = true;
        sGraph.setMinMaxX(this.xaxis.minimum, this.xaxis.maximum);
        sGraph.setMinMaxY(this.yaxis.minimum, this.yaxis.maximum);
        sGraph.xaxis.manualRange = n;
        sGraph.yaxis.manualRange = bl;
        return sGraph;
    }

    public synchronized Series createSeries(int n) {
        Series series = null;
        boolean bl = false;
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            bl = true;
            break;
        }
        if (!bl) {
            series = this.makeEmptySeries(n);
        }
        return series;
    }

    public void clearAllData() {
        int n = this.dataSetSeries.size();
        for (int i = 0; i < n; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            series.data.deleteData();
        }
        this.makeDefaultData();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void clearSeries(int n) {
        this.clearSeriesData(n);
    }

    public void clearSeriesData(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            series.data.deleteData();
            series.setOwner(this.parentSApplet);
            break;
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void adjustScale() {
        if (this.yaxis.isManualRange()) {
            return;
        }
        double d = this.yaxis.minimum;
        double d2 = this.yaxis.maximum;
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            d = Math.min(mathFunction.ymin, d);
            d2 = Math.max(mathFunction.ymax, d2);
        }
        this.yaxis.minimum = d;
        this.yaxis.maximum = d2;
        this.yaxis.calculateGridLabels();
    }

    public void paintFunctions(Graphics graphics, Rectangle rectangle) {
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)enumeration.nextElement();
            mathFunction.paint(graphics, rectangle);
        }
    }

    public void paintOffScreen(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n < 10 || n2 < 10) {
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Image image = this.createImage(n, n2);
        Graphics graphics2 = image.getGraphics();
        this.paint(graphics2);
        graphics.drawImage(image, 0, 0, n, n2, this);
        graphics2.dispose();
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        Enumeration enumeration = this.dataSetSeries.elements();
        while (enumeration.hasMoreElements()) {
            Series series = (Series)enumeration.nextElement();
            series.paintLastPoint(graphics, rectangle);
        }
        if (this.titleStr != null) {
            this.title.draw(graphics, rectangle.x + rectangle.width / 2, rectangle.y + Math.max(10 + rectangle.height / 20, 16), 0);
        }
    }

    public int pixFromX(double d) {
        return this.xaxis.getInteger(d);
    }

    public int pixFromY(double d) {
        return this.yaxis.getInteger(d);
    }

    public double xFromPix(int n) {
        return this.xaxis.getDouble(n);
    }

    public double yFromPix(int n) {
        return this.yaxis.getDouble(n);
    }

    public synchronized DataSet addDataSet(double[] dArray, int n) {
        DataSet dataSet = this.loadDataSet(dArray, n);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        return dataSet;
    }

    private synchronized DataSet addDataSeries(Series series) {
        DataSet dataSet = null;
        this.addData(series.sid, series.getX(), series.getY(), series.getNumpts());
        dataSet = this.getDataSetFromSID(series.sid);
        if (dataSet == null) {
            System.out.println("Erroe: DataSet not created in SGraph.addDataSetSeries.");
            return null;
        }
        dataSet.markercolor = series.getDataSet().markercolor;
        dataSet.linestyle = series.getDataSet().linestyle;
        dataSet.linecolor = series.getDataSet().linecolor;
        dataSet.markercolor = series.getDataSet().markercolor;
        dataSet.markerscale = series.getDataSet().markerscale;
        dataSet.marker = series.getDataSet().marker;
        dataSet.legend(series.getDataSet().getLegend_ix(), series.getDataSet().getLegend_iy(), series.getDataSet().getLegend());
        return dataSet;
    }

    public synchronized void addDatum(int n, double d, double d2) {
        boolean bl = false;
        Series series = null;
        boolean bl2 = false;
        double d3 = this.xaxis.minimum;
        double d4 = this.xaxis.maximum;
        double d5 = this.yaxis.minimum;
        double d6 = this.yaxis.maximum;
        if (d < d3 || d > d4 || d2 < d5 || d2 > d6) {
            bl = true;
        }
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            bl2 = true;
            break;
        }
        this.dPoint[0] = d;
        this.dPoint[1] = d2;
        if (!bl2) {
            series = this.attachArray(n, this.dPoint);
            bl = true;
        } else {
            try {
                if (series.data.dataPoints() == 0) {
                    this.removeDefaultData();
                    bl = true;
                }
                series.data.append(this.dPoint, 1);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        if (d3 != this.xaxis.minimum || d4 != this.xaxis.maximum || d5 != this.yaxis.minimum || d6 != this.yaxis.maximum) {
            bl = true;
        }
        if (!this.autoRefresh) {
            return;
        }
        if (this.datarect == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (series.enableLPCursor) {
            this.paintOffScreen(graphics);
        } else if (this.xaxis.isManualRange() && this.yaxis.isManualRange()) {
            series.data.draw_data(graphics, this.datarect);
            series.paintLastPoint(graphics, this.datarect);
        } else if (bl) {
            this.paintOffScreen(graphics);
        } else {
            series.data.draw_data(graphics, this.datarect);
            series.paintLastPoint(graphics, this.datarect);
        }
        graphics.dispose();
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2) {
        this.addData(n, dArray, dArray2, dArray.length);
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2, int n2) {
        int n3;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || n2 == 0) {
            if (this.getSeriesFromSID(n) == null) {
                this.makeEmptySeries(n);
            }
            return;
        }
        int n4 = dArray.length;
        if (n4 > n2) {
            n4 = n2;
        }
        Series series = null;
        boolean bl = false;
        int n5 = this.dataSetSeries.size();
        for (n3 = 0; n3 < n5; ++n3) {
            series = (Series)this.dataSetSeries.elementAt(n3);
            if (n != series.sid) continue;
            bl = true;
            break;
        }
        double[] dArray3 = new double[2 * n4];
        int n6 = 0;
        n3 = 0;
        while (n3 < n4) {
            dArray3[n6] = dArray[n3];
            dArray3[n6 + 1] = dArray2[n3];
            ++n3;
            n6 += 2;
        }
        if (!bl) {
            series = this.attachArray(n, dArray3);
        } else {
            try {
                series.data.append(dArray3, n4);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized int addFunction(String string) {
        MathFunction mathFunction = new MathFunction(string);
        this.functions.addElement(mathFunction);
        if (this.datarect != null) {
            Rectangle rectangle = this.datarect;
            mathFunction.xmin = this.xFromPix(rectangle.x);
            mathFunction.xmax = this.xFromPix(rectangle.x + rectangle.width - 1);
            mathFunction.numPts = rectangle.width;
            mathFunction.setScale();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
        return mathFunction.hashCode();
    }

    public void drawCoords(int n, int n2) {
        String string = String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.format.form(this.xFromPix(n))))).concat(String.valueOf(" , "))).concat(String.valueOf(this.format.form(this.yFromPix(n2))));
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.dispose();
    }

    public boolean isEnableMouse() {
        return this.enableMouse;
    }

    public void setEnableMouse(boolean bl) {
        if (this.enableMouse == bl) {
            return;
        }
        this.enableMouse = bl;
        if (this.enableMouse) {
            this.mouseMotionAdapter = new SGraph_mouseMotionAdapter(this);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.mouseAdapter = new SGraph_mouseAdapter(this);
            this.addMouseListener(this.mouseAdapter);
        } else {
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeMouseListener(this.mouseAdapter);
        }
    }

    public void setParentSApplet(SApplet sApplet) {
        this.parentSApplet = sApplet;
    }

    public void setFormat(String string) {
        this.format = new Format(string);
    }

    void sGraph_mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            SGraphFrame sGraphFrame = new SGraphFrame((SGraph)this.clone());
            ((Component)sGraphFrame).setSize(this.getSize().width, this.getSize().height);
            sGraphFrame.show();
        } else {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.drawCoords(n, n2);
        }
    }

    void sGraph_mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.drawCoords(n, n2);
    }

    void sGraph_mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getBounds();
        this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        this.boxWidth = 0;
    }

    public void sGraph_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void sGraph_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void sGraph_mouseMoved(MouseEvent mouseEvent) {
    }

    private Series attachArray(int n, double[] dArray) {
        if (dArray.length < 2) {
            return null;
        }
        int n2 = dArray.length / 2;
        DataSet dataSet = this.loadDataSet(dArray, n2);
        dataSet.linestyle = 1;
        dataSet.marker = 3;
        dataSet.markerscale = this.defaultMarkerScale;
        dataSet.markercolor = new Color(0, 0, 255);
        dataSet.linecolor = new Color(0, 0, 255);
        dataSet.legendColor(Color.black);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        Series series = new Series(n, dataSet);
        this.dataSetSeries.addElement(series);
        this.removeDefaultData();
        return series;
    }

    private void makeDefaultData() {
        if (this.defaultData != null) {
            return;
        }
        double[] dArray = new double[]{0.0, 0.0};
        this.defaultData = this.loadDataSet(dArray, 1);
        this.xaxis.attachDataSet(this.defaultData);
        this.yaxis.attachDataSet(this.defaultData);
    }

    private void removeDefaultData() {
        if (this.defaultData == null) {
            return;
        }
        this.detachDataSet(this.defaultData);
        this.defaultData = null;
    }

    private Series makeEmptySeries(int n) {
        this.dPoint[0] = 0.0;
        this.dPoint[1] = 0.0;
        Series series = this.attachArray(n, this.dPoint);
        DataSet dataSet = series.getDataSet();
        dataSet.deleteData();
        return series;
    }

    private void makeSampleData(int n) {
        double[] dArray = new double[2 * n];
        int n2 = 0;
        int n3 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < n) {
            dArray[n3] = n3 - n;
            dArray[n3 + 1] = (double)60000 * Math.pow(dArray[n3] / (double)(n - 2), 2.0);
            ++n2;
            n3 += 2;
        }
        Series series = this.attachArray(1, dArray);
        DataSet dataSet = series.getDataSet();
        dataSet.legend(200, 100, "sample data");
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    private void buildMarkers(int n) {
        Markers markers = new Markers();
        this.setMarkers(markers);
        boolean[] blArray = new boolean[5];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = false;
        blArray[3] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray2[0] = n;
        nArray2[1] = -n;
        nArray2[2] = n;
        nArray2[3] = -n;
        markers.AddMarker(1, 4, blArray, nArray, nArray2);
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray[4] = n;
        nArray2[0] = n;
        nArray2[1] = n;
        nArray2[2] = -n;
        nArray2[3] = -n;
        nArray2[4] = n;
        markers.AddMarker(2, 5, blArray, nArray, nArray2);
        markers.AddMarker(3, n, Markers.TYPE_CIRCLE);
        markers.AddMarker(4, n, Markers.TYPE_SQUARE);
    }

    class MathFunction
    implements Cloneable,
    SDataSource {
        Parser parser = null;
        Color color = Color.black;
        int numPts = 100;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        boolean fixedRange = false;
        String[] varStrings = new String[]{"x", "y", "v", "a"};
        SApplet owner = null;

        MathFunction(String string) {
            string = string.trim();
            this.parser = new Parser(1);
            this.parser.defineVariable(1, "x");
            this.parser.define(string);
            this.parser.parse();
            if (this.parser.getErrorCode() != 0) {
                System.out.println(String.valueOf("Failed to parse f(x)): ").concat(String.valueOf(this.parser)));
                System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error in MathFunction: ").concat(String.valueOf(this.parser.getErrorString()))).concat(String.valueOf(" at function 1, position "))).concat(String.valueOf(this.parser.getErrorPosition())));
            } else {
                this.setScale();
            }
            this.owner = SGraph.this.parentSApplet;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public final int getID() {
            return this.hashCode();
        }

        Parser getParser() {
            return this.parser;
        }

        String getFunctionStr() {
            return this.parser.getFunctionString();
        }

        void setFunctionRange(double d, double d2, int n) {
            if (n < 1) {
                this.fixedRange = false;
                return;
            }
            this.xmin = d;
            this.xmax = d2;
            this.numPts = n;
            this.fixedRange = true;
        }

        void paint(Graphics graphics, Rectangle rectangle) {
            if (this.fixedRange) {
                this.paint2(graphics, rectangle);
            } else {
                this.paint1(graphics, rectangle);
            }
        }

        void paint1(Graphics graphics, Rectangle rectangle) {
            this.numPts = rectangle.width;
            if (this.numPts < 1) {
                return;
            }
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            this.xmin = SGraph.this.xFromPix(rectangle.x);
            this.xmax = SGraph.this.xFromPix(rectangle.x + rectangle.width - 1);
            d = this.xmin;
            this.ymax = this.ymin = this.parser.evaluate(d);
            n = SGraph.this.pixFromY(this.ymin);
            graphics.setColor(this.color);
            for (int i = 1; i < rectangle.width; ++i) {
                d2 = SGraph.this.xFromPix(rectangle.x + i);
                d3 = this.parser.evaluate(d2);
                if (d3 < this.ymin) {
                    this.ymin = d3;
                }
                if (d3 > this.ymax) {
                    this.ymax = d3;
                }
                n2 = SGraph.this.pixFromY(d3);
                graphics.drawLine(rectangle.x + i - 1, n, rectangle.x + i, n2);
                n = n2;
            }
        }

        void paint2(Graphics graphics, Rectangle rectangle) {
            if (this.numPts < 1) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (this.xmax - this.xmin) / (double)(this.numPts - 1);
            d = this.xmin;
            n = SGraph.this.pixFromX(d);
            this.ymax = this.ymin = this.parser.evaluate(d);
            n3 = SGraph.this.pixFromY(this.ymin);
            graphics.setColor(this.color);
            for (int i = 1; i < this.numPts; ++i) {
                n2 = SGraph.this.pixFromX(d += d3);
                d2 = this.parser.evaluate(d);
                if (d2 < this.ymin) {
                    this.ymin = d2;
                }
                if (d2 > this.ymax) {
                    this.ymax = d2;
                }
                n4 = SGraph.this.pixFromY(d2);
                graphics.drawLine(n, n3, n2, n4);
                n = n2;
                n3 = n4;
            }
        }

        public double[][] getVariables() {
            double d = SGraph.this.xaxis.minimum;
            double d2 = SGraph.this.xaxis.maximum;
            double d3 = (d2 - d) / (double)(this.numPts - 1);
            double[][] dArray = new double[this.numPts][4];
            for (int i = 0; i < this.numPts; ++i) {
                dArray[i][0] = d;
                dArray[i][1] = this.parser.evaluate(d);
                d += d3;
            }
            if (this.numPts < 4) {
                return dArray;
            }
            for (int i = 2; i < this.numPts - 2; ++i) {
                dArray[i][2] = (-dArray[i + 2][1] + (double)8 * dArray[i + 1][1] - (double)8 * dArray[i - 1][1] + dArray[i - 2][1]) / d3 / (double)12;
                dArray[i][3] = (-dArray[i + 2][1] + (double)16 * dArray[i + 1][1] - (double)30 * dArray[i][1] + (double)16 * dArray[i - 1][1] - dArray[i - 2][1]) / d3 / d3 / (double)12;
            }
            d = SGraph.this.xaxis.minimum;
            dArray[1][2] = (-dArray[3][1] + (double)8 * dArray[2][1] - (double)8 * dArray[0][1] + this.parser.evaluate(d - d3)) / d3 / (double)12;
            dArray[0][2] = (-dArray[2][1] + (double)8 * dArray[1][1] - (double)8 * this.parser.evaluate(d - d3) + this.parser.evaluate(d - (double)2 * d3)) / d3 / (double)12;
            dArray[this.numPts - 1][2] = (-this.parser.evaluate(d2 + (double)2 * d3) + (double)8 * this.parser.evaluate(d2 + d3) - (double)8 * dArray[this.numPts - 2][1] + dArray[this.numPts - 3][1]) / d3 / (double)12;
            dArray[this.numPts - 2][2] = (-this.parser.evaluate(d2 + d3) + (double)8 * dArray[this.numPts - 1][1] - (double)8 * dArray[this.numPts - 3][1] + dArray[this.numPts - 4][1]) / d3 / (double)12;
            dArray[1][3] = (-dArray[3][1] + (double)16 * dArray[2][1] - (double)30 * dArray[1][1] + (double)16 * dArray[0][1] - this.parser.evaluate(d - d3)) / d3 / d3 / (double)12;
            dArray[0][3] = (-dArray[2][1] + (double)16 * dArray[1][1] - (double)30 * dArray[0][1] + (double)16 * this.parser.evaluate(d - d3) - this.parser.evaluate(d - (double)2 * d3)) / d3 / d3 / (double)12;
            dArray[this.numPts - 1][3] = (-this.parser.evaluate(d2 + (double)2 * d3) + (double)16 * this.parser.evaluate(d2 + d3) - (double)30 * dArray[this.numPts - 1][1] + (double)16 * dArray[this.numPts - 2][1] - dArray[this.numPts - 3][1]) / d3 / d3 / (double)12;
            dArray[this.numPts - 2][3] = (-this.parser.evaluate(d2 + d3) + (double)16 * dArray[this.numPts - 1][1] - (double)30 * dArray[this.numPts - 2][1] + (double)16 * dArray[this.numPts - 3][1] - dArray[this.numPts - 4][1]) / d3 / d3 / (double)12;
            return dArray;
        }

        void setScale() {
            if (this.numPts < 2) {
                return;
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (this.xmax - this.xmin) / (double)(this.numPts - 1);
            d = this.xmin;
            this.ymax = this.ymin = this.parser.evaluate(d);
            for (int i = 1; i < this.numPts; ++i) {
                d2 = this.parser.evaluate(d += d3);
                this.ymin = Math.min(this.ymin, d2);
                this.ymax = Math.max(this.ymax, d2);
            }
        }
    }

    class Series
    implements SDataSource {
        private DataSet data;
        private int sid;
        boolean enableLPCursor = false;
        String[] varStrings = new String[]{"x", "y", "u", "v"};
        SApplet owner = null;

        public Series(int n, DataSet dataSet) {
            this.sid = n;
            this.data = dataSet;
            this.owner = SGraph.this.parentSApplet;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        DataSet getDataSet() {
            return this.data;
        }

        public final int getID() {
            return this.hashCode();
        }

        void paintLastPoint(Graphics graphics, Rectangle rectangle) {
            int n = this.data.dataPoints();
            if (n < 1 || !this.enableLPCursor) {
                return;
            }
            double[] dArray = this.data.getPoint(n - 1);
            int n2 = SGraph.this.pixFromX(dArray[0]);
            int n3 = SGraph.this.pixFromY(dArray[1]);
            graphics.setColor(Color.red);
            graphics.fillOval(n2 - 2 - 1, n3 - 2 - 1, 5, 5);
            graphics.setColor(Color.black);
            graphics.drawOval(n2 - 2 - 1, n3 - 2 - 1, 5, 5);
        }

        double[] getX() {
            int n = this.data.dataPoints();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.data.getData()[2 * i];
            }
            return dArray;
        }

        double[] getY() {
            int n = this.data.dataPoints();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.data.getData()[2 * i + 1];
            }
            return dArray;
        }

        int getNumpts() {
            return this.data.dataPoints();
        }

        public double[][] getVariables() {
            int n = this.data.dataPoints();
            double[][] dArray = new double[n][4];
            if (n < 1) {
                return dArray;
            }
            double[] dArray2 = this.data.getPoint(0);
            dArray[0][0] = dArray2[0];
            dArray[0][1] = dArray2[1];
            for (int i = 1; i < n; ++i) {
                dArray2 = this.data.getPoint(i);
                dArray[i][0] = dArray2[0];
                dArray[i][1] = dArray2[1];
                dArray[i][2] = dArray[i][0] - dArray[i - 1][0];
                dArray[i][3] = dArray[i][1] - dArray[i - 1][1];
            }
            return dArray;
        }
    }
}

