/*
 * Decompiled with CFR 0.152.
 */
package ripple;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;
import java.net.URL;
import ripple.RippleCanvas;
import ripple.RippleFrame;
import ripple.Source;

public class Ripple
extends Applet
implements Runnable {
    boolean m_fStandAlone = false;
    private double zscale = 0.0;
    private int m_numSources = 2;
    private int m_pixPerUnit = 20;
    private double m_wavelength = 2.0;
    private boolean m_canDrag = true;
    private boolean m_showControls = true;
    private boolean m_showIntensity = false;
    private boolean m_animate = false;
    private int m_fps = 20;
    private String m_caption = "Ripple Tank";
    private String m_helpFile = null;
    private final String PARAM_numOfSources = "numberOfSources";
    private final String PARAM_pixPerUnit = "pixPerUnit";
    private final String PARAM_wavelength = "wavelength";
    private final String PARAM_showControls = "showControls";
    private final String PARAM_showIntensity = "showIntensity";
    private final String PARAM_animate = "animate";
    private final String PARAM_fps = "fps";
    private final String PARAM_caption = "caption";
    private final String PARAM_helpFile = "helpFile";
    private int iwidth = 0;
    private int iheight = 0;
    Button forwardBtn;
    Button stopBtn;
    Button stepFBtn;
    Button stepBBtn;
    Button editBtn;
    private RippleCanvas rc;
    private Thread calcThread = null;
    int[] M_RED = new int[256];
    int[] M_GREEN = new int[256];
    int[] M_BLUE = new int[256];
    double[] SIN = new double[100];
    int pixPerWave;
    double timePhase = 0.0;
    double maxAmp = 0.0;
    int imgCount = 0;
    int[] c = new int[4];
    int numPix = 4;
    int[] pixels = new int[this.numPix];

    String GetParameter(String string, String[] stringArray) {
        if (stringArray == null) {
            return this.getParameter(string);
        }
        String string2 = String.valueOf(string).concat(String.valueOf("="));
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i].substring(0, string2.length())) || !(string3 = stringArray[i].substring(string2.length())).startsWith("\"") || !(string3 = string3.substring(1)).endsWith("\"")) continue;
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    void GetParameters(String[] stringArray) {
        String string = this.GetParameter("numberOfSources", stringArray);
        if (string != null) {
            this.m_numSources = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("pixPerUnit", stringArray)) != null) {
            this.m_pixPerUnit = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("wavelength", stringArray)) != null) {
            this.m_wavelength = Double.valueOf(string);
        }
        if ((string = this.GetParameter("showControls", stringArray)) != null) {
            this.m_showControls = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("showIntensity", stringArray)) != null) {
            this.m_showIntensity = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("animate", stringArray)) != null) {
            this.m_animate = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("fps", stringArray)) != null) {
            this.m_fps = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("caption", stringArray)) != null) {
            this.m_caption = string;
        }
        if ((string = this.GetParameter("helpFile", stringArray)) != null) {
            this.m_helpFile = string;
        }
    }

    public static void main(String[] stringArray) {
        RippleFrame rippleFrame = new RippleFrame("Ripple");
        rippleFrame.show();
        ((Component)rippleFrame).hide();
        rippleFrame.resize(rippleFrame.insets().left + rippleFrame.insets().right + 320, rippleFrame.insets().top + rippleFrame.insets().bottom + 370);
        Ripple ripple = new Ripple();
        rippleFrame.add("Center", ripple);
        ripple.m_fStandAlone = true;
        ripple.GetParameters(stringArray);
        ripple.init();
        ripple.start();
        rippleFrame.show();
    }

    public String getAppletInfo() {
        return "Name: Ripple Ver 1.1\r\nAuthor: Wolfgang Christian\r\nEmail: WOCHRISTIAN@Davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"numberOfSources", "int", "Number of sources."}, {"pixPerUnit", "int", "Pixels per unit."}, {"wavelength", "double", "Wavelength"}, {"showControls", "boolean", "Show controls on the screen."}, {"showIntensity", "boolean", "Show intensity instead of amplitude."}, {"animate", "boolean", "Animate pattern."}, {"fps", "int", "Frames per second for during animation."}, {"caption", "String", "Applet caption"}, {"helpFile", "String", "Applet help file URL"}};
        return stringArray;
    }

    public void init() {
        if (!this.m_fStandAlone) {
            this.GetParameters(null);
        }
        this.pixPerWave = (int)((double)this.m_pixPerUnit * this.m_wavelength);
        this.resize(320, 370);
        this.generatePallete();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new GridLayout(1, 4));
        this.forwardBtn = new Button("Forward");
        panel.add(this.forwardBtn);
        this.stopBtn = new Button("Stop");
        panel.add(this.stopBtn);
        this.stepBBtn = new Button("<<Step");
        panel.add(this.stepBBtn);
        this.stepFBtn = new Button("Step>>");
        panel.add(this.stepFBtn);
        this.editBtn = new Button("Edit");
        panel.add(this.editBtn);
        if (this.m_showControls) {
            this.add("South", panel);
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 1));
        this.rc = new RippleCanvas();
        this.rc.setBackground(Color.white);
        panel2.add(this.rc);
        this.add("Center", panel2);
        this.rc.setPixPerUnit(this.m_pixPerUnit);
        this.rc.setWavelength(this.m_wavelength);
        this.rc.setSleepTime((int)Math.round(this.m_wavelength * (double)1000 / (double)this.m_fps));
        this.rc.setShowInfo(this.m_showControls);
        boolean bl = this.m_animate;
        for (int i = 0; i < this.m_numSources; ++i) {
            this.addSource(-this.m_numSources / 2 + i, 0.0, 1.0, 0.0);
        }
        this.m_animate = bl;
        if (!this.m_animate) {
            this.rc.msgStr = "Click-Drag any source.";
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
            this.forwardBtn.setLabel("Calculate");
        }
    }

    public void setDrag(boolean bl) {
        this.m_canDrag = bl;
    }

    public void setZScale(double d) {
        this.zscale = d;
    }

    public void setWavelength(double d) {
        if (d < 0.1) {
            return;
        }
        if (d > (double)10) {
            return;
        }
        this.m_wavelength = d;
        this.pixPerWave = (int)((double)this.m_pixPerUnit * this.m_wavelength);
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.rc.setSleepTime((int)Math.round(d * (double)1000 / (double)this.m_fps));
        this.rc.setWavelength(this.m_wavelength);
    }

    public void showIntensity(boolean bl) {
        this.m_showIntensity = bl;
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
    }

    public void cancel() {
        if (this.calcThread == null) {
            this.stopAnimate();
        } else {
            this.stop();
            this.rc.stop();
            this.rc.msgStr = "Click-Drag any source.";
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
            this.forwardBtn.setLabel("Calculate");
            this.stepFBtn.setLabel("Add");
            this.stepBBtn.setLabel("Delete");
            this.m_animate = false;
        }
    }

    public void pause() {
        this.stopAnimate();
    }

    public void stopAnimate() {
        this.m_animate = false;
        if (this.calcThread != null) {
            return;
        }
        if (this.rc.isRunning()) {
            this.rc.stop();
            this.rc.msgStr = "Stopped";
        }
    }

    public synchronized void startAnimate() {
        this.m_animate = true;
        if (this.calcThread != null) {
            return;
        }
        if (this.rc.getImage() == null) {
            this.rc.msgStr = "Please Wait....";
            this.rc.repaint();
            this.start();
            this.forwardBtn.setLabel("Cancel");
            this.stepFBtn.setLabel("--");
            this.stepBBtn.setLabel("--");
            return;
        }
        if (this.rc.getImageNumber() < 8) {
            this.start();
            this.forwardBtn.setLabel("Cancel");
            this.stepFBtn.setLabel("--");
            this.stepBBtn.setLabel("--");
        } else {
            this.rc.start();
        }
    }

    public void start() {
        if (this.rc.getImage() != null && this.calcThread == null && this.rc.getImageNumber() == 8) {
            this.rc.start();
            return;
        }
        if (this.calcThread == null && this.m_animate) {
            this.calcThread = new Thread(this);
            this.calcThread.start();
            this.setControlBtn(true);
        }
    }

    public void stop() {
        block5: {
            try {
                if (this.calcThread == null) break block5;
                this.calcThread.stop();
                try {
                    this.calcThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.calcThread = null;
                this.forwardBtn.setLabel("Calculate");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.calcThread = null;
        if (this.rc.isRunning()) {
            this.rc.stop();
        }
    }

    public synchronized void recalculate() {
        this.stop();
        this.rc.stop();
        this.rc.msgStr = "";
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.start();
    }

    private void setControlBtn(boolean bl) {
        if (bl) {
            if (this.calcThread != null) {
                this.forwardBtn.setLabel("Cancel");
                this.stepFBtn.setLabel("--");
                this.stepBBtn.setLabel("--");
            } else {
                this.forwardBtn.setLabel("Calculate");
                this.stepFBtn.setLabel("Add");
                this.stepBBtn.setLabel("Delete");
            }
            this.stopBtn.setLabel("--");
            this.editBtn.setLabel("--");
        } else {
            this.forwardBtn.setLabel("Forward");
            this.stopBtn.setLabel("Stop");
            this.stepFBtn.setLabel("Step>>");
            this.stepBBtn.setLabel("<<Step");
            this.editBtn.setLabel("Edit");
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (this.calcThread != thread) {
            return;
        }
        this.rc.stop();
        double d = this.pixPerWave > 0 ? 16.0 / (double)this.pixPerWave : 1.0;
        if (d > 1.0) {
            d = 1.0;
        }
        int n = (int)((double)this.rc.size().width * d);
        int n2 = (int)((double)this.rc.size().height * d);
        if (this.rc.size().width != this.iwidth || this.rc.size().height != this.iheight) {
            this.iwidth = this.rc.size().width;
            this.iheight = this.rc.size().height;
            this.rc.setImage(null);
            this.rc.frames.removeAllElements();
        }
        if (this.numPix != n * n2) {
            this.pixels = new int[n * n2];
            this.numPix = n * n2;
        }
        int n3 = 0;
        int n4 = 0;
        n3 = this.rc.getImageNumber();
        while (n3 < 8) {
            if (this.rc.isImageLoaded() || n4 > 100) {
                int n5 = 0;
                n4 = 0;
                this.timePhase = (double)n3 * 100.0 / 8.0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.c[2] = 0;
                        this.c[1] = 0;
                        this.c[0] = 0;
                        this.c[3] = 255;
                        this.Funcion(this.c, j, i, n, n2, d, this.timePhase);
                        this.pixels[n5++] = this.c[3] << 24 | this.c[0] << 16 | this.c[1] << 8 | this.c[2] << 0;
                    }
                }
                if (this.rc.addImage(n, n2, this.pixels, 0, n, n3)) {
                    ++n3;
                }
            }
            ++n4;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.calcThread = null;
        this.setControlBtn(false);
        this.rc.msgStr = "Stopped";
        if (this.m_animate) {
            this.rc.start();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            String string = this.m_helpFile;
            if (string != null) {
                try {
                    URL uRL = new URL(this.getDocumentBase(), string);
                    this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    System.out.println("Failed to load help file!");
                }
            }
            return true;
        }
        return false;
    }

    public void forward() {
        if (this.calcThread == null) {
            this.startAnimate();
        }
    }

    public void edit() {
        this.stop();
        this.rc.stop();
        this.rc.msgStr = "Click-Drag any source.";
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.forwardBtn.setLabel("Calculate");
        this.stepFBtn.setLabel("Add");
        this.stepBBtn.setLabel("Delete");
        this.m_animate = false;
        this.editSources();
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.forwardBtn)) {
            if (this.calcThread == null) {
                this.startAnimate();
            } else {
                this.cancel();
            }
            return true;
        }
        if (event.target.equals(this.stopBtn)) {
            this.stopAnimate();
            return true;
        }
        if (event.target.equals(this.stepFBtn)) {
            if (this.forwardBtn.getLabel().equals("Calculate")) {
                this.addSource();
                return true;
            }
            this.m_animate = false;
            if (this.rc.isRunning() && this.calcThread == null) {
                this.rc.stop();
            }
            this.rc.step(1);
            return true;
        }
        if (event.target.equals(this.stepBBtn)) {
            if (this.forwardBtn.getLabel().equals("Calculate")) {
                this.deleteAll();
                return true;
            }
            this.m_animate = false;
            if (this.rc.isRunning() && this.calcThread == null) {
                this.rc.stop();
            }
            this.rc.step(-1);
            return true;
        }
        if (event.target.equals(this.editBtn)) {
            this.cancel();
            this.editSources();
            return true;
        }
        return false;
    }

    void Funcion(int[] nArray, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n3;
        int n6 = n4;
        int n7 = n5 / 2;
        int n8 = n6 / 2;
        int n9 = 0;
        double d3 = 0.0;
        double d4 = 100.0 / (double)this.pixPerWave / d;
        int n10 = this.rc.sources.size();
        double d5 = 0.0;
        for (int i = 0; i < n10; ++i) {
            double d6;
            Source source = (Source)this.rc.sources.elementAt(i);
            double d7 = (double)(n - n7) - source.getX() * (double)this.m_pixPerUnit * d;
            double d8 = (double)(n2 - n8) + source.getY() * (double)this.m_pixPerUnit * d;
            d3 = source.getPhase() / 0.36;
            int n11 = (int)(-d2 - d3 + Math.sqrt(d6 = d7 * d7 + d8 * d8) * d4) % 100;
            if (n11 < 0) {
                d5 -= this.SIN[-n11] * source.getAmp();
                continue;
            }
            d5 += this.SIN[n11] * source.getAmp();
        }
        n9 = this.maxAmp <= 0.0 ? 0 : (this.m_showIntensity ? (int)Math.round(d5 * d5 / this.maxAmp / this.maxAmp / (double)255) : (int)Math.round(((double)255 + d5 / this.maxAmp) / (double)2));
        nArray[0] = this.M_RED[n9];
        nArray[1] = this.M_GREEN[n9];
        nArray[2] = this.M_BLUE[n9];
    }

    void generatePallete() {
        int n;
        for (n = 0; n < 256; ++n) {
            this.M_RED[n] = n;
        }
        for (n = 0; n < 256; ++n) {
            this.M_GREEN[n] = n;
        }
        for (n = 0; n < 256; ++n) {
            this.M_BLUE[n] = n;
        }
        for (n = 0; n < 100; ++n) {
            this.SIN[n] = (double)255 * Math.sin(Math.PI * 2 * (double)n / (double)100);
        }
    }

    public void editSources() {
        this.stop();
        this.rc.stop();
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.rc.msgStr = "Click-Drag any source.";
        this.rc.repaint();
        this.setControlBtn(true);
        this.m_animate = false;
    }

    public void addSource() {
        if (this.rc.sources.size() > 0) {
            Source source = (Source)this.rc.sources.lastElement();
            double d = source.getX();
            double d2 = source.getY();
            double d3 = source.getAmp();
            double d4 = source.getPhase();
            this.addSource(d + 1.0, d2 - 1.0, d3, d4);
        } else {
            this.addSource(0.0, 0.0, 1.0, 0.0);
        }
    }

    public void addSource(double d, double d2, double d3, double d4) {
        d3 = Math.abs(d3);
        this.maxAmp += d3;
        if (this.zscale != 0.0) {
            this.maxAmp = this.zscale;
        }
        this.stop();
        this.rc.stop();
        Source source = new Source(d, d2, d3, d4);
        source.canDrag = this.m_canDrag;
        this.rc.sources.addElement(source);
        this.rc.setImage(null);
        this.rc.frames.removeAllElements();
        this.rc.msgStr = "Click-Drag any source.";
        this.rc.repaint();
        this.setControlBtn(true);
        this.m_animate = false;
    }

    public void deleteAll() {
        this.m_canDrag = true;
        this.rc.sources.removeAllElements();
        this.rc.frames.removeAllElements();
        this.maxAmp = 0.0;
        this.recalculate();
    }
}

