/*
 * Decompiled with CFR 0.152.
 */
package ripple;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import ripple.Source;

class RippleCanvas
extends Canvas
implements Runnable {
    Image img;
    int pixPerUnit = 10;
    double gridUnit = 1.0;
    int sleepTime = 100;
    Vector sources = new Vector();
    public String msgStr = "Please Wait...";
    private int iwidth = 0;
    private int iheight = 0;
    private boolean showCoord = false;
    private int xCoord;
    private int yCoord;
    private Thread movieThread;
    Vector frames = new Vector();
    int current = 0;
    boolean running = false;
    boolean imageLoaded = true;
    Source dragSource = null;
    double wavelength = 0.0;
    boolean showInfo = true;

    public void stop() {
        this.running = false;
    }

    public void stopThread() {
        if (this.movieThread != null) {
            this.movieThread.stop();
            try {
                this.movieThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.running = false;
        this.movieThread = null;
    }

    public void start() {
        if (this.movieThread == null) {
            this.movieThread = new Thread(this);
            this.running = true;
            this.movieThread.start();
        }
        this.imageLoaded = true;
    }

    public void run() {
        Graphics graphics = this.getGraphics();
        while (this.running && this.sources.size() > 0 && this.frames.size() > 1) {
            try {
                if (this.current >= this.frames.size()) {
                    this.current = 0;
                }
                if (this.frames.size() > 0) {
                    this.img = (Image)this.frames.elementAt(this.current);
                }
                this.paint(graphics);
                ++this.current;
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.movieThread = null;
        this.running = false;
        graphics.dispose();
        this.imageLoaded = true;
        this.repaint();
    }

    void setSleepTime(int n) {
        this.sleepTime = n;
    }

    void setWavelength(double d) {
        this.wavelength = d;
    }

    void setShowInfo(boolean bl) {
        this.showInfo = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = 4;
        Source.setSize(((double)n3 + 1.0) / (double)this.pixPerUnit);
        this.iwidth = this.size().width;
        this.iheight = this.size().height;
        int n4 = this.iwidth / 2;
        int n5 = this.iheight / 2;
        int n6 = this.sources.size();
        if (n6 == 0) {
            this.msgStr = "No Sources.";
        }
        if (this.img == null) {
            super.paint(graphics);
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n2 = (this.iwidth - fontMetrics.stringWidth(this.msgStr)) / 2;
            graphics.drawString(this.msgStr, n2, 30);
            n2 = (this.iwidth - fontMetrics.stringWidth(String.valueOf("Wavelength= ").concat(String.valueOf(this.wavelength)))) / 2;
            if (this.showInfo) {
                graphics.drawString(String.valueOf("Wavelength= ").concat(String.valueOf(this.wavelength)), n2, 60);
            }
        } else if (n6 > 0) {
            graphics.drawImage(this.img, 0, 0, this.iwidth, this.iheight, this);
            graphics.setColor(Color.red);
            if (this.running) {
                graphics.drawString("running", 10, 15);
            } else {
                graphics.drawString(String.valueOf("frame: ").concat(String.valueOf(this.current)), 10, 15);
            }
        }
        if (n6 > 0) {
            for (n = 0; n < n6; ++n) {
                graphics.setColor(Color.red);
                Source source = (Source)this.sources.elementAt(n);
                if (source.canDrag) {
                    graphics.setColor(Color.red);
                } else {
                    graphics.setColor(new Color(0, 255, 0));
                }
                int n7 = (int)Math.round((double)n4 + source.getX() * (double)this.pixPerUnit) + 1;
                n2 = (int)Math.round((double)n5 - source.getY() * (double)this.pixPerUnit) + 1;
                if (source == this.dragSource) continue;
                graphics.fillOval(n7 - n3, n2 - n3, 2 * n3, 2 * n3);
            }
        } else {
            graphics.setColor(Color.black);
        }
        graphics.setColor(Color.black);
        int n8 = (int)Math.round((double)this.pixPerUnit * this.gridUnit);
        if (n8 > 0) {
            for (n = n4 % n8; n < this.iwidth; n += n8) {
                graphics.drawLine(n, this.iheight - 5, n, this.iheight);
                graphics.drawLine(n, 0, n, 5);
            }
        }
        if (n8 > 0) {
            for (n = n5 % n8; n < this.iheight; n += n8) {
                graphics.drawLine(this.iwidth - 5, n, this.iwidth, n);
                graphics.drawLine(0, n, 5, n);
            }
        }
        if (this.showCoord && this.running) {
            graphics.setColor(Color.red);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            graphics.setColor(Color.black);
            graphics.clearRect(8, this.iheight - 30, 150, 20);
            graphics.drawString(String.valueOf(String.valueOf(String.valueOf("X: ").concat(String.valueOf(this.pixToX(this.xCoord)))).concat(String.valueOf("  Y: "))).concat(String.valueOf(this.pixToY(this.yCoord))), 10, this.iheight - 15);
        }
    }

    public Dimension minimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension preferredSize() {
        return new Dimension(200, 200);
    }

    public Image getImage() {
        return this.img;
    }

    public int getImageNumber() {
        return this.frames.size();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public synchronized void setImage(Image image) {
        this.img = image;
        this.repaint();
        this.imageLoaded = true;
    }

    private void showImageSize() {
        System.out.print(String.valueOf("Image w: ").concat(String.valueOf(this.img.getWidth(this))));
        System.out.println(String.valueOf("Image h: ").concat(String.valueOf(this.img.getHeight(this))));
    }

    synchronized boolean addImage(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        this.imageLoaded = false;
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n4);
        if (memoryImageSource == null) {
            System.out.println("MemoryImageSource not created.");
            return false;
        }
        this.img = this.createImage(memoryImageSource);
        if (n5 < 8) {
            this.frames.addElement(this.img);
            this.current = n5;
        }
        this.paintImage();
        return true;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.imageLoaded = true;
        }
        return true;
    }

    public void paintImage() {
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public void step(int n) {
        int n2 = this.frames.size() - 1;
        if (n2 < 1) {
            return;
        }
        this.current += n;
        while (this.current > n2) {
            this.current = this.current - n2 - 1;
        }
        while (this.current < 0) {
            this.current = this.current + n2 + 1;
        }
        this.img = (Image)this.frames.elementAt(this.current);
        this.imageLoaded = true;
        this.paintImage();
    }

    private double pixToX(int n) {
        int n2 = this.iwidth / 2;
        return (double)(n - n2) / (1.0 * (double)this.pixPerUnit);
    }

    private double pixToY(int n) {
        int n2 = this.iheight / 2;
        return (double)(-(n - n2)) / (1.0 * (double)this.pixPerUnit);
    }

    public void setDragSource(int n, int n2) {
        int n3 = this.sources.size();
        this.dragSource = null;
        if (this.img != null) {
            return;
        }
        if (n3 < 1) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            Source source = (Source)this.sources.elementAt(i);
            if (!source.isInside(this.pixToX(n), this.pixToY(n2))) continue;
            this.dragSource = source;
        }
    }

    public void startDrawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (!this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.clearRect(8, this.iheight - 30, 150, 20);
            graphics.drawString(String.valueOf(String.valueOf(String.valueOf("X: ").concat(String.valueOf(this.pixToX(this.xCoord)))).concat(String.valueOf("  Y: "))).concat(String.valueOf(this.pixToY(this.yCoord))), 10, this.iheight - 15);
            graphics.setColor(Color.red);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            this.setDragSource(n, n2);
            graphics.dispose();
        }
        this.showCoord = true;
    }

    public void endDrawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (this.dragSource != null) {
            this.dragSource.setX(this.pixToX(this.xCoord));
            this.dragSource.setY(this.pixToY(this.yCoord));
        }
        this.showCoord = false;
        this.dragSource = null;
        if (!this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public void drawCoord(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        if (this.showCoord && !this.running) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.clearRect(8, this.iheight - 30, 150, 20);
            graphics.drawString(String.valueOf(String.valueOf(String.valueOf("X: ").concat(String.valueOf(this.pixToX(this.xCoord)))).concat(String.valueOf("  Y: "))).concat(String.valueOf(this.pixToY(this.yCoord))), 10, this.iheight - 15);
            graphics.setColor(Color.red);
            graphics.drawLine(this.xCoord - 10, this.yCoord, this.xCoord + 10, this.yCoord);
            graphics.drawLine(this.xCoord, this.yCoord - 10, this.xCoord, this.yCoord + 10);
            if (this.dragSource != null) {
                int n3 = 4;
                graphics.fillOval(this.xCoord - n3, this.yCoord - n3, 2 * n3, 2 * n3);
            }
            graphics.dispose();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.startDrawCoord(n, n2);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.endDrawCoord(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        this.drawCoord(n, n2);
        return true;
    }
}

