/*
 * Decompiled with CFR 0.152.
 */
package blackbody;

import blackbody.BlackBody_autox_itemAdapter;
import blackbody.BlackBody_autoy_itemAdapter;
import blackbody.BlackBody_graph_mouseAdapter;
import blackbody.BlackBody_graph_mouseMotionAdapter;
import blackbody.BlackBody_redNumber_actionAdapter;
import blackbody.BlackBody_slider_adjustmentAdapter;
import blackbody.BlackBody_slider_mouseAdapter;
import blackbody.BlackBody_tempNumber_actionAdapter;
import borland.jbcl.control.BevelPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import sTools.Format;
import sTools.SGraph;
import sTools.SNumber;
import sTools.SPanel;
import sTools.SSlider;
import sTools.STimer;
import sTools.TimerClient;

public class BlackBody
extends Applet
implements TimerClient {
    static double h = 6.626075E-34;
    static double c = 2.99792458E8;
    static double k = 1.380658E-23;
    static double pi = Math.PI;
    static double exp = Math.E;
    static double phcc = (double)2 * pi * h * c * c;
    static double hc = h * c;
    static int np = 60;
    static int halfWidth = 150;
    static int[] saturation = new int[halfWidth * 2];
    boolean isStandalone = false;
    BBGraph graph = new BBGraph();
    PyroPanel swatch = new PyroPanel();
    Checkbox autox = new Checkbox();
    Checkbox autoy = new Checkbox();
    SNumber redNumber = new SNumber();
    SNumber greenNumber = new SNumber();
    SNumber blueNumber = new SNumber();
    Label label1 = new Label();
    Label label2 = new Label();
    Label label3 = new Label();
    SNumber totalNumber = new SNumber();
    BevelPanel bevelPanel1 = new BevelPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    Label label4 = new Label();
    BevelPanel bevelPanel2 = new BevelPanel();
    BevelPanel bevelPanel3 = new BevelPanel();
    STimer timer = new STimer();
    double temperature;
    double lambda;
    int r;
    int g;
    int b;
    int greenColor;
    boolean showControls = true;
    int colorSwatch = 1;
    int enableCursor = 1;
    int i = 0;
    int xPos1;
    int xPos2;
    double[] x = new double[np];
    double[] y = new double[np];
    boolean validImage = false;
    BorderLayout borderLayout3 = new BorderLayout();
    Label label5 = new Label();
    Label label6 = new Label();
    BorderLayout borderLayout4 = new BorderLayout();
    Format mouseFormat = new Format("%-3.3g");
    SSlider slider = new SSlider();
    SNumber tempNumber = new SNumber();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();

    public static void calSaturation() {
        int n = halfWidth * 2;
        for (int i = 0; i < n; ++i) {
            double d = 1.4 * (double)(i - halfWidth) / (double)halfWidth;
            BlackBody.saturation[i] = (int)((double)255 * Math.exp(-d * d));
        }
    }

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.temperature = Double.valueOf(this.getParameter("Temp", "5321"));
            this.colorSwatch = Integer.valueOf(this.getParameter("colorSwatch", "1"));
            this.enableCursor = Integer.valueOf(this.getParameter("enableCursor", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BlackBody.calSaturation();
        this.timer.setClient(this);
        this.tempNumber.setFormat("%+6.2f");
    }

    public void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setSize(new Dimension(445, 378));
        this.graph.setBorders("20,20,50,20");
        this.graph.setLabelY("Intensity");
        this.graph.addMouseMotionListener(new BlackBody_graph_mouseMotionAdapter(this));
        this.graph.addMouseListener(new BlackBody_graph_mouseAdapter(this));
        this.autox.setState(true);
        this.autox.addItemListener(new BlackBody_autox_itemAdapter(this));
        this.autox.setVisible(true);
        this.autox.setLabel("Auto X");
        this.autoy.setState(true);
        this.autoy.addItemListener(new BlackBody_autoy_itemAdapter(this));
        this.swatch.setLayout(this.borderLayout4);
        this.label1.setText("blue");
        this.label2.setText("green");
        this.label3.setText("red");
        this.bevelPanel1.setVisible(false);
        this.label4.setText("total");
        this.bevelPanel2.setMargins(new Insets(5, 5, 5, 5));
        this.bevelPanel3.setMargins(new Insets(0, 5, 0, 0));
        this.label5.setText("Blackbody Radiation");
        this.label6.setBackground(Color.black);
        this.label6.setForeground(Color.white);
        this.label6.setText("        Colors");
        this.slider.addMouseListener(new BlackBody_slider_mouseAdapter(this));
        this.slider.addAdjustmentListener(new BlackBody_slider_adjustmentAdapter(this));
        this.bevelPanel3.setLayout(this.borderLayout3);
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.bevelPanel1.setLayout(this.flowLayout1);
        this.redNumber.addActionListener(new BlackBody_redNumber_actionAdapter(this));
        this.autoy.setVisible(true);
        this.autoy.setLabel("Auto Y");
        this.setLayout(this.borderLayout1);
        this.add((Component)this.graph, "Center");
        if (this.colorSwatch == 1) {
            this.add((Component)this.swatch, "West");
        }
        this.add((Component)this.swatch, "West");
        this.swatch.setBackground(Color.black);
        this.graph.setBackground(new Color(230, 230, 230));
        this.graph.setLabelX("Wavelength");
        if (this.showControls) {
            this.add((Component)this.bevelPanel2, "South");
        }
        this.bevelPanel2.add((Component)this.bevelPanel1, "North");
        this.bevelPanel1.add((Component)this.label1, null);
        this.bevelPanel1.add((Component)this.blueNumber, null);
        this.bevelPanel1.add((Component)this.label2, null);
        this.bevelPanel1.add((Component)this.greenNumber, null);
        this.bevelPanel1.add((Component)this.label3, null);
        this.bevelPanel1.add((Component)this.redNumber, null);
        this.bevelPanel1.add((Component)this.label4, null);
        this.bevelPanel1.add((Component)this.totalNumber, null);
        this.bevelPanel2.add((Component)this.bevelPanel3, "South");
        this.bevelPanel3.add((Component)this.autox, "West");
        this.bevelPanel3.add((Component)this.autoy, "Center");
        this.bevelPanel3.add((Component)this.label5, "East");
        this.bevelPanel2.add((Component)this.slider, "Center");
        this.bevelPanel2.add((Component)this.tempNumber, "East");
        this.setT(this.temperature);
        this.slider.setDValue(this.temperature / (double)10000);
        this.tempNumber.addActionListener(new BlackBody_tempNumber_actionAdapter(this));
    }

    public void start() {
        this.timer.start(500);
    }

    public void stop() {
        this.timer.stop();
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Name: BlackBody\r\nAuthor: Wolfgang Christian and Mike Lee\r\nemail:wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Temp", "double", "Temperature"}, {"showControls", "boolean", "whether or not to show UI controls"}, {"colorSwatch", "integer", "whether or not to show color swatch"}, {"enableCursor", "integer", "whether or not to enable cursor"}};
        return stringArray;
    }

    public void setTemperature(double d) {
        this.setT(d);
    }

    public void setT(double d) {
        this.validImage = false;
        this.graph.deleteAllSeries();
        double d2 = 1.0E-6;
        double d3 = d2 / (double)np;
        this.temperature = d;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        this.i = 1;
        while (this.i < np) {
            this.x[this.i] = (double)this.i * d3;
            this.y[this.i] = phcc / ((Math.pow(exp, hc / (this.x[this.i] * k * this.temperature)) - 1.0) * Math.pow(this.x[this.i], 5.0));
            if (this.i >= 19 & this.i <= 29) {
                d6 += this.y[this.i];
            }
            if (this.i >= 29 & this.i <= 38) {
                d5 += this.y[this.i];
            }
            if (this.i >= 38 & this.i <= 46) {
                d4 += this.y[this.i];
            }
            ++this.i;
        }
        d7 = d6 + d5 + d4;
        d9 = d6 > d4 ? d6 : d4;
        if (d9 < d5) {
            d9 = d5;
        }
        double d10 = d4 < 6.158 ? 0.0 : 255.0 * d4 / d9 * (Math.log(d7) / (double)20);
        double d11 = d5 < 6.158 ? 0.0 : 255.0 * d5 / d9 * (Math.log(d7) / (double)20);
        double d12 = d6 < 6.158 ? 0.0 : 255.0 * d6 / d9 * (Math.log(d7) / (double)20);
        this.r = (int)Math.round(d10);
        this.greenColor = this.g = (int)Math.round(d11);
        this.b = (int)Math.round(d12);
        if (this.r > 255) {
            this.r = 255;
        }
        if (this.greenColor > 255) {
            this.greenColor = 255;
        }
        if (this.b > 255) {
            this.b = 255;
        }
        if (this.b < 5) {
            this.b = 1;
        }
        this.redNumber.setValue(d4);
        this.greenNumber.setValue(d5);
        this.blueNumber.setValue(d6);
        this.totalNumber.setValue(d7);
        this.graph.addData(1, this.x, this.y);
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.swatch.repaint();
        this.tempNumber.setValue(this.temperature);
    }

    public void tick() {
        if (!this.validImage) {
            this.graph.createImage();
        }
    }

    public void setAutoscale(boolean bl, boolean bl2) {
        if (bl) {
            this.graph.setAutoscaleX(true);
        } else {
            this.graph.setAutoscaleX(false);
        }
        if (bl2) {
            this.graph.setAutoscaleY(true);
        } else {
            this.graph.setAutoscaleY(false);
        }
    }

    void slider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.validImage = false;
        this.setT(this.slider.getDValue() * (double)10000);
        this.graph.repaint();
    }

    void redNumber_actionPerformed(ActionEvent actionEvent) {
    }

    void graph_mousePressed(MouseEvent mouseEvent) {
        if (this.enableCursor == 1) {
            Graphics graphics = this.graph.getGraphics();
            graphics.setColor(Color.yellow);
            graphics.fillRect(25, this.graph.pixFromY(0.0) + 28, 155, 15);
            this.lambda = 0.0029 / this.temperature;
            this.xPos1 = this.graph.pixFromX(this.lambda);
            graphics.setColor(Color.blue);
            graphics.drawLine(this.xPos1, 0, this.xPos1, 12);
            graphics.drawLine(this.xPos1, 12, this.xPos1 - 3, 9);
            graphics.drawLine(this.xPos1, 12, this.xPos1 + 3, 9);
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            this.lambda = this.graph.xFromPix(this.xPos2);
            graphics.drawString(String.valueOf(String.valueOf("lambda max = ").concat(String.valueOf(this.mouseFormat.form(this.lambda * 1.0E9)))).concat(String.valueOf(" nm")), 30, this.graph.pixFromY(0.0) + 40);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
            graphics.dispose();
        }
    }

    void graph_mouseDragged(MouseEvent mouseEvent) {
        if (this.enableCursor == 1) {
            Graphics graphics = this.graph.getGraphics();
            graphics.setColor(new Color(230, 230, 230));
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            graphics.setColor(Color.yellow);
            graphics.fillRect(25, this.graph.pixFromY(0.0) + 28, 155, 15);
            graphics.setColor(Color.blue);
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            graphics.drawLine(this.xPos1, 0, this.xPos1, 12);
            graphics.drawLine(this.xPos1, 12, this.xPos1 - 3, 9);
            graphics.drawLine(this.xPos1, 12, this.xPos1 + 3, 9);
            graphics.drawLine(this.xPos2, 0, this.xPos2, 12);
            graphics.drawLine(this.xPos2, 12, this.xPos2 - 3, 9);
            graphics.drawLine(this.xPos2, 12, this.xPos2 + 3, 9);
            this.lambda = this.graph.xFromPix(this.xPos2);
            graphics.drawString(String.valueOf(String.valueOf("lambda max = ").concat(String.valueOf(this.mouseFormat.form(this.lambda * 1.0E9)))).concat(String.valueOf(" nm")), 30, this.graph.pixFromY(0.0) + 40);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
            graphics.dispose();
        }
    }

    void graph_mouseReleased(MouseEvent mouseEvent) {
        if (this.enableCursor == 1) {
            this.xPos2 = mouseEvent.getX();
            if (this.xPos2 <= this.graph.pixFromX(0.0)) {
                this.xPos2 = this.graph.pixFromX(0.0) + 1;
            }
            if (this.xPos2 >= this.graph.pixFromX(1.0E-6)) {
                this.xPos2 = this.graph.pixFromX(1.0E-6);
            }
            this.lambda = this.graph.xFromPix(this.xPos2);
            this.setT(0.0029 / this.lambda);
            this.slider.setDValue(0.0029 / this.lambda / (double)10000);
            this.tempNumber.setValue(0.0029 / this.lambda);
        }
    }

    void slider_mouseReleased(MouseEvent mouseEvent) {
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
        this.setT(this.slider.getDValue() * (double)10000);
        this.graph.repaint();
    }

    void graph_mouseEntered(MouseEvent mouseEvent) {
        if (this.enableCursor == 1) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    void graph_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void autoy_itemStateChanged(ItemEvent itemEvent) {
        this.validImage = false;
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
    }

    void autox_itemStateChanged(ItemEvent itemEvent) {
        this.validImage = false;
        this.setAutoscale(this.autox.getState(), this.autoy.getState());
    }

    void tempNumber_actionPerformed(ActionEvent actionEvent) {
        this.setT(this.tempNumber.getValue());
        this.slider.setDValue(this.tempNumber.getValue() / (double)10000);
    }

    class PyroPanel
    extends SPanel {
        public PyroPanel() {
            this.setMinimumSize(new Dimension(80, 100));
            this.setPreferredSize(new Dimension(80, 100));
        }

        public void paint(Graphics graphics) {
            graphics.setColor(new Color(BlackBody.this.r, 0, 0));
            graphics.fillOval(this.getBounds().width / 2 - 15, 15, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("R", this.getBounds().width / 2 - 30, 35);
            graphics.setColor(new Color(0, BlackBody.this.greenColor, 0));
            graphics.fillOval(this.getBounds().width / 2 - 15, 50, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("G", this.getBounds().width / 2 - 30, 70);
            graphics.setColor(new Color(0, 0, BlackBody.this.b));
            graphics.fillOval(this.getBounds().width / 2 - 15, 85, 30, 30);
            graphics.setColor(Color.white);
            graphics.drawString("B", this.getBounds().width / 2 - 30, 105);
            graphics.setColor(new Color(BlackBody.this.r, BlackBody.this.greenColor, BlackBody.this.b));
            graphics.fillOval(this.getBounds().width / 2 - 20, 150, 40, 40);
            graphics.setColor(Color.white);
            graphics.drawString("Appearance", this.getBounds().width / 2 - 35, 210);
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf(String.valueOf("T=").concat(String.valueOf((long)BlackBody.this.temperature))).concat(String.valueOf(" K")), this.getBounds().width / 2 - 30, 240);
        }
    }

    class BBGraph
    extends SGraph {
        int iheight = 0;
        int iwidth = 0;
        Image osi = null;

        BBGraph() {
        }

        public synchronized void paint(Graphics graphics) {
            if (this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
                BlackBody.this.validImage = false;
            }
            if (BlackBody.this.validImage) {
                graphics.drawImage(this.osi, 0, 0, this);
            } else {
                super.paint(graphics);
            }
        }

        public synchronized void createImage() {
            if (this.osi == null) {
                return;
            }
            Graphics graphics = this.osi.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            graphics.setColor(Color.black);
            super.paint(graphics);
            this.paintSpectrum(graphics);
            graphics.dispose();
            BlackBody.this.validImage = true;
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.osi, 0, 0, this);
            graphics2.dispose();
        }

        public void paintFirst(Graphics graphics, Rectangle rectangle) {
            if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
                this.iwidth = this.getSize().width;
                this.iheight = this.getSize().height;
                this.osi = this.createImage(this.iwidth, this.iheight);
                BlackBody.this.validImage = false;
            }
        }

        public final double getIntensity(double d) {
            return phcc / ((Math.pow(exp, hc / (d * k * BlackBody.this.temperature)) - 1.0) * Math.pow(d, 5.0));
        }

        public final Color getColor(double d) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)(d * 1.0E9);
            if (n4 > 400 - halfWidth && n4 < 400 + halfWidth) {
                n3 = saturation[n4 - 400 + halfWidth];
            }
            if (n4 > 500 - halfWidth && n4 < 500 + halfWidth) {
                n2 = saturation[n4 - 500 + halfWidth];
            }
            if (n4 > 600 - halfWidth && n4 < 600 + halfWidth) {
                n = saturation[n4 - 600 + halfWidth];
            }
            return new Color(n, n2, n3);
        }

        public void paintSpectrum(Graphics graphics) {
            int n = this.pixFromX(BlackBody.this.x[1]);
            int n2 = this.pixFromX(BlackBody.this.x[np - 1]);
            int n3 = this.pixFromY(0.0);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = n; i < n2; ++i) {
                d2 = this.xFromPix(i);
                d = this.getIntensity(d2);
                graphics.setColor(this.getColor(d2));
                graphics.drawLine(i, n3, i, this.pixFromY(d));
            }
        }
    }
}

