/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class BorderItemPainter
implements ItemPainter {
    public static final int OUTER_RAISED = 256;
    public static final int OUTER_SUNKEN = 512;
    public static final int INNER_RAISED = 1024;
    public static final int INNER_SUNKEN = 2048;
    public static final int EDGE_RAISED = 1280;
    public static final int EDGE_SUNKEN = 2560;
    public static final int EDGE_ETCHED = 1536;
    public static final int EDGE_BUMP = 2304;
    public static final int EDGE_OUTER = 768;
    public static final int EDGE_INNER = 3072;
    public static final int EDGE_ALL = 3840;
    public static final int NONE = 0;
    public static final int PLAIN = 1;
    public static final int RAISED = 2;
    public static final int RECESSED = 3;
    public static final int EMBOSSED = 4;
    public static final int GROOVED = 5;
    public static final int BUTTON_UP = 6;
    public static final int BUTTON_DN = 7;
    public static final int WND_RAISED = 8;
    public static final int WND_RECESSED = 9;
    public static final int WELL_SET = 10;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int TOP_LEFT = 3;
    public static final int TOP_RIGHT = 6;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 12;
    public static final int RECT = 15;
    public static final int FILL = 2048;
    public static final int SOFT = 4096;
    public static final int FLAT = 16384;
    public static final int MONO = 32768;
    private static int[] edges = new int[]{0, 0, 1024, 2048, 2304, 1536, 1280, 2560, 1280, 2560, 1536};
    private static int[] flagses = new int[]{0, 0, 0, 0, 0, 0, 4096, 4096, 0, 0, 0};
    private int edge;
    private int which;
    private int flags;
    private ItemPainter painter;

    public BorderItemPainter(int n, int n2, int n3) {
        if ((n & 0xF00) == 0) {
            this.edge = edges[n];
            this.flags = flagses[n] | n3;
        } else {
            this.edge = n;
            this.flags = n3;
        }
        this.which = n2;
    }

    public BorderItemPainter(int n, int n2) {
        this(n, n2, 0);
    }

    public BorderItemPainter(int n) {
        this(n, 15, 0);
    }

    public BorderItemPainter() {
        this(0, 15, 0);
    }

    public BorderItemPainter(ItemPainter itemPainter, int n, int n2, int n3) {
        this(n, n2, n3);
        this.painter = itemPainter;
    }

    public BorderItemPainter(ItemPainter itemPainter, int n, int n2) {
        this(n, n2);
        this.painter = itemPainter;
    }

    public BorderItemPainter(ItemPainter itemPainter, int n) {
        this(n);
        this.painter = itemPainter;
    }

    public BorderItemPainter(ItemPainter itemPainter) {
        this();
        this.painter = itemPainter;
    }

    public int getEdgeOrStyle() {
        return this.edge;
    }

    public void setEdgeOrStyle(int n) {
        if ((n & 0xF00) == 0) {
            this.edge = edges[n];
            this.flags = flagses[n] | this.flags;
        } else {
            this.edge = n;
        }
    }

    public int getWhichEdges() {
        return this.which;
    }

    public void setWhichEdges(int n) {
        this.which = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public Insets getInsets() {
        int n = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
        return new Insets(n * ((this.which & 2) != 0 ? 1 : 0), n * ((this.which & 1) != 0 ? 1 : 0), n * ((this.which & 8) != 0 ? 1 : 0), n * ((this.which & 4) != 0 ? 1 : 0));
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Insets insets = this.getInsets();
        if (this.painter != null) {
            Dimension dimension = this.painter.getPreferredSize(object, graphics, n, itemPaintSite);
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            return;
        }
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        BorderItemPainter.drawEdge(graphics, rectangle, this.edge, this.which, this.flags);
        if (this.painter != null) {
            Insets insets = this.getInsets();
            int n2 = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.painter.paint(object, graphics, rectangle, n, itemPaintSite);
        }
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public static boolean drawEdge(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        Color[] colorArray;
        Color[] colorArray2;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if ((n3 & 0x8000) != 0) {
            if ((n & 0x300) != 0) {
                BorderItemPainter.PaintFrame(graphics, rectangle2, n2, SystemColor.windowBorder, SystemColor.windowBorder);
                rectangle2.grow(-1, -1);
            }
            if ((n3 & 0x800) != 0) {
                graphics.setColor(SystemColor.window);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            return true;
        }
        if ((n3 & 0x4000) != 0) {
            if ((n & 0x300) != 0) {
                BorderItemPainter.PaintFrame(graphics, rectangle2, n2, SystemColor.controlShadow, SystemColor.controlShadow);
                rectangle2.grow(-1, -1);
            }
            if ((n3 & 0x800) != 0) {
                graphics.setColor(SystemColor.control);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            return true;
        }
        if ((n & 0x300) != 0) {
            colorArray2 = new Color[]{SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow};
            colorArray = new Color[]{SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight};
            n4 = ((n & 0x200) != 0 ? 2 : 0) | ((n3 & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.PaintFrame(graphics, rectangle2, n2, colorArray2[n4], colorArray[n4]);
            rectangle2.grow(-1, -1);
        }
        if ((n & 0xC00) != 0) {
            colorArray2 = new Color[]{SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow};
            colorArray = new Color[]{SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight};
            n4 = ((n & 0x800) != 0 ? 2 : 0) | ((n3 & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.PaintFrame(graphics, rectangle2, n2, colorArray2[n4], colorArray[n4]);
            rectangle2.grow(-1, -1);
        }
        if ((n3 & 0x800) != 0) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        return true;
    }

    static void PaintFrame(Graphics graphics, Rectangle rectangle, int n, Color color, Color color2) {
        if ((n & 3) != 0) {
            graphics.setColor(color);
            if ((n & 1) != 0) {
                graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x, rectangle.y + rectangle.height - 1);
            }
            if ((n & 2) != 0) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            }
        }
        if ((n & 0xC) != 0) {
            graphics.setColor(color2);
            if ((n & 4) != 0) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
            if ((n & 8) != 0) {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
        }
    }

    static void PaintFrameC(Graphics graphics, Rectangle rectangle, int n, Color color, Color color2, Color color3) {
        if ((n & 3) != 0) {
            graphics.setColor(color);
            if ((n & 1) != 0) {
                graphics.drawLine(rectangle.x, rectangle.y + 1, 1, rectangle.y + rectangle.height - 1);
            }
            if ((n & 2) != 0) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
                graphics.setColor(color3);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            }
        }
        if ((n & 0xC) != 0) {
            graphics.setColor(color2);
            if ((n & 4) != 0) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
            if ((n & 8) != 0) {
                graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.width - 2, rectangle.y + rectangle.height - 1);
                graphics.setColor(color3);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
            }
        }
    }
}

