/*
 * Decompiled with CFR 0.152.
 */
package sTools;

public final class Parser {
    private int varcount;
    private String[] varname;
    private double[] varvalue;
    private double[] number;
    private String function = "";
    private String postfixcode = "";
    private boolean valid = false;
    private int error = 0;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private boolean radian;
    private static final int MAX_NUM = 100;
    private static final int NO_FUNCS = 25;
    private static final int NO_EXT_FUNCS = 4;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private static final double DEGTORAD = Math.PI / 180;
    private static final double LOG10 = Math.log(10.0);
    public static final int NO_ERROR = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int FUNC_OFFSET = 100;
    public static final int EXT_FUNC_OFFSET = 125;
    public static final int VAR_OFFSET = 200;
    public static final char PI_CODE = '\u00fd';
    public static final char E_CODE = '\u00fe';
    public static final char NUMERIC = '\u00ff';
    public static final char JUMP_CODE = '\u0001';
    public static final char LESS_THAN = '\u0002';
    public static final char GREATER_THAN = '\u0003';
    public static final char LESS_EQUAL = '\u0004';
    public static final char GREATER_EQUAL = '\u0005';
    public static final char NOT_EQUAL = '\u0006';
    public static final char EQUAL = '\u0007';
    public static final char IF_CODE = '\b';
    public static final char ENDIF = '\t';
    public static final char AND_CODE = '\n';
    public static final char OR_CODE = '\u000b';
    public static final char NOT_CODE = '\f';
    String[] funcname = new String[]{"sin", "cos", "tan", "ln", "log", "abs", "int", "frac", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ceil", "floor", "round", "exp", "sqr", "sqrt", "sign", "step"};
    String[] extfunc = new String[]{"min", "max", "mod", "atan2"};

    public Parser(int n) {
        this.varcount = n;
        this.varname = new String[n];
        this.varvalue = new double[n];
        this.number = new double[100];
        this.radian = true;
    }

    public void useRadian() {
        this.radian = true;
    }

    public void useDegree() {
        this.radian = false;
    }

    public int getErrorCode() {
        return this.error;
    }

    public int getErrorPosition() {
        if (this.error != 0) {
            return this.position;
        }
        return 0;
    }

    public String getErrorString() {
        String string = "";
        switch (this.error) {
            case 0: {
                string = "no error";
                break;
            }
            case 1: {
                string = "syntax error";
                break;
            }
            case 2: {
                string = "parenthesis expected";
                break;
            }
            case 3: {
                string = "uncompiled function";
                break;
            }
            case 4: {
                string = "expression expected";
                break;
            }
            case 5: {
                string = "unknown identifier";
                break;
            }
            case 6: {
                string = "operator expected";
                break;
            }
            case 7: {
                string = "parentheses not match";
                break;
            }
            case 8: {
                string = "internal code damaged";
                break;
            }
            case 9: {
                string = "execution stack overflow";
                break;
            }
            case 10: {
                string = "too many constants";
                break;
            }
            case 11: {
                string = "comma expected";
                break;
            }
            case 12: {
                string = "invalid operand type";
                break;
            }
            case 13: {
                string = "invalid operator";
            }
        }
        return string;
    }

    public void defineVariable(int n, String string) {
        if (n > this.varcount) {
            return;
        }
        this.varname[n - 1] = string;
    }

    public void setVariable(int n, double d) {
        if (n > this.varcount) {
            return;
        }
        this.varvalue[n - 1] = d;
    }

    public void setVariable(String string, double d) {
        for (int i = 0; i < this.varcount; ++i) {
            if (!this.varname[i].equals(string)) continue;
            this.varvalue[i] = d;
            break;
        }
    }

    private void skip_spaces() {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.error = 7;
            return;
        }
    }

    private void get_next_character() {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.error = 7;
            return;
        }
    }

    private void addcode(char c) {
        this.postfixcode = String.valueOf(this.postfixcode).concat(String.valueOf(c));
    }

    private void scan_number() {
        double d;
        String string = "";
        if (this.num == 100) {
            this.error = 10;
            return;
        }
        do {
            string = String.valueOf(string).concat(String.valueOf(this.character));
            this.get_next_character();
            if (this.error == 0) continue;
            return;
        } while (this.character >= '0' && this.character <= '9');
        if (this.character == '.') {
            do {
                string = String.valueOf(string).concat(String.valueOf(this.character));
                this.get_next_character();
                if (this.error == 0) continue;
                return;
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e') {
            string = String.valueOf(string).concat(String.valueOf(this.character));
            this.get_next_character();
            if (this.error != 0) {
                return;
            }
            if (this.character == '+' || this.character == '-') {
                string = String.valueOf(string).concat(String.valueOf(this.character));
                this.get_next_character();
                if (this.error != 0) {
                    return;
                }
            }
            while (this.character >= '0' && this.character <= '9') {
                string = String.valueOf(string).concat(String.valueOf(this.character));
                this.get_next_character();
                if (this.error == 0) continue;
                return;
            }
        }
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.error = 1;
            this.position = this.start;
            return;
        }
        this.number[this.num++] = d;
        this.addcode('\u00ff');
    }

    private void scan_variable_or_function() {
        String string = "";
        if (this.character == '*' || this.character == '/' || this.character == '^' || this.character == ')' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            this.error = 1;
            return;
        }
        do {
            string = String.valueOf(string).concat(String.valueOf(this.character));
            this.get_next_character();
            if (this.error == 0) continue;
            return;
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '^' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        if (string.equals("pi")) {
            this.addcode('\u00fd');
            return;
        }
        if (string.equals("e")) {
            this.addcode('\u00fe');
            return;
        }
        if (string.equals("if")) {
            this.skip_spaces();
            if (this.error != 0) {
                return;
            }
            if (this.character != '(') {
                this.error = 2;
                return;
            }
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ',') {
                this.error = 11;
                return;
            }
            this.addcode('\b');
            String string2 = new String(this.postfixcode);
            this.postfixcode = "";
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ',') {
                this.error = 11;
                return;
            }
            this.addcode('\u0001');
            string2 = String.valueOf(string2).concat(String.valueOf((char)(this.postfixcode.length() + 2)));
            string2 = String.valueOf(string2).concat(String.valueOf(this.postfixcode));
            this.postfixcode = "";
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ')') {
                this.error = 2;
                return;
            }
            string2 = String.valueOf(string2).concat(String.valueOf((char)(this.postfixcode.length() + 1)));
            string2 = String.valueOf(string2).concat(String.valueOf(this.postfixcode));
            this.postfixcode = new String(string2);
            this.get_next_character();
            if (this.error != 0) {
                return;
            }
            return;
        }
        for (int i = 0; i < 25; ++i) {
            if (!string.equals(this.funcname[i])) continue;
            this.skip_spaces();
            if (this.error != 0) {
                return;
            }
            if (this.character != '(') {
                this.error = 2;
                return;
            }
            this.scan_and_parse();
            if (this.error == 0) {
                if (this.character != ')') {
                    this.error = 2;
                    return;
                }
                this.get_next_character();
                if (this.error != 0) {
                    return;
                }
                this.addcode((char)(i + 100));
            }
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (!string.equals(this.extfunc[i])) continue;
            this.skip_spaces();
            if (this.error != 0) {
                return;
            }
            if (this.character != '(') {
                this.error = 2;
                return;
            }
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ',') {
                this.error = 11;
                return;
            }
            String string3 = new String(this.postfixcode);
            this.postfixcode = "";
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ')') {
                this.error = 2;
                return;
            }
            this.get_next_character();
            if (this.error != 0) {
                return;
            }
            string3 = String.valueOf(string3).concat(String.valueOf(this.postfixcode));
            this.postfixcode = new String(string3);
            this.addcode((char)(i + 125));
            return;
        }
        for (int i = 0; i < this.varcount; ++i) {
            if (!string.equals(this.varname[i])) continue;
            this.addcode((char)(i + 200));
            return;
        }
        this.error = 5;
        this.position = this.start;
    }

    private void getidentifier() {
        boolean bl = false;
        this.get_next_character();
        this.skip_spaces();
        if (this.error != 0) {
            return;
        }
        if (this.character == '!') {
            this.get_next_character();
            this.skip_spaces();
            if (this.error != 0) {
                return;
            }
            if (this.character != '(') {
                this.error = 2;
                return;
            }
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            if (this.character != ')') {
                this.error = 2;
                return;
            }
            if (!this.ISBOOLEAN) {
                this.error = 12;
                return;
            }
            this.addcode('\f');
            this.get_next_character();
            if (this.error != 0) {
                return;
            }
            return;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                bl = !bl;
            }
            this.get_next_character();
            this.skip_spaces();
            if (this.error == 0) continue;
            return;
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9') {
            this.scan_number();
        } else if (this.character == '(') {
            this.scan_and_parse();
            if (this.error != 0) {
                return;
            }
            this.get_next_character();
            if (this.error != 0) {
                return;
            }
        } else {
            this.scan_variable_or_function();
        }
        if (this.error != 0) {
            return;
        }
        this.skip_spaces();
        if (this.error != 0) {
            return;
        }
        if (bl) {
            this.addcode('_');
        }
    }

    private void level3() {
        int n = 0;
        if (this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        do {
            this.getidentifier();
            if (this.ISBOOLEAN && this.error == 0) {
                this.error = 12;
                return;
            }
            n = (byte)(n + 1);
        } while (this.character == '^');
        for (int i = 1; i <= n; ++i) {
            this.addcode('^');
        }
    }

    private void level2() {
        if (this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        do {
            char c = this.character;
            this.getidentifier();
            if (this.ISBOOLEAN && this.error == 0) {
                this.error = 12;
                return;
            }
            if (this.character == '^') {
                this.level3();
            }
            this.addcode(c);
        } while (this.character == '*' || this.character == '/');
    }

    private void level1() {
        if (this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        do {
            char c = this.character;
            this.getidentifier();
            if (this.ISBOOLEAN && this.error == 0) {
                this.error = 12;
                return;
            }
            if (this.character == '^') {
                this.level3();
            } else if (this.character == '*' || this.character == '/') {
                this.level2();
            }
            this.addcode(c);
        } while (this.character == '+' || this.character == '-');
    }

    private void relation_level() {
        int n = 0;
        if (this.INRELATION) {
            this.error = 13;
            return;
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        switch (this.character) {
            case '=': {
                n = 7;
                break;
            }
            case '<': {
                n = 2;
                this.get_next_character();
                if (this.error != 0) {
                    return;
                }
                if (this.character == '>') {
                    n = 6;
                    break;
                }
                if (this.character == '=') {
                    n = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                n = 3;
                this.get_next_character();
                if (this.error != 0) {
                    return;
                }
                if (this.character == '=') {
                    n = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scan_and_parse();
        this.INRELATION = false;
        if (this.error != 0) {
            return;
        }
        if (this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        this.addcode((char)n);
        this.ISBOOLEAN = true;
    }

    private void boolean_level() {
        if (!this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        char c = this.character;
        this.scan_and_parse();
        if (this.error != 0) {
            return;
        }
        if (!this.ISBOOLEAN) {
            this.error = 12;
            return;
        }
        switch (c) {
            case '&': {
                this.addcode('\n');
                break;
            }
            case '|': {
                this.addcode('\u000b');
            }
        }
    }

    private void scan_and_parse() {
        this.getidentifier();
        do {
            if (this.error != 0) continue;
            switch (this.character) {
                case '+': 
                case '-': {
                    this.level1();
                    break;
                }
                case '*': 
                case '/': {
                    this.level2();
                    break;
                }
                case '^': {
                    this.level3();
                    break;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '<': 
                case '=': 
                case '>': {
                    this.relation_level();
                    break;
                }
                case '&': 
                case '|': {
                    this.boolean_level();
                    break;
                }
                default: {
                    this.error = 6;
                }
            }
        } while (this.error == 0);
    }

    public void parse() {
        if (this.valid) {
            return;
        }
        this.position = 0;
        this.error = 0;
        this.num = 0;
        this.postfixcode = "";
        this.INRELATION = false;
        this.ISBOOLEAN = false;
        this.scan_and_parse();
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
        if (this.error == 1 && this.postfixcode == "") {
            this.error = 4;
        }
        this.valid = this.error == 0;
    }

    public void define(String string) {
        this.function = String.valueOf(string).concat(String.valueOf(")"));
        this.function.toLowerCase();
        this.valid = false;
    }

    private double built_in_function(int n, double d) {
        switch (n) {
            case 0: {
                if (this.radian) {
                    return Math.sin(d);
                }
                return Math.sin(d * (Math.PI / 180));
            }
            case 1: {
                if (this.radian) {
                    return Math.cos(d);
                }
                return Math.cos(d * (Math.PI / 180));
            }
            case 2: {
                if (this.radian) {
                    return Math.tan(d);
                }
                return Math.tan(d * (Math.PI / 180));
            }
            case 3: {
                return Math.log(d);
            }
            case 4: {
                return Math.log(d) / LOG10;
            }
            case 5: {
                return Math.abs(d);
            }
            case 6: {
                return Math.rint(d);
            }
            case 7: {
                return d - Math.rint(d);
            }
            case 8: {
                if (this.radian) {
                    return Math.asin(d);
                }
                return Math.asin(d) / (Math.PI / 180);
            }
            case 9: {
                if (this.radian) {
                    return Math.acos(d);
                }
                return Math.acos(d) / (Math.PI / 180);
            }
            case 10: {
                if (this.radian) {
                    return Math.atan(d);
                }
                return Math.atan(d) / (Math.PI / 180);
            }
            case 11: {
                return (Math.exp(d) - Math.exp(-d)) / (double)2;
            }
            case 12: {
                return (Math.exp(d) + Math.exp(-d)) / (double)2;
            }
            case 13: {
                double d2 = Math.exp(d);
                double d3 = Math.exp(-d);
                return (d2 - d3) / (d2 + d3);
            }
            case 14: {
                return Math.log(d + Math.sqrt(d * d + 1.0));
            }
            case 15: {
                return Math.log(d + Math.sqrt(d * d - 1.0));
            }
            case 16: {
                return Math.log((1.0 + d) / (1.0 - d)) / (double)2;
            }
            case 17: {
                return Math.ceil(d);
            }
            case 18: {
                return Math.floor(d);
            }
            case 19: {
                return Math.round(d);
            }
            case 20: {
                return Math.exp(d);
            }
            case 21: {
                return d * d;
            }
            case 22: {
                return Math.sqrt(d);
            }
            case 23: {
                if (d == 0.0) {
                    return 0.0;
                }
                if (d > 0.0) {
                    return 1.0;
                }
                return -1.0;
            }
            case 24: {
                if (d < 0.0) {
                    return 0.0;
                }
                return 1.0;
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double built_in_ext_function(int n, double d, double d2) {
        switch (n) {
            case 0: {
                return Math.min(d, d2);
            }
            case 1: {
                return Math.max(d, d2);
            }
            case 2: {
                return Math.IEEEremainder(d, d2);
            }
            case 3: {
                return Math.atan2(d, d2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    public double evaluate(double d, double d2) {
        if (this.varcount != 2) {
            return 0.0;
        }
        this.varvalue[0] = d;
        this.varvalue[1] = d2;
        return this.evaluate();
    }

    public double evaluate(double d) {
        if (this.varcount != 1) {
            return 0.0;
        }
        this.varvalue[0] = d;
        return this.evaluate();
    }

    public double evaluate() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        int n4 = this.postfixcode.length();
        block27: while (true) {
            char c;
            try {
                if (n2 == n4) {
                    double d = this.stack[0];
                    return d;
                }
                c = this.postfixcode.charAt(n2++);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                double d = this.stack[0];
                return d;
            }
            try {
                switch (c) {
                    case '+': {
                        int n5 = n - 1;
                        this.stack[n5] = this.stack[n5] + this.stack[n];
                        --n;
                        break;
                    }
                    case '-': {
                        int n6 = n - 1;
                        this.stack[n6] = this.stack[n6] - this.stack[n];
                        --n;
                        break;
                    }
                    case '*': {
                        int n7 = n - 1;
                        this.stack[n7] = this.stack[n7] * this.stack[n];
                        --n;
                        break;
                    }
                    case '/': {
                        int n8 = n - 1;
                        this.stack[n8] = this.stack[n8] / this.stack[n];
                        --n;
                        break;
                    }
                    case '^': {
                        this.stack[n - 1] = Math.pow(this.stack[n - 1], this.stack[n]);
                        --n;
                        break;
                    }
                    case '_': {
                        this.stack[n] = -this.stack[n];
                        break;
                    }
                    case '\u0001': {
                        int n9 = n2 + this.postfixcode.charAt(n2++);
                        while (true) {
                            if (n2 >= n9) continue block27;
                            if (this.postfixcode.charAt(n2++) != '\u00ff') continue;
                            ++n3;
                        }
                    }
                    case '\u0002': {
                        double d = this.stack[--n] < this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\u0003': {
                        double d = this.stack[--n] > this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\u0004': {
                        double d = this.stack[--n] <= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\u0005': {
                        double d = this.stack[--n] >= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\u0007': {
                        double d = this.stack[--n] == this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\u0006': {
                        double d = this.stack[--n] != this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        break;
                    }
                    case '\b': {
                        int n9;
                        if (this.stack[n--] == 0.0) {
                            n9 = n2 + this.postfixcode.charAt(n2++);
                            while (true) {
                                if (n2 >= n9) continue block27;
                                if (this.postfixcode.charAt(n2++) != '\u00ff') continue;
                                ++n3;
                            }
                        }
                        ++n2;
                        break;
                    }
                    case '\t': {
                        break;
                    }
                    case '\n': {
                        if (this.stack[--n] != 0.0 && this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            break;
                        }
                        this.stack[n] = 0.0;
                        break;
                    }
                    case '\u000b': {
                        if (this.stack[--n] != 0.0 || this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            break;
                        }
                        this.stack[n] = 0.0;
                        break;
                    }
                    case '\f': {
                        this.stack[n] = this.stack[n] == 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case '\u00ff': {
                        this.stack[++n] = this.number[n3++];
                        break;
                    }
                    case '\u00fd': {
                        this.stack[++n] = Math.PI;
                        break;
                    }
                    case '\u00fe': {
                        this.stack[++n] = Math.E;
                        break;
                    }
                    default: {
                        if (c >= '\u00c8') {
                            this.stack[++n] = this.varvalue[c - 200];
                            break;
                        }
                        if (c >= '}') {
                            this.stack[n - 1] = this.built_in_ext_function(c - 125, this.stack[n - 1], this.stack[n]);
                            --n;
                            break;
                        }
                        if (c >= 'd') {
                            this.stack[n] = this.built_in_function(c - 100, this.stack[n]);
                            break;
                        }
                        this.error = 8;
                        double d = Double.NaN;
                        return d;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error = 9;
                double d = Double.NaN;
                return d;
            }
        }
    }

    public void debug() {
        int n = 0;
        int n2 = 0;
        String string = "";
        if (!this.valid) {
            this.error = 3;
            return;
        }
        block24: while (true) {
            char c;
            try {
                c = this.postfixcode.charAt(n++);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.out.println(string);
                return;
            }
            switch (c) {
                case '+': {
                    string = String.valueOf(string).concat(String.valueOf("+ "));
                    continue block24;
                }
                case '-': {
                    string = String.valueOf(string).concat(String.valueOf("- "));
                    continue block24;
                }
                case '*': {
                    string = String.valueOf(string).concat(String.valueOf("* "));
                    continue block24;
                }
                case '/': {
                    string = String.valueOf(string).concat(String.valueOf("/ "));
                    continue block24;
                }
                case '^': {
                    string = String.valueOf(string).concat(String.valueOf("^ "));
                    continue block24;
                }
                case '_': {
                    string = String.valueOf(string).concat(String.valueOf("_ "));
                    continue block24;
                }
                case '\u0001': {
                    string = String.valueOf(string).concat(String.valueOf("JMP "));
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf((int)this.postfixcode.charAt(n++))));
                    string = String.valueOf(string).concat(String.valueOf(" "));
                    continue block24;
                }
                case '\u0002': {
                    string = String.valueOf(string).concat(String.valueOf("LT "));
                    continue block24;
                }
                case '\u0003': {
                    string = String.valueOf(string).concat(String.valueOf("GT "));
                    continue block24;
                }
                case '\u0004': {
                    string = String.valueOf(string).concat(String.valueOf("LE "));
                    continue block24;
                }
                case '\u0007': {
                    string = String.valueOf(string).concat(String.valueOf("EQ "));
                    continue block24;
                }
                case '\u0006': {
                    string = String.valueOf(string).concat(String.valueOf("NE "));
                    continue block24;
                }
                case '\b': {
                    string = String.valueOf(string).concat(String.valueOf("IF "));
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf((int)this.postfixcode.charAt(n++))));
                    string = String.valueOf(string).concat(String.valueOf(" "));
                    continue block24;
                }
                case '\t': {
                    string = String.valueOf(string).concat(String.valueOf("EI "));
                    continue block24;
                }
                case '\n': {
                    string = String.valueOf(string).concat(String.valueOf("& "));
                    continue block24;
                }
                case '\u000b': {
                    string = String.valueOf(string).concat(String.valueOf("| "));
                    continue block24;
                }
                case '\f': {
                    string = String.valueOf(string).concat(String.valueOf("! "));
                    continue block24;
                }
                case '\u00ff': {
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf(this.number[n2++])));
                    string = String.valueOf(string).concat(String.valueOf(" "));
                    continue block24;
                }
                case '\u00fd': {
                    string = String.valueOf(string).concat(String.valueOf("pi "));
                    continue block24;
                }
                case '\u00fe': {
                    string = String.valueOf(string).concat(String.valueOf("e "));
                    continue block24;
                }
            }
            if (c >= '}') {
                string = "xf ";
                continue;
            }
            string = "f";
        }
    }
}

