/*
 * Decompiled with CFR 0.152.
 */
package sTools;

import borland.jbcl.util.BlackBox;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;
import java.util.Vector;
import sTools.graph.Axis;
import sTools.graph.DataSet;
import sTools.graph.Graph2D;
import sTools.graph.Markers;

public class SGraph
extends Graph2D
implements BlackBox {
    Axis xaxis;
    Axis yaxis;
    int[] borders = new int[]{0, 10, 10, 0};
    private boolean sampleData = true;
    private Vector dataSetSeries = new Vector();
    private double[] dPoint = new double[2];
    private DataSet defaultData = null;
    private String labelX = "X Axis";
    private String labelY = "Y Axis";

    public SGraph() {
        this.buildMarkers(4);
        this.drawzero = false;
        this.drawgrid = false;
        this.borderLeft = this.borders[0];
        this.borderTop = this.borders[1];
        this.borderRight = this.borders[2];
        this.borderBottom = this.borders[3];
        this.xaxis = this.createAxis(5);
        this.xaxis.setTitleColor(Color.black);
        this.xaxis.setLabelColor(Color.black);
        this.xaxis.setTitleText(this.labelX);
        this.xaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.xaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.yaxis = this.createAxis(2);
        this.yaxis.setTitleColor(Color.black);
        this.yaxis.setLabelColor(Color.black);
        this.yaxis.setTitleText(this.labelY);
        this.yaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.yaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.makeSampleData(100);
    }

    public void setSampleData(boolean bl) {
        if (bl == this.sampleData) {
            return;
        }
        this.sampleData = bl;
        this.repaint();
    }

    public boolean isSampleData() {
        return this.sampleData;
    }

    public void setDrawGrid(boolean bl) {
        if (bl == this.drawgrid) {
            return;
        }
        this.drawgrid = bl;
        this.repaint();
    }

    public boolean isDrawGrid() {
        return this.drawgrid;
    }

    public void setAutoscaleX(boolean bl) {
        if (!bl == this.xaxis.isManualRange()) {
            return;
        }
        this.xaxis.setManualRange(!bl);
        this.repaint();
    }

    public boolean isAutoscaleX() {
        return !this.xaxis.isManualRange();
    }

    public void setAutoscaleY(boolean bl) {
        if (!bl == this.yaxis.isManualRange()) {
            return;
        }
        this.yaxis.setManualRange(!bl);
        this.repaint();
    }

    public boolean isAutoscaleY() {
        return !this.yaxis.isManualRange();
    }

    public void setDrawZero(boolean bl) {
        if (bl == this.drawzero) {
            return;
        }
        this.drawzero = bl;
        this.repaint();
    }

    public boolean isDrawZero() {
        return this.drawzero;
    }

    public synchronized void setSeriesStyle(int n, Color color, boolean bl, int n2) {
        DataSet dataSet;
        Series series = null;
        boolean bl2 = false;
        int n3 = this.dataSetSeries.size();
        for (int i = 0; i < n3; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.access$071()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            dataSet = new DataSet();
            this.dataSetSeries.addElement(new Series(n, dataSet));
        } else {
            dataSet = series.access$171();
        }
        dataSet.linestyle = bl ? 1 : 0;
        dataSet.marker = n2;
        dataSet.markercolor = color;
        dataSet.linecolor = color;
        this.repaint();
    }

    public String getBorders() {
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.borders[0]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[1]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[2]))).concat(String.valueOf(','))).concat(String.valueOf(this.borders[3]));
        return string;
    }

    public void setBorders(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    this.borders[i] = Integer.parseInt(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.borderLeft = this.borders[0];
            this.borderTop = this.borders[1];
            this.borderRight = this.borders[2];
            this.borderBottom = this.borders[3];
            this.repaint();
        } else {
            this.borders[0] = this.borderLeft;
            this.borders[1] = this.borderTop;
            this.borders[2] = this.borderRight;
            this.borders[3] = this.borderBottom;
        }
    }

    public void setLabelX(String string) {
        this.xaxis.setTitleColor(Color.black);
        this.xaxis.setTitleText(string);
        this.labelY = string;
        this.repaint();
    }

    public void setLabelX(String string, Color color) {
        this.xaxis.setTitleColor(color);
        this.xaxis.setTitleText(string);
        this.labelY = string;
        this.repaint();
    }

    public String getLabelX() {
        return this.labelX;
    }

    public void setLabelY(String string) {
        this.yaxis.setTitleColor(Color.black);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        this.repaint();
    }

    public void setLabelY(String string, Color color) {
        this.yaxis.setTitleColor(color);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        this.repaint();
    }

    public String getLabelY() {
        return this.labelY;
    }

    public void setMinMaxX(double d, double d2) {
        if (this.xaxis.isManualRange()) {
            this.xaxis.setManualRange(true, d, d2);
        } else {
            this.xaxis.resetRange();
        }
        this.repaint();
    }

    public void setMinMaxY(double d, double d2) {
        if (this.yaxis.isManualRange()) {
            this.yaxis.setManualRange(true, d, d2);
        } else {
            this.yaxis.resetRange();
        }
        this.repaint();
    }

    public void deleteAllSeries() {
        this.dataSetSeries.removeAllElements();
        this.detachDataSets();
        this.defaultData = null;
        this.makeDefaultData();
        this.repaint();
    }

    public void deleteSeries(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.access$071()) continue;
            this.dataSetSeries.removeElement(series);
            this.detachDataSet(series.access$171());
            break;
        }
        if (this.dataSetSeries.size() == 0) {
            this.detachDataSets();
            this.defaultData = null;
            this.makeDefaultData();
        }
        this.repaint();
    }

    public void clearSeriesData(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.access$071()) continue;
            this.dataSetSeries.removeElement(series);
            series.access$171().deleteData();
            break;
        }
        this.repaint();
    }

    public int pixFromX(double d) {
        return this.xaxis.getInteger(d);
    }

    public int pixFromY(double d) {
        return this.yaxis.getInteger(d);
    }

    public double xFromPix(int n) {
        return this.xaxis.getDouble(n);
    }

    public double yFromPix(int n) {
        return this.yaxis.getDouble(n);
    }

    public synchronized void addDatum(int n, double d, double d2) {
        Series series = null;
        boolean bl = false;
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.access$071()) continue;
            bl = true;
            break;
        }
        this.dPoint[0] = d;
        this.dPoint[1] = d2;
        if (!bl) {
            this.attachArray(n, this.dPoint);
        } else {
            try {
                series.access$171().append(this.dPoint, 1);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        this.repaint();
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            return;
        }
        this.addData(n, dArray, dArray2, dArray.length);
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2, int n2) {
        int n3;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || n2 == 0) {
            return;
        }
        int n4 = dArray.length;
        if (n4 > n2) {
            n4 = n2;
        }
        Series series = null;
        boolean bl = false;
        int n5 = this.dataSetSeries.size();
        for (n3 = 0; n3 < n5; ++n3) {
            series = (Series)this.dataSetSeries.elementAt(n3);
            if (n != series.access$071()) continue;
            bl = true;
            break;
        }
        double[] dArray3 = new double[2 * n4];
        int n6 = 0;
        n3 = 0;
        while (n3 < n4) {
            dArray3[n6] = dArray[n3];
            dArray3[n6 + 1] = dArray2[n3];
            ++n3;
            n6 += 2;
        }
        if (!bl) {
            this.attachArray(n, dArray3);
        } else {
            try {
                series.access$171().append(dArray3, 1);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        this.repaint();
    }

    private DataSet attachArray(int n, double[] dArray) {
        if (dArray.length < 2) {
            return null;
        }
        int n2 = dArray.length / 2;
        DataSet dataSet = this.loadDataSet(dArray, n2);
        dataSet.linestyle = 1;
        dataSet.marker = 1;
        dataSet.markerscale = 1.0;
        dataSet.markercolor = new Color(0, 0, 255);
        dataSet.linecolor = new Color(0, 0, 255);
        dataSet.legendColor(Color.black);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        this.dataSetSeries.addElement(new Series(n, dataSet));
        this.removeDefaultData();
        this.repaint();
        return dataSet;
    }

    private void makeDefaultData() {
        if (this.defaultData != null) {
            return;
        }
        double[] dArray = new double[]{0.0, 0.0};
        this.defaultData = this.loadDataSet(dArray, 1);
        this.xaxis.attachDataSet(this.defaultData);
        this.yaxis.attachDataSet(this.defaultData);
    }

    private void removeDefaultData() {
        if (this.defaultData == null) {
            return;
        }
        this.detachDataSet(this.defaultData);
        this.defaultData = null;
    }

    private void makeSampleData(int n) {
        double[] dArray = new double[2 * n];
        int n2 = 0;
        int n3 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < n) {
            dArray[n3] = n3 - n;
            dArray[n3 + 1] = (double)60000 * Math.pow(dArray[n3] / (double)(n - 2), 2.0);
            ++n2;
            n3 += 2;
        }
        DataSet dataSet = this.attachArray(1, dArray);
        dataSet.legend(200, 100, "sample data");
    }

    private void buildMarkers(int n) {
        Markers markers = new Markers();
        this.setMarkers(markers);
        boolean[] blArray = new boolean[5];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = false;
        blArray[3] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray2[0] = n;
        nArray2[1] = -n;
        nArray2[2] = n;
        nArray2[3] = -n;
        markers.AddMarker(1, 4, blArray, nArray, nArray2);
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray[4] = n;
        nArray2[0] = n;
        nArray2[1] = n;
        nArray2[2] = -n;
        nArray2[3] = -n;
        nArray2[4] = n;
        markers.AddMarker(2, 5, blArray, nArray, nArray2);
    }

    class Series {
        private DataSet data;
        private int id;

        public Series(int n, DataSet dataSet) {
            this.id = n;
            this.data = dataSet;
        }

        final /* synthetic */ int access$071() {
            return this.id;
        }

        final /* synthetic */ DataSet access$171() {
            return this.data;
        }
    }
}

