/*
 * Decompiled with CFR 0.152.
 */
package sTools.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import sTools.graph.Axis;
import sTools.graph.Graph2D;
import sTools.graph.Markers;
import sTools.graph.TextLine;

public class DataSet {
    public static final int NOLINE = 0;
    public static final int LINE = 1;
    public Graph2D g2d;
    public int linestyle = 1;
    public Color linecolor = null;
    public int marker = 0;
    public Color markercolor = null;
    public double markerscale = 1.0;
    public Axis xaxis;
    public Axis yaxis;
    public double xmax;
    public double xmin;
    public double ymax;
    public double ymin;
    public boolean clipping = true;
    protected double dxmax;
    protected double dxmin;
    protected double dymax;
    protected double dymin;
    protected double[] data;
    protected int length;
    protected double xrange;
    protected double yrange;
    protected int legend_length = 20;
    protected TextLine legend_text = null;
    protected int legend_ix;
    protected int legend_iy;
    protected double legend_dx;
    protected double legend_dy;
    protected int increment = 100;
    protected int stride = 2;

    public DataSet() {
        this.length = 0;
        this.range(this.stride);
    }

    public DataSet(int stride) throws Exception {
        if (stride < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        this.stride = stride;
        this.length = 0;
        this.range(stride);
    }

    public DataSet(double[] d, int n) throws Exception {
        boolean k = false;
        this.length = 0;
        if (d == null || d.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        System.arraycopy(d, 0, this.data, 0, this.length);
        this.range(this.stride);
    }

    public DataSet(double[] d, int n, int s) throws Exception {
        if (s < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        boolean k = false;
        this.length = 0;
        if (d == null || d.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        this.stride = s;
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        System.arraycopy(d, 0, this.data, 0, this.length);
        this.range(this.stride);
    }

    public void append(double[] d, int n) throws Exception {
        block6: {
            boolean k = false;
            int ln = n * this.stride;
            if (d == null || d.length == 0 || n <= 0) {
                throw new Exception("DataSet: Error in append data!");
            }
            if (this.data == null) {
                this.data = new double[this.increment];
            }
            if (ln + this.length < this.data.length) {
                System.arraycopy(d, 0, this.data, this.length, ln);
                this.length += ln;
            } else {
                double[] tmp = new double[ln + this.length + this.increment];
                if (this.length != 0) {
                    System.arraycopy(this.data, 0, tmp, 0, this.length);
                }
                System.arraycopy(d, 0, tmp, this.length, ln);
                this.length += ln;
                this.data = tmp;
            }
            this.range(this.stride);
            if (this.xaxis != null) {
                this.xaxis.resetRange();
            }
            if (this.yaxis == null) break block6;
            this.yaxis.resetRange();
        }
    }

    public void delete(int start, int end) {
        int End = this.stride * end;
        int Start = this.stride * start;
        if (this.length <= 0) {
            return;
        }
        if (End < Start) {
            return;
        }
        if (Start < 0) {
            Start = 0;
        }
        if (End > this.length - this.stride) {
            End = this.length - this.stride;
        }
        if (End < this.length - this.stride) {
            System.arraycopy(this.data, End + this.stride, this.data, Start, this.length - End - this.stride);
        }
        this.length -= End + this.stride - Start;
        this.range(this.stride);
    }

    public void deleteData() {
        this.length = 0;
        this.data = null;
        this.range(this.stride);
    }

    public void draw_data(Graphics g, Rectangle bounds) {
        if (this.xaxis != null) {
            this.xmax = this.xaxis.maximum;
            this.xmin = this.xaxis.minimum;
        }
        if (this.yaxis != null) {
            this.ymax = this.yaxis.maximum;
            this.ymin = this.yaxis.minimum;
        }
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        this.draw_legend(g, bounds);
        if (this.clipping) {
            g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        Color c = g.getColor();
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                g.setColor(this.linecolor);
            } else {
                g.setColor(c);
            }
            this.draw_lines(g, bounds);
        }
        if (this.marker > 0) {
            if (this.markercolor != null) {
                g.setColor(this.markercolor);
            } else {
                g.setColor(c);
            }
            this.draw_markers(g, bounds);
        }
        g.setColor(c);
    }

    public double getXmax() {
        return this.dxmax;
    }

    public double getXmin() {
        return this.dxmin;
    }

    public double getYmax() {
        return this.dymax;
    }

    public double getYmin() {
        return this.dymin;
    }

    public void legend(int x, int y, String text) {
        if (text == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(text);
        } else {
            this.legend_text.setText(text);
        }
        this.legend_text.setJustification(1);
        this.legend_ix = x;
        this.legend_iy = y;
        this.legend_dx = 0.0;
        this.legend_dy = 0.0;
    }

    public void legend(double x, double y, String text) {
        if (text == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(text);
        } else {
            this.legend_text.setText(text);
        }
        this.legend_text.setJustification(1);
        this.legend_dx = x;
        this.legend_dy = y;
        this.legend_ix = 0;
        this.legend_iy = 0;
    }

    public void legendFont(Font f) {
        if (f == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setFont(f);
    }

    public void legendColor(Color c) {
        if (c == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setColor(c);
    }

    public int dataPoints() {
        return this.length / this.stride;
    }

    public double[] getPoint(int index) {
        double[] point = new double[this.stride];
        int i = index * this.stride;
        if (index < 0 || i > this.length - this.stride) {
            return null;
        }
        for (int j = 0; j < this.stride; ++j) {
            point[j] = this.data[i + j];
        }
        return point;
    }

    public double[] getClosestPoint(double x, double y) {
        double[] point = new double[]{0.0, 0.0, 0.0};
        double xdiff = this.data[0] - x;
        double ydiff = this.data[1] - y;
        point[0] = this.data[0];
        point[1] = this.data[1];
        point[2] = xdiff * xdiff + ydiff * ydiff;
        for (int i = this.stride; i < this.length - 1; i += this.stride) {
            xdiff = this.data[i] - x;
            ydiff = this.data[i + 1] - y;
            double dist2 = xdiff * xdiff + ydiff * ydiff;
            if (!(dist2 < point[2])) continue;
            point[0] = this.data[i];
            point[1] = this.data[i + 1];
            point[2] = dist2;
        }
        return point;
    }

    protected void draw_lines(Graphics g, Rectangle w) {
        boolean inside0 = false;
        boolean inside1 = false;
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        Rectangle clip = g.getClipBounds();
        int xcmin = clip.x;
        int xcmax = clip.x + clip.width;
        int ycmin = clip.y;
        int ycmax = clip.y + clip.height;
        if (this.data == null || this.data.length < this.stride) {
            return;
        }
        inside0 = this.inside(this.data[0], this.data[1]);
        if (inside0) {
            x0 = (int)((double)w.x + (this.data[0] - this.xmin) / this.xrange * (double)w.width);
            y0 = (int)((double)w.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)w.height);
            if (x0 < xcmin || x0 > xcmax || y0 < ycmin || y0 > ycmax) {
                inside0 = false;
            }
        }
        for (int i = this.stride; i < this.length; i += this.stride) {
            inside1 = this.inside(this.data[i], this.data[i + 1]);
            if (inside1 || inside0) {
                x1 = (int)((double)w.x + (this.data[i] - this.xmin) / this.xrange * (double)w.width);
                y1 = (int)((double)w.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)w.height);
                if (x1 < xcmin || x1 > xcmax || y1 < ycmin || y1 > ycmax) {
                    inside1 = false;
                }
            }
            if (!inside0 && inside1) {
                x0 = (int)((double)w.x + (this.data[i - this.stride] - this.xmin) / this.xrange * (double)w.width);
                y0 = (int)((double)w.y + (1.0 - (this.data[i - this.stride + 1] - this.ymin) / this.yrange) * (double)w.height);
            }
            if (inside0 || inside1) {
                g.drawLine(x0, y0, x1, y1);
            }
            inside0 = inside1;
            x0 = x1;
            y0 = y1;
        }
    }

    protected boolean inside(double x, double y) {
        return x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax;
    }

    protected void draw_markers(Graphics g, Rectangle w) {
        Rectangle clip = g.getClipBounds();
        int xcmin = clip.x;
        int xcmax = clip.x + clip.width;
        int ycmin = clip.y;
        int ycmax = clip.y + clip.height;
        Markers m = this.g2d.getMarkers();
        if (m == null) {
            return;
        }
        for (int i = 0; i < this.length; i += this.stride) {
            if (!this.inside(this.data[i], this.data[i + 1])) continue;
            int x1 = (int)((double)w.x + (this.data[i] - this.xmin) / this.xrange * (double)w.width);
            int y1 = (int)((double)w.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)w.height);
            if (x1 < xcmin || x1 > xcmax || y1 < ycmin || y1 > ycmax) continue;
            m.draw(g, this.marker, this.markerscale, x1, y1);
        }
    }

    protected void draw_legend(Graphics g, Rectangle w) {
        Color c = g.getColor();
        Markers m = null;
        if (this.legend_text == null) {
            return;
        }
        if (this.legend_text.isNull()) {
            return;
        }
        if (this.legend_ix == 0 && this.legend_iy == 0) {
            this.legend_ix = (int)((double)w.x + (this.legend_dx - this.xmin) / this.xrange * (double)w.width);
            this.legend_iy = (int)((double)w.y + (1.0 - (this.legend_dy - this.ymin) / this.yrange) * (double)w.height);
        }
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                g.setColor(this.linecolor);
            }
            g.drawLine(this.legend_ix, this.legend_iy, this.legend_ix + this.legend_length, this.legend_iy);
        }
        if (this.marker > 0 && (m = this.g2d.getMarkers()) != null) {
            if (this.markercolor != null) {
                g.setColor(this.markercolor);
            } else {
                g.setColor(c);
            }
            m.draw(g, this.marker, 1.0, this.legend_ix + this.legend_length / 2, this.legend_iy);
        }
        this.legend_text.draw(g, this.legend_ix + this.legend_length + this.legend_text.charWidth(g, ' '), this.legend_iy + this.legend_text.getAscent(g) / 3);
        g.setColor(c);
    }

    protected void range(int stride) {
        if (this.length >= stride) {
            this.dxmax = this.data[0];
            this.dymax = this.data[1];
            this.dxmin = this.dxmax;
            this.dymin = this.dymax;
        } else {
            this.dxmin = 0.0;
            this.dxmax = 0.0;
            this.dymin = 0.0;
            this.dymax = 0.0;
        }
        for (int i = stride; i < this.length; i += stride) {
            if (this.dxmax < this.data[i]) {
                this.dxmax = this.data[i];
            } else if (this.dxmin > this.data[i]) {
                this.dxmin = this.data[i];
            }
            if (this.dymax < this.data[i + 1]) {
                this.dymax = this.data[i + 1];
                continue;
            }
            if (!(this.dymin > this.data[i + 1])) continue;
            this.dymin = this.data[i + 1];
        }
        if (this.xaxis == null) {
            this.xmin = this.dxmin;
            this.xmax = this.dxmax;
        }
        if (this.yaxis == null) {
            this.ymin = this.dymin;
            this.ymax = this.dymax;
        }
    }
}

