/*
 * Decompiled with CFR 0.152.
 */
package sTools.graph;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import sTools.graph.Axis;
import sTools.graph.DataSet;
import sTools.graph.LoadMessage;
import sTools.graph.Markers;
import sTools.graph.TextLine;

public class Graph2D
extends Canvas {
    private boolean showAxis = true;
    private Color DefaultBackground = null;
    protected Vector axis = new Vector(4);
    protected Vector dataset = new Vector(10);
    protected Markers markers = null;
    protected LoadMessage load_thread = null;
    protected Color DataBackground = null;
    public int loadingData = 0;
    public int borderTop = 20;
    public int borderBottom = 20;
    public int borderLeft = 20;
    public int borderRight = 20;
    public boolean frame = true;
    public Color framecolor;
    public boolean drawgrid = true;
    public Color gridcolor = Color.pink;
    public boolean drawzero = true;
    public Color zerocolor = Color.orange;
    public Rectangle datarect = new Rectangle();
    public boolean clearAll = true;
    public boolean paintAll = true;
    public boolean square = false;
    public TextLine lastText = null;

    public final boolean isShowAxis() {
        return this.showAxis;
    }

    public final void setShowAxis(boolean sa) {
        this.showAxis = sa;
    }

    public DataSet loadFile(URL file) {
        byte[] b = new byte[50];
        int nbytes = 0;
        int max = 100;
        int inc = 100;
        int n = 0;
        double[] data = new double[max];
        InputStream is = null;
        boolean comment = false;
        try {
            int c;
            is = file.openStream();
            block9: while ((c = is.read()) > -1) {
                switch (c) {
                    case 35: {
                        comment = true;
                        break;
                    }
                    case 10: 
                    case 13: {
                        comment = false;
                    }
                    case 9: 
                    case 32: {
                        if (nbytes <= false) continue block9;
                        String s = new String(b, 0, nbytes);
                        data[n] = Double.valueOf(s);
                        if (++n >= max) {
                            double[] d = new double[max += inc];
                            System.arraycopy(data, 0, d, 0, n);
                            data = d;
                        }
                        nbytes = 0;
                        break;
                    }
                    default: {
                        if (comment) continue block9;
                        b[nbytes] = (byte)c;
                        ++nbytes;
                        break;
                    }
                }
            }
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println("Mouse Released.");
            e.printStackTrace();
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ev) {
                    // empty catch block
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        return this.loadDataSet(data, n / 2);
    }

    public DataSet loadDataSet(double[] data, int n) {
        DataSet d;
        try {
            d = new DataSet(data, n);
            this.dataset.addElement(d);
            d.g2d = this;
        }
        catch (Exception e) {
            System.out.println("Failed to load Data set ");
            e.printStackTrace();
            DataSet dataSet = null;
            return dataSet;
        }
        return d;
    }

    public void attachDataSet(DataSet d) {
        if (d != null) {
            this.dataset.addElement(d);
            d.g2d = this;
        }
    }

    public void detachDataSet(DataSet d) {
        if (d != null) {
            if (d.xaxis != null) {
                d.xaxis.detachDataSet(d);
            }
            if (d.yaxis != null) {
                d.yaxis.detachDataSet(d);
            }
            this.dataset.removeElement(d);
        }
    }

    public void detachDataSets() {
        if (this.dataset == null | this.dataset.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet d = (DataSet)this.dataset.elementAt(i);
            if (d.xaxis != null) {
                d.xaxis.detachDataSet(d);
            }
            if (d.yaxis == null) continue;
            d.yaxis.detachDataSet(d);
        }
        this.dataset.removeAllElements();
    }

    public Axis createAxis(int position) {
        Axis a;
        try {
            a = new Axis(position);
            a.g2d = this;
            this.axis.addElement(a);
        }
        catch (Exception e) {
            System.out.println("Failed to create Axis");
            e.printStackTrace();
            Axis axis = null;
            return axis;
        }
        return a;
    }

    public void attachAxis(Axis a) {
        if (a == null) {
            return;
        }
        try {
            this.axis.addElement(a);
            a.g2d = this;
        }
        catch (Exception e) {
            System.out.println("Failed to attach Axis");
            e.printStackTrace();
        }
    }

    public void detachAxis(Axis a) {
        if (a != null) {
            a.detachAll();
            a.g2d = null;
            this.axis.removeElement(a);
        }
    }

    public void detachAxes() {
        if (this.axis == null | this.axis.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.axis.size(); ++i) {
            ((Axis)this.axis.elementAt(i)).detachAll();
            ((Axis)this.axis.elementAt((int)i)).g2d = null;
        }
        this.axis.removeAllElements();
    }

    public double getXmax() {
        double max = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return max;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet d = (DataSet)this.dataset.elementAt(i);
            max = i == 0 ? d.getXmax() : Math.max(max, d.getXmax());
        }
        return max;
    }

    public double getYmax() {
        double max = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return max;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet d = (DataSet)this.dataset.elementAt(i);
            max = i == 0 ? d.getYmax() : Math.max(max, d.getYmax());
        }
        return max;
    }

    public double getXmin() {
        double min = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return min;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet d = (DataSet)this.dataset.elementAt(i);
            min = i == 0 ? d.getXmin() : Math.min(min, d.getXmin());
        }
        return min;
    }

    public double getYmin() {
        double min = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return min;
        }
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet d = (DataSet)this.dataset.elementAt(i);
            min = i == 0 ? d.getYmin() : Math.min(min, d.getYmin());
        }
        return min;
    }

    public void setMarkers(Markers m) {
        this.markers = m;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public void setGraphBackground(Color c) {
        if (c == null) {
            return;
        }
        this.setBackground(c);
    }

    public void setDataBackground(Color c) {
        if (c == null) {
            return;
        }
        this.DataBackground = c;
    }

    public void paint(Graphics g) {
        Rectangle r = this.getBounds();
        this.paint(g, r);
    }

    public void paint(Graphics g, Rectangle r) {
        Graphics lg = g.create();
        r.x = 0;
        r.y = 0;
        if (this.DefaultBackground == null) {
            this.DefaultBackground = this.getBackground();
        }
        if (this.DataBackground == null) {
            this.DataBackground = this.getBackground();
        }
        if (!this.paintAll) {
            return;
        }
        r.x += this.borderLeft;
        r.y += this.borderTop;
        r.width -= this.borderLeft + this.borderRight;
        r.height -= this.borderBottom + this.borderTop;
        this.paintFirst(lg, r);
        if (!this.axis.isEmpty()) {
            r = this.drawAxis(lg, r);
        } else {
            if (this.clearAll) {
                Color c = g.getColor();
                g.setColor(this.DataBackground);
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(c);
            }
            this.drawFrame(lg, r.x, r.y, r.width, r.height);
        }
        this.paintBeforeData(lg, r);
        if (!this.dataset.isEmpty()) {
            this.datarect.x = r.x;
            this.datarect.y = r.y;
            this.datarect.width = r.width;
            this.datarect.height = r.height;
            for (int i = 0; i < this.dataset.size(); ++i) {
                ((DataSet)this.dataset.elementAt(i)).draw_data(lg, r);
            }
        }
        this.paintLast(lg, r);
        lg.dispose();
    }

    public void paintFirst(Graphics g, Rectangle r) {
    }

    public void paintBeforeData(Graphics g, Rectangle r) {
    }

    public void paintLast(Graphics g, Rectangle r) {
        if (this.lastText != null) {
            this.lastText.draw(g, r.width / 2, r.height / 2, 0);
        }
    }

    public void update(Graphics g) {
        if (this.clearAll) {
            Color c = g.getColor();
            Rectangle r = this.getBounds();
            r.x = 0;
            r.y = 0;
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
        }
        if (this.paintAll) {
            this.paint(g);
        }
    }

    public void startedloading() {
        ++this.loadingData;
        if (this.loadingData != 1) {
            return;
        }
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setFont(new Font("Helvetica", 0, 25));
        this.load_thread.begin();
    }

    public void finishedloading() {
        --this.loadingData;
        if (this.loadingData > 0) {
            return;
        }
        if (this.load_thread != null) {
            this.load_thread.end();
        }
        this.load_thread = null;
    }

    public void loadmessage(String s) {
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setMessage(s);
    }

    protected Rectangle ForceSquare(Graphics g, Rectangle r) {
        double range;
        Axis a;
        int x = r.x;
        int y = r.y;
        int width = r.width;
        int height = r.height;
        double xrange = 0.0;
        double yrange = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return r;
        }
        for (int i = 0; i < this.axis.size(); ++i) {
            a = (Axis)this.axis.elementAt(i);
            range = a.maximum - a.minimum;
            if (a.isVertical()) {
                yrange = Math.max(range, yrange);
                continue;
            }
            xrange = Math.max(range, xrange);
        }
        if (xrange <= 0.0 | yrange <= 0.0) {
            return r;
        }
        range = xrange > yrange ? xrange : yrange;
        for (int i = 0; i < this.axis.size(); ++i) {
            a = (Axis)this.axis.elementAt(i);
            a.maximum = a.minimum + range;
        }
        Rectangle dr = this.getDataRectangle(g, r);
        if (dr.width > dr.height) {
            x += (int)((double)(dr.width - dr.height) / 2.0);
            width -= dr.width - dr.height;
        } else {
            y += (int)((double)(dr.height - dr.width) / 2.0);
            height -= dr.height - dr.width;
        }
        return new Rectangle(x, y, width, height);
    }

    protected Rectangle getDataRectangle(Graphics g, Rectangle r) {
        int x = r.x;
        int y = r.y;
        int width = r.width;
        int height = r.height;
        block6: for (int i = 0; i < this.axis.size(); ++i) {
            Axis a = (Axis)this.axis.elementAt(i);
            int waxis = a.getAxisWidth(g);
            switch (a.getAxisPos()) {
                case 2: {
                    x += waxis;
                    width -= waxis;
                    continue block6;
                }
                case 3: {
                    width -= waxis;
                    continue block6;
                }
                case 4: {
                    y += waxis;
                    height -= waxis;
                    continue block6;
                }
                case 5: {
                    height -= waxis;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected Rectangle drawAxis(Graphics g, Rectangle r) {
        if (this.square) {
            r = this.ForceSquare(g, r);
        }
        Rectangle dr = !this.showAxis ? r : this.getDataRectangle(g, r);
        int x = dr.x;
        int y = dr.y;
        int width = dr.width;
        int height = dr.height;
        if (this.clearAll) {
            Color c = g.getColor();
            g.setColor(this.DataBackground);
            g.fillRect(x, y, width, height);
            g.setColor(c);
        }
        if (this.frame) {
            this.drawFrame(g, x, y, width, height);
        }
        block6: for (int i = 0; i < this.axis.size(); ++i) {
            Axis a = (Axis)this.axis.elementAt(i);
            a.data_window = new Dimension(width, height);
            switch (a.getAxisPos()) {
                case 2: {
                    if (this.showAxis) {
                        r.x += a.width;
                    }
                    if (this.showAxis) {
                        r.width -= a.width;
                    }
                    a.positionAxis(r.x, r.x, y, y + height);
                    if (r.x == x) {
                        a.gridcolor = this.gridcolor;
                        a.drawgrid = this.drawgrid;
                        a.zerocolor = this.zerocolor;
                        a.drawzero = this.drawzero;
                    }
                    a.drawAxis(g);
                    a.drawgrid = false;
                    a.drawzero = false;
                    continue block6;
                }
                case 3: {
                    if (this.showAxis) {
                        r.width -= a.width;
                    }
                    a.positionAxis(r.x + r.width, r.x + r.width, y, y + height);
                    if (r.x + r.width == x + width) {
                        a.gridcolor = this.gridcolor;
                        a.drawgrid = this.drawgrid;
                        a.zerocolor = this.zerocolor;
                        a.drawzero = this.drawzero;
                    }
                    a.drawAxis(g);
                    a.drawgrid = false;
                    a.drawzero = false;
                    continue block6;
                }
                case 4: {
                    if (this.showAxis) {
                        r.y += a.width;
                    }
                    if (this.showAxis) {
                        r.height -= a.width;
                    }
                    a.positionAxis(x, x + width, r.y, r.y);
                    if (r.y == y) {
                        a.gridcolor = this.gridcolor;
                        a.drawgrid = this.drawgrid;
                        a.zerocolor = this.zerocolor;
                        a.drawzero = this.drawzero;
                    }
                    a.drawAxis(g);
                    a.drawgrid = false;
                    a.drawzero = false;
                    continue block6;
                }
                case 5: {
                    if (this.showAxis) {
                        r.height -= a.width;
                    }
                    a.positionAxis(x, x + width, r.y + r.height, r.y + r.height);
                    if (r.y + r.height == y + height) {
                        a.gridcolor = this.gridcolor;
                        a.drawgrid = this.drawgrid;
                        a.zerocolor = this.zerocolor;
                        a.drawzero = this.drawzero;
                    }
                    a.drawAxis(g);
                    a.drawgrid = false;
                    a.drawzero = false;
                    continue block6;
                }
            }
        }
        return r;
    }

    protected void drawFrame(Graphics g, int x, int y, int width, int height) {
        Color c = g.getColor();
        if (this.framecolor != null) {
            g.setColor(this.framecolor);
        }
        g.drawRect(x, y, width, height);
        g.setColor(c);
    }
}

