/*
 * Decompiled with CFR 0.152.
 */
package sTools.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import sTools.graph.RotateTextFilter;
import sTools.graph.TextLine;
import sTools.graph.TextState;

public class RTextLine
extends TextLine {
    protected int angle = 0;
    private double cos = 1.0;
    private double sin = 0.0;
    private Component component = null;

    public RTextLine() {
    }

    public RTextLine(String s) {
        super(s);
    }

    public RTextLine(Component c) {
        this.setDrawingComponent(c);
    }

    public RTextLine(String s, Font f) {
        super(s, f);
    }

    public RTextLine(String s, Font f, Color c, int j) {
        super(s, f, c, j);
    }

    public RTextLine(String s, Color c) {
        super(s, c);
    }

    public RTextLine(Font f, Color c, int j, int a) {
        super(f, c, j);
        this.setRotation(a);
    }

    public RTextLine(Font f, Color c, int j) {
        super(f, c, j);
    }

    public void copyState(RTextLine t) {
        if (t == null) {
            return;
        }
        this.font = t.getFont();
        this.color = t.getColor();
        this.justification = t.getJustification();
        this.setRotation(t.getRotation(), t.getComponent());
        if (this.font == null) {
            return;
        }
        this.fontname = this.font.getName();
        this.fontstyle = this.font.getStyle();
        this.fontsize = this.font.getSize();
        this.parse = true;
    }

    public void setRotation(int angle) {
        this.angle = angle % 360 / 90 * 90;
        this.cos = Math.cos((double)angle * Math.PI / 180.0);
        this.sin = Math.sin((double)angle * Math.PI / 180.0);
    }

    public void setDrawingComponent(Component c) {
        this.component = c;
    }

    public void setRotation(int angle, Component c) {
        this.setRotation(angle);
        this.setDrawingComponent(c);
    }

    public int getRotation() {
        return this.angle;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getRWidth(Graphics g) {
        this.parseText(g);
        return (int)(Math.abs(this.cos * (double)this.width + this.sin * (double)this.height) + 0.5);
    }

    public int getRHeight(Graphics g) {
        this.parseText(g);
        return (int)(Math.abs(-this.sin * (double)this.width + this.cos * (double)this.height) + 0.5);
    }

    public int getLeftEdge(Graphics g) {
        return this.getLeftEdge(g, this.justification);
    }

    public int getRightEdge(Graphics g) {
        return this.getRightEdge(g, this.justification);
    }

    public int getTopEdge(Graphics g) {
        return this.getTopEdge(g, this.justification);
    }

    public int getBottomEdge(Graphics g) {
        return this.getBottomEdge(g, this.justification);
    }

    public int getLeftEdge(Graphics g, int j) {
        this.parseText(g);
        switch (this.angle) {
            case -270: 
            case 90: {
                return -this.ascent;
            }
            case -180: 
            case 180: {
                if (j == 0) {
                    return -this.width / 2;
                }
                if (j == 2) {
                    return 0;
                }
                return -this.width;
            }
            case -90: 
            case 270: {
                return -this.descent - this.leading;
            }
        }
        if (j == 0) {
            return -this.width / 2;
        }
        if (j == 2) {
            return -this.width;
        }
        return 0;
    }

    public int getRightEdge(Graphics g, int j) {
        this.parseText(g);
        switch (this.angle) {
            case -270: 
            case 90: {
                return this.descent + this.leading;
            }
            case -180: 
            case 180: {
                if (j == 0) {
                    return this.width / 2;
                }
                if (j == 2) {
                    return this.width;
                }
                return 0;
            }
            case -90: 
            case 270: {
                return this.ascent;
            }
        }
        if (j == 0) {
            return this.width / 2;
        }
        if (j == 2) {
            return 0;
        }
        return this.width;
    }

    public int getTopEdge(Graphics g, int j) {
        this.parseText(g);
        switch (this.angle) {
            case -270: 
            case 90: {
                if (j == 0) {
                    return this.width / 2;
                }
                if (j == 2) {
                    return 0;
                }
                return this.width;
            }
            case -180: 
            case 180: {
                return this.descent + this.leading;
            }
            case -90: 
            case 270: {
                if (j == 0) {
                    return this.width / 2;
                }
                if (j == 2) {
                    return this.width;
                }
                return 0;
            }
        }
        return this.ascent;
    }

    public int getBottomEdge(Graphics g, int j) {
        this.parseText(g);
        switch (this.angle) {
            case -270: 
            case 90: {
                if (j == 0) {
                    return -this.width / 2;
                }
                if (j == 2) {
                    return -this.width;
                }
                return 0;
            }
            case -180: 
            case 180: {
                return -this.ascent;
            }
            case -90: 
            case 270: {
                if (j == 0) {
                    return -this.width / 2;
                }
                if (j == 2) {
                    return 0;
                }
                return -this.width;
            }
        }
        return -this.descent - this.leading;
    }

    public void draw(Graphics g, int x, int y) {
        if (g == null) {
            return;
        }
        if (this.component == null) {
            this.angle = 0;
        }
        if (this.angle == 0) {
            super.draw(g, x, y);
        } else {
            this.draw(this.component, g, x, y);
        }
    }

    public void draw(Graphics g, int x, int y, int j) {
        this.justification = j;
        if (g == null) {
            return;
        }
        if (this.component == null) {
            this.angle = 0;
        }
        if (this.angle == 0) {
            super.draw(g, x, y);
        } else {
            this.draw(this.component, g, x, y);
        }
    }

    public synchronized void draw(Component comp, Graphics g, int x, int y) {
        int xoffset = 0;
        int yoffset = 0;
        Image offsI = null;
        Graphics offsG = null;
        Image rotatedImage = null;
        int maxHeight = 0;
        if (this.text == null || comp == null) {
            return;
        }
        this.parseText(g);
        maxHeight = this.maxAscent + this.maxDescent;
        switch (this.angle) {
            case -270: 
            case 90: {
                xoffset = -this.maxAscent;
                if (this.justification == 0) {
                    yoffset = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    yoffset = 0;
                    break;
                }
                yoffset = -this.width;
                break;
            }
            case -180: 
            case 180: {
                yoffset = -this.maxDescent;
                if (this.justification == 0) {
                    xoffset = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    xoffset = 0;
                    break;
                }
                xoffset = -this.width;
                break;
            }
            case -90: 
            case 270: {
                xoffset = -this.maxDescent;
                if (this.justification == 0) {
                    yoffset = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    yoffset = -this.width;
                    break;
                }
                yoffset = 0;
                break;
            }
            default: {
                xoffset = 0;
                yoffset = 0;
                break;
            }
        }
        offsI = comp.createImage(this.width, maxHeight);
        if (offsI == null) {
            return;
        }
        offsG = offsI.getGraphics();
        if (this.background != null) {
            offsG.setColor(this.background);
        } else {
            offsG.setColor(comp.getBackground());
        }
        offsG.fillRect(0, 0, this.width, maxHeight);
        offsG.setFont(g.getFont());
        offsG.setColor(g.getColor());
        if (this.font != null) {
            offsG.setFont(this.font);
        }
        if (this.color != null) {
            offsG.setColor(this.color);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            TextState ts = (TextState)this.list.elementAt(i);
            if (ts.f != null) {
                offsG.setFont(ts.f);
            }
            if (ts.s == null) continue;
            offsG.drawString(ts.toString(), ts.x, ts.y + this.maxAscent);
        }
        RotateTextFilter f = new RotateTextFilter(this.angle);
        FilteredImageSource producer = new FilteredImageSource(offsI.getSource(), f);
        rotatedImage = comp.createImage(producer);
        if (rotatedImage == null) {
            return;
        }
        g.drawImage(rotatedImage, x + xoffset, y + yoffset, null);
    }
}

