/*
 * Decompiled with CFR 0.152.
 */
package sTools.graph;

public final class SpecialFunction {
    private static final double MACHEP = (double)1.110223E-16f;
    private static final double MAXLOG = 709.782712893384;
    private static final double MINLOG = -745.1332191019412;
    private static final double MAXGAM = 171.6243769563027;
    private static final double SQTPI = 2.5066282746310007;
    private static final double SQRTH = 0.7071067811865476;
    private static final double LOGPI = 1.1447298858494002;
    public static final double BOLTZMAN = 1.3807E-16;
    public static final double ECHARGE = 4.8032E-10;
    public static final double EMASS = 9.1095E-28;
    public static final double PMASS = 1.6726000000000002E-24;
    public static final double GRAV = 6.672E-8;
    public static final double PLANCK = 6.6262E-27;
    public static final double LIGHTSPEED = 2.9979E10;
    public static final double STEFANBOLTZ = 5.6703E-5;
    public static final double AVOGADRO = 6.022E23;
    public static final double GASCONSTANT = 8.3144E7;
    public static final double GRAVACC = 980.67;
    public static final double SOLARMASS = 1.99E33;
    public static final double SOLARRADIUS = 6.96E10;
    public static final double SOLARLUM = 3.8999999999999996E33;
    public static final double SOLARFLUX = 6.41E10;
    public static final double AU = 1.5E13;

    private SpecialFunction() {
    }

    public static double log10(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(x) / 2.302585092994046;
    }

    public static double cosh(double x) throws ArithmeticException {
        double a = x;
        if (a < 0.0) {
            a = Math.abs(x);
        }
        a = Math.exp(a);
        return 0.5 * (a + 1.0 / a);
    }

    public static double sinh(double x) throws ArithmeticException {
        if (x == 0.0) {
            return x;
        }
        double a = x;
        if (a < 0.0) {
            a = Math.abs(x);
        }
        a = Math.exp(a);
        if (x < 0.0) {
            return -0.5 * (a - 1.0 / a);
        }
        return 0.5 * (a - 1.0 / a);
    }

    public static double tanh(double x) throws ArithmeticException {
        if (x == 0.0) {
            return x;
        }
        double a = x;
        if (a < 0.0) {
            a = Math.abs(x);
        }
        a = Math.exp(2.0 * a);
        if (x < 0.0) {
            return -(1.0 - 2.0 / (a + 1.0));
        }
        return 1.0 - 2.0 / (a + 1.0);
    }

    public static double acosh(double x) throws ArithmeticException {
        if (x < 1.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double asinh(double xx) throws ArithmeticException {
        double x;
        int sign;
        if (xx == 0.0) {
            return xx;
        }
        if (xx < 0.0) {
            sign = -1;
            x = -xx;
        } else {
            sign = 1;
            x = xx;
        }
        return (double)sign * Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double atanh(double x) throws ArithmeticException {
        if (x > 1.0 || x < -1.0) {
            throw new ArithmeticException("range exception");
        }
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static double j0(double x) throws ArithmeticException {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = 5.7568490574E10 + y * (-1.3362590354E10 + y * (6.516196407E8 + y * (-1.121442418E7 + y * (77392.33017 + y * -184.9052456))));
            double ans2 = 5.7568490411E10 + y * (1.029532985E9 + y * (9494680.718 + y * (59272.64853 + y * (267.8532712 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double y = z * z;
        double xx = ax - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 - y * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
    }

    public static double j1(double x) throws ArithmeticException {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = x * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double xx = ax - 2.356194491;
        double y = z * z;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        double ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        if (x < 0.0) {
            ans = -ans;
        }
        return ans;
    }

    public static double jn(int n, double x) throws ArithmeticException {
        double ans;
        double ACC = 40.0;
        double BIGNO = 1.0E10;
        double BIGNI = 1.0E-10;
        if (n == 0) {
            return SpecialFunction.j0(x);
        }
        if (n == 1) {
            return SpecialFunction.j1(x);
        }
        double ax = Math.abs(x);
        if (ax == 0.0) {
            return 0.0;
        }
        if (ax > (double)n) {
            double tox = 2.0 / ax;
            double bjm = SpecialFunction.j0(ax);
            double bj = SpecialFunction.j1(ax);
            for (int j = 1; j < n; ++j) {
                double bjp = (double)j * tox * bj - bjm;
                bjm = bj;
                bj = bjp;
            }
            ans = bj;
        } else {
            double tox = 2.0 / ax;
            int m = 2 * ((n + (int)Math.sqrt(ACC * (double)n)) / 2);
            boolean jsum = false;
            double sum = 0.0;
            ans = 0.0;
            double bjp = 0.0;
            double bj = 1.0;
            for (int j = m; j > 0; --j) {
                double bjm = (double)j * tox * bj - bjp;
                bjp = bj;
                bj = bjm;
                if (Math.abs(bj) > BIGNO) {
                    bj *= BIGNI;
                    bjp *= BIGNI;
                    ans *= BIGNI;
                    sum *= BIGNI;
                }
                if (jsum) {
                    sum += bj;
                }
                boolean bl = jsum = !jsum;
                if (j != n) continue;
                ans = bjp;
            }
            sum = 2.0 * sum - bj;
            ans /= sum;
        }
        return x < 0.0 && n % 2 == 1 ? -ans : ans;
    }

    public static double y0(double x) throws ArithmeticException {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = -2.957821389E9 + y * (7.062834065E9 + y * (-5.123598036E8 + y * (1.087988129E7 + y * (-86327.92757 + y * 228.4622733))));
            double ans2 = 4.0076544269E10 + y * (7.452499648E8 + y * (7189466.438 + y * (47447.2647 + y * (226.1030244 + y * 1.0))));
            return ans1 / ans2 + 0.636619772 * SpecialFunction.j0(x) * Math.log(x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 + y * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double y1(double x) throws ArithmeticException {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = x * (-4.900604943E12 + y * (1.27527439E12 + y * (-5.153438139E10 + y * (7.349264551E8 + y * (-4237922.726 + y * 8511.937935)))));
            double ans2 = 2.49958057E13 + y * (4.244419664E11 + y * (3.733650367E9 + y * (2.245904002E7 + y * (102042.605 + y * (354.9632885 + y)))));
            return ans1 / ans2 + 0.636619772 * (SpecialFunction.j1(x) * Math.log(x) - 1.0 / x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 2.356194491;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double yn(int n, double x) throws ArithmeticException {
        if (n == 0) {
            return SpecialFunction.y0(x);
        }
        if (n == 1) {
            return SpecialFunction.y1(x);
        }
        double tox = 2.0 / x;
        double by = SpecialFunction.y1(x);
        double bym = SpecialFunction.y0(x);
        for (int j = 1; j < n; ++j) {
            double byp = (double)j * tox * by - bym;
            bym = by;
            by = byp;
        }
        return by;
    }

    public static double fac(double x) throws ArithmeticException {
        double d = Math.abs(x);
        if (Math.floor(d) == d) {
            return SpecialFunction.fac((int)x);
        }
        return SpecialFunction.gamma(x + 1.0);
    }

    public static int fac(int j) throws ArithmeticException {
        int i = j;
        int d = 1;
        if (j < 0) {
            i = Math.abs(j);
        }
        while (i > 1) {
            d *= i--;
        }
        if (j < 0) {
            return -d;
        }
        return d;
    }

    public static double gamma(double x) throws ArithmeticException {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176156, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double MAXGAM = 171.6243769563027;
        double LOGPI = 1.1447298858494002;
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int i = (int)p;
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * SpecialFunction.stirf(q));
                return -z;
            }
            return SpecialFunction.stirf(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = SpecialFunction.polevl(x -= 2.0, P, 6);
        q = SpecialFunction.polevl(x, Q, 7);
        return z * p / q;
    }

    private static double stirf(double x) throws ArithmeticException {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * SpecialFunction.polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    public static double igamc(double a, double x) throws ArithmeticException {
        double t;
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        if (x <= 0.0 || a <= 0.0) {
            return 1.0;
        }
        if (x < 1.0 || x < a) {
            return 1.0 - SpecialFunction.igam(a, x);
        }
        double ax = a * Math.log(x) - x - SpecialFunction.lgamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double y = 1.0 - a;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > big)) continue;
            pkm2 *= biginv;
            pkm1 *= biginv;
            qkm2 *= biginv;
            qkm1 *= biginv;
        } while (t > (double)1.110223E-16f);
        return ans * ax;
    }

    public static double igam(double a, double x) throws ArithmeticException {
        if (x <= 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x > 1.0 && x > a) {
            return 1.0 - SpecialFunction.igamc(a, x);
        }
        double ax = a * Math.log(x) - x - SpecialFunction.lgamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double r = a;
        double c = 1.0;
        double ans = 1.0;
        while ((c *= x / (r += 1.0)) / (ans += c) > (double)1.110223E-16f) {
        }
        return ans * ax / a;
    }

    public static double chisq(double df, double x) throws ArithmeticException {
        if (x < 0.0 || df < 1.0) {
            return 0.0;
        }
        return SpecialFunction.igam(df / 2.0, x / 2.0);
    }

    public static double chisqc(double df, double x) throws ArithmeticException {
        if (x < 0.0 || df < 1.0) {
            return 0.0;
        }
        return SpecialFunction.igamc(df / 2.0, x / 2.0);
    }

    public static double poisson(int k, double x) throws ArithmeticException {
        if (k < 0 || x < 0.0) {
            return 0.0;
        }
        return SpecialFunction.igamc(k + 1, x);
    }

    public static double poissonc(int k, double x) throws ArithmeticException {
        if (k < 0 || x < 0.0) {
            return 0.0;
        }
        return SpecialFunction.igam(k + 1, x);
    }

    public static double normal(double a) throws ArithmeticException {
        double y;
        double x = a * 0.7071067811865476;
        double z = Math.abs(x);
        if (z < 0.7071067811865476) {
            y = 0.5 + 0.5 * SpecialFunction.erf(x);
        } else {
            y = 0.5 * SpecialFunction.erfc(z);
            if (x > 0.0) {
                y = 1.0 - y;
            }
        }
        return y;
    }

    public static double erfc(double a) throws ArithmeticException {
        double q;
        double p;
        double[] P = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] Q = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] R = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] S = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double x = a < 0.0 ? -a : a;
        if (x < 1.0) {
            return 1.0 - SpecialFunction.erf(a);
        }
        double z = -a * a;
        if (z < -709.782712893384) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        z = Math.exp(z);
        if (x < 8.0) {
            p = SpecialFunction.polevl(x, P, 8);
            q = SpecialFunction.p1evl(x, Q, 8);
        } else {
            p = SpecialFunction.polevl(x, R, 5);
            q = SpecialFunction.p1evl(x, S, 6);
        }
        double y = z * p / q;
        if (a < 0.0) {
            y = 2.0 - y;
        }
        if (y == 0.0) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return y;
    }

    public static double erf(double x) throws ArithmeticException {
        double[] T = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] U = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(x) > 1.0) {
            return 1.0 - SpecialFunction.erfc(x);
        }
        double z = x * x;
        double y = x * SpecialFunction.polevl(z, T, 4) / SpecialFunction.p1evl(z, U, 5);
        return y;
    }

    private static double polevl(double x, double[] coef, int N) throws ArithmeticException {
        double ans = coef[0];
        for (int i = 1; i <= N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    private static double p1evl(double x, double[] coef, int N) throws ArithmeticException {
        double ans = x + coef[0];
        for (int i = 1; i < N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    private static double lgamma(double x) throws ArithmeticException {
        double[] A = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = SpecialFunction.lgamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * SpecialFunction.polevl(x, B, 5) / SpecialFunction.p1evl(x, C, 6);
            return Math.log(z) + p;
        }
        if (x > 2.5563480000000002E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += SpecialFunction.polevl(p, A, 4) / x);
        return q;
    }

    public static double ibeta(double aa, double bb, double xx) throws ArithmeticException {
        double x;
        double xc;
        double b;
        double a;
        if (aa <= 0.0 || bb <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (xx <= 0.0 || xx >= 1.0) {
            if (xx == 0.0) {
                return 0.0;
            }
            if (xx == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean flag = false;
        if (bb * xx <= 1.0 && xx <= 0.95) {
            double t = SpecialFunction.pseries(aa, bb, xx);
            return t;
        }
        double w = 1.0 - xx;
        if (xx > aa / (aa + bb)) {
            flag = true;
            a = bb;
            b = aa;
            xc = xx;
            x = w;
        } else {
            a = aa;
            b = bb;
            xc = w;
            x = xx;
        }
        if (flag && b * x <= 1.0 && x <= 0.95) {
            double t = SpecialFunction.pseries(a, b, x);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = x * (a + b - 2.0) - (a - 1.0);
        w = y < 0.0 ? SpecialFunction.incbcf(a, b, x) : SpecialFunction.incbd(a, b, x) / xc;
        y = a * Math.log(x);
        double t = b * Math.log(xc);
        if (a + b < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= SpecialFunction.gamma(a + b) / (SpecialFunction.gamma(a) * SpecialFunction.gamma(b));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + SpecialFunction.lgamma(a + b) - SpecialFunction.lgamma(a) - SpecialFunction.lgamma(b);
        t = (y += Math.log(w / a)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    private static double incbcf(double a, double b, double x) throws ArithmeticException {
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > big) {
                pkm2 *= biginv;
                pkm1 *= biginv;
                qkm2 *= biginv;
                qkm1 *= biginv;
            }
            if (!(Math.abs(qk) < biginv) && !(Math.abs(pk) < biginv)) continue;
            pkm2 *= big;
            pkm1 *= big;
            qkm2 *= big;
            qkm1 *= big;
        } while (++n < 300);
        return ans;
    }

    private static double incbd(double a, double b, double x) throws ArithmeticException {
        double big = 4.503599627370496E15;
        double biginv = 2.220446049250313E-16;
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > big) {
                pkm2 *= biginv;
                pkm1 *= biginv;
                qkm2 *= biginv;
                qkm1 *= biginv;
            }
            if (!(Math.abs(qk) < biginv) && !(Math.abs(pk) < biginv)) continue;
            pkm2 *= big;
            pkm1 *= big;
            qkm2 *= big;
            qkm1 *= big;
        } while (++n < 300);
        return ans;
    }

    private static double pseries(double a, double b, double x) throws ArithmeticException {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = SpecialFunction.gamma(a + b) / (SpecialFunction.gamma(a) * SpecialFunction.gamma(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = SpecialFunction.lgamma(a + b) - SpecialFunction.lgamma(a) - SpecialFunction.lgamma(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }
}

