/*
 * Decompiled with CFR 0.152.
 */
package sTools.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Stack;
import java.util.Vector;
import sTools.graph.SpecialFunction;
import sTools.graph.TextState;

public class TextLine {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int SCIENTIFIC = 1;
    public static final int ALGEBRAIC = 2;
    static final int MINIMUM_SIZE = 6;
    protected double script_fraction = 0.8;
    protected double sup_offset = 0.6;
    protected double sub_offset = 0.7;
    protected Font font = null;
    protected Color color = null;
    protected Color background = null;
    protected String text = null;
    protected String fontname = "TimesRoman";
    protected int fontsize = 0;
    protected int fontstyle = 0;
    protected int justification = 1;
    protected int width = 0;
    protected int ascent = 0;
    protected int maxAscent = 0;
    protected int descent = 0;
    protected int maxDescent = 0;
    protected int height = 0;
    protected int leading = 0;
    protected boolean parse = true;
    protected Graphics lg = null;
    protected Vector list = new Vector(8, 4);

    public TextLine() {
    }

    public TextLine(String s) {
        this.text = s;
    }

    public TextLine(String s, Font f) {
        this(s);
        this.font = f;
        if (this.font == null) {
            return;
        }
        this.fontname = f.getName();
        this.fontstyle = f.getStyle();
        this.fontsize = f.getSize();
    }

    public TextLine(String s, Font f, Color c, int j) {
        this(s, f);
        this.color = c;
        this.justification = j;
    }

    public TextLine(String s, Color c) {
        this(s);
        this.color = c;
    }

    public TextLine(Font f, Color c, int j) {
        this.font = f;
        this.color = c;
        this.justification = j;
        if (this.font == null) {
            return;
        }
        this.fontname = f.getName();
        this.fontstyle = f.getStyle();
        this.fontsize = f.getSize();
    }

    public TextLine copyState() {
        return new TextLine(this.font, this.color, this.justification);
    }

    public void copyState(TextLine t) {
        if (t == null) {
            return;
        }
        this.font = t.getFont();
        this.color = t.getColor();
        this.justification = t.getJustification();
        if (this.font == null) {
            return;
        }
        this.fontname = this.font.getName();
        this.fontstyle = this.font.getStyle();
        this.fontsize = this.font.getSize();
        this.parse = true;
    }

    public void setFont(Font f) {
        this.font = f;
        this.fontname = f.getName();
        this.fontstyle = f.getStyle();
        this.fontsize = f.getSize();
        this.parse = true;
    }

    public void setText(String s) {
        this.text = s;
        this.parse = true;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setJustification(int i) {
        switch (i) {
            case 0: {
                this.justification = 0;
                break;
            }
            default: {
                this.justification = 1;
                break;
            }
            case 2: {
                this.justification = 2;
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getBackground() {
        return this.background;
    }

    public int getJustification() {
        return this.justification;
    }

    public FontMetrics getFM(Graphics g) {
        if (g == null) {
            return null;
        }
        if (this.font == null) {
            return g.getFontMetrics();
        }
        return g.getFontMetrics(this.font);
    }

    public int charWidth(Graphics g, char ch) {
        if (g == null) {
            return 0;
        }
        FontMetrics fm = this.font == null ? g.getFontMetrics() : g.getFontMetrics(this.font);
        return fm.charWidth(ch);
    }

    public int getWidth(Graphics g) {
        this.parseText(g);
        return this.width;
    }

    public int getHeight(Graphics g) {
        this.parseText(g);
        return this.height;
    }

    public int getAscent(Graphics g) {
        if (g == null) {
            return 0;
        }
        this.parseText(g);
        return this.ascent;
    }

    public int getMaxAscent(Graphics g) {
        if (g == null) {
            return 0;
        }
        this.parseText(g);
        return this.maxAscent;
    }

    public int getDescent(Graphics g) {
        if (g == null) {
            return 0;
        }
        this.parseText(g);
        return this.descent;
    }

    public int getMaxDescent(Graphics g) {
        if (g == null) {
            return 0;
        }
        this.parseText(g);
        return this.maxDescent;
    }

    public int getLeading(Graphics g) {
        if (g == null) {
            return 0;
        }
        this.parseText(g);
        return this.leading;
    }

    public void parseText(Graphics g) {
        TextState current = new TextState();
        Stack<TextState> state = new Stack<TextState>();
        int w = 0;
        if (this.lg != g) {
            this.parse = true;
        }
        this.lg = g;
        if (!this.parse) {
            return;
        }
        this.parse = false;
        this.width = 0;
        this.leading = 0;
        this.ascent = 0;
        this.descent = 0;
        this.height = 0;
        this.maxAscent = 0;
        this.maxDescent = 0;
        if (this.text == null || g == null) {
            return;
        }
        this.list.removeAllElements();
        current.f = this.font == null ? g.getFont() : this.font;
        state.push(current);
        this.list.addElement(current);
        FontMetrics fm = g.getFontMetrics(current.f);
        block7: for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            switch (ch) {
                case '$': {
                    if (++i >= this.text.length()) continue block7;
                    current.s.append(this.text.charAt(i));
                    continue block7;
                }
                case '{': {
                    w = current.getWidth(g);
                    if (!current.isEmpty()) {
                        current = current.copyState();
                        this.list.addElement(current);
                    }
                    state.push(current);
                    current.x += w;
                    continue block7;
                }
                case '}': {
                    w = current.x + current.getWidth(g);
                    state.pop();
                    current = ((TextState)state.peek()).copyState();
                    this.list.addElement(current);
                    current.x = w;
                    continue block7;
                }
                case '^': {
                    w = current.getWidth(g);
                    if (!current.isEmpty()) {
                        current = current.copyState();
                        this.list.addElement(current);
                    }
                    current.f = this.getScriptFont(current.f);
                    current.x += w;
                    current.y -= (int)((double)current.getAscent(g) * this.sup_offset + 0.5);
                    continue block7;
                }
                case '_': {
                    w = current.getWidth(g);
                    if (!current.isEmpty()) {
                        current = current.copyState();
                        this.list.addElement(current);
                    }
                    current.f = this.getScriptFont(current.f);
                    current.x += w;
                    current.y += (int)((double)current.getDescent(g) * this.sub_offset + 0.5);
                    continue block7;
                }
                default: {
                    current.s.append(ch);
                }
            }
        }
        for (int i = 0; i < this.list.size(); ++i) {
            current = (TextState)this.list.elementAt(i);
            if (current.isEmpty()) continue;
            this.width += current.getWidth(g);
            this.ascent = Math.max(this.ascent, Math.abs(current.y) + current.getAscent(g));
            this.descent = Math.max(this.descent, Math.abs(current.y) + current.getDescent(g));
            this.leading = Math.max(this.leading, current.getLeading(g));
            this.maxDescent = Math.max(this.maxDescent, Math.abs(current.y) + current.getMaxDescent(g));
            this.maxAscent = Math.max(this.maxAscent, Math.abs(current.y) + current.getMaxAscent(g));
        }
        this.height = this.ascent + this.descent + this.leading;
    }

    public boolean isNull() {
        return this.text == null;
    }

    public void draw(Graphics g, int x, int y, int j) {
        this.justification = j;
        if (g == null) {
            return;
        }
        this.draw(g, x, y);
    }

    public void draw(Graphics g, int x, int y) {
        int xoffset = x;
        int yoffset = y;
        if (g == null || this.text == null) {
            return;
        }
        Graphics lg = g.create();
        this.parseText(g);
        if (this.justification == 0) {
            xoffset = x - this.width / 2;
        } else if (this.justification == 2) {
            xoffset = x - this.width;
        }
        if (this.background != null) {
            lg.setColor(this.background);
            lg.fillRect(xoffset, yoffset - this.ascent, this.width, this.height);
            lg.setColor(g.getColor());
        }
        if (this.font != null) {
            lg.setFont(this.font);
        }
        if (this.color != null) {
            lg.setColor(this.color);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            TextState ts = (TextState)this.list.elementAt(i);
            if (ts.f != null) {
                lg.setFont(ts.f);
            }
            if (ts.s == null) continue;
            lg.drawString(ts.toString(), ts.x + xoffset, ts.y + yoffset);
        }
        lg.dispose();
        lg = null;
    }

    public String getFontName() {
        return this.fontname;
    }

    public int getFontStyle() {
        return this.fontstyle;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontName(String s) {
        this.fontname = s;
        this.rebuildFont();
    }

    public void setFontStyle(int i) {
        this.fontstyle = i;
        this.rebuildFont();
    }

    public void setFontSize(int i) {
        this.fontsize = i;
        this.rebuildFont();
    }

    private void rebuildFont() {
        this.parse = true;
        this.font = this.fontsize <= 0 || this.fontname == null ? null : new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public Font getScriptFont(Font f) {
        if (f == null) {
            return f;
        }
        int size = f.getSize();
        if (size <= 6) {
            return f;
        }
        size = (int)((double)f.getSize() * this.script_fraction + 0.5);
        if (size <= 6) {
            return f;
        }
        return new Font(f.getName(), f.getStyle(), size);
    }

    public boolean parseDouble(double d) {
        return this.parseDouble(d, 7, 6, 2);
    }

    public boolean parseDouble(double d, int p) {
        return this.parseDouble(d, p + 1, p, 2);
    }

    public boolean parseDouble(double d, int n, int p, int f) {
        int i;
        int exponent;
        int power;
        double x = d;
        int left = n - p;
        double right = 0.0;
        StringBuffer s = new StringBuffer(n + 4);
        if (left < 0) {
            System.out.println("TextLine.parseDouble: Precision > significant figures!");
            return false;
        }
        if (d < 0.0) {
            x = -d;
            s.append("-");
        }
        if ((power = (exponent = d == 0.0 ? 0 : (int)Math.floor(SpecialFunction.log10(x))) - (left - 1)) < 0) {
            for (i = power; i < 0; ++i) {
                x *= 10.0;
            }
        } else {
            for (i = 0; i < power; ++i) {
                x /= 10.0;
            }
        }
        left = (int)x;
        s.append(left);
        if (p > 0) {
            s.append('.');
            right = x - (double)left;
            for (i = 0; i < p; ++i) {
                right *= (double)10;
                if (i == p - 1) {
                    right += 0.5;
                }
                s.append((int)right);
                right -= (double)((int)right);
            }
        }
        if (power != 0) {
            if (f == 1) {
                s.append('E');
                if (power < 0) {
                    s.append('-');
                } else {
                    s.append('+');
                }
                power = Math.abs(power);
                if (power > 9) {
                    s.append(power);
                } else {
                    s.append('0');
                    s.append(power);
                }
            } else {
                s.append("x10{^");
                s.append(power);
                s.append("}");
            }
        }
        this.setText(s.toString());
        return true;
    }
}

