/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;

public final class Differentiator
extends SApplet
implements SDataListener,
SDataSource {
    private String fStr;
    private Parser fun = null;
    private int save = 5;
    String[] varStrings = new String[]{"x", "y", "d", "dd"};
    double[][] variables = new double[1][4];
    double[] x = new double[this.save];
    double[] y = new double[this.save];
    int n = 0;
    boolean isStandalone = false;

    public void init() {
        try {
            this.varStrings[0] = this.getParameter("Independent", "x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.varStrings[1] = this.getParameter("Dependent", "y");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fStr = this.getParameter("Function", this.varStrings[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SApplet.addDataListener((Object)((Object)this));
        SApplet.addDataSource((Object)((Object)this));
    }

    private boolean parseFunction(SDataSource sDataSource) {
        this.fStr = this.fStr.trim();
        this.fStr = this.fStr.toLowerCase();
        int n = sDataSource.getVarStrings().length;
        this.fun = new Parser(n);
        for (int i = 0; i < n; ++i) {
            this.fun.defineVariable(1 + i, sDataSource.getVarStrings()[i]);
        }
        this.fun.define(this.fStr);
        this.fun.parse();
        if (this.fun.getErrorCode() != 0) {
            System.out.println("Failed to parse the derivative function in filters.Differentiator: ".concat(String.valueOf(this.fStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.fun.getErrorString()).append(" at function 1, position ").append(this.fun.getErrorPosition())));
            this.fun = null;
            return false;
        }
        return true;
    }

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public String getAppletInfo() {
        return "Differentiator Physlets";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Integrand", "String", "Integrand"}, {"Differential", "String", "Differential"}};
        return stringArray;
    }

    public double[][] getVariables() {
        if (this.n < 3) {
            this.variables[0][0] = this.x[0];
            this.variables[0][1] = this.y[0];
            this.variables[0][2] = 0.0;
            this.variables[0][3] = 0.0;
            return this.variables;
        }
        this.variables[0][0] = this.x[1];
        this.variables[0][1] = this.y[1];
        double d = this.x[0] - this.x[1] != 0.0 ? (this.y[0] - this.y[1]) / (this.x[0] - this.x[1]) : (this.y[0] - this.y[1] != 0.0 && this.x[0] - this.x[1] != 0.0 ? 1.0E20 * (this.y[0] - this.y[1]) / Math.abs(this.y[0] - this.y[1]) : 0.0);
        double d2 = this.x[1] - this.x[2] != 0.0 ? (this.y[1] - this.y[2]) / (this.x[1] - this.x[2]) : (this.y[1] - this.y[2] != 0.0 && this.x[1] - this.x[2] != 0.0 ? 1.0E20 * (this.y[1] - this.y[2]) / Math.abs(this.y[1] - this.y[2]) : 0.0);
        this.variables[0][2] = (d + d2) / (double)2;
        this.variables[0][3] = this.x[0] - this.x[2] != 0.0 ? (double)2 * (d - d2) / (this.x[0] - this.x[2]) : 0.0;
        return this.variables;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public void reset() {
        this.n = 0;
        for (int i = 0; i < this.save; ++i) {
            this.x[i] = 0.0;
            this.y[i] = 0.0;
        }
        this.updateDataConnections();
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (d == this.x[0]) {
            return;
        }
        double d3 = 0.0;
        if (this.fun == null && this.fStr != null) {
            this.parseFunction(sDataSource);
        }
        for (int i = this.save - 1; i > 0; --i) {
            this.x[i] = this.x[i - 1];
            this.y[i] = this.y[i - 1];
        }
        this.x[0] = d;
        this.y[0] = this.fun.evaluate(sDataSource.getVariables()[0]);
        ++this.n;
        if (this.n < 3) {
            return;
        }
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        this.reset();
    }
}

