/*
 * Decompiled with CFR 0.152.
 */
package filters;

import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;

public final class Integral
extends SApplet
implements SDataListener,
SDataSource {
    private String xiStr;
    private Parser xIntegrand = null;
    private String yiStr;
    private Parser yIntegrand = null;
    private Definite definite = new Definite(this);
    String[] varStrings = new String[]{"x", "y", "n", "integral", "ds"};
    double[][] variables = null;
    int n = 0;
    double sumX = 0.0;
    double sumY = 0.0;
    double lastX = 0.0;
    double lastY = 0.0;
    double lastXIntegrand;
    double lastYIntegrand;
    double dx = 0.0;
    double dy = 0.0;
    double ds = 0.0;
    boolean isStandalone = false;
    int mode = 0;

    public Integral() {
        try {
            SApplet.addDataListener((Object)((Object)this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init() {
        String string = "dx";
        int n = 500;
        try {
            this.varStrings[0] = this.getParameter("Independent", "x");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = this.getParameter("Differential", "dx");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xiStr = this.getParameter("Integrand", this.varStrings[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            n = Integer.parseInt(this.getParameter("MaxPoints", "500"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.variables = new double[n][5];
        this.yiStr = new String(this.xiStr);
        string = string.toLowerCase();
        if (string.equals("dx")) {
            this.mode = 0;
        } else if (string.equals("dy")) {
            this.mode = 1;
        } else if (string.equals("ds")) {
            this.mode = 2;
        } else {
            this.mode = 0;
            System.out.println("Differential parameter invalid. Use dx, dy or ds.");
        }
    }

    private boolean parseXIntegrand(SDataSource sDataSource) {
        this.xiStr = this.xiStr.trim();
        this.xiStr = this.xiStr.toLowerCase();
        int n = sDataSource.getVarStrings().length;
        this.xIntegrand = new Parser(n);
        for (int i = 0; i < n; ++i) {
            this.xIntegrand.defineVariable(1 + i, sDataSource.getVarStrings()[i]);
        }
        this.xIntegrand.define(this.xiStr);
        this.xIntegrand.parse();
        if (this.xIntegrand.getErrorCode() != 0) {
            System.out.println("Failed to parse the x integrand in filters.Integrator: ".concat(String.valueOf(this.xiStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.xIntegrand.getErrorString()).append(" at function 1, position ").append(this.xIntegrand.getErrorPosition())));
            this.xIntegrand = null;
            return false;
        }
        return true;
    }

    private boolean parseYIntegrand(SDataSource sDataSource) {
        this.yiStr = this.yiStr.trim();
        this.yiStr = this.yiStr.toLowerCase();
        int n = sDataSource.getVarStrings().length;
        this.yIntegrand = new Parser(n);
        for (int i = 0; i < n; ++i) {
            this.yIntegrand.defineVariable(1 + i, sDataSource.getVarStrings()[i]);
        }
        this.yIntegrand.define(this.yiStr);
        this.yIntegrand.parse();
        if (this.yIntegrand.getErrorCode() != 0) {
            System.out.println("Failed to parse the y integrand in filters.Integrator: ".concat(String.valueOf(this.yiStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.yIntegrand.getErrorString()).append(" at function 1, position ").append(this.yIntegrand.getErrorPosition())));
            this.yIntegrand = null;
            return false;
        }
        return true;
    }

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public String getAppletInfo() {
        return "Integrator Physlets";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Integrand", "String", "Integrand"}, {"Differential", "String", "Differential"}};
        return stringArray;
    }

    public double[][] getVariables() {
        return this.variables;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this;
    }

    public void reset() {
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.n = 0;
        this.updateDataConnections();
    }

    public synchronized void setLineIntegralMode(String string, String string2) {
        this.mode = 3;
        this.xIntegrand = null;
        this.yIntegrand = null;
        this.xiStr = string;
        this.yiStr = string2;
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.n = 0;
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (this.xIntegrand == null && this.xiStr != null) {
            this.parseXIntegrand(sDataSource);
        }
        if (this.yIntegrand == null && this.yiStr != null) {
            this.parseYIntegrand(sDataSource);
        }
        this.dx = d - this.lastX;
        this.dy = d2 - this.lastY;
        this.ds = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        double d3 = 0.0;
        if (this.n > 0) {
            switch (this.mode) {
                case 0: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                    break;
                }
                case 1: {
                    if (this.yIntegrand == null) break;
                    d3 = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += (d3 + this.lastYIntegrand) * this.dy / (double)2;
                    this.lastYIntegrand = d3;
                    break;
                }
                case 2: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.ds / (double)2;
                    this.lastXIntegrand = d3;
                    break;
                }
                case 3: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                    if (this.yIntegrand == null) break;
                    d3 = this.yIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumY += (d3 + this.lastYIntegrand) * this.dy / (double)2;
                    this.lastYIntegrand = d3;
                    break;
                }
                default: {
                    if (this.xIntegrand == null) break;
                    d3 = this.xIntegrand.evaluate(sDataSource.getVariables()[0]);
                    this.sumX += (d3 + this.lastXIntegrand) * this.dx / (double)2;
                    this.lastXIntegrand = d3;
                }
            }
        }
        this.lastX = d;
        this.lastY = d2;
        if (this.n < this.variables.length) {
            this.variables[this.n][0] = this.lastX;
            this.variables[this.n][1] = this.lastY;
            this.variables[this.n][2] = this.n;
            this.variables[this.n][3] = this.sumX + this.sumY;
            this.variables[this.n][4] = this.n > 0 ? this.ds : 0.0;
        }
        for (int i = this.n + 1; i < this.variables.length; ++i) {
            this.variables[i][0] = this.lastX;
            this.variables[i][1] = this.lastY;
            this.variables[i][2] = i;
            this.variables[i][3] = this.sumX + this.sumY;
            this.variables[i][4] = 0.0;
        }
        ++this.n;
        this.updateDataConnections();
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        this.n = dArray.length;
        if (this.n < 2) {
            return;
        }
        if (this.n != this.variables.length) {
            this.variables = new double[this.n][5];
        }
        if (this.xIntegrand == null && this.xiStr != null) {
            this.parseXIntegrand(sDataSource);
        }
        if (this.yIntegrand == null && this.yiStr != null) {
            this.parseYIntegrand(sDataSource);
        }
        this.sumX = 0.0;
        this.sumY = 0.0;
        double d = 0.0;
        this.dx = (dArray[1] - dArray[0]) / (double)2;
        this.dy = (dArray2[1] - dArray2[0]) / (double)2;
        double[][] dArray3 = sDataSource.getVariables();
        for (int i = 0; i < this.n; ++i) {
            this.ds = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            switch (this.mode) {
                case 0: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(dArray3[i]);
                    this.sumX += d * this.dx;
                    break;
                }
                case 1: {
                    if (this.yIntegrand == null) break;
                    d = this.yIntegrand.evaluate(dArray3[i]);
                    this.sumY += d * this.dy;
                    break;
                }
                case 2: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(dArray3[i]);
                    this.sumX += d * this.ds;
                    break;
                }
                case 3: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(dArray3[i]);
                    this.sumX += d * this.dx;
                    if (this.yIntegrand == null) break;
                    d = this.yIntegrand.evaluate(dArray3[i]);
                    this.sumY += d * this.dy;
                    break;
                }
                default: {
                    if (this.xIntegrand == null) break;
                    d = this.xIntegrand.evaluate(dArray3[i]);
                    this.sumX += d * this.dx;
                }
            }
            if (i < this.n - 3) {
                this.dx = dArray[i + 2] - dArray[i + 1];
                this.dy = dArray2[i + 2] - dArray2[i + 1];
            } else if (i < this.n - 2) {
                this.dx = (dArray[i + 2] - dArray[i + 1]) / (double)2;
                this.dy = (dArray2[i + 2] - dArray2[i + 1]) / (double)2;
            }
            this.variables[i][0] = dArray[i];
            this.variables[i][1] = dArray2[i];
            this.variables[i][2] = i;
            this.variables[i][3] = this.sumX + this.sumY;
            this.variables[i][4] = this.ds;
        }
        this.updateDataConnections();
    }

    public void deleteSeries(int n) {
        this.reset();
    }

    public void clearSeries(int n) {
        this.reset();
    }

    public int getDefiniteIntegralID(double d, double d2) {
        this.definite.setLimits(d, d2);
        return this.definite.getID();
    }

    public class Definite
    implements SDataSource {
        String[] varStrings = new String[]{"start", "stop", "integral"};
        double[][] vars = new double[1][3];
        double start = 0.0;
        double stop = 0.0;
        SApplet owner;

        Definite(SApplet sApplet) {
            this.owner = sApplet;
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void setLimits(double d, double d2) {
            this.start = d;
            this.stop = d2;
        }

        int getStartIndex() {
            if (Integral.this.variables == null) {
                return -1;
            }
            for (int i = 0; i < Integral.this.variables.length; ++i) {
                if (!(Integral.this.variables[i][0] >= this.start)) continue;
                return i;
            }
            return Integral.this.variables.length - 1;
        }

        int getEndIndex() {
            if (Integral.this.variables == null) {
                return -1;
            }
            for (int i = 0; i < Integral.this.variables.length; ++i) {
                if (!(Integral.this.variables[i][0] >= this.stop)) continue;
                return i;
            }
            return Integral.this.variables.length - 1;
        }

        public double[][] getVariables() {
            double d;
            int n = this.getStartIndex();
            int n2 = this.getEndIndex();
            if (n < 0 || n2 <= 0) {
                this.vars[0][0] = 0.0;
                this.vars[0][1] = 0.0;
                this.vars[0][2] = 0.0;
                return this.vars;
            }
            this.vars[0][0] = Math.max(this.start, Integral.this.variables[0][0]);
            this.vars[0][1] = Math.min(this.stop, Integral.this.variables[Integral.this.variables.length - 1][0]);
            this.vars[0][2] = Integral.this.variables[n2][3] - Integral.this.variables[n][3];
            if (n > 1 && Integral.this.variables.length > 1) {
                d = 0.0;
                d = (Integral.this.variables[n][0] - this.start) / (Integral.this.variables[n][0] - Integral.this.variables[n - 1][0]);
                this.vars[0][2] = this.vars[0][2] + d * (Integral.this.variables[n][3] - Integral.this.variables[n - 1][3]);
            }
            if (n2 < Integral.this.variables.length - 1 && Integral.this.variables.length > 1 && this.stop < Integral.this.variables[Integral.this.variables.length - 1][0]) {
                d = 0.0;
                d = (Integral.this.variables[n2][0] - this.stop) / (Integral.this.variables[n2][0] - Integral.this.variables[n2 - 1][0]);
                this.vars[0][2] = this.vars[0][2] - d * (Integral.this.variables[n2][3] - Integral.this.variables[n2 - 1][3]);
            }
            return this.vars;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }
    }
}

