/*
 * Decompiled with CFR 0.152.
 */
package optics;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import optics.Bench;
import optics.OpticElement;

public class CalcThing
extends Thing {
    private String calcStr;
    private String text;
    private double[] tempVars = new double[4];
    Parser calcFunc = null;
    Bench bench = null;

    public CalcThing(SApplet sApplet, Bench bench, String string, String string2, double d, double d2) {
        super((SScalable)bench, d, d2);
        this.color = Color.white;
        this.bench = bench;
        this.applet = sApplet;
        this.font = new Font("Helvetica", 1, 14);
        this.text = string;
        this.calcStr = string2;
        if (this.calcStr == null || this.calcStr.equals("")) {
            this.calcStr = null;
            this.calcFunc = null;
            return;
        }
        this.calcFunc = new Parser(4);
        this.calcFunc.defineVariable(1, "x");
        this.calcFunc.defineVariable(2, "y");
        this.calcFunc.defineVariable(3, "f");
        this.calcFunc.defineVariable(4, "n");
        this.calcFunc.define(this.calcStr);
        this.calcFunc.parse();
        if (this.calcFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse calc-text: ".concat(String.valueOf(this.calcStr)));
            System.out.println(String.valueOf(new StringBuffer("Parse error: ").append(this.calcFunc.getErrorString()).append(" at function 1, position ").append(this.calcFunc.getErrorPosition())));
            return;
        }
    }

    public final String getText() {
        if (this.calcFunc == null) {
            return this.text;
        }
        double d = 0.0;
        Thing thing = this.getMaster();
        this.tempVars[0] = this.x;
        this.tempVars[1] = this.y;
        this.tempVars[2] = 0.0;
        this.tempVars[3] = 0.0;
        if (thing != null && thing instanceof OpticElement) {
            this.tempVars[2] = ((OpticElement)thing).focalLength / (double)this.bench.pixPerUnit;
            this.tempVars[3] = ((OpticElement)thing).indexOfRefraction;
        }
        try {
            d = this.calcFunc.evaluate(this.tempVars);
            d = SUtil.chop((double)d, (double)1.0E-8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(new StringBuffer(String.valueOf(this.text)).append(" ").append(this.format.form(d)));
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (!this.visible) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        int n = Math.round(this.canvas.pixFromX(this.x)) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.y)) - this.yDisplayOff;
        graphics.setColor(this.color);
        graphics.drawString(this.getText(), n, n2);
        graphics.setColor(Color.black);
        graphics.setFont(font);
    }
}

