/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import optics.Bench;
import optics.OpticElement;

public class Dielectric
extends OpticElement {
    double delN;
    int R;
    private Polygon outline = new Polygon();
    private int iheight = 0;

    public Dielectric(Bench bench, int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        super(bench);
        this.resizable = bl3;
        this.info = bl;
        this.noDrag = !bl2;
        this.percentSize = d2;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        this.R = n3;
        this.focalLength = this.delN == 0.0 ? 0.0 : (double)this.R / this.delN;
        this.delN = d;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = this.R == 0 ? 0.0 : -this.delN / (double)this.R;
        this.mat[1][1] = 1.0;
    }

    private void makeOutline(int n) {
        if (this.R > 0) {
            this.makeOutlineMinus(n);
        } else {
            this.makeOutlinePlus(n);
        }
    }

    private void makeOutlinePlus(int n) {
        double d;
        this.iheight = n;
        n = (int)((double)n * this.percentSize);
        this.outline = new Polygon();
        int n2 = Math.abs(this.R);
        double d2 = n / 2 < n2 ? Math.asin((double)n / (double)n2 / 2.0) : 1.5707963267948966;
        double d3 = d2 / (double)50;
        double d4 = (double)n2 * Math.cos(d2);
        double d5 = (double)n2 - d4 - 1.0;
        int n3 = this.xPosition;
        int n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2));
        this.outline.addPoint(n3, n4);
        for (d = d2; d > -d2; d -= d3) {
            n3 = (int)((double)this.xPosition - d4 + (double)n2 * Math.cos(d) - d5);
            n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2));
            this.outline.addPoint(n3, n4);
        }
        n3 = this.xPosition;
        n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2) + (double)2);
        this.outline.addPoint(n3, n4);
    }

    private void makeOutlineMinus(int n) {
        double d;
        this.iheight = n;
        n = (int)((double)n * this.percentSize);
        this.outline = new Polygon();
        int n2 = Math.abs(this.R);
        double d2 = n / 2 < n2 ? Math.asin((double)n / (double)n2 / 2.0) : 1.5707963267948966;
        double d3 = d2 / (double)50;
        double d4 = (double)n2 * Math.cos(d2);
        double d5 = (double)n2 - d4 - 1.0;
        int n3 = (int)((double)this.xPosition + d4 - (double)n2 * Math.cos(d) + d5);
        int n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2));
        this.outline.addPoint(n3, n4);
        for (d = d2; d > -d2; d -= d3) {
            n3 = (int)((double)this.xPosition + d4 - (double)n2 * Math.cos(d) + d5);
            n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2));
            this.outline.addPoint(n3, n4);
        }
        n3 = (int)((double)this.xPosition + d4 - (double)n2 * Math.cos(d) + d5);
        n4 = (int)((double)n2 * Math.sin(d) + (double)(this.iheight / 2) + (double)2);
        this.outline.addPoint(n3, n4);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (rectangle.height != this.iheight) {
            this.makeOutline(rectangle.height);
        }
        graphics.setColor(Color.black);
        if (this.R < 0) {
            graphics.fillRect(this.xPosition, 0, rectangle.width, rectangle.height);
        } else {
            graphics.fillRect(this.outline.xpoints[0] - 1, 0, rectangle.width, rectangle.height);
        }
        int n = (int)Math.min(255.0, (double)50 * (0.2 + this.indexOfRefraction + this.delN));
        if (this.indexOfRefraction + this.delN > 1.0) {
            graphics.setColor(new Color(0, 0, n));
        } else {
            graphics.setColor(Color.black);
        }
        if (this.R >= 5 || this.R <= -5) {
            graphics.fillPolygon(this.outline);
        }
        int n2 = this.outline.npoints - 1;
        int n3 = Math.abs(this.outline.ypoints[n2] - this.outline.ypoints[0]) + 1;
        if (this.R < 0) {
            graphics.fillRect(this.xPosition, this.outline.ypoints[n2] - 1, rectangle.width, n3);
        } else if (this.R > 0) {
            graphics.fillRect(this.outline.xpoints[0] - 1, this.outline.ypoints[n2] - 0, rectangle.width, n3 - 1);
        } else {
            graphics.fillRect(this.xPosition, 0, rectangle.width, rectangle.height);
        }
        if (this.color == null) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
        if (this.showFocus) {
            graphics.setColor(Color.white);
            int n4 = (int)Math.abs((double)this.R / this.delN);
            if (this.focalLength == 0.0) {
                n4 = 20;
            }
            n4 = Math.min(n4, rectangle.width / 2 - 5);
            graphics.fillOval(this.xPosition - n4 - 3, rectangle.height / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition + n4 - 3, rectangle.height / 2 - 3, 6, 6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        if (this.delN == 0.0) {
            return dArray;
        }
        if (this.focalLength != 0.0) {
            double d = dArray[0] - (double)(rectangle.height / 2);
            dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
            dArray[1] = (double)n * d * this.mat[1][0] + dArray[1] * this.mat[1][1];
            return dArray;
        }
        double d = dArray[0] - (double)(rectangle.height / 2);
        double d2 = Math.atan(dArray[1]);
        this.errCode = 0;
        if (n == 1) {
            if (!(Math.abs(this.indexOfRefraction * Math.sin(d2) / (this.delN + this.indexOfRefraction)) <= 1.0)) {
                dArray[1] = -dArray[1];
                this.errCode = 2;
                return dArray;
            }
            d2 = Math.asin(this.indexOfRefraction * Math.sin(d2) / (this.delN + this.indexOfRefraction));
        } else {
            if (!(dArray[1] > 0.0 && Math.sin(d2) * (this.delN + this.indexOfRefraction) <= 1.0 || dArray[1] < 0.0 && Math.sin(d2) * (this.delN + this.indexOfRefraction) >= (double)-1 || dArray[1] == 0.0)) {
                dArray[1] = -dArray[1];
                this.errCode = 2;
                return dArray;
            }
            d2 = Math.asin(Math.sin(d2) * (this.delN + this.indexOfRefraction) / this.indexOfRefraction);
        }
        dArray[1] = Math.tan(d2);
        return dArray;
    }

    public void setDelN(double d) {
        this.delN = d;
        this.mat[1][1] = this.indexOfRefraction / (this.delN + this.indexOfRefraction);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (!this.noDrag) {
            graphics.setColor(Color.green);
            graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
        }
        if (this.showFocus || this.resizable) {
            graphics.setColor(Color.white);
            int n = (int)Math.abs((double)this.R / this.delN);
            if (this.focalLength == 0.0) {
                n = 20;
            }
            n = Math.min(n, rectangle.width / 2 - 5);
            graphics.fillOval(this.xPosition - n - 3, rectangle.height / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition + n - 3, rectangle.height / 2 - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString("x = ".concat(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 70);
            if (this.delN + this.indexOfRefraction >= 1.0) {
                graphics.drawString(String.valueOf(new StringBuffer("n1 = ").append(this.df.format(this.indexOfRefraction)).append("    n2=").append(this.df.format(this.delN + this.indexOfRefraction))), this.xPosition, rectangle.height - 50);
            } else {
                graphics.drawString("ERROR: n2<1.0 ", this.xPosition, rectangle.height - 50);
            }
            graphics.drawString("R = ".concat(String.valueOf(this.df.format(1.0 * (double)this.R / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 30);
        }
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (!this.noDrag && n > this.xPosition - 10 && n < this.xPosition + 10) {
            return 1;
        }
        int n3 = (int)((double)this.R / this.delN);
        if (this.focalLength == 0.0) {
            n3 = 20;
        }
        n3 = n3 < 0 ? -Math.min(-n3, rectangle.width / 2 - 5) : Math.min(n3, rectangle.width / 2 - 5);
        if (this.resizable && n > this.xPosition + n3 - 15 && n < this.xPosition + n3 + 15 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 2;
        }
        if (this.resizable && n > this.xPosition - n3 - 15 && n < this.xPosition - n3 + 15 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 3;
        }
        return 0;
    }

    void adjustPosition() {
        super.adjustPosition();
        this.makeOutline(this.iheight);
    }

    public void setY(double d) {
    }

    public void setPixX(int n, Rectangle rectangle) {
        super.setPixX(n, rectangle);
        this.makeOutline(this.iheight);
    }

    public void setRadius(int n, Rectangle rectangle) {
        if (n != this.R) {
            this.makeOutline(this.iheight);
        }
        if (n > rectangle.width - 20) {
            this.R = rectangle.width - 20;
        } else if (-n > rectangle.width - 20) {
            this.R = -(rectangle.width - 20);
            this.focalLength = (double)this.R / this.delN;
        } else {
            this.R = n;
            this.focalLength = (double)this.R / this.delN;
        }
        if (this.R < 10 && this.R > -10) {
            this.mat[1][0] = 0.0;
            this.focalLength = 0.0;
        } else {
            this.mat[1][0] = -this.delN / (double)this.R;
        }
    }

    public final int getR() {
        return this.R;
    }

    public final double getFocalLength() {
        return this.focalLength;
    }

    public final String getType() {
        return "dielectric";
    }
}

