/*
 * Decompiled with CFR 0.152.
 */
package optics;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Enumeration;
import optics.Bench;

public class OpticElement
extends Thing {
    double focalLength;
    int errCode = 0;
    private Color rayColor = new Color(255, 255, 191);
    Color color = null;
    private int nextElement = 0;
    private boolean clipOn = false;
    boolean drawDashedRay;
    boolean drawPRay;
    boolean drawSourceRay;
    int pixPerUnit = 1;
    int xPosition;
    int yPosition;
    boolean info;
    boolean showFocus = false;
    double percentSize;
    double indexOfRefraction = 1.0;
    double[][] mat = new double[2][2];
    DecimalFormat df = new DecimalFormat("0.##");
    Bench bench = null;

    public OpticElement(Bench bench) {
        super((SScalable)bench);
        this.bench = bench;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
        this.varStrings = new String[]{"x", "y", "f", "n"};
        this.ds = new double[1][4];
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
    }

    public void paintTempActive(Graphics graphics, Rectangle rectangle) {
    }

    public void paintTemp(Graphics graphics, Rectangle rectangle) {
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public void setDrag(boolean bl) {
        this.noDrag = !bl;
    }

    public boolean getInfo() {
        return this.info;
    }

    public boolean getDrag() {
        return !this.noDrag;
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (n > this.xPosition - 10 && n < this.xPosition + 10) {
            return 1;
        }
        return 0;
    }

    public int isInside(int n, int n2) {
        Rectangle rectangle = this.bench.getBounds();
        return this.isInside(n, n2, rectangle);
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = (double)n * (d * this.mat[1][0] + dArray[1] * this.mat[1][1]);
        return dArray;
    }

    public void setColor(Color color) {
        this.color = color;
        this.rayColor = color;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (this.color == null) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.green);
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
    }

    public void setPixX(int n, Rectangle rectangle) {
        this.xPosition = n < 1 ? 1 : (n > rectangle.width - 1 ? rectangle.width - 1 : n);
        this.setX((double)this.xPosition / (double)this.pixPerUnit);
        if (this.constraint != null) {
            this.xPosition = (int)(this.getX() * (double)this.pixPerUnit);
        }
        if (this.bench.activeElement != null) {
            this.bench.activeElement.updateMySlaves();
        }
    }

    public void setPixY(int n, Rectangle rectangle) {
        this.yPosition = n < 1 ? 1 : (n > rectangle.height - 1 ? rectangle.height - 1 : n);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        if (this.constraint != null) {
            this.yPosition = (int)((double)this.bench.iheight / 2.0 - this.getY() * (double)this.pixPerUnit);
        }
        if (this.bench.activeElement != null) {
            this.bench.activeElement.updateMySlaves();
        }
    }

    void adjustPosition() {
        this.xPosition = (int)(this.getX() * (double)this.pixPerUnit);
        this.xPosition += this.xDisplayOff;
        this.x = (double)this.xPosition / (double)this.pixPerUnit;
        this.yPosition = (int)((double)this.bench.iheight / 2.0 - this.getY() * (double)this.pixPerUnit);
        this.yPosition -= this.yDisplayOff;
        this.y = ((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit;
    }

    public void updateMySlaves() {
        Thing thing = null;
        Enumeration enumeration = this.getSlaves().elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
            if (!(thing instanceof OpticElement)) continue;
            ((OpticElement)thing).adjustPosition();
        }
    }

    public int getPixX() {
        return this.xPosition;
    }

    public int getPixY() {
        return this.yPosition;
    }

    public double getTheta() {
        return 0.0;
    }

    public int getSpread() {
        return 0;
    }

    public void setSpread(int n) {
    }

    public double getAngle() {
        return 0.0;
    }

    public void setAngle(double d) {
    }

    public int getSpacing() {
        return 0;
    }

    public void setSpacing(int n) {
    }

    public final Color getRayColor() {
        return this.rayColor;
    }

    public final void setRayColor(Color color) {
        this.rayColor = color;
    }

    public final void setElementColor(Color color) {
        this.color = color;
    }

    public void setRayIncrement(double d) {
    }

    public double getRayIncrement() {
        return 0.0;
    }

    public void setRaySlope(double d) {
    }

    public double getRaySlope() {
        return 0.0;
    }

    public String getType() {
        return "optic element";
    }

    public void setFocalLength(double d, Rectangle rectangle) {
    }

    public void setOpeningSize(int n) {
    }

    public int getOpeningSize() {
        return 0;
    }

    public double getFocalLength() {
        return 0.0;
    }

    public void setRadius(int n, Rectangle rectangle) {
    }

    public int getR() {
        return 0;
    }

    public void setDirection(int n) {
    }

    public int getDirection() {
        return 0;
    }

    public final void setNextElement(int n) {
        this.nextElement = n;
    }

    public final int getNextElement() {
        return this.nextElement;
    }

    public final void setClipOn(boolean bl) {
        this.clipOn = bl;
    }

    public final boolean getClipOn() {
        return this.clipOn;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public final double[][] getVariables() {
        this.ds[0][0] = this.x;
        this.ds[0][1] = this.y;
        this.ds[0][2] = this.focalLength / (double)this.bench.pixPerUnit;
        this.ds[0][3] = this.indexOfRefraction;
        return this.ds;
    }
}

