/*
 * Decompiled with CFR 0.152.
 */
package optics;

import edu.davidson.display.BoxThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.Constraint;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import optics.Bench;
import optics.CalcThing;
import optics.OpticElement;
import optics.OpticsApplet_aperatureBtn_actionAdapter;
import optics.OpticsApplet_bench_keyAdapter;
import optics.OpticsApplet_bench_mouseAdapter;
import optics.OpticsApplet_bench_mouseMotionAdapter;
import optics.OpticsApplet_bevelPanel1_mouseAdapter;
import optics.OpticsApplet_clearActiveElementBtn_actionAdapter;
import optics.OpticsApplet_clearBtn_actionAdapter;
import optics.OpticsApplet_isourceBtn_actionAdapter;
import optics.OpticsApplet_lensBtn_actionAdapter;
import optics.OpticsApplet_mirrorBtn_actionAdapter;
import optics.OpticsApplet_psourceBtn_actionAdapter;
import optics.OpticsApplet_sourceBtn_actionAdapter;

public class OpticsApplet
extends SApplet {
    private boolean showControls = true;
    private boolean clipOn = true;
    private boolean firstTime = true;
    boolean info = false;
    boolean propertyDrag = false;
    boolean drag = true;
    double size = 0.5;
    int direction = 1;
    int pixPerUnit;
    boolean isStandalone = false;
    String example;
    String opticString = null;
    EtchedBorder bevelPanel1 = new EtchedBorder();
    Button lensBtn = new Button();
    Button sourceBtn = new Button();
    Bench bench = new Bench(this);
    EtchedBorder bevelPanel2 = new EtchedBorder();
    BorderLayout borderLayout2 = new BorderLayout();
    Button clearBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    Button psourceBtn = new Button();
    int defaultFocalLength = 50;
    int defaultOpeningSize = 100;
    double defaultDelN = 1.4;
    int defaultR = -50;
    Button isourceBtn = new Button();
    EtchedBorder bevelPanel3 = new EtchedBorder();
    Button aperatureBtn = new Button();
    Button clearActiveElementBtn = new Button();
    Button mirrorBtn = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (((Applet)((Object)this)).getParameter(string) != null ? ((Applet)((Object)this)).getParameter(string) : string2);
    }

    public void init() {
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.showControls) {
            this.setUnDefault();
        } else {
            this.setDefault();
        }
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.bevelPanel2.setBackground(Color.lightGray);
        this.bevelPanel3.setBackground(Color.lightGray);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
    }

    public void jbInit() throws Exception {
        this.bevelPanel1.setLayout(this.flowLayout2);
        ((Component)((Object)this)).setSize(new Dimension(437, 426));
        this.bevelPanel1.addMouseListener(new OpticsApplet_bevelPanel1_mouseAdapter(this));
        this.lensBtn.setLabel("  Lens  ");
        this.lensBtn.addActionListener(new OpticsApplet_lensBtn_actionAdapter(this));
        this.sourceBtn.setLabel(" Source ");
        this.sourceBtn.addActionListener(new OpticsApplet_sourceBtn_actionAdapter(this));
        this.bench.addKeyListener(new OpticsApplet_bench_keyAdapter(this));
        this.bench.addMouseMotionListener(new OpticsApplet_bench_mouseMotionAdapter(this));
        this.clearBtn.setLabel("Clear All");
        this.psourceBtn.setLabel(" Object ");
        this.isourceBtn.setActionCommand("Add ISource");
        this.aperatureBtn.setActionCommand("aperatureBtn");
        this.clearActiveElementBtn.setLabel("Clear Active");
        this.clearActiveElementBtn.setActionCommand("clearActiveElementBtn");
        this.mirrorBtn.setActionCommand("mirrorBtn");
        this.mirrorBtn.addActionListener(new OpticsApplet_mirrorBtn_actionAdapter(this));
        this.mirrorBtn.setLabel(" Mirror ");
        this.clearActiveElementBtn.addActionListener(new OpticsApplet_clearActiveElementBtn_actionAdapter(this));
        this.aperatureBtn.addActionListener(new OpticsApplet_aperatureBtn_actionAdapter(this));
        this.aperatureBtn.setLabel("Aperature");
        this.bevelPanel3.setLayout(this.flowLayout1);
        this.isourceBtn.addActionListener(new OpticsApplet_isourceBtn_actionAdapter(this));
        this.isourceBtn.setLabel("  Beam  ");
        this.psourceBtn.addActionListener(new OpticsApplet_psourceBtn_actionAdapter(this));
        this.clearBtn.addActionListener(new OpticsApplet_clearBtn_actionAdapter(this));
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.bench.addMouseListener(new OpticsApplet_bench_mouseAdapter(this));
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.bench.repaint();
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel1, "South");
        }
        this.bevelPanel1.add((Component)this.lensBtn, null);
        this.bevelPanel1.add((Component)this.mirrorBtn, null);
        this.bevelPanel1.add((Component)this.aperatureBtn, null);
        this.bevelPanel1.add((Component)this.clearActiveElementBtn, null);
        ((Container)((Object)this)).add((Component)this.bevelPanel2, "Center");
        this.bevelPanel2.add((Component)this.bench, "Center");
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel3, "North");
        }
        this.bevelPanel3.add((Component)this.isourceBtn, null);
        this.bevelPanel3.add((Component)this.psourceBtn, null);
        this.bevelPanel3.add((Component)this.sourceBtn, null);
        this.bevelPanel3.add((Component)this.clearBtn, null);
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            this.bench.createOSI();
        }
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"example", "String", "an example parameter"}};
        return stringArray;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public void clearAll() {
        this.bench.clearThings();
        if (this.autoRefresh) {
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    public boolean setShowFocus(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        if (thing instanceof OpticElement) {
            ((OpticElement)thing).setDragable(this.drag);
        }
        return true;
    }

    public boolean setConstraint(int n, int n2) {
        Thing thing = this.bench.getThing(n);
        Thing thing2 = this.bench.getThing(n2);
        if (thing == null) {
            return false;
        }
        if (thing2 == null) {
            return false;
        }
        if (!(thing2 instanceof Constraint)) {
            return false;
        }
        thing.setConstraint((Constraint)thing2);
        return true;
    }

    public void setDrag(boolean bl) {
        this.drag = bl;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.bench.getThing(n);
        Thing thing2 = this.bench.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        thing.updateMySlaves();
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public boolean setResizable(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setResizable(bl);
        return true;
    }

    public void setPropertyDrag(boolean bl) {
        this.propertyDrag = bl;
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public void setElementRGB(int n, int n2, int n3) {
        if (n == 0 && n2 == 0 && n3 == 0) {
            this.bench.setElementColor(null);
        } else {
            this.bench.setElementColor(new Color(n, n2, n3));
        }
    }

    public void setRayRGB(int n, int n2, int n3) {
        this.bench.setRayColor(new Color(n, n2, n3));
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setColor(new Color(n2, n3, n4));
        return true;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
        this.bench.setPixPerUnit(n);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            this.bench.repaint();
        }
    }

    public void setDefault() {
        this.info = false;
        this.drag = false;
        this.propertyDrag = false;
        this.bench.setElementColor(null);
        this.bench.setRayColor(null);
        this.clearAll();
        this.setPixPerUnit(100);
        this.setInfo(false);
        this.setSize(0.8);
        this.setDrag(false);
        this.setPropertyDrag(false);
        this.setDirection(1);
    }

    public void setUnDefault() {
        this.clearAll();
        this.setPixPerUnit(100);
        this.setInfo(true);
        this.setSize(0.8);
        this.setDrag(true);
        this.setPropertyDrag(true);
        this.setDirection(1);
    }

    public boolean setVisibility(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        return true;
    }

    void lensBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.opticString != null && this.opticString.equals("lens")) {
            this.setNull();
        } else {
            this.opticString = "lens";
            this.setBtnOff();
            this.lensBtn.setForeground(Color.blue);
            this.lensBtn.repaint();
        }
    }

    void sourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.sourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "source";
            this.setBtnOff();
            this.sourceBtn.setForeground(Color.red);
            this.sourceBtn.repaint();
        }
    }

    public double getFocalLength(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return opticElement.focalLength / (double)this.pixPerUnit;
    }

    public double getX(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return (double)opticElement.getPixX() / (double)this.pixPerUnit;
    }

    public double getY(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        Rectangle rectangle = this.bench.getBounds();
        return (double)(-(opticElement.getPixY() - rectangle.height / 2)) / (double)this.pixPerUnit;
    }

    public double getIndex(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return opticElement.indexOfRefraction;
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("lens")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"f=")) {
                d3 = SUtil.getParam((String)string2, (String)"f=");
            }
            return this.addLens(d, d3);
        }
        if (string.equals("screen")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            return this.addScreen(d);
        }
        if (string.equals("source")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"infinite")) {
                int n = 20;
                double d4 = 0.0;
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"slope=")) {
                    d4 = SUtil.getParam((String)string2, (String)"slope=");
                }
                return this.addISource(d, d2, n, d4);
            }
            if (SUtil.parameterExist((String)string2, (String)"point")) {
                double d5 = 0.1;
                double d6 = 0.5;
                if (SUtil.parameterExist((String)string2, (String)"slope=")) {
                    d6 = SUtil.getParam((String)string2, (String)"slope=");
                }
                if (SUtil.parameterExist((String)string2, (String)"inc=")) {
                    d5 = SUtil.getParam((String)string2, (String)"inc=");
                }
                return this.addSource(d, d2, d5, d6);
            }
            return this.addPSource(d, d2);
        }
        if (string.equals("dielectric")) {
            double d7 = 1.0;
            double d8 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"dn=")) {
                d7 = SUtil.getParam((String)string2, (String)"dn=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                d8 = SUtil.getParam((String)string2, (String)"r=");
            }
            if (d8 == 0.0) {
                return this.addIndexChange(d, d7);
            }
            return this.addDielectric(d, d7, d8);
        }
        if (string.equals("refraction")) {
            double d9 = 1.0;
            double d10 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"dn=")) {
                d9 = SUtil.getParam((String)string2, (String)"dn=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                d10 = SUtil.getParam((String)string2, (String)"r=");
            }
            return this.addRefraction(d, d9, d10);
        }
        if (string.equals("mirror")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"f=")) {
                d3 = SUtil.getParam((String)string2, (String)"f=");
            }
            if (SUtil.parameterExist((String)string2, (String)"spherical")) {
                return this.addSphericalMirror(d, d3);
            }
            return this.addMirror(d, d3);
        }
        if (string.equals("aperture")) {
            double d11 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"opening=")) {
                d11 = SUtil.getParam((String)string2, (String)"opening=");
            }
            d11 = Math.min(1.0, d11);
            d11 = Math.max(0.0, d11);
            return this.addAperture(d, d11);
        }
        if (string.equals("constraint")) {
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d12 = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d14 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d13 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d15 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            object = new Constraint((SApplet)this, (SScalable)this.bench, d12, d13, d14, d15);
            object.setColor(Color.pink);
        } else if (string.equals("rectangle")) {
            int n = 20;
            int n2 = 20;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new RectangleThing((SApplet)this, (SScalable)this.bench, d, d2, n, n2);
        } else if (string.equals("circle")) {
            int n = 10;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new CircleThing((SApplet)this, (SScalable)this.bench, d, d2, n);
        } else if (string.equals("shell")) {
            int n = 10;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new ShellThing((SApplet)this, (SScalable)this.bench, d, d2, n);
        } else if (string.equals("box")) {
            int n = 20;
            int n3 = 20;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.bench, d, d2, n, n3);
        } else if (string.equals("text")) {
            String string4 = "";
            String string5 = null;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            object = new CalcThing(this, this.bench, string4, string5, d, d2);
        }
        if (object == null) {
            System.out.println(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2)));
            return 0;
        }
        this.bench.addThing((Thing)object);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return object.hashCode();
    }

    public int addAperture(double d, double d2) {
        return this.addAperature(d, d2);
    }

    private int addAperature(double d, double d2) {
        int n = this.bench.addAperature((int)(d * (double)this.pixPerUnit), 0, (int)(d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addDielectric(double d, double d2, double d3) {
        int n = this.bench.addDielectric((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addIndexChange(double d, double d2) {
        int n = this.bench.addIndexChange((int)(d * (double)this.pixPerUnit), 0, d2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addRefraction(double d, double d2, double d3) {
        int n = this.bench.addRefraction((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addISource(double d, double d2, int n, double d3) {
        Rectangle rectangle = this.bench.getBounds();
        int n2 = this.bench.addISource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), n, d3, this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addLens(double d, double d2) {
        int n = this.bench.addLens((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addMirror(double d, double d2) {
        int n = this.bench.addMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addSphericalMirror(double d, double d2) {
        int n = this.bench.addSphericalMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addPSource(double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        int n = this.bench.addPSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addScreen(double d) {
        int n = this.bench.addScreen((int)(d * (double)this.pixPerUnit), 0, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addSource(double d, double d2, double d3, double d4) {
        Rectangle rectangle = this.bench.getBounds();
        int n = this.bench.addSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), d3, -Math.abs(d4), this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addApertureP(int n, int n2) {
        return this.addAperatureP(n, n2);
    }

    private int addAperatureP(int n, int n2) {
        int n3 = this.bench.addAperature(n, 0, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addDielectricP(int n, double d, int n2) {
        int n3 = this.bench.addDielectric(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addIndexChangeP(int n, double d) {
        int n2 = this.bench.addIndexChange(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addRefractionP(int n, double d, int n2) {
        int n3 = this.bench.addRefraction(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addISourceP(int n, int n2, int n3, double d) {
        Rectangle rectangle = this.bench.getBounds();
        int n4 = this.bench.addISource(n, rectangle.height / 2 - n2, n3, d, this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n4;
    }

    public int addLensP(int n, double d) {
        int n2 = this.bench.addLens(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addMirrorP(int n, double d) {
        int n2 = this.bench.addMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addSphericalMirrorP(int n, double d) {
        int n2 = this.bench.addSphericalMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addPSourceP(int n, int n2) {
        Rectangle rectangle = this.bench.getBounds();
        int n3 = this.bench.addPSource(n, rectangle.height / 2 - n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addScreenP(int n) {
        int n2 = this.bench.addScreen(n, 0, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addSourceP(int n, int n2, double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        int n3 = this.bench.addSource(n, rectangle.height / 2 - n2, d, -Math.abs(d2), this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    void bench_mousePressed(MouseEvent mouseEvent) {
        this.bench.isControlDown = mouseEvent.isControlDown();
        if (this.opticString == "lens") {
            this.bench.addLens(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "mirror") {
            this.bench.addMirror(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "source") {
            this.bench.addSource(mouseEvent.getX(), mouseEvent.getY(), 0.25, -1.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "psource") {
            this.bench.addPSource(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "screen") {
            this.bench.addScreen(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "isource") {
            this.bench.addISource(mouseEvent.getX(), mouseEvent.getY(), 100, 0.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "aperature") {
            this.bench.addAperature(mouseEvent.getX(), mouseEvent.getY(), this.defaultOpeningSize, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "dielectric") {
            this.bench.addDielectric(mouseEvent.getX(), mouseEvent.getY(), this.defaultDelN, this.defaultR, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == null) {
            this.bench.mousePressed(mouseEvent.getX(), mouseEvent.getY());
        }
        ((Component)((Object)this)).repaint();
    }

    public void setNull() {
        this.opticString = null;
        this.setBtnOff();
    }

    void nullBtn_actionPerformed(ActionEvent actionEvent) {
        this.setNull();
    }

    void clearBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearThings();
        this.opticString = null;
        this.setBtnOff();
        ((Component)((Object)this)).repaint();
    }

    void bench_mouseReleased(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseDragged(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseMoved(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseMoved(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void psourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.psourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "psource";
            this.setBtnOff();
            this.psourceBtn.setForeground(Color.red);
            this.psourceBtn.repaint();
        }
    }

    void isourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.isourceBtn.getForeground() == Color.green) {
            this.setNull();
        } else {
            this.opticString = "isource";
            this.setBtnOff();
            this.isourceBtn.setForeground(Color.green);
            this.isourceBtn.repaint();
        }
    }

    public void setBtnOff() {
        this.lensBtn.setForeground(Color.black);
        this.sourceBtn.setForeground(Color.black);
        this.psourceBtn.setForeground(Color.black);
        this.isourceBtn.setForeground(Color.black);
        this.aperatureBtn.setForeground(Color.black);
        this.mirrorBtn.setForeground(Color.black);
        this.bench.repaint();
    }

    void aperatureBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.aperatureBtn.getForeground() == Color.yellow) {
            this.setNull();
        } else {
            this.opticString = "aperature";
            this.setBtnOff();
            this.aperatureBtn.setForeground(Color.yellow);
            this.aperatureBtn.repaint();
        }
    }

    void clearActiveElementBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearActiveElement();
    }

    void mirrorBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.mirrorBtn.getForeground() == Color.blue) {
            this.setNull();
        } else {
            this.opticString = "mirror";
            this.setBtnOff();
            this.mirrorBtn.setForeground(Color.blue);
            this.mirrorBtn.repaint();
        }
    }

    void buttonControl1_actionPerformed(ActionEvent actionEvent) {
        this.addSource(50.0, 50.0, 0.25, -1.0);
    }

    void bench_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 && this.showControls) {
            this.bench.clearActiveElement();
        }
    }
}

