/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.Bench;
import optics.Source;

public final class PSource
extends Source {
    public PSource(Bench bench, int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        super(bench);
        this.info = bl;
        this.noDrag = !bl2;
        this.drawDashedRay = true;
        this.drawPRay = true;
        this.drawSourceRay = true;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        this.theta = d;
        this.numberOfRays = n3;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
        this.direction = 1;
    }

    public void init(int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        this.resizable = bl3;
        this.info = bl;
        this.noDrag = !bl2;
        this.drawDashedRay = true;
        this.drawPRay = true;
        this.drawSourceRay = true;
        this.xPosition = n;
        this.yPosition = n2;
        this.theta = d;
        this.numberOfRays = n3;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
        this.direction = 1;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.lightGray);
        graphics.drawLine(this.xPosition, this.yPosition, this.xPosition, rectangle.height / 2);
        graphics.setColor(Color.white);
        graphics.drawLine(this.xPosition + 1, this.yPosition, this.xPosition + 1, rectangle.height / 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xPosition - 1, this.yPosition, this.xPosition - 1, rectangle.height / 2);
        graphics.setColor(Color.lightGray);
        if (this.yPosition < rectangle.height / 2) {
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition + 5, this.yPosition + 10);
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition - 5, this.yPosition + 10);
            graphics.setColor(Color.white);
            graphics.drawLine(this.xPosition + 1, this.yPosition, this.xPosition + 6, this.yPosition + 10);
            graphics.drawLine(this.xPosition + 1, this.yPosition, this.xPosition - 4, this.yPosition + 10);
            graphics.setColor(Color.gray);
            graphics.drawLine(this.xPosition - 1, this.yPosition, this.xPosition + 4, this.yPosition + 10);
            graphics.drawLine(this.xPosition - 1, this.yPosition, this.xPosition - 6, this.yPosition + 10);
        } else {
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition + 5, this.yPosition - 10);
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition - 5, this.yPosition - 10);
            graphics.setColor(Color.white);
            graphics.drawLine(this.xPosition + 1, this.yPosition, this.xPosition + 6, this.yPosition - 10);
            graphics.drawLine(this.xPosition + 1, this.yPosition, this.xPosition - 4, this.yPosition - 10);
            graphics.setColor(Color.gray);
            graphics.drawLine(this.xPosition - 1, this.yPosition, this.xPosition + 4, this.yPosition - 10);
            graphics.drawLine(this.xPosition - 1, this.yPosition, this.xPosition - 6, this.yPosition - 10);
        }
    }

    public void paintTemp(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.lightGray);
        graphics.drawLine(this.xPosition, this.yPosition, this.xPosition, rectangle.height / 2);
        if (this.yPosition < rectangle.height / 2) {
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition + 5, this.yPosition + 10);
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition - 5, this.yPosition + 10);
        } else {
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition + 5, this.yPosition - 10);
            graphics.drawLine(this.xPosition, this.yPosition, this.xPosition - 5, this.yPosition - 10);
        }
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (!this.noDrag) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - 3, this.yPosition - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf(new StringBuffer("x = ").append(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)).append(" , y =").append(this.df.format(1.0 * (double)rectangle.height / (double)2 / (double)this.pixPerUnit - 1.0 * (double)this.yPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 50);
        }
    }

    public void paintTempActive(Graphics graphics, Rectangle rectangle) {
        if (this.info) {
            graphics.setColor(Color.yellow);
            graphics.drawString(String.valueOf(new StringBuffer("x = ").append(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)).append(" , y =").append(this.df.format(1.0 * (double)this.yPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 30);
        }
    }

    public String getType() {
        return "psource";
    }
}

