/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.Bench;
import optics.OpticElement;

public final class Screen
extends OpticElement {
    public Screen(Bench bench, int n, int n2, boolean bl, boolean bl2, double d, boolean bl3) {
        super(bench);
        this.resizable = bl3;
        this.info = bl;
        this.noDrag = !bl2;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = d * this.mat[1][0] + dArray[1] * this.mat[1][1];
        return dArray;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (this.color == null) {
            graphics.setColor(Color.yellow);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
        graphics.setColor(Color.orange);
        graphics.drawLine(this.xPosition + 1, 0, this.xPosition + 1, rectangle.height);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (!this.noDrag) {
            graphics.setColor(Color.white);
            graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString("x = ".concat(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit))), this.xPosition, rectangle.height - 30);
        }
    }

    public String getType() {
        return "screen";
    }
}

